/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.common;

import com.iplanet.am.sdk.common.CacheBlockBase;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.shared.debug.Debug;
import java.util.Set;

public class IdCacheBlock
extends CacheBlockBase {
    protected static final String ENTRY_EXPIRATION_ENABLED_KEY = "com.sun.identity.idm.cache.entry.expire.enabled";
    protected static final String ENTRY_USER_EXPIRE_TIME_KEY = "com.sun.identity.idm.cache.entry.user.expire.time";
    protected static final String ENTRY_DEFAULT_EXPIRE_TIME_KEY = "com.sun.identity.idm.cache.entry.default.expire.time";
    protected static boolean ENTRY_EXPIRATION_ENABLED_FLAG = false;
    protected static long ENTRY_USER_EXPIRE_TIME;
    protected static long ENTRY_DEFAULT_EXPIRE_TIME;
    private Debug debug = Debug.getInstance((String)"amIdm");
    private Set fullyQualifiedNames;

    private static void initializeExpirationParms() {
        IdCacheBlock.setEntryExpirationEnabledFlag();
        if (ENTRY_EXPIRATION_ENABLED_FLAG) {
            IdCacheBlock.setUserEntryExpirationTime();
            IdCacheBlock.setDefaultEntryExpirationTime();
        }
    }

    private static void setEntryExpirationEnabledFlag() {
        String userEntryExpireTimeStr = SystemProperties.get(ENTRY_EXPIRATION_ENABLED_KEY, "false");
        ENTRY_EXPIRATION_ENABLED_FLAG = Boolean.valueOf(userEntryExpireTimeStr);
    }

    private static void setUserEntryExpirationTime() {
        ENTRY_USER_EXPIRE_TIME = IdCacheBlock.getPropertyIntValue(ENTRY_USER_EXPIRE_TIME_KEY, 15) * 60000;
    }

    private static void setDefaultEntryExpirationTime() {
        ENTRY_DEFAULT_EXPIRE_TIME = IdCacheBlock.getPropertyIntValue(ENTRY_DEFAULT_EXPIRE_TIME_KEY, 30) * 60000;
    }

    private static int getPropertyIntValue(String key, int defaultValue) {
        int value = defaultValue;
        String valueStr = SystemProperties.get(key);
        if (valueStr != null && valueStr.trim().length() > 0) {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public boolean isEntryExpirationEnabled() {
        return ENTRY_EXPIRATION_ENABLED_FLAG;
    }

    public long getUserEntryExpirationTime() {
        return ENTRY_USER_EXPIRE_TIME;
    }

    public long getDefaultEntryExpirationTime() {
        return ENTRY_DEFAULT_EXPIRE_TIME;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public Set getFullyQualifiedNames() {
        return this.fullyQualifiedNames;
    }

    public void setFullyQualifiedNames(Set fqn) {
        this.fullyQualifiedNames = fqn;
    }

    public IdCacheBlock(String entryDN, boolean validEntry) {
        super(entryDN, validEntry);
    }

    public IdCacheBlock(String entryDN, String orgDN, boolean validEntry) {
        super(entryDN, orgDN, validEntry);
    }

    static {
        IdCacheBlock.initializeExpirationParms();
    }
}

