/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.ui;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Button;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.identity.password.ui.PWResetQuestionTiledView;
import com.sun.identity.password.ui.PWResetSuccessViewBean;
import com.sun.identity.password.ui.PWResetUserValidationViewBean;
import com.sun.identity.password.ui.PWResetViewBeanBase;
import com.sun.identity.password.ui.model.PWResetException;
import com.sun.identity.password.ui.model.PWResetModel;
import com.sun.identity.password.ui.model.PWResetQuestionModel;
import com.sun.identity.password.ui.model.PWResetQuestionModelImpl;
import java.io.Serializable;
import java.util.Map;

public class PWResetQuestionViewBean
extends PWResetViewBeanBase {
    public static final String PW_QUESTION_TITLE = "pwQuestionTitle";
    public static final String BUTTON_OK = "btnOK";
    public static final String BUTTON_PREVIOUS = "btnPrevious";
    public static final String PAGE_NAME = "PWResetQuestion";
    public static final String PASSWORD_RESET_TILEDVIEW = "passResetTileView";
    public static final String FLD_USER_ATTR = "fldUserAttr";
    public static final String DEFAULT_DISPLAY_URL = "/password/ui/PWResetQuestion.jsp";

    public PWResetQuestionViewBean() {
        super(PAGE_NAME);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PW_QUESTION_TITLE, StaticTextField.class);
        this.registerChild(BUTTON_OK, Button.class);
        this.registerChild(BUTTON_PREVIOUS, Button.class);
        this.registerChild(PASSWORD_RESET_TILEDVIEW, PWResetQuestionTiledView.class);
    }

    protected View createChild(String name) {
        Object child = null;
        child = name.equals(BUTTON_OK) ? new Button((ContainerView)this, BUTTON_OK, (Object)"") : (name.equals(BUTTON_PREVIOUS) ? new Button((ContainerView)this, BUTTON_PREVIOUS, (Object)"") : (name.equals(PW_QUESTION_TITLE) ? new StaticTextField((ContainerView)this, PW_QUESTION_TITLE, (Object)"") : (name.equals(PASSWORD_RESET_TILEDVIEW) ? new PWResetQuestionTiledView((View)this, PASSWORD_RESET_TILEDVIEW) : super.createChild(name))));
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        PWResetQuestionModel model = (PWResetQuestionModel)this.getModel();
        String orgDN = (String)this.getPageSessionAttribute("orgDN");
        String userDN = (String)this.getPageSessionAttribute("userDN");
        PWResetQuestionTiledView tView = (PWResetQuestionTiledView)this.getChild(PASSWORD_RESET_TILEDVIEW);
        tView.populateQuestionsList(userDN, orgDN);
        String value = (String)this.getPageSessionAttribute("userValueAttr");
        this.setDisplayFieldValue(PW_QUESTION_TITLE, model.getPWQuestionTitleString(value));
        this.setDisplayFieldValue(BUTTON_OK, model.getOKBtnLabel());
        this.setDisplayFieldValue(BUTTON_PREVIOUS, model.getPreviousBtnLabel());
    }

    public void forwardTo(RequestContext context) {
        String orgDN = (String)this.getPageSessionAttribute("orgDN");
        String userDN = (String)this.getPageSessionAttribute("userDN");
        String loc = (String)this.getPageSessionAttribute("locale");
        if (orgDN == null || orgDN.length() == 0 || userDN == null || userDN.length() == 0) {
            PWResetUserValidationViewBean vb = (PWResetUserValidationViewBean)this.getViewBean(PWResetUserValidationViewBean.class);
            vb.forwardTo(context);
        } else {
            PWResetQuestionModel model = (PWResetQuestionModel)this.getModel();
            model.readPWResetProfile(orgDN);
            this.populateQuestionsList(userDN, orgDN);
            super.forwardTo(context);
        }
    }

    public void handleBtnOKRequest(RequestInvocationEvent event) {
        PWResetQuestionModel model = (PWResetQuestionModel)this.getModel();
        String orgDN = (String)this.getPageSessionAttribute("orgDN");
        String userDN = (String)this.getPageSessionAttribute("userDN");
        String locale = (String)this.getPageSessionAttribute("locale");
        PWResetQuestionTiledView tView = (PWResetQuestionTiledView)this.getChild(PASSWORD_RESET_TILEDVIEW);
        Map map = tView.getAnswers();
        if (tView.isAnswerBlank()) {
            this.setErrorMessage(model.getErrorTitle(), model.getMissingAnswerMessage());
            this.forwardTo();
        } else {
            try {
                model.resetPassword(userDN, orgDN, map);
                PWResetSuccessViewBean vb = (PWResetSuccessViewBean)this.getViewBean(PWResetSuccessViewBean.class);
                vb.setResetMessage(model.getPasswordResetMessage());
                vb.setPageSessionAttribute("locale", (Serializable)((Object)locale));
                vb.forwardTo(this.getRequestContext());
            }
            catch (PWResetException pwe) {
                if (!model.isUserLockout(userDN, orgDN)) {
                    this.setErrorMessage(model.getErrorTitle(), pwe.getMessage());
                }
                this.forwardTo();
            }
        }
    }

    public void handleBtnPreviousRequest(RequestInvocationEvent event) {
        String orgDN = (String)this.getPageSessionAttribute("orgDN");
        String value = (String)this.getPageSessionAttribute("userValueAttr");
        String locale = (String)this.getPageSessionAttribute("locale");
        String initialOrgDN = (String)this.getPageSessionAttribute("initialOrgDN");
        PWResetUserValidationViewBean vb = (PWResetUserValidationViewBean)this.getViewBean(PWResetUserValidationViewBean.class);
        vb.setPageSessionAttribute("orgDN", (Serializable)((Object)initialOrgDN));
        vb.setPageSessionAttribute("userValueAttr", (Serializable)((Object)value));
        vb.setPageSessionAttribute("locale", (Serializable)((Object)locale));
        String orgDNFlag = (String)this.getPageSessionAttribute("orgDNFlag");
        if (orgDNFlag != null && orgDNFlag.equals("true")) {
            vb.setPageSessionAttribute("orgDNFlag", (Serializable)((Object)"true"));
        }
        vb.forwardTo(this.getRequestContext());
    }

    protected PWResetModel getModel() {
        if (this.model == null) {
            this.model = new PWResetQuestionModelImpl();
        }
        return this.model;
    }

    private void populateQuestionsList(String userDN, String orgDN) {
        PWResetQuestionModel model = (PWResetQuestionModel)this.getModel();
        Map map = model.getSecretQuestions(userDN, orgDN);
        if (map == null || map.isEmpty()) {
            model.setNoQuestionsInfoMsg();
        }
    }

    public boolean beginResetPageDisplay(ChildDisplayEvent event) {
        PWResetQuestionModel model = (PWResetQuestionModel)this.getModel();
        String orgDN = (String)this.getPageSessionAttribute("orgDN");
        String userDN = (String)this.getPageSessionAttribute("userDN");
        return this.isPWResetEnabled() && model.isQuestionAvailable(userDN, orgDN) && !model.isUserLockout(userDN, orgDN);
    }
}

