/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LEAuthLevelCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private Map properties;
    private String authLevel;
    private String authRealm;
    private int authLevelInt;
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.NONE;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = (HashMap)properties;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        boolean allowed = false;
        int maxRequestAuthLevel = Integer.MIN_VALUE;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.getConditionDecision():entering");
        }
        if ((maxRequestAuthLevel = this.getMaxRequestAuthLevel(env)) == Integer.MIN_VALUE) {
            maxRequestAuthLevel = this.getMaxRequestAuthLevel(token);
        }
        if (maxRequestAuthLevel <= this.authLevelInt) {
            allowed = true;
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At AuthLevelCondition.getConditionDecision():authLevel=" + this.authLevel + ",maxRequestAuthLevel=" + maxRequestAuthLevel + ",allowed = " + allowed);
        }
        return new ConditionDecision(allowed);
    }

    public Object clone() {
        LEAuthLevelCondition theClone = null;
        try {
            theClone = (LEAuthLevelCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            for (Object o : this.properties.keySet()) {
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private boolean validateProperties() throws PolicyException {
        Set keySet;
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.setProperties(),properties=" + this.properties);
        }
        if (!(keySet = this.properties.keySet()).contains("AuthLevel")) {
            Object[] args = new String[]{"AuthLevel"};
            throw new PolicyException("amPolicy", "property_value_not_defined", args, null);
        }
        for (String key : keySet) {
            if ("AuthLevel".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property ", args, null);
        }
        Set authLevelSet = (Set)this.properties.get("AuthLevel");
        if (authLevelSet != null) {
            this.validateAuthLevels(authLevelSet);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.setProperties(),authLevel=" + this.authLevel + ",authRealm=" + this.authRealm + ",authLevelInt=" + this.authLevelInt);
        }
        return true;
    }

    private boolean validateAuthLevels(Set authLevelSet) throws PolicyException {
        if (authLevelSet.isEmpty() || authLevelSet.size() > 1) {
            Object[] args = new String[]{"AuthLevel"};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_or_multiple_values", args, null);
        }
        Iterator authLevels = authLevelSet.iterator();
        this.authLevel = (String)authLevels.next();
        try {
            this.authRealm = AMAuthUtils.getRealmFromRealmQualifiedData(this.authLevel);
            String authLevelIntString = AMAuthUtils.getDataFromRealmQualifiedData(this.authLevel);
            this.authLevelInt = Integer.parseInt(authLevelIntString);
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{"AuthLevel"};
            throw new PolicyException("amPolicy", "property_is_not_an_Integer", args, null);
        }
        return true;
    }

    private int getMaxRequestAuthLevel(Map env) throws PolicyException {
        Object envAuthLevelObject;
        int maxAuthLevel = Integer.MIN_VALUE;
        int currentAuthLevel = Integer.MIN_VALUE;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.getMaxRequestAuthLevel(envMap,realm): entering: envMap= " + env + ", authRealm= " + this.authRealm + ", conditionAuthLevel= " + this.authLevel);
        }
        if ((envAuthLevelObject = env.get("requestAuthLevel")) != null) {
            if (envAuthLevelObject instanceof Integer) {
                if (this.authRealm == null || this.authRealm.length() == 0) {
                    maxAuthLevel = (Integer)envAuthLevelObject;
                    if (DEBUG.messageEnabled()) {
                        DEBUG.message("AuthLevelCondition.getMaxRequestAuthLevel():Integer level in env= " + maxAuthLevel);
                    }
                }
            } else if (envAuthLevelObject instanceof Set) {
                Set envAuthLevelSet = (Set)envAuthLevelObject;
                if (!envAuthLevelSet.isEmpty()) {
                    for (Object envAuthLevelElement : envAuthLevelSet) {
                        if (!(envAuthLevelElement instanceof String)) {
                            if (DEBUG.warningEnabled()) {
                                DEBUG.warning("LEAuthLevelCondition.getMaxRequestAuthLevel():requestAuthLevel Set element not String");
                            }
                            throw new PolicyException("amPolicy", "request_authlevel_in_env_set_element_not_string", null, null);
                        }
                        String qualifiedLevel = (String)envAuthLevelElement;
                        currentAuthLevel = this.getAuthLevel(qualifiedLevel);
                        if (this.authRealm == null || this.authRealm.length() == 0) {
                            if (currentAuthLevel <= maxAuthLevel) continue;
                            maxAuthLevel = currentAuthLevel;
                            continue;
                        }
                        String realmString = AMAuthUtils.getRealmFromRealmQualifiedData(qualifiedLevel);
                        if (!this.authRealm.equals(realmString) || currentAuthLevel <= maxAuthLevel) continue;
                        maxAuthLevel = currentAuthLevel;
                    }
                }
            } else {
                if (DEBUG.warningEnabled()) {
                    DEBUG.warning("LEAuthLevelCondition.getMaxRequestAuthLevel():requestAuthLevel in env neither Integer nor Set");
                }
                throw new PolicyException("amPolicy", "request_authlevel_in_env_not_Integer_or_set", null, null);
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.getMaxRequestAuthLevel(): returning: maxAuthLevel=" + maxAuthLevel);
        }
        return maxAuthLevel;
    }

    private int getMaxRequestAuthLevel(SSOToken token) throws PolicyException, SSOException {
        int maxAuthLevel = Integer.MIN_VALUE;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.getMaxRequestAuthLevel(token,realm): entering: authRealm = " + this.authRealm + ", conditionAuthLevel= " + this.authLevel);
        }
        if (this.authRealm == null || this.authRealm.length() == 0) {
            Set levels = AMAuthUtils.getAuthenticatedLevels(token);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("LEAuthLevelCondition.getMaxRequestAuthLevel(): levels from token= " + levels);
            }
            if (levels != null && !levels.isEmpty()) {
                for (String levelString : levels) {
                    int level = this.getAuthLevel(levelString);
                    maxAuthLevel = level > maxAuthLevel ? level : maxAuthLevel;
                }
            }
        } else {
            Set qualifiedLevels = AMAuthUtils.getRealmQualifiedAuthenticatedLevels(token);
            if (DEBUG.messageEnabled()) {
                DEBUG.message("LEAuthLevelCondition.getMaxRequestAuthLevel(): qualifiedLeves from token= " + qualifiedLevels);
            }
            if (qualifiedLevels != null && !qualifiedLevels.isEmpty()) {
                for (String qualifiedLevel : qualifiedLevels) {
                    if (!this.authLevel.equals(qualifiedLevel)) continue;
                    int level = this.getAuthLevel(qualifiedLevel);
                    maxAuthLevel = level > maxAuthLevel ? level : maxAuthLevel;
                }
            }
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("LEAuthLevelCondition.getMaxRequestAuthLevel(): returning: maxAuthLevel= " + maxAuthLevel);
        }
        return maxAuthLevel;
    }

    private int getAuthLevel(String qualifiedLevel) throws PolicyException {
        int levelInt = 0;
        String levelString = AMAuthUtils.getDataFromRealmQualifiedData(qualifiedLevel);
        try {
            levelInt = Integer.parseInt(levelString);
        }
        catch (NumberFormatException nfe) {
            if (DEBUG.warningEnabled()) {
                DEBUG.warning("LEAuthLevelCondition.getAuthLevel(qualifiedLevel):got NumberFormatException:qualifiedLevel=" + qualifiedLevel + ", levelString = " + levelString);
            }
            Object[] args = new Object[]{levelString};
            throw new PolicyException("amPolicy", "auth_level_not_integer", args, nfe);
        }
        return levelInt;
    }

    static {
        propertyNames.add("AuthLevel");
    }
}

