/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class SiteStatusCheckThreadImpl
implements WebtopNaming.SiteStatusCheck {
    protected static Debug debug;
    private static int timeout;
    private static String hcPath;
    private static int urlCheckerInvalidateInterval;
    private static int urlCheckerSleep;
    private static int urlCheckerRetryInterval;
    private static int urlCheckerRetryLimit;
    private HashMap urlCheckers = new HashMap();

    private String getThreadName(URL u) {
        return "Site-Monitor " + u.toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLChecker getURLChecker(URL url) {
        URLChecker checker = (URLChecker)((Object)this.urlCheckers.get(this.getThreadName(url)));
        if (checker == null) {
            HashMap hashMap = this.urlCheckers;
            synchronized (hashMap) {
                checker = (URLChecker)((Object)this.urlCheckers.get(this.getThreadName(url)));
                if (checker != null) {
                    return checker;
                }
                checker = new URLChecker(url);
                this.urlCheckers.put(this.getThreadName(url), checker);
                checker.check();
            }
            SystemTimer.getTimer().schedule((TaskRunnable)checker, new Date((System.currentTimeMillis() + (long)urlCheckerSleep) / 1000L * 1000L));
            try {
                ((Object)((Object)checker)).wait(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (URLChecker)((Object)this.urlCheckers.get(this.getThreadName(url)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCheckSiteStatus(URL url) {
        URLChecker checker = this.getURLChecker(url);
        if (checker != null && checker.getStatus() == 0) {
            checker.cancel();
            ((Object)((Object)checker)).notify();
            HashMap hashMap = this.urlCheckers;
            synchronized (hashMap) {
                this.urlCheckers.remove(this.getThreadName(url));
            }
            debug.error("SiteStatusCheckThreadImpl.doCheckSiteStatus() Killing thread " + this.getThreadName(url));
            return false;
        }
        return checker != null && checker.getStatus() == 1;
    }

    static {
        String deployuri;
        debug = Debug.getInstance((String)"amNaming");
        timeout = Long.valueOf(SystemProperties.get("com.sun.identity.sitemonitor.timeout", "10000")).intValue();
        hcPath = SystemProperties.get("com.sun.identity.urlchecker.targeturl", null);
        urlCheckerInvalidateInterval = Long.valueOf(SystemProperties.get("com.sun.identity.urlchecker.invalidate.interval", "70000")).intValue();
        urlCheckerSleep = Long.valueOf(SystemProperties.get("com.sun.identity.urlchecker.sleep.interval", "30000")).intValue();
        urlCheckerRetryInterval = Long.valueOf(SystemProperties.get("com.sun.identity.urlchecker.retry.interval", "500")).intValue();
        urlCheckerRetryLimit = Long.valueOf(SystemProperties.get("com.sun.identity.urlchecker.retry.limit", "3")).intValue();
        if (hcPath == null && !(hcPath = (deployuri = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor", "/opensso")) + "/namingservice").startsWith("/")) {
            hcPath = hcPath + "/" + hcPath;
        }
    }

    class URLChecker
    extends GeneralTaskRunnable {
        private URL url = null;
        private URLStatus urlStatus = null;

        URLChecker(URL url) {
            this.url = this.getHealthCheckURL(url);
            this.setUrlStatus(new URLStatus());
        }

        public void check() {
            int cnt = 0;
            boolean statusNotSet = true;
            while (cnt < urlCheckerRetryLimit && statusNotSet) {
                ++cnt;
                try {
                    boolean sockStatus = this.checkSocketConnection(this.url);
                    if (!sockStatus) {
                        this.getUrlStatus().setStatus(-1);
                        Thread.sleep(urlCheckerRetryInterval);
                        continue;
                    }
                    Date t0 = null;
                    if (debug.messageEnabled()) {
                        t0 = Calendar.getInstance().getTime();
                    }
                    HttpURLConnection huc = HttpURLConnectionManager.getConnection((URL)this.url);
                    huc.setDoInput(true);
                    huc.setRequestMethod("GET");
                    String s = huc.getHeaderField(0);
                    if (debug.messageEnabled()) {
                        Date t1 = Calendar.getInstance().getTime();
                        long t = t1.getTime() - t0.getTime();
                        debug.message("URLChecker.check() : Http connection took " + t + " ms");
                    }
                    if (s != null) {
                        if (debug.messageEnabled()) {
                            debug.message("URLChecker.check() :  setting status to AVAILABLE for " + this.url.toExternalForm());
                        }
                        statusNotSet = false;
                        this.getUrlStatus().setStatus(1);
                    } else {
                        if (debug.messageEnabled()) {
                            debug.message("URLChecker.check() : setting status to ** UNAVAILABLE ** for " + this.url.toExternalForm());
                        }
                        if (cnt == urlCheckerRetryLimit) {
                            this.getUrlStatus().setStatus(-1);
                        } else {
                            Thread.sleep(urlCheckerRetryInterval);
                        }
                    }
                    huc.disconnect();
                }
                catch (Exception e) {
                    debug.error("URLChecker.check() :  setting status to ** UNAVAILABLE ** for " + this.url.toExternalForm(), (Throwable)e);
                    this.getUrlStatus().setStatus(-1);
                }
            }
        }

        public void run() {
            if (debug.messageEnabled()) {
                debug.message("URLChecker.run() : monitoring URL " + this.url.toExternalForm());
            }
            this.check();
        }

        public long getRunPeriod() {
            return urlCheckerSleep;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        private URLStatus getUrlStatus() {
            return this.urlStatus;
        }

        private void setUrlStatus(URLStatus urlStatus) {
            this.urlStatus = urlStatus;
        }

        public int getStatus() {
            if (Calendar.getInstance().getTimeInMillis() - this.getUrlStatus().getLastStatusUpdatedTime().getTime() > (long)urlCheckerInvalidateInterval) {
                if (debug.messageEnabled()) {
                    debug.message("URLChecker.getStatus() : Last status update was @ " + this.getUrlStatus().getLastStatusUpdatedTime());
                }
                return 0;
            }
            return this.getUrlStatus().getStatus();
        }

        boolean checkSocketConnection(URL url) {
            boolean flag = false;
            try {
                InetSocketAddress inetsocketaddress = new InetSocketAddress(url.getHost(), url.getPort());
                Socket socket = new Socket();
                socket.connect(inetsocketaddress, timeout);
                socket.close();
                flag = true;
            }
            catch (IOException ioexception) {
                debug.error("URLChecker.checkSocketConnection() : Socket connection Failed : " + ioexception.toString());
            }
            if (debug.messageEnabled()) {
                debug.message("URLChecker.checkSocketConnection() returning " + flag);
            }
            return flag;
        }

        private URL getHealthCheckURL(URL u) {
            URL url = null;
            int port = u.getPort();
            String protocol = u.getProtocol();
            if (port == -1) {
                port = protocol.equalsIgnoreCase("http") ? 80 : 443;
            }
            StringBuffer buff = new StringBuffer(protocol);
            buff.append("://").append(u.getHost()).append(":").append(port).append(hcPath);
            try {
                url = new URL(buff.toString());
            }
            catch (MalformedURLException e) {
                debug.error("URLChecker.getHealthCheckURL() : Incorrect URL : " + e.toString());
            }
            return url;
        }
    }

    class URLStatus {
        public static final int STATUS_UNKNOWN = 0;
        public static final int STATUS_AVAILABLE = 1;
        public static final int STATUS_UNAVAILABLE = -1;
        private int status = -1;
        private Date lastStatusUpdatedTime = null;

        public URLStatus() {
            this.setStatus(0);
            this.lastStatusUpdatedTime = Calendar.getInstance().getTime();
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
            if (this.getStatus() != 0) {
                this.lastStatusUpdatedTime = Calendar.getInstance().getTime();
            }
        }

        public Date getLastStatusUpdatedTime() {
            return this.lastStatusUpdatedTime;
        }
    }
}

