/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.util;

import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.interfaces.ISearchIndex;
import com.sun.identity.entitlement.util.RelaxedURL;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNameSplitter
implements ISearchIndex {
    @Override
    public ResourceSearchIndexes getIndexes(String resName) {
        try {
            RelaxedURL url = new RelaxedURL(resName);
            Set<String> hostIndexes = ResourceNameSplitter.splitHost(url);
            Set<String> pathIndexes = ResourceNameSplitter.splitPath(url);
            String path = url.getPath();
            if (path.length() == 0) {
                path = "/";
            }
            HashSet<String> parentPath = new HashSet<String>();
            parentPath.add(path);
            return new ResourceSearchIndexes(hostIndexes, pathIndexes, parentPath);
        }
        catch (MalformedURLException e) {
            HashSet<String> setHost = new HashSet<String>();
            setHost.add(".");
            Set<String> setPath = ResourceNameSplitter.splitPath(resName);
            HashSet<String> parentPath = new HashSet<String>();
            parentPath.add(resName);
            return new ResourceSearchIndexes(setHost, setPath, parentPath);
        }
    }

    public static Set<String> splitHost(RelaxedURL url) {
        HashSet<String> results = new HashSet<String>();
        String host = url.getHostname().toLowerCase();
        results.add("://");
        results.add("://" + host);
        List<String> dns = ResourceNameSplitter.getDNS(host);
        String buff = "";
        for (String s : dns) {
            if (buff.length() > 0) {
                results.add("://." + s + buff);
            } else {
                results.add("://." + s);
            }
            buff = buff + "." + s;
        }
        return results;
    }

    private static List<String> getDNS(String host) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(host, ".");
        boolean first = true;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (first) {
                first = false;
                continue;
            }
            result.add(0, s);
        }
        return result;
    }

    private static Set<String> splitPath(RelaxedURL url) {
        HashSet<String> results = new HashSet<String>();
        Set<String> queries = ResourceNameSplitter.normalizeQuery(url.getQuery());
        results.add("/");
        for (String q : queries) {
            results.add("/?" + q);
        }
        Set<String> paths = ResourceNameSplitter.splitPath(url.getPath());
        results.addAll(paths);
        for (String p : paths) {
            for (String q : queries) {
                results.add(p + "?" + q);
            }
        }
        return results;
    }

    private static Set<String> splitPath(String path) {
        HashSet<String> results = new HashSet<String>();
        if ((path = path.toLowerCase()).length() > 0 && !path.equals("/")) {
            String prefix = "";
            StringTokenizer st = new StringTokenizer(path, "/");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                prefix = prefix + "/" + s;
                results.add(prefix);
            }
        }
        return results;
    }

    private static Set<String> normalizeQuery(String path) {
        HashSet<String> results = new HashSet<String>();
        if (path == null || path.length() == 0) {
            return results;
        }
        path = path.toLowerCase();
        ArrayList possibleCombinations = new ArrayList();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, "&");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        possibleCombinations.add(list);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : list) {
            int idx = s.indexOf(61);
            String string = idx == -1 ? s : s.substring(0, idx);
            String val = idx == -1 || idx == s.length() - 1 ? "" : s.substring(idx + 1);
            map.put(string, val);
        }
        HashSet<String> keys = new HashSet<String>();
        for (String s : map.keySet()) {
            keys.add(s);
        }
        ArrayList<String> allBlanks = new ArrayList<String>();
        for (String string : keys) {
            allBlanks.add(string + "=");
        }
        possibleCombinations.add(allBlanks);
        while (!keys.isEmpty()) {
            String s = (String)keys.iterator().next();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String key : map.keySet()) {
                String val = key.equals(s) ? "" : (String)map.get(key);
                arrayList.add(key + "=" + val);
            }
            possibleCombinations.add(arrayList);
            keys.remove(s);
        }
        for (List list2 : possibleCombinations) {
            results.add(ResourceNameSplitter.queryToString(list2));
        }
        return results;
    }

    static String queryToString(List<String> query) {
        StringBuffer buff = new StringBuffer();
        Collections.sort(query);
        boolean first = true;
        for (String s : query) {
            if (first) {
                first = false;
            } else {
                buff.append("&");
            }
            buff.append(s);
        }
        return buff.toString();
    }
}

