/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.remote;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.remote.IdRemoteServicesImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.SMSSchema;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class IdRemoteEventListener {
    private static Debug debug;
    private static SOAPClient client;
    private static IdRemoteEventListener instance;
    private static final String NOTIFICATION_PROPERTY = "com.sun.identity.idm.remote.notification.enabled";
    private static final String CACHE_POLLING_TIME_PROPERTY = "com.iplanet.am.sdk.remote.pollingTime";
    private static final int DEFAULT_CACHE_POLLING_TIME = 1;
    private static final String IDREPO_SERVICE = "IdRepoServiceIF";
    public static final String METHOD = "method";
    public static final String ENTITY_NAME = "entityName";
    public static final String EVENT_TYPE = "eventType";
    public static final String ATTR_NAMES = "attrNames";
    public static final String OBJECT_CHANGED = "objectChanged";
    public static final String ALL_OBJECTS_CHANGED = "allObjectsChanged";

    public static synchronized IdRemoteEventListener getInstance() {
        if (instance == null) {
            instance = new IdRemoteEventListener();
        }
        return instance;
    }

    private IdRemoteEventListener() {
        String notificationFlag;
        if (debug == null) {
            debug = IdRemoteServicesImpl.getDebug();
        }
        if (client == null) {
            client = new SOAPClient("DirectoryManagerIF");
        }
        if ((notificationFlag = SystemProperties.get(NOTIFICATION_PROPERTY, "true")).equalsIgnoreCase("true")) {
            URL url = null;
            try {
                url = WebtopNaming.getNotificationURL();
                client.send("registerNotificationURL_idrepo", (Object)url.toString(), null, null);
                PLLClient.addNotificationHandler(IDREPO_SERVICE, new IdRepoEventNotificationHandler());
                if (debug.messageEnabled()) {
                    debug.message("EventService: Using notification mechanism for cache updates: " + url.toString());
                }
            }
            catch (Exception e) {
                if (debug.warningEnabled()) {
                    debug.warning("EventService: Registering for notification via URL failed for " + url + " Exception: " + e.getMessage() + "\nUsing polling mechanism for updates");
                }
                IdRemoteEventListener.startPollingThreadIfEnabled(this.getCachePollingInterval());
            }
        } else {
            IdRemoteEventListener.startPollingThreadIfEnabled(this.getCachePollingInterval());
        }
    }

    private int getCachePollingInterval() {
        String cachePollingTimeStr = SystemProperties.get(CACHE_POLLING_TIME_PROPERTY);
        int cachePollingInterval = 1;
        if (cachePollingTimeStr != null) {
            try {
                cachePollingInterval = Integer.parseInt(cachePollingTimeStr);
            }
            catch (NumberFormatException nfe) {
                debug.error("EventListener::NotificationRunnable:: Invalid Polling Time: " + cachePollingTimeStr + " Defaulting to " + 1 + " minute");
            }
        }
        return cachePollingInterval;
    }

    private static void startPollingThreadIfEnabled(int cachePollingInterval) {
        if (cachePollingInterval > 0) {
            if (debug.messageEnabled()) {
                debug.message("EventListener: Polling mode enabled. Starting the polling thread..");
            }
            NotificationRunnable nt = new NotificationRunnable(cachePollingInterval);
            SystemTimer.getTimer().schedule((TaskRunnable)nt, new Date(System.currentTimeMillis() / 1000L * 1000L));
        } else if (debug.warningEnabled()) {
            debug.warning("EventListener: Polling mode DISABLED. com.iplanet.am.sdk.remote.pollingTime=" + cachePollingInterval);
        }
    }

    static void sendIdRepoNotification(String nItem) {
        block15: {
            if (debug.messageEnabled()) {
                debug.message("EventListener::sendIdRepoNotification: Received notification.");
            }
            StringBuffer sb = new StringBuffer(nItem.length() + 50);
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(nItem);
            try {
                Map attrs = CreateServiceConfig.getAttributeValuePairs(SMSSchema.getXMLDocument(sb.toString(), false).getDocumentElement(), false);
                if (attrs == null || attrs.isEmpty()) {
                    if (debug.warningEnabled()) {
                        debug.warning("EventListener::sendIdRepoNotification: Invalid event: " + attrs);
                    }
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("EventListener::sendIdRepoNotification Decoded Event: " + attrs);
                }
                String entityName = IdRemoteEventListener.getAttributeValue(attrs, ENTITY_NAME);
                String method = IdRemoteEventListener.getAttributeValue(attrs, METHOD);
                if (entityName == null || entityName.length() == 0 || method == null || method.length() == 0) {
                    if (debug.warningEnabled()) {
                        debug.warning("EventListener::sendIdRepoNotification: Invalid universalID or method: " + entityName + " method");
                    }
                    return;
                }
                IdRepoListener repoListener = new IdRepoListener();
                String realm = null;
                if (entityName.toLowerCase().indexOf(",amsdkdn=") != -1) {
                    AMIdentity id = new AMIdentity(null, entityName);
                    realm = id.getRealm();
                } else {
                    DN entityDN = new DN(entityName);
                    realm = entityDN.getParent().getParent().toRFCString();
                }
                if (debug.messageEnabled()) {
                    debug.message("EventListener::sendIdRepoNotification: modified UUID: " + entityName + " realm: " + realm);
                }
                HashMap<String, String> configMap = new HashMap<String, String>();
                configMap.put("realm", realm);
                repoListener.setConfigMap(configMap);
                if (method.equalsIgnoreCase(OBJECT_CHANGED)) {
                    int eventType = IdRemoteEventListener.getEventType((Set)attrs.get(EVENT_TYPE));
                    repoListener.objectChanged(entityName, null, eventType, null);
                } else if (method.equalsIgnoreCase(ALL_OBJECTS_CHANGED)) {
                    repoListener.allObjectsChanged();
                } else {
                    IdRemoteEventListener.handleError("invalid method name: " + method);
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block15;
                debug.warning("EventListener::sendIdRepoNotification: Unable to send notification: " + nItem, (Throwable)e);
            }
        }
    }

    static void handleError(String msg) throws Exception {
        debug.error("EventListener::sendNotification: " + msg);
        throw new Exception(msg);
    }

    static String getAttributeValue(Map attrs, String attrName) {
        String answer = null;
        Set set = (Set)attrs.get(attrName);
        if (set != null && set.size() == 1) {
            answer = (String)set.iterator().next();
        }
        return answer;
    }

    static int getEventType(Set eventSet) throws Exception {
        if (eventSet == null || eventSet.size() != 1) {
            throw new Exception("EventListener::sendNotification: invalid event type: " + eventSet);
        }
        String eventString = (String)eventSet.iterator().next();
        return Integer.parseInt(eventString);
    }

    static class IdRepoEventNotificationHandler
    implements NotificationHandler {
        IdRepoEventNotificationHandler() {
        }

        public void process(Vector notifications) {
            for (int i = 0; i < notifications.size(); ++i) {
                Notification notification = (Notification)notifications.elementAt(i);
                String content = notification.getContent();
                if (debug.messageEnabled()) {
                    debug.message("IdRemoteEventListener:IdRepoEventNotificationHandler:  received notification: " + content);
                }
                IdRemoteEventListener.sendIdRepoNotification(content);
            }
        }
    }

    static class NotificationRunnable
    extends GeneralTaskRunnable {
        private int pollingTime;
        private long runPeriod;

        NotificationRunnable(int interval) {
            this.pollingTime = interval;
            this.runPeriod = this.pollingTime * 1000 * 60;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }

        public void run() {
            block5: {
                String installTime = SystemProperties.get("installTime", "false");
                if (installTime.equalsIgnoreCase("true")) {
                    return;
                }
                try {
                    Object[] obj = new Object[]{new Integer(this.pollingTime)};
                    Set mods = (Set)client.send("objectsChanged_idrepo", obj, null, null);
                    if (debug.messageEnabled()) {
                        debug.message("IdRemoteEventListener:NotificationRunnable retrived idrepo changes: " + mods);
                    }
                    Iterator items = mods.iterator();
                    while (items.hasNext()) {
                        IdRemoteEventListener.sendIdRepoNotification((String)items.next());
                    }
                }
                catch (Exception ex) {
                    if (!debug.warningEnabled()) break block5;
                    debug.warning("IdRemoteEventListener::NotificationRunnable:run Exception", (Throwable)ex);
                }
            }
        }
    }
}

