/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthXMLHandler;
import com.sun.identity.authentication.service.AuthConfigMonitor;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProviderBase;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AuthD {
    public static Debug debug;
    private static Map bundles;
    private static AuthD authInstance;
    private static boolean authInitFailed;
    private static String superAdmin;
    private static String specialUser;
    private static final String consoleProto;
    private static final String consoleHost;
    private static final String consolePort;
    private static final boolean isConsoleRemote;
    public static final String DEFAULT_AUTH_LEVEL = "0";
    public static final int LOG_ACCESS = 0;
    public static final int LOG_ERROR = 1;
    public static Hashtable sAuth;
    public static boolean enforceJAASThread;
    public static String directoryHostName;
    public static int directoryPort;
    public static int revisionNumber;
    private static HashMap idRepoMap;
    private static HashMap orgMap;
    public static final String BUNDLE_NAME = "amAuth";
    private String defaultOrg;
    private String platformLocale;
    private String platformCharset;
    private Set platformClientCharsets;
    public ResourceBundle bundle;
    private SSOToken ssoAuthSession;
    private Session authSession;
    private AMStoreConnection dpStore;
    String clientDetectionClass;
    public static String platLocale;
    private String defaultAuthLocale;
    ServiceSchema platformSchema;
    ServiceSchema sessionSchema;
    private static boolean logStatus;
    public Set defaultSuccessURLSet;
    public String defaultSuccessURL;
    public Set defaultFailureURLSet;
    public String defaultFailureURL;
    public Set defaultServiceSuccessURLSet;
    public Set defaultServiceFailureURLSet;
    private String adminAuthModule;
    public String defaultAuthLevel;
    private Hashtable authMethods;
    private long defaultSleepTime;
    private ServletContext servletContext;
    private static boolean useHttpSession;
    String rootSuffix;
    Logger logger;

    private AuthD() {
        block4: {
            this.bundle = null;
            this.ssoAuthSession = null;
            this.authSession = null;
            this.dpStore = null;
            this.clientDetectionClass = null;
            this.defaultSuccessURLSet = null;
            this.defaultSuccessURL = null;
            this.defaultFailureURLSet = null;
            this.defaultFailureURL = null;
            this.defaultServiceSuccessURLSet = null;
            this.defaultServiceFailureURLSet = null;
            this.authMethods = new Hashtable();
            this.defaultSleepTime = 300L;
            this.rootSuffix = null;
            this.logger = null;
            debug.message("AuthD initializing");
            try {
                this.rootSuffix = this.defaultOrg = ServiceManager.getBaseDN();
                this.initAuthSessions();
                this.initAuthServiceGlobalSettings();
                this.initPlatformServiceGlobalSettings();
                this.initSessionServiceDynamicSettings();
                this.initAuthConfigGlobalSettings();
                this.bundle = Locale.getInstallResourceBundle((String)BUNDLE_NAME);
                ResourceBundle platBundle = Locale.getInstallResourceBundle((String)"amPlatform");
                this.platformCharset = platBundle.getString("iplanet-am-platform-html-char-set");
                this.printProfileAttrs();
                new AuthXMLHandler();
                authInitFailed = false;
            }
            catch (Exception ex) {
                debug.error("AuthD init()", (Throwable)ex);
                authInitFailed = true;
            }
            try {
                enforceJAASThread = Boolean.valueOf(SystemProperties.get("com.sun.identity.authentication.usingJaasThread"));
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block4;
                debug.message("Wrong format of com.sun.identity.authentication.usingJaasThread");
            }
        }
    }

    private void initAuthServiceGlobalSettings() throws SMSException, SSOException, Exception {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthService", this.ssoAuthSession);
        revisionNumber = scm.getRevisionNumber();
        if (debug.messageEnabled()) {
            debug.message("revision number = " + revisionNumber);
        }
        this.updateAuthServiceGlobals(scm);
        new AuthConfigMonitor(scm);
    }

    synchronized void updateAuthServiceGlobals(ServiceSchemaManager scm) throws SMSException, Exception {
        ServiceSchema schema = scm.getOrganizationSchema();
        Map attrs = schema.getAttributeDefaults();
        schema = scm.getGlobalSchema();
        attrs.putAll(schema.getAttributeDefaults());
        if (debug.messageEnabled()) {
            debug.message("attrs : " + attrs);
        }
        this.defaultAuthLocale = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-locale");
        this.adminAuthModule = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-admin-auth-module");
        this.defaultAuthLevel = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-default-auth-level", (String)DEFAULT_AUTH_LEVEL);
        Set s = (Set)attrs.get("iplanet-am-auth-authenticators");
        for (String name : s) {
            int dot = name.lastIndexOf(46);
            if (dot > -1) {
                String tmp = name.substring(dot + 1, name.length());
                this.authMethods.put(tmp, name);
                continue;
            }
            this.authMethods.put(name, name);
        }
        if (debug.messageEnabled()) {
            debug.message("AM.update authMethods = " + this.authMethods.toString());
        }
        this.defaultSuccessURLSet = (Set)attrs.get("iplanet-am-auth-login-success-url");
        this.defaultFailureURLSet = (Set)attrs.get("iplanet-am-auth-login-failure-url");
        if (debug.messageEnabled()) {
            debug.message("Default Success URL Set = " + this.defaultSuccessURLSet);
            debug.message("Default Failure URL Set = " + this.defaultFailureURLSet);
        }
        Integer sleepTime = new Integer(CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-sleep-interval"));
        this.defaultSleepTime = sleepTime.longValue();
    }

    private void initAuthConfigGlobalSettings() throws SMSException, SSOException, Exception {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthConfiguration", this.ssoAuthSession);
        this.updateAuthConfigGlobals(scm);
        new AuthConfigMonitor(scm);
    }

    synchronized void updateAuthConfigGlobals(ServiceSchemaManager scm) throws SMSException {
        ServiceSchema schema = scm.getOrganizationSchema();
        schema = schema.getSubSchema("Configurations");
        Map attrs = (schema = schema.getSubSchema("NamedConfiguration")).getAttributeDefaults();
        if (attrs != null) {
            this.defaultServiceSuccessURLSet = (Set)attrs.get("iplanet-am-auth-login-success-url");
            this.defaultServiceFailureURLSet = (Set)attrs.get("iplanet-am-auth-login-failure-url");
        }
        if (debug.messageEnabled()) {
            debug.message("Default Service Success URL Set = " + this.defaultServiceSuccessURLSet);
            debug.message("Default Service Failure URL Set = " + this.defaultServiceFailureURLSet);
        }
    }

    private void initPlatformServiceGlobalSettings() throws SMSException, SSOException {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMPlatformService", this.ssoAuthSession);
        this.updatePlatformServiceGlobals(scm);
        new AuthConfigMonitor(scm);
    }

    synchronized void updatePlatformServiceGlobals(ServiceSchemaManager scm) throws SMSException {
        this.platformSchema = scm.getGlobalSchema();
        Map attrs = this.platformSchema.getAttributeDefaults();
        this.platformLocale = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-platform-locale");
        this.platformClientCharsets = (Set)attrs.get("iplanet-am-platform-client-charsets");
        if (debug.messageEnabled()) {
            debug.message("PlatformLocale = " + this.platformLocale + "\nplatformClientCharsets = " + this.platformClientCharsets);
        }
    }

    private void initSessionServiceDynamicSettings() throws SMSException, SSOException {
        ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMSessionService", this.ssoAuthSession);
        this.updateSessionServiceDynamics(scm);
        new AuthConfigMonitor(scm);
    }

    synchronized void updateSessionServiceDynamics(ServiceSchemaManager scm) throws SMSException {
        this.sessionSchema = scm.getDynamicSchema();
        if (debug.messageEnabled()) {
            Map attrs = this.sessionSchema.getAttributeDefaults();
            String defaultMaxSessionTime = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-session-max-session-time", (String)"120");
            String defaultMaxIdleTime = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-session-max-idle-time", (String)"30");
            String defaultMaxCachingTime = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-session-max-caching-time", (String)"3");
            debug.message("AuthD.defaultMaxSessionTime=" + defaultMaxSessionTime + "\nAuthD.defaultMaxIdleTime=" + defaultMaxIdleTime + "\nAuthD.defaultMaxCachingTime=" + defaultMaxCachingTime);
        }
    }

    String getDefaultMaxSessionTime() {
        return CollectionHelper.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-session-time", (String)"120");
    }

    String getDefaultMaxIdleTime() {
        return CollectionHelper.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-idle-time", (String)"30");
    }

    String getDefaultMaxCachingTime() {
        return CollectionHelper.getMapAttr((Map)this.sessionSchema.getAttributeDefaults(), (String)"iplanet-am-session-max-caching-time", (String)"3");
    }

    public Map getOrgServiceAttributes(String orgDN, String serviceName) {
        Map map;
        block3: {
            map = Collections.EMPTY_MAP;
            try {
                AMIdentityRepository idRepo = this.getAMIdentityRepository(orgDN);
                AMIdentity realmIdentity = idRepo.getRealmIdentity();
                Set set = realmIdentity.getAssignedServices();
                if (set.contains(serviceName)) {
                    map = realmIdentity.getServiceAttributes(serviceName);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("Exception in getting service attributes for " + serviceName + " in org " + orgDN);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthD getAuth() {
        if (authInstance != null) return authInstance;
        Class<AuthD> clazz = AuthD.class;
        synchronized (AuthD.class) {
            if (authInstance != null) return authInstance;
            authInstance = new AuthD();
            if (!authInitFailed) return authInstance;
            authInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return authInstance;
        }
    }

    public void destroySession(SessionID sid) {
        AuthD.getSS().destroyInternalSession(sid);
    }

    public void logoutSession(SessionID sid) {
        AuthD.getSS().logoutInternalSession(sid);
    }

    public static InternalSession newSession(String domain, HttpSession httpSession) {
        InternalSession is = null;
        try {
            is = AuthD.getSS().newInternalSession(domain, httpSession);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            debug.error("Error creating session: ", (Throwable)ex);
        }
        return is;
    }

    public static InternalSession getSession(String sessId) {
        if (debug.messageEnabled()) {
            debug.message("getSession for " + sessId);
        }
        InternalSession is = null;
        if (sessId != null) {
            SessionID sid = new SessionID(sessId);
            is = AuthD.getSession(sid);
        }
        if (is == null) {
            debug.message("getSession returned null");
        }
        return is;
    }

    public static InternalSession getSession(SessionID sid) {
        InternalSession is = null;
        if (sid != null) {
            is = AuthD.getSS().getInternalSession(sid);
        }
        return is;
    }

    public InternalSession getSession(HttpServletRequest req) {
        SessionID sid = new SessionID(req);
        return AuthD.getSession(sid);
    }

    public String getAuthenticatorForName(String moduleName) {
        return (String)this.authMethods.get(moduleName);
    }

    public boolean containsAuthenticator(String module) {
        return this.authMethods.containsKey(module);
    }

    public Iterator getAuthenticators() {
        return this.authMethods.keySet().iterator();
    }

    public int getAuthenticatorCount() {
        return this.authMethods.size();
    }

    public String getPlatformCharset() {
        return this.platformCharset;
    }

    public String getPlatformLocale() {
        return this.platformLocale;
    }

    public String getCoreAuthLocaleFromAuthService() {
        return this.defaultAuthLocale;
    }

    public String getDefaultAuthLocale() {
        if (this.defaultAuthLocale == null || this.defaultAuthLocale.length() == 0) {
            return "en_US";
        }
        return this.defaultAuthLocale;
    }

    public void logLogout(SSOToken ssot) {
        try {
            String authMethName;
            String orgDN;
            String userDN;
            String logLogout = this.bundle.getString("logout");
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(logLogout);
            StringBuffer messageId = new StringBuffer();
            messageId.append("LOGOUT");
            String indexType = ssot.getProperty("IndexType");
            if (indexType != null) {
                messageId.append("_").append(indexType.toString().toUpperCase());
                dataList.add(indexType.toString());
                if (indexType.equals(AuthContext.IndexType.USER.toString())) {
                    dataList.add(ssot.getProperty("Principal"));
                } else if (indexType.equals(AuthContext.IndexType.ROLE.toString())) {
                    dataList.add(ssot.getProperty("Role"));
                } else if (indexType.equals(AuthContext.IndexType.SERVICE.toString())) {
                    dataList.add(ssot.getProperty("Service"));
                } else if (indexType.equals(AuthContext.IndexType.LEVEL.toString())) {
                    dataList.add(ssot.getProperty("AuthLevel"));
                } else if (indexType.equals(AuthContext.IndexType.MODULE_INSTANCE.toString())) {
                    dataList.add(ssot.getProperty("AuthType"));
                }
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            String client = ssot.getProperty("Host");
            if (client != null) {
                props.put("IPAddr", client);
            }
            if ((userDN = ssot.getProperty("Principal")) != null) {
                props.put("LoginID", userDN);
            }
            if ((orgDN = ssot.getProperty("Organization")) != null) {
                props.put("Domain", orgDN);
            }
            if ((authMethName = ssot.getProperty("AuthType")) != null) {
                props.put("ModuleName", authMethName);
            }
            String contextId = null;
            contextId = ssot.getProperty("AMCtxId");
            if (contextId != null) {
                props.put("ContextID", contextId);
            }
            props.put("LoginIDSid", ((Object)ssot.getTokenID()).toString());
            String[] data = dataList.toArray(new String[0]);
            this.logIt(data, 0, messageId.toString(), props);
        }
        catch (SSOException ssoExp) {
            debug.error("AuthD.logLogout: SSO Error", (Throwable)((Object)ssoExp));
        }
        catch (Exception e) {
            debug.error("AuthD.logLogout: Error ", (Throwable)e);
        }
    }

    public void logIt(String[] s, int type, String messageName, Hashtable ssoProperties) {
        if (logStatus && s != null) {
            try {
                LogMessageProviderBase provider = (LogMessageProviderBase)MessageProviderFactory.getProvider("Authentication");
                LogRecord lr = null;
                SSOToken ssot = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                lr = ssoProperties == null ? provider.createLogRecord(messageName, s, ssot) : provider.createLogRecord(messageName, s, ssoProperties);
                switch (type) {
                    case 0: {
                        this.logger = (Logger)Logger.getLogger("amAuthentication.access");
                        this.logger.log(lr, ssot);
                        break;
                    }
                    case 1: {
                        this.logger = (Logger)Logger.getLogger("amAuthentication.error");
                        this.logger.log(lr, ssot);
                        break;
                    }
                    default: {
                        this.logger = (Logger)Logger.getLogger("amAuthentication.access");
                        this.logger.log(lr, ssot);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                debug.error("Logging exception : " + ex.getMessage());
            }
        }
    }

    public AMStoreConnection getSDK() {
        if (this.dpStore == null) {
            try {
                this.dpStore = new AMStoreConnection(this.ssoAuthSession);
            }
            catch (SSOException e) {
                debug.warning("AuthD.getSDK", (Throwable)((Object)e));
            }
        }
        return this.dpStore;
    }

    void printProfileAttrs() {
        if (!debug.messageEnabled()) {
            return;
        }
        debug.message("Authd Profile Attributes");
        String adminAuthName = this.adminAuthModule;
        int index = this.adminAuthModule.lastIndexOf(".");
        if (index > 0) {
            adminAuthName = this.adminAuthModule.substring(index + 1);
        }
        if (debug.messageEnabled()) {
            debug.message("adminAuthModule->" + this.adminAuthModule + "\nadminAuthName->" + adminAuthName + "\ndefaultOrg->" + this.defaultOrg + "\nlocale->" + this.platformLocale + "\ncharset>" + this.platformCharset);
        }
    }

    static SessionService getSS() {
        SessionService ss = SessionService.getSessionService();
        if (ss == null) {
            debug.error("AuthD failed to get session service instance");
        }
        return ss;
    }

    public String getDefaultOrg() {
        return this.defaultOrg;
    }

    public Session getAuthSession() {
        return this.authSession;
    }

    public SSOToken getSSOAuthSession() {
        return this.ssoAuthSession;
    }

    private void initAuthSessions() throws SSOException, SessionException {
        if (this.authSession == null) {
            this.authSession = AuthD.getSS().getAuthenticationSession(this.defaultOrg, null);
            if (this.authSession == null) {
                debug.error("AuthD failed to get auth session");
                throw new SessionException(BUNDLE_NAME, "gettingSessionFailed", null);
            }
            String clientID = this.authSession.getClientID();
            this.authSession.setProperty("Principal", clientID);
            this.authSession.setProperty("Organization", this.defaultOrg);
            this.authSession.setProperty("Host", this.authSession.getID().getSessionServer());
            if (DN.isDN((String)clientID)) {
                DN dn = new DN(clientID);
                String[] tokens = dn.explodeDN(true);
                String id = "id=" + tokens[0] + ",ou=user," + ServiceManager.getBaseDN();
                this.authSession.setProperty("sun.am.UniversalIdentifier", id);
            }
            SSOTokenManager ssoManager = SSOTokenManager.getInstance();
            this.ssoAuthSession = ssoManager.createSSOToken(this.authSession.getID().toString());
        }
    }

    boolean getInetDomainStatus(String orgName) throws IdRepoException, SSOException {
        return IdUtils.isOrganizationActive(this.ssoAuthSession, orgName);
    }

    public String getClientPlatformCharset(Vector charsetVector, String clientType) {
        String plCharSet;
        block11: {
            block10: {
                String platformClientCharset;
                if (debug.messageEnabled()) {
                    debug.message("platform charset : " + this.platformCharset);
                }
                if ((platformClientCharset = this.getClientCharsets(clientType)) != null && platformClientCharset.length() > 0) {
                    return platformClientCharset;
                }
                plCharSet = null;
                try {
                    if (charsetVector.contains(this.platformCharset)) {
                        plCharSet = this.platformCharset;
                    }
                }
                catch (Exception ee) {
                    if (!debug.warningEnabled()) break block10;
                    debug.warning("Exception: getClientPlatformCharset :", (Throwable)ee);
                }
            }
            if (plCharSet != null && plCharSet.length() > 0) {
                return plCharSet;
            }
            try {
                plCharSet = (String)charsetVector.firstElement();
                if (debug.messageEnabled()) {
                    debug.message("Platform CharSet is.. :" + plCharSet);
                }
            }
            catch (Exception ie) {
                if (!debug.warningEnabled()) break block11;
                debug.warning("Exception:getPlatformCharsets :", (Throwable)ie);
            }
        }
        if (plCharSet != null && plCharSet.length() > 0) {
            return plCharSet;
        }
        return this.platformCharset;
    }

    String getClientCharsets(String clientType) {
        String cliTypeCharset;
        block4: {
            cliTypeCharset = null;
            try {
                if (this.platformClientCharsets == null) break block4;
                for (String charsetElem : this.platformClientCharsets) {
                    String cliType;
                    int i;
                    if (charsetElem == null || charsetElem.length() <= 0 || (i = charsetElem.indexOf("|")) == -1 || !(cliType = charsetElem.substring(0, i)).equals(clientType)) continue;
                    cliTypeCharset = charsetElem.substring(i + 1);
                    if (debug.messageEnabled()) {
                        debug.message("clientCharset:" + cliTypeCharset);
                    }
                    break;
                }
            }
            catch (Exception ee) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("Exception:getClientCharsets : ", (Throwable)ee);
            }
        }
        return cliTypeCharset;
    }

    public boolean isSuperAdmin(String dn) {
        boolean isAdmin = false;
        String nDN = DNUtils.normalizeDN(dn);
        if (nDN != null && (superAdmin != null || specialUser != null)) {
            if (debug.messageEnabled()) {
                debug.message("passed dn is :" + dn);
            }
            if (superAdmin != null) {
                if (debug.messageEnabled()) {
                    debug.message("normalized super dn is :" + superAdmin);
                }
                isAdmin = nDN.equals(superAdmin);
            }
            if (!isAdmin) {
                isAdmin = this.isSpecialUser(nDN);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("is Super Admin :" + isAdmin);
        }
        return isAdmin;
    }

    public boolean isSpecialUser(String dn) {
        boolean isSpecialUser = false;
        String nDN = DNUtils.normalizeDN(dn);
        if (nDN != null && specialUser != null) {
            StringTokenizer st = new StringTokenizer(specialUser, "|");
            while (st.hasMoreTokens()) {
                String specialAdminDN = st.nextToken();
                if (specialAdminDN == null) continue;
                String normSpecialAdmin = DNUtils.normalizeDN(specialAdminDN);
                if (debug.messageEnabled()) {
                    debug.message("normalized special dn is :" + normSpecialAdmin);
                }
                if (!nDN.equals(normSpecialAdmin)) continue;
                isSpecialUser = true;
                break;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("is Special User :" + isSpecialUser);
        }
        return isSpecialUser;
    }

    public ResourceBundle getResourceBundle(String locale) {
        if (locale == null) {
            return this.bundle;
        }
        ResourceBundle rb = (ResourceBundle)bundles.get(locale);
        if (rb == null) {
            rb = Locale.getResourceBundle((String)BUNDLE_NAME, (String)locale);
            if (rb == null) {
                rb = this.bundle;
            }
            bundles.put(locale, rb);
        }
        return rb;
    }

    public long getDefaultSleepTime() {
        return this.defaultSleepTime * 1000L;
    }

    public String getOrgDN(String userOrg) {
        DN userOrgDN = new DN(userOrg);
        DN rootSuffixDN = new DN(this.rootSuffix);
        String orgDN = null;
        if (debug.messageEnabled()) {
            debug.message("userOrg is : " + userOrg);
            debug.message("rootSuffix is : " + this.rootSuffix);
            debug.message("rootSuffixDN is : " + rootSuffixDN);
            debug.message("userOrgDN is : " + userOrgDN);
        }
        orgDN = userOrgDN.equals(rootSuffixDN) || userOrgDN.isDescendantOf(rootSuffixDN) ? userOrgDN.toString() : new StringBuffer(50).append(userOrgDN.toString()).append(",").append(rootSuffixDN).toString();
        if (debug.messageEnabled()) {
            debug.message("Returning OrgDN is : " + orgDN);
        }
        return orgDN.toString();
    }

    public String processURL(String URL2, HttpServletRequest servletRequest) {
        String url = URL2;
        if (url != null) {
            url = this.processDynamicVariables(url, servletRequest);
        }
        if (debug.messageEnabled()) {
            debug.message("processURL : " + url);
        }
        return url;
    }

    private String processDynamicVariables(String rawURL, HttpServletRequest servletRequest) {
        if (rawURL.indexOf("%") != -1) {
            StringBuffer sb = new StringBuffer(200);
            int index = rawURL.indexOf("%protocol");
            if (index != -1) {
                sb.append(rawURL.substring(0, index));
                if (isConsoleRemote) {
                    sb.append(consoleProto);
                } else {
                    String protocol = null;
                    if (servletRequest != null) {
                        protocol = RequestUtils.getRedirectProtocol(servletRequest.getScheme(), servletRequest.getServerName());
                    }
                    if (protocol != null) {
                        sb.append(protocol);
                    } else {
                        sb.append(consoleProto);
                    }
                }
                sb.append(rawURL.substring(index + "%protocol".length()));
                rawURL = sb.toString();
            }
            if ((index = rawURL.indexOf("%host")) != -1) {
                int hostlen = "%host".length();
                sb.delete(0, 200);
                sb.append(rawURL.substring(0, index));
                if (isConsoleRemote) {
                    sb.append(consoleHost);
                } else {
                    String host = null;
                    if (servletRequest != null) {
                        host = servletRequest.getHeader("Host");
                    }
                    if (host != null) {
                        sb.append(host);
                        ++hostlen;
                    } else {
                        sb.append(consoleHost);
                    }
                }
                sb.append(rawURL.substring(index + hostlen));
                rawURL = sb.toString();
            }
            if ((index = rawURL.indexOf("%port")) != -1) {
                sb.delete(0, 200);
                sb.append(rawURL.substring(0, index));
                if (isConsoleRemote) {
                    sb.append(consolePort);
                }
                sb.append(rawURL.substring(index + "%port".length()));
                rawURL = sb.toString();
            }
        }
        return rawURL;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        if (debug.messageEnabled()) {
            debug.message("Setting servletContext" + servletContext);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMIdentityRepository getAMIdentityRepository(String orgDN) {
        AMIdentityRepository amIdentityRepository;
        block6: {
            amIdentityRepository = null;
            try {
                if (idRepoMap != null && !idRepoMap.isEmpty()) {
                    amIdentityRepository = (AMIdentityRepository)idRepoMap.get(orgDN);
                }
                if (amIdentityRepository != null) break block6;
                amIdentityRepository = new AMIdentityRepository(this.ssoAuthSession, orgDN);
                HashMap hashMap = idRepoMap;
                synchronized (hashMap) {
                    idRepoMap.put(orgDN, amIdentityRepository);
                }
            }
            catch (Exception id) {
                if (!debug.messageEnabled()) break block6;
                debug.message("Error getAMIdentityRepository", (Throwable)id);
            }
        }
        return amIdentityRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationConfigManager getOrgConfigManager(String orgDN) {
        OrganizationConfigManager orgConfigMgr;
        block7: {
            orgConfigMgr = null;
            try {
                if (orgMap != null && !orgMap.isEmpty()) {
                    orgConfigMgr = (OrganizationConfigManager)orgMap.get(orgDN);
                }
                HashMap hashMap = orgMap;
                synchronized (hashMap) {
                    if (orgConfigMgr == null) {
                        orgConfigMgr = new OrganizationConfigManager(this.ssoAuthSession, orgDN);
                        orgMap.put(orgDN, orgConfigMgr);
                    }
                }
            }
            catch (Exception id) {
                if (!debug.messageEnabled()) break block7;
                debug.message("Error getAMIdentityRepository", (Throwable)id);
            }
        }
        return orgConfigMgr;
    }

    public AMIdentity getIdentity(IdType idType, String idName, String orgName) throws AuthException {
        AMIdentity amIdentity;
        block17: {
            block16: {
                if (debug.messageEnabled()) {
                    debug.message("IdType is :" + idType);
                    debug.message("IdName is :" + idName);
                    debug.message("orgName is :" + orgName);
                }
                amIdentity = null;
                try {
                    if (debug.messageEnabled()) {
                        debug.message("AuthD.getIdentity() from IdUtils Name: " + idName + " Org: " + orgName);
                    }
                    if ((amIdentity = IdUtils.getIdentity(this.getSSOAuthSession(), idName, orgName)) != null && amIdentity.isExists() && amIdentity.getType().equals(idType) && amIdentity.getAttributes() != null) {
                        if (debug.messageEnabled()) {
                            debug.message("AuthD.getIdentity obtained identityusing IdUtil.getIdentity: " + amIdentity);
                        }
                        return amIdentity;
                    }
                }
                catch (IdRepoException e) {
                    if (debug.messageEnabled()) {
                        debug.message("AuthD.getIdentity: Got IdRepoException while getting Identity from IdUtils: " + e.getMessage());
                    }
                }
                catch (SSOException ssoe) {
                    if (!debug.messageEnabled()) break block16;
                    debug.message("AuthD.getIdentity: Got SSOException while getting Identity from IdUtils: " + ssoe.getMessage());
                }
            }
            try {
                amIdentity = null;
                idName = DNUtils.DNtoName(idName);
                AMIdentityRepository amIdRepo = this.getAMIdentityRepository(orgName);
                IdSearchControl idsc = new IdSearchControl();
                idsc.setRecursive(true);
                idsc.setTimeOut(0);
                idsc.setMaxResults(0);
                idsc.setAllReturnAttributes(false);
                IdSearchResults searchResults = amIdRepo.searchIdentities(idType, idName, idsc);
                Set results = Collections.EMPTY_SET;
                if (searchResults != null) {
                    results = searchResults.getSearchResults();
                }
                if (results != null && results.size() > 1) {
                    debug.error("getIdentity: Multiple matches found for user '" + idName);
                    throw new AuthException("102", null);
                }
                Iterator users = results.iterator();
                if (users.hasNext()) {
                    amIdentity = (AMIdentity)users.next();
                }
            }
            catch (SSOException sso) {
                if (debug.messageEnabled()) {
                    debug.message("getIdentity error " + sso.getMessage());
                }
            }
            catch (IdRepoException ide) {
                if (!debug.messageEnabled()) break block17;
                debug.message("IdRepoException error " + ide.getMessage());
            }
        }
        if (amIdentity == null) {
            throw new AuthException("100", null);
        }
        return amIdentity;
    }

    public String getSuperUserName() {
        return superAdmin;
    }

    public static boolean isHttpSessionUsed() {
        return useHttpSession;
    }

    public String getOrgConfiguredAuthenticationChain(String orgDN) {
        String orgAuthConfig = null;
        try {
            OrganizationConfigManager orgConfigMgr = this.getOrgConfigManager(orgDN);
            ServiceConfig svcConfig = orgConfigMgr.getServiceConfig("iPlanetAMAuthService");
            Map attrs = svcConfig.getAttributes();
            orgAuthConfig = Misc.getMapAttr(attrs, "iplanet-am-auth-org-config");
        }
        catch (Exception e) {
            debug.error("Error in getOrgConfiguredAuthenticationChain : ", (Throwable)e);
        }
        return orgAuthConfig;
    }

    static {
        bundles = new HashMap();
        authInitFailed = false;
        superAdmin = DNUtils.normalizeDN(SystemProperties.get("com.sun.identity.authentication.super.user", ""));
        specialUser = SystemProperties.get("com.sun.identity.authentication.special.users", "");
        consoleProto = SystemProperties.get("com.iplanet.am.console.protocol", "http");
        consoleHost = SystemProperties.get("com.iplanet.am.console.host");
        consolePort = SystemProperties.get("com.iplanet.am.console.port");
        isConsoleRemote = Boolean.valueOf(SystemProperties.get("com.iplanet.am.console.remote"));
        enforceJAASThread = false;
        directoryHostName = SystemProperties.get("com.iplanet.am.directory.host");
        idRepoMap = new HashMap();
        orgMap = new HashMap();
        platLocale = SystemProperties.get("com.iplanet.am.locale");
        logStatus = false;
        String status = SystemProperties.get("com.iplanet.am.logstatus", "INACTIVE");
        if ("ACTIVE".equalsIgnoreCase(status)) {
            logStatus = true;
        }
        try {
            directoryPort = Integer.parseInt(SystemProperties.get("com.iplanet.am.directory.port"));
        }
        catch (NumberFormatException nfex) {
            directoryPort = 0;
        }
        String useHttpSessionStr = SystemProperties.get("com.sun.identity.auth.sessionStore");
        if (useHttpSessionStr != null && useHttpSessionStr.equalsIgnoreCase("HttpSession")) {
            useHttpSession = true;
        }
        if ((debug = Debug.getInstance((String)BUNDLE_NAME)).messageEnabled()) {
            debug.message("Directory Host: " + directoryHostName + "\nDirectory PORT : " + directoryPort);
            debug.message("Session store using " + useHttpSessionStr);
        }
    }
}

