/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.ISResourceBundle;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class GetResourceBundle
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String bundleName = this.getStringOptionValue("bundlename");
        String localeName = this.getStringOptionValue("bundlelocale");
        try {
            String[] params = new String[]{bundleName, localeName};
            this.writeLog(0, Level.INFO, "ATTEMPT_GET_RESOURCE_BUNDLE", params);
            ResourceBundle rb = ISResourceBundle.getResourceBundle(adminSSOToken, bundleName, localeName);
            IOutput outputWriter = this.getOutputWriter();
            if (rb != null) {
                Enumeration<String> e = rb.getKeys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    outputWriter.printlnMessage(key + "=" + rb.getString(key));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("resourcebundle-not-found"));
                String[] args = new String[]{bundleName, localeName, "resource bundle not found"};
                this.writeLog(0, Level.INFO, "FAILED_GET_RESOURCE_BUNDLE", args);
                throw new CLIException(this.getResourceString("resourcebundle-not-found"), 127);
            }
            outputWriter.printlnMessage(this.getResourceString("resourcebundle-returned"));
            this.writeLog(0, Level.INFO, "SUCCEED_GET_RESOURCE_BUNDLE", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{bundleName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_GET_RESOURCE_BUNDLE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (MissingResourceException e) {
            String[] args = new String[]{bundleName, localeName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_GET_RESOURCE_BUNDLE", args);
            throw new CLIException(e, 127);
        }
    }
}

