/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.nightly;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MergeSDKProperties {
    private static Set propertyFileNames = new HashSet();
    private static final String AM_SDK = "amSDK";
    private DirFilter dirFilter = new DirFilter();
    private LocaleFileFilter localeFileFilter = new LocaleFileFilter();

    private MergeSDKProperties() {
    }

    private void create(String baseDir, String targetDir) throws IOException {
        StringBuffer buff = new StringBuffer();
        File dir = new File(baseDir);
        File[] directories = dir.listFiles(this.dirFilter);
        for (int i = 0; i < directories.length; ++i) {
            File d = directories[i];
            this.mergeFiles(d, targetDir);
        }
    }

    private void mergeFiles(File dirLocale, String targetDir) throws IOException {
        HashMap map = new HashMap();
        this.getLocaleFiles(dirLocale, map);
        for (String locale : map.keySet()) {
            String content = this.getMergeContent((Set)map.get(locale));
            MergeSDKProperties.writeToFile(targetDir + File.separator + AM_SDK + "_" + locale + ".properties", content);
        }
    }

    private String getMergeContent(Set files) throws IOException {
        StringBuffer buff = new StringBuffer();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            buff.append(MergeSDKProperties.readFile((String)i.next()));
            buff.append("\n");
        }
        return buff.toString();
    }

    private void getLocaleFiles(File dirLocale, Map map) {
        File[] files = dirLocale.listFiles(this.localeFileFilter);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            String path = f.getPath();
            path = path.substring(path.lastIndexOf(File.separatorChar) + 1);
            path = path.substring(0, path.indexOf(".properties"));
            String locale = null;
            Iterator j = propertyFileNames.iterator();
            while (j.hasNext() && locale == null) {
                String m = (String)j.next();
                if (!path.startsWith(m + "_")) continue;
                locale = path.substring(m.length() + 1);
            }
            HashSet<String> set = (HashSet<String>)map.get(locale);
            if (set == null) {
                set = new HashSet<String>();
                map.put(locale, set);
            }
            set.add(f.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String filename) throws IOException {
        StringBuffer buff = new StringBuffer();
        FileReader input = new FileReader(filename);
        BufferedReader bufRead = new BufferedReader(input);
        try {
            String line = bufRead.readLine();
            while (line != null) {
                buff.append(line).append("\n");
                line = bufRead.readLine();
            }
        }
        finally {
            bufRead.close();
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filename, String content) throws IOException {
        if (filename != null) {
            File fileHandle = new File(filename);
            FileWriter out = null;
            try {
                out = new FileWriter(filename);
                out.write(content);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            new MergeSDKProperties().create(args[0], args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        propertyFileNames.add("Services");
        propertyFileNames.add("DSConfig");
        propertyFileNames.add("ums");
        propertyFileNames.add("sso");
        propertyFileNames.add("SMS");
        propertyFileNames.add("authentication_util");
    }

    public class LocaleFileFilter
    implements FileFilter {
        public boolean accept(File a) {
            if (a.isFile() && a.getPath().endsWith(".properties")) {
                String path = a.getPath();
                path = path.substring(path.lastIndexOf(File.separatorChar) + 1);
                path = path.substring(0, path.indexOf(".properties"));
                for (String m : propertyFileNames) {
                    if (!path.startsWith(m + "_")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public class DirFilter
    implements FileFilter {
        public boolean accept(File a) {
            return a.isDirectory() && !a.getPath().endsWith("/CVS");
        }
    }
}

