/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.config.AS9ContainerConfigInfo;
import com.sun.identity.tune.constants.WebContainerConstants;
import com.sun.identity.tune.intr.TuneAppServer;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TuneAS9Container
extends TuneAppServer
implements WebContainerConstants {
    private AMTuneLogger pLogger = AMTuneLogger.getLoggerInst();
    private MessageWriter mWriter = MessageWriter.getInstance();
    private AMTuneConfigInfo configInfo;
    private AS9ContainerConfigInfo asConfigInfo;
    private Map curCfgMap;
    private String passwordStr;

    public void initialize(AMTuneConfigInfo confInfo) throws AMTuneException {
        try {
            this.configInfo = confInfo;
            this.asConfigInfo = (AS9ContainerConfigInfo)confInfo.getWSConfigInfo();
            this.passwordStr = "AS_ADMIN_PASSWORD=" + this.asConfigInfo.getAsAdminPass();
            this.curCfgMap = this.asConfigInfo.getCurASConfigInfo();
            this.validateInstanceDir();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "initialize", "Error initializing Application server 9.1.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-app-tuning-msg");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.tuneDomainXML();
            if (AMTuneUtil.isLinux()) {
                this.tuneSecurityLimits();
            }
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error Tuning Application server 9.1.");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-web-tuning-error-msg");
            this.mWriter.writelnLocaleMsg("pt-manual-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.deletePasswordFile();
            }
            catch (Exception exception) {}
        }
    }

    protected void tuneDomainXML() throws AMTuneException {
        try {
            String curGCThreadOpt;
            String tuneFile = this.asConfigInfo.getContainerInstanceDir() + "/" + "config" + "/" + "domain.xml";
            this.mWriter.writelnLocaleMsg("pt-app-srv-tuning-inst");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile + " (using asadmin command line tool)");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-acceptor-threads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("acceptor-threads=" + this.curCfgMap.get(".acceptor-threads"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("acceptor-threads=" + this.configInfo.getAcceptorThreads());
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-pending-count-threads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("max-pending-count=" + this.curCfgMap.get("server.http-service.connection-pool.max-pending-count"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("max-pending-count=8192");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-queue-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("queue-size=" + this.curCfgMap.get("server.http-service.connection-pool.queue-size-in-bytes"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("queue-size=8192");
            this.mWriter.writeln(" ");
            int newMinHeapVal = this.configInfo.getMaxHeapSize();
            int newMaxHeapVal = this.configInfo.getMaxHeapSize();
            if (newMinHeapVal > 12288) {
                newMinHeapVal = 12288;
            }
            String asAdminNewMinHeap = "-Xms" + newMinHeapVal + "M";
            String asAdminNewMaxHeap = "-Xmx" + newMaxHeapVal + "M";
            this.mWriter.writelnLocaleMsg("pt-as-heap-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("Min Heap: " + this.curCfgMap.get("-Xms"));
            this.mWriter.writeln(" Max Heap: " + this.curCfgMap.get("-Xmx"));
            if (this.asConfigInfo.isJVM64Bit() && this.configInfo.getMemToUse() > this.configInfo.getFAMTuneMaxMemoryToUseInMB()) {
                this.displayJVM64bitMessage(asAdminNewMinHeap, asAdminNewMaxHeap);
            } else {
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writeln(asAdminNewMinHeap + " " + asAdminNewMaxHeap);
                this.mWriter.writeln(" ");
            }
            String asAdminNewLoggcOutput = "-Xloggc:" + this.asConfigInfo.getContainerInstanceDir() + "/" + "logs" + "/" + "gc.log";
            this.mWriter.writelnLocaleMsg("pt-as-loggc-output-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-Xloggc"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewLoggcOutput);
            this.mWriter.writeln(" ");
            String asAdminNewServerMode = "-server";
            this.mWriter.writelnLocaleMsg("pt-as-server-mode-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            String modeFlag = (String)this.curCfgMap.get("-client");
            if (modeFlag != null && modeFlag.trim().length() > 0 && modeFlag.indexOf("-client") != -1) {
                this.mWriter.writeln(modeFlag);
            } else {
                this.mWriter.writeln((String)this.curCfgMap.get("-server"));
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewServerMode);
            this.mWriter.writeln(" ");
            String asAdminNewStackSize = "";
            asAdminNewStackSize = this.asConfigInfo.isJVM64Bit() ? "-Xss" + this.configInfo.getFAMTunePerThreadStackSizeInKB64Bit() + "k" : "-Xss" + this.configInfo.getFAMTunePerThreadStackSizeInKB() + "k";
            this.mWriter.writelnLocaleMsg("pt-as-stack-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-Xss"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewStackSize);
            this.mWriter.writeln(" ");
            String asAdminNewNewSize = "-XX:NewSize=" + this.configInfo.getMaxNewSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-as-new-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:NewSize"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewNewSize);
            this.mWriter.writeln(" ");
            String asAdminNewMaxNewSize = "-XX:MaxNewSize=" + this.configInfo.getMaxNewSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-as-max-new-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:MaxNewSize"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewMaxNewSize);
            this.mWriter.writeln(" ");
            String asAdminNewDisableExplicitGc = "-XX:+DisableExplicitGC";
            this.mWriter.writelnLocaleMsg("pt-as-diable-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+DisableExplicitGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewDisableExplicitGc);
            this.mWriter.writeln(" ");
            String asAdminNewUseParallelGc = "-XX:+UseParNewGC";
            this.mWriter.writelnLocaleMsg("pt-as-use-parallel-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+UseParNewGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewUseParallelGc);
            this.mWriter.writeln(" ");
            String asAdminNewPrintClassHistogram = "-XX:+PrintClassHistogram";
            this.mWriter.writelnLocaleMsg("pt-as-histo-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+PrintClassHistogram"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewPrintClassHistogram);
            this.mWriter.writeln(" ");
            String asAdminNewPrintGcTimeStamps = "-XX:+PrintGCTimeStamps";
            this.mWriter.writelnLocaleMsg("pt-as-gc-time-stamp-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+PrintGCTimeStamps"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewPrintGcTimeStamps);
            this.mWriter.writeln(" ");
            String asAdminNewUseConMarkSweepGc = "-XX:+UseConcMarkSweepGC";
            this.mWriter.writelnLocaleMsg("pt-as-sweep-mark-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+UseConcMarkSweepGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewUseConMarkSweepGc);
            this.mWriter.writeln(" ");
            String asAdminNewServerpolicy = "";
            if (this.asConfigInfo.isTuneWebContainerJavaPolicy()) {
                asAdminNewServerpolicy = "${com.sun.aas.instanceRoot}/config/server.policy.NOTUSED";
                this.mWriter.writelnLocaleMsg("pt-as-server-sec-policy-check-msg");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                this.mWriter.write("-Djava.security.policy=");
                this.mWriter.writeln((String)this.curCfgMap.get("-Djava.security.policy"));
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.write("-Djava.security.policy=");
                this.mWriter.writeln(asAdminNewServerpolicy);
                this.mWriter.writeln(" ");
            }
            if (AMTuneUtil.isNiagara()) {
                this.mWriter.writelnLocaleMsg("pt-as-parallel-gc-threads-msg");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                this.mWriter.writeln("-XX:ParallelGCThreads=" + this.curCfgMap.get("-XX:ParallelGCThreads"));
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writelnLocaleMsg("pt-rec-none");
                this.mWriter.writeln(" ");
            }
            this.mWriter.writelnLocaleMsg("pt-as-rqst-proc-init-threads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("initial-thread-count=" + this.curCfgMap.get("server.http-service.request-processing.initial-thread-count"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("initial-thread-count=10");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-rqst-proc-thread-count-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("thread-count=" + this.curCfgMap.get("server.http-service.request-processing.thread-count"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("thread-count=" + this.getMaxThreadPoolVal());
            this.mWriter.writeln(" ");
            if (this.configInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            this.setASParams();
            ArrayList<Object> delOptList = new ArrayList<Object>();
            ArrayList<String> newOptList = new ArrayList<String>();
            if (!this.curCfgMap.get("-Xms").toString().equals(asAdminNewMinHeap)) {
                delOptList.add(this.curCfgMap.get("-Xms"));
                newOptList.add(asAdminNewMinHeap);
            }
            if (!this.curCfgMap.get("-Xmx").toString().equals(asAdminNewMaxHeap)) {
                delOptList.add(this.curCfgMap.get("-Xmx"));
                newOptList.add(asAdminNewMaxHeap);
            }
            if (!this.curCfgMap.get("-Xloggc").toString().equals(asAdminNewLoggcOutput)) {
                delOptList.add(this.curCfgMap.get("-Xloggc"));
                newOptList.add(asAdminNewLoggcOutput);
            }
            if (!this.curCfgMap.get("-Xss").toString().equals(asAdminNewStackSize)) {
                delOptList.add(this.curCfgMap.get("-Xss"));
                newOptList.add(asAdminNewStackSize);
            }
            if (!this.curCfgMap.get("-XX:NewSize").toString().equals(asAdminNewNewSize)) {
                delOptList.add(this.curCfgMap.get("-XX:NewSize"));
                newOptList.add(asAdminNewNewSize);
            }
            if (!this.curCfgMap.get("-XX:MaxNewSize").toString().equals(asAdminNewMaxNewSize)) {
                delOptList.add(this.curCfgMap.get("-XX:MaxNewSize"));
                newOptList.add(asAdminNewMaxNewSize);
            }
            if (!this.curCfgMap.get("-XX:+DisableExplicitGC").toString().equals(asAdminNewDisableExplicitGc)) {
                delOptList.add(this.curCfgMap.get("-XX:+DisableExplicitGC"));
                newOptList.add(asAdminNewDisableExplicitGc);
            }
            if (!this.curCfgMap.get("-XX:+UseParNewGC").toString().equals(asAdminNewUseParallelGc)) {
                delOptList.add(this.curCfgMap.get("-XX:+UseParNewGC"));
                newOptList.add(asAdminNewUseParallelGc);
            }
            if (!this.curCfgMap.get("-XX:+UseConcMarkSweepGC").toString().equals(asAdminNewUseConMarkSweepGc)) {
                delOptList.add(this.curCfgMap.get("-XX:+UseConcMarkSweepGC"));
                newOptList.add(asAdminNewUseConMarkSweepGc);
            }
            if (!this.curCfgMap.get("-XX:+PrintClassHistogram").toString().equals(asAdminNewPrintClassHistogram)) {
                delOptList.add(this.curCfgMap.get("-XX:+PrintClassHistogram"));
                newOptList.add(asAdminNewPrintClassHistogram);
            }
            if (!this.curCfgMap.get("-XX:+PrintGCTimeStamps").toString().equals(asAdminNewPrintGcTimeStamps)) {
                delOptList.add(this.curCfgMap.get("-XX:+PrintGCTimeStamps"));
                newOptList.add(asAdminNewPrintGcTimeStamps);
            }
            if (modeFlag != null && modeFlag.trim().length() > 0 && modeFlag.indexOf("-client") != -1) {
                delOptList.add(modeFlag);
                newOptList.add(asAdminNewServerMode);
            }
            if (this.asConfigInfo.isTuneWebContainerJavaPolicy()) {
                delOptList.add("-Djava.security.policy=" + this.curCfgMap.get("-Djava.security.policy"));
            }
            if (AMTuneUtil.isNiagara() && (curGCThreadOpt = "-XX:ParallelGCThreads=" + this.curCfgMap.get("-XX:ParallelGCThreads")).indexOf("<No value set>") == -1) {
                delOptList.add(curGCThreadOpt);
            }
            if (this.asConfigInfo.isTuneWebContainerJavaPolicy()) {
                newOptList.add("-Djava.security.policy=" + asAdminNewServerpolicy);
            }
            this.deleteCurJVMOptions(delOptList);
            this.insertNewJVMOptions(newOptList);
            if (delOptList.size() > 0 || newOptList.size() > 0) {
                this.mWriter.writelnLocaleMsg("pt-as-restart-msg");
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneDomainXML", "Error tuning Application server 9.1 domain xml file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void setASParams() {
        try {
            int curVal;
            int curReqVal;
            int curReqInitVal;
            int curAccVal;
            StringBuffer asAdminSetParams = new StringBuffer();
            if (this.curCfgMap.get(".acceptor-threads") != null && (curAccVal = Integer.parseInt(this.curCfgMap.get(".acceptor-threads").toString())) != this.configInfo.getAcceptorThreads()) {
                asAdminSetParams.append(this.asConfigInfo.getAcceptorThreadString());
                asAdminSetParams.append("=");
                asAdminSetParams.append(this.configInfo.getAcceptorThreads());
                asAdminSetParams.append(" ");
            }
            if (this.curCfgMap.get("server.http-service.request-processing.initial-thread-count") != null && (curReqInitVal = Integer.parseInt(this.curCfgMap.get("server.http-service.request-processing.initial-thread-count").toString())) < 10) {
                asAdminSetParams.append("server.http-service.request-processing.initial-thread-count");
                asAdminSetParams.append("=");
                asAdminSetParams.append(10);
                asAdminSetParams.append(" ");
            }
            if (this.curCfgMap.get("server.http-service.request-processing.thread-count") != null && (curReqVal = Integer.parseInt(this.curCfgMap.get("server.http-service.request-processing.thread-count").toString())) < this.getMaxThreadPoolVal()) {
                asAdminSetParams.append("server.http-service.request-processing.thread-count");
                asAdminSetParams.append("=");
                asAdminSetParams.append(this.getMaxThreadPoolVal());
                asAdminSetParams.append(" ");
            }
            if (this.curCfgMap.get("server.http-service.connection-pool.max-pending-count") != null && (curVal = Integer.parseInt(this.curCfgMap.get("server.http-service.connection-pool.max-pending-count").toString())) < 8192) {
                asAdminSetParams.append("server.http-service.connection-pool.max-pending-count");
                asAdminSetParams.append("=");
                asAdminSetParams.append(8192);
                asAdminSetParams.append(" ");
            }
            if (this.curCfgMap.get("server.http-service.connection-pool.queue-size-in-bytes") != null && (curVal = Integer.parseInt(this.curCfgMap.get("server.http-service.connection-pool.queue-size-in-bytes").toString())) < 8192) {
                asAdminSetParams.append("server.http-service.connection-pool.queue-size-in-bytes");
                asAdminSetParams.append("=");
                asAdminSetParams.append(8192);
            }
            if (asAdminSetParams.length() == 0) {
                this.pLogger.log(Level.INFO, "asAdminSetParams", "All params are same as recommended values.");
                return;
            }
            StringBuffer resultBuffer = new StringBuffer();
            StringBuffer setCmd = new StringBuffer(this.asConfigInfo.getASAdminCmd());
            setCmd.append("set ");
            setCmd.append(this.asConfigInfo.getAsAdminCommonParamsNoTarget());
            setCmd.append(" ");
            setCmd.append(asAdminSetParams.toString());
            int retVal = AMTuneUtil.executeCommand(setCmd.toString(), this.passwordStr, this.asConfigInfo.getAdminPassfilePath(), resultBuffer);
            if (retVal != 0) {
                this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                this.pLogger.log(Level.SEVERE, "setASParams", "Error executing asadmin.");
            }
        }
        catch (Exception ex) {
            this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
            this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
            this.pLogger.log(Level.SEVERE, "setASParams", "Application Server Parameters couldn't be set. " + ex.getMessage());
        }
    }

    private void deleteCurJVMOptions(List curJvmOptions) {
        try {
            StringBuffer delOpts = new StringBuffer();
            if (AMTuneUtil.isWindows()) {
                delOpts.append(" \"");
            } else {
                delOpts.append(" :");
            }
            Iterator optItr = curJvmOptions.iterator();
            while (optItr.hasNext()) {
                String val = optItr.next().toString().trim();
                if (val.length() <= 0 || val.equalsIgnoreCase("<No value set>")) continue;
                delOpts.append(":");
                val = val.replace(":", "\\:");
                delOpts.append(val);
            }
            if (AMTuneUtil.isWindows()) {
                delOpts.append("\"");
            }
            if (delOpts.toString().trim().length() < 3) {
                this.pLogger.log(Level.INFO, "deleteCurJVMOptions", "No JVM options to delete");
                return;
            }
            StringBuffer depOptCmd = new StringBuffer(this.asConfigInfo.getASAdminCmd());
            depOptCmd.append("delete-jvm-options ");
            depOptCmd.append(this.asConfigInfo.getAsAdminCommonParams());
            depOptCmd.append(delOpts.toString());
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(depOptCmd.toString(), this.passwordStr, this.asConfigInfo.getAdminPassfilePath(), resultBuffer);
            if (retVal != 0) {
                this.mWriter.writelnLocaleMsg("pt-del-jvm-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "deleteCurJVMOptions", "Error deleting JVM options. " + ex.getMessage());
        }
    }

    private void insertNewJVMOptions(List newJVMOpts) {
        try {
            StringBuffer newOpts = new StringBuffer();
            if (AMTuneUtil.isWindows()) {
                newOpts.append(" \"");
            } else {
                newOpts.append(" :");
            }
            Iterator optItr = newJVMOpts.iterator();
            while (optItr.hasNext()) {
                String val = optItr.next().toString().trim();
                if (val.length() <= 0) continue;
                newOpts.append(":");
                val = val.replace(":", "\\:");
                newOpts.append(val);
            }
            if (AMTuneUtil.isWindows()) {
                newOpts.append("\"");
            }
            if (newOpts.toString().trim().length() < 3) {
                this.pLogger.log(Level.INFO, "insertNewJVMOptions", "No JVM options to insert");
                return;
            }
            StringBuffer resultBuffer = new StringBuffer();
            StringBuffer newOptCmd = new StringBuffer(this.asConfigInfo.getASAdminCmd());
            newOptCmd.append("create-jvm-options ");
            newOptCmd.append(this.asConfigInfo.getAsAdminCommonParams());
            newOptCmd.append(newOpts.toString());
            int retVal = AMTuneUtil.executeCommand(newOptCmd.toString(), this.passwordStr, this.asConfigInfo.getAdminPassfilePath(), resultBuffer);
            if (retVal != 0) {
                this.mWriter.writelnLocaleMsg("pt-create-jvm-opts-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "insertNewJVMOptions", "Error setting new JVM options. " + ex.getMessage());
        }
    }

    protected void tuneSecurityLimits() throws AMTuneException {
        String tuneFile = "/etc/security/limits.conf";
        FileHandler fh = null;
        try {
            fh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-app-stack-size-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            String[] mLines = fh.getMattchingLines("^#", true);
            mLines = AMTuneUtil.getMatchedLines(mLines, "stack");
            mLines = AMTuneUtil.getMatchedLines(mLines, "hard");
            String newStackSize = "";
            String curStackSizeStr = " ";
            if (mLines.length > 0) {
                String firCol = mLines[0].substring(0, mLines[0].indexOf(" "));
                newStackSize = firCol + "               " + "hard    " + "stack          " + "256";
                curStackSizeStr = mLines[0];
            } else {
                newStackSize = "*               hard    stack          256";
            }
            this.mWriter.writelnLocaleMsg("pt-stack-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(curStackSizeStr);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(newStackSize);
            if (this.configInfo.isReviewMode() || curStackSizeStr != null && curStackSizeStr.trim().length() > 0 && curStackSizeStr.equals(newStackSize)) {
                return;
            }
            String[] delLines = new String[3];
            delLines[0] = "Start: AS9.1 OpenSSO Tuning :";
            delLines[1] = "End: AS9.1 OpenSSO Tuning :";
            if (curStackSizeStr != null && curStackSizeStr.trim().length() > 0) {
                delLines[2] = curStackSizeStr;
            }
            fh.removeMatchingLines(delLines);
            fh.appendLine("# " + delLines[0] + AMTuneUtil.getTodayDateStr());
            fh.appendLine(newStackSize);
            fh.appendLine("# " + delLines[1] + AMTuneUtil.getTodayDateStr());
            this.mWriter.writelnLocaleMsg("pt-lnx-reboot-msg");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneSecurityLimits", "Error tuning security limits " + ex.getMessage());
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            try {
                fh.close();
            }
            catch (Exception ex) {}
        }
    }

    private void displayJVM64bitMessage(String calMaxHeapSize, String calMinHeapSize) {
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg1");
        this.mWriter.write("                     : " + this.configInfo.getMemToUse());
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg2");
        this.mWriter.write("                     : ");
        this.mWriter.writeLocaleMsg("pt-web-64bit-jvm-rec-msg3");
        this.mWriter.writeln("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO, in amtune-env");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg4");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg5");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg6");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-rec-msg7");
        this.mWriter.writeln(" ");
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-cur-msg1");
        this.mWriter.write("                     : ");
        this.mWriter.writeln("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO=" + this.configInfo.getFAMTuneMemMaxHeapSizeRatioExp());
        this.mWriter.write("                     : ");
        this.mWriter.writelnLocaleMsg("pt-web-64bit-jvm-cur-msg2");
        this.mWriter.write("                     : ");
        this.mWriter.writeln("Min Heap: " + calMaxHeapSize + " Max Heap: " + calMinHeapSize);
    }

    protected void deletePasswordFile() {
        AMTuneUtil.deleteFile(this.asConfigInfo.getAdminPassfilePath());
    }

    private int getMaxThreadPoolVal() {
        int recMaxThreadPool = this.configInfo.getNumOfMaxThreadPool();
        if (recMaxThreadPool < 256) {
            recMaxThreadPool = 256;
        }
        if (recMaxThreadPool > 512) {
            recMaxThreadPool = 512;
        }
        return recMaxThreadPool;
    }

    private void validateInstanceDir() throws AMTuneException {
        String appConfFile = this.asConfigInfo.getContainerInstanceDir() + "/" + "config" + "/" + "domain.xml";
        File confFile = new File(appConfFile);
        if (!confFile.exists()) {
            this.mWriter.writelnLocaleMsg("pt-error-as-conf-file-not-found");
            AMTuneUtil.printErrorMsg("CONTAINER_INSTANCE_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-as-invalid-instance-dir"));
        }
    }
}

