/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.Conditions;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Referrals;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResponseProviders;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Subjects;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Node;

public class Policy
implements Cloneable {
    static final String REFERRAL_POLICY = "referralPolicy";
    static final String ACTIVE_FLAG = "active";
    private static final int SUBJECTS_CONDITIONS_RULES = 1;
    private static final int CONDITIONS_SUBJECTS_RULES = 2;
    private static final int RULES_SUBJECTS_CONDITIONS = 3;
    private static final int RULES_CONDITIONS_SUBJECTS = 4;
    private static final int SUBJECTS_RULES_CONDITIONS = 5;
    private static final int CONDITIONS_RULES_SUBJECTS = 6;
    private static String EVALUATION_WEIGHTS = null;
    private static String DEFAULT_EVALUATION_WEIGHTS = "10:10:10";
    private static final String EVALUATION_WEIGHTS_KEY = "com.sun.identity.policy.Policy.policy_evaluation_weights";
    private static final Debug DEBUG = PolicyManager.debug;
    private int evaluationOrder = 3;
    private static int ruleWeight;
    private static int conditionWeight;
    private static int subjectWeight;
    private int prWeight;
    private int pcWeight;
    private int psWeight;
    private String origPolicyName;
    private String policyName;
    private String description = "";
    private String createdBy;
    private String lastModifiedBy;
    private long creationDate;
    private long lastModifiedDate;
    private boolean referralPolicy = false;
    private boolean active = true;
    private int priority;
    private Map rules = new HashMap();
    private Subjects users = new Subjects();
    private Conditions conditions = new Conditions();
    private ResponseProviders respProviders = new ResponseProviders();
    private Referrals referrals = new Referrals();
    private String organizationName;
    private static final int MATCHED_RULE_RESULTS_CACHE_SIZE = 1000;
    private static final int MATCHED_REFERRAL_RULES_CACHE_SIZE = 100;
    private Cache matchRulesResultsCache = new Cache(1000);
    private String subjectRealm;

    private Policy() {
    }

    public Policy(String policyName) throws InvalidNameException {
        this(policyName, null);
    }

    private Policy(String policyName, int priority) throws InvalidNameException {
        this.validateName(policyName);
        this.policyName = policyName;
        this.priority = priority;
    }

    public Policy(String policyName, String description) throws InvalidNameException {
        this(policyName, description, false, true);
    }

    public Policy(String policyName, String description, boolean referralPolicy) throws InvalidNameException {
        this(policyName, description, referralPolicy, true);
    }

    public Policy(String policyName, String description, boolean referralPolicy, boolean active) throws InvalidNameException {
        this.validateName(policyName);
        this.policyName = policyName;
        if (description != null) {
            this.description = description;
        }
        this.referralPolicy = referralPolicy;
        this.active = active;
    }

    public Policy(PolicyManager pm, Node policyNode) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        Set ruleNodes;
        String pri;
        String active;
        if (!policyNode.getNodeName().equalsIgnoreCase("Policy")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid policy xml blob given to construct policy");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_policy_root_node", null, "", 1);
        }
        this.policyName = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"name");
        this.validateName(this.policyName);
        this.description = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"description");
        this.getModificationInfo(policyNode);
        String referralPolicy = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)REFERRAL_POLICY);
        if (referralPolicy != null && referralPolicy.equalsIgnoreCase("true")) {
            this.referralPolicy = true;
        }
        if ((active = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)ACTIVE_FLAG)) != null && active.equalsIgnoreCase("false")) {
            this.active = false;
        }
        if ((pri = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"priority")) != null) {
            try {
                this.priority = Integer.parseInt(pri);
            }
            catch (NumberFormatException nfe) {
                PolicyManager.debug.error("Number format exception in determining policy's priority: " + pri, (Throwable)nfe);
            }
        }
        if ((ruleNodes = XMLUtils.getChildNodes((Node)policyNode, (String)"Rule")) != null) {
            for (Node ruleNode : ruleNodes) {
                Rule rule = new Rule(ruleNode);
                this.addRule(rule);
            }
        }
        if (!this.referralPolicy) {
            Node respProvidersNode;
            Node conditionsNode;
            Node subjectsNode = XMLUtils.getChildNode((Node)policyNode, (String)"Subjects");
            if (subjectsNode != null) {
                this.users = new Subjects(pm, subjectsNode);
            }
            if ((conditionsNode = XMLUtils.getChildNode((Node)policyNode, (String)"Conditions")) != null) {
                this.conditions = new Conditions(pm.getConditionTypeManager(), conditionsNode);
            }
            if ((respProvidersNode = XMLUtils.getChildNode((Node)policyNode, (String)"ResponseProviders")) != null) {
                this.respProviders = new ResponseProviders(pm.getResponseProviderTypeManager(), respProvidersNode);
            }
        } else {
            Node referralsNode = XMLUtils.getChildNode((Node)policyNode, (String)"Referrals");
            if (referralsNode != null) {
                this.referrals = new Referrals(pm, referralsNode);
            }
        }
    }

    private void getModificationInfo(Node policyNode) {
        String strLastModifiediDate;
        String strCreationDate = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"creationdate");
        if (strCreationDate != null && strCreationDate.length() > 0) {
            try {
                this.creationDate = Long.parseLong(strCreationDate);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((strLastModifiediDate = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"lastmodifieddate")) != null && strLastModifiediDate.length() > 0) {
            try {
                this.lastModifiedDate = Long.parseLong(strLastModifiediDate);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.createdBy = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"createdby");
        this.lastModifiedBy = XMLUtils.getNodeAttributeValue((Node)policyNode, (String)"lastmodifiedby");
    }

    public String getName() {
        return this.policyName;
    }

    public void setName(String policyName) throws InvalidNameException {
        this.validateName(policyName);
        if (this.policyName.equals(policyName)) {
            return;
        }
        if (this.origPolicyName == null) {
            this.origPolicyName = this.policyName;
        }
        this.policyName = policyName;
    }

    protected String getOriginalName() {
        return this.origPolicyName;
    }

    void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    protected void resetOriginalName() {
        this.origPolicyName = null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws InvalidNameException {
        if (description != null) {
            this.description = description;
        }
    }

    public boolean isReferralPolicy() {
        return this.referralPolicy;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Set getRuleNames() {
        return new HashSet(this.rules.keySet());
    }

    public Rule getRule(String ruleName) throws NameNotFoundException {
        Rule rule = (Rule)this.rules.get(ruleName);
        if (rule == null) {
            throw new NameNotFoundException("amPolicy", "rule_not_found", null, ruleName, 2);
        }
        return rule;
    }

    public void addRule(Rule rule) throws NameAlreadyExistsException, InvalidNameException {
        if (rule.getName() == null) {
            rule.setName("rule" + ServiceTypeManager.generateRandomName());
        }
        if (this.rules.containsKey(rule.getName())) {
            throw new NameAlreadyExistsException("amPolicy", "rule_name_already_present", null, rule.getName(), 2);
        }
        if (this.rules.containsValue(rule)) {
            throw new NameAlreadyExistsException("amPolicy", "rule_already_present", null, rule.getName(), 2);
        }
        this.rules.put(rule.getName(), rule);
    }

    public void replaceRule(Rule rule) throws InvalidNameException {
        if (rule.getName() == null) {
            rule.setName("rule" + ServiceTypeManager.generateRandomName());
        }
        this.rules.put(rule.getName(), rule);
    }

    public Rule removeRule(String ruleName) {
        return (Rule)this.rules.remove(ruleName);
    }

    Subjects getSubjects() {
        return this.users;
    }

    public Set getSubjectNames() {
        return this.users.getSubjectNames();
    }

    public Subject getSubject(String subjectName) throws NameNotFoundException {
        return this.users.getSubject(subjectName);
    }

    public void addSubject(String name, Subject subject) throws NameAlreadyExistsException, InvalidNameException {
        this.users.addSubject(name, subject, false);
    }

    public void addRealmSubject(SSOToken token, String subjectName, String realmName, boolean exclusive) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        PolicyManager pm = new PolicyManager(token, realmName);
        SubjectTypeManager stm = pm.getSubjectTypeManager();
        this.addRealmSubject(subjectName, stm, exclusive);
    }

    public void addRealmSubject(String subjectName, SubjectTypeManager stm, boolean exclusive) throws NameAlreadyExistsException, InvalidNameException, PolicyException, SSOException {
        String realmName = stm.getPolicyManager().getOrganizationDN();
        realmName = new DN(realmName).toRFCString().toLowerCase();
        if (this.subjectRealm != null && !this.subjectRealm.equals(realmName)) {
            Object[] objs = new String[]{realmName, this.subjectRealm};
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Policy.addRealmSubject():can not add realm subject " + subjectName + " , from realm : " + realmName + " , policy already has subject from different realm:" + this.subjectRealm);
            }
            throw new InvalidNameException("amPolicy", "policy_realms_do_not_match", objs, null, realmName, 1);
        }
        if (this.subjectRealm == null) {
            this.subjectRealm = realmName;
        }
        stm.getSubjectByName(subjectName);
        this.users.addSubject(subjectName, stm.getSharedSubject(subjectName), exclusive);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Policy.addRealmSubject():added  realm subject " + subjectName + " , from realm : " + realmName);
        }
    }

    public void addSubject(String name, Subject subject, boolean exclusive) throws NameAlreadyExistsException, InvalidNameException {
        this.users.addSubject(name, subject, exclusive);
    }

    public void replaceSubject(String name, Subject subject) throws NameNotFoundException {
        this.users.replaceSubject(name, subject, false);
    }

    public void replaceSubject(String name, Subject subject, boolean exclusive) throws NameNotFoundException {
        this.users.replaceSubject(name, subject, exclusive);
    }

    public Subject removeSubject(String subjectName) {
        return this.users.removeSubject(subjectName);
    }

    public void removeSubject(Subject subject) {
        String subjectName = this.users.getSubjectName(subject);
        if (subjectName != null) {
            this.removeSubject(subjectName);
        }
    }

    public boolean isSubjectExclusive(String subjectName) throws NameNotFoundException {
        return this.users.isSubjectExclusive(subjectName);
    }

    public boolean isRealmSubject(String subjectName) throws NameNotFoundException {
        return this.users.isRealmSubject(subjectName);
    }

    Referrals getReferrals() {
        return this.referrals;
    }

    public Set getReferralNames() {
        return this.referrals.getReferralNames();
    }

    public Referral getReferral(String referralName) throws NameNotFoundException {
        return this.referrals.getReferral(referralName);
    }

    public void addReferral(String name, Referral referral) throws NameAlreadyExistsException, InvalidNameException {
        this.referrals.addReferral(name, referral);
    }

    public void replaceReferral(String name, Referral referral) throws NameNotFoundException {
        this.referrals.replaceReferral(name, referral);
    }

    public Referral removeReferral(String referralName) {
        return this.referrals.removeReferral(referralName);
    }

    public void removeReferral(Referral referral) {
        String referralName = this.referrals.getReferralName(referral);
        if (referralName != null) {
            this.removeReferral(referralName);
        }
    }

    Conditions getConditions() {
        return this.conditions;
    }

    public Set getConditionNames() {
        return this.conditions.getConditionNames();
    }

    public Condition getCondition(String condition) throws NameNotFoundException {
        return this.conditions.getCondition(condition);
    }

    public void addCondition(String name, Condition condition) throws NameAlreadyExistsException, InvalidNameException {
        this.conditions.addCondition(name, condition);
    }

    public void replaceCondition(String name, Condition condition) throws NameNotFoundException {
        this.conditions.replaceCondition(name, condition);
    }

    public Condition removeCondition(String condition) {
        return this.conditions.removeCondition(condition);
    }

    public void removeCondition(Condition condition) {
        String conditionName = this.conditions.getConditionName(condition);
        if (conditionName != null) {
            this.removeCondition(conditionName);
        }
    }

    ResponseProviders getResponseProviders() {
        return this.respProviders;
    }

    public Set getResponseProviderNames() {
        return this.respProviders.getResponseProviderNames();
    }

    public ResponseProvider getResponseProvider(String respProvider) throws NameNotFoundException {
        return this.respProviders.getResponseProvider(respProvider);
    }

    public void addResponseProvider(String name, ResponseProvider respProvider) throws NameAlreadyExistsException {
        this.respProviders.addResponseProvider(name, respProvider);
    }

    public void replaceResponseProvider(String name, ResponseProvider respProvider) throws NameNotFoundException {
        this.respProviders.replaceResponseProvider(name, respProvider);
    }

    public ResponseProvider removeResponseProvider(String respProvider) {
        return this.respProviders.removeResponseProvider(respProvider);
    }

    public void removeResponseProvider(ResponseProvider respProvider) {
        String respProviderName = this.respProviders.getResponseProviderName(respProvider);
        if (respProviderName != null) {
            this.removeResponseProvider(respProviderName);
        }
    }

    public void store(SSOToken token, String name) throws SSOException, NoPermissionException, NameAlreadyExistsException, NameNotFoundException, PolicyException {
        PolicyManager pm = new PolicyManager(token, name);
        pm.addPolicy(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Policy) {
            Policy p = (Policy)obj;
            if (((Object)this.rules).equals(p.rules) && this.users.equals(p.users) && this.referrals.equals(p.referrals) && this.respProviders.equals(p.respProviders) && this.conditions.equals(p.conditions)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Policy answer = null;
        try {
            answer = (Policy)super.clone();
        }
        catch (CloneNotSupportedException se) {
            answer = new Policy();
        }
        answer.origPolicyName = this.origPolicyName;
        answer.policyName = this.policyName;
        answer.description = this.description;
        answer.active = this.active;
        answer.rules = new HashMap();
        for (Object o : this.rules.keySet()) {
            Rule rule = (Rule)this.rules.get(o);
            answer.rules.put(o, rule.clone());
        }
        answer.users = (Subjects)this.users.clone();
        answer.referrals = (Referrals)this.referrals.clone();
        answer.respProviders = (ResponseProviders)this.respProviders.clone();
        answer.conditions = (Conditions)this.conditions.clone();
        return answer;
    }

    public String toXML() {
        StringBuffer answer = new StringBuffer(200);
        answer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        answer.append("<Policy name=\"");
        answer.append(XMLUtils.escapeSpecialCharacters((String)this.policyName));
        if (this.description != null && this.description.length() > 0) {
            answer.append("\" description=\"");
            answer.append(XMLUtils.escapeSpecialCharacters((String)this.description));
        }
        if (this.createdBy != null && this.createdBy.length() > 0) {
            answer.append("\" ").append("createdby").append("=\"").append(XMLUtils.escapeSpecialCharacters((String)this.createdBy));
        }
        if (this.lastModifiedBy != null && this.lastModifiedBy.length() > 0) {
            answer.append("\" ").append("lastmodifiedby").append("=\"").append(XMLUtils.escapeSpecialCharacters((String)this.lastModifiedBy));
        }
        if (this.creationDate > 0L) {
            answer.append("\" ").append("creationdate").append("=\"").append(XMLUtils.escapeSpecialCharacters((String)Long.toString(this.creationDate)));
        }
        if (this.lastModifiedDate > 0L) {
            answer.append("\" ").append("lastmodifieddate").append("=\"").append(XMLUtils.escapeSpecialCharacters((String)Long.toString(this.lastModifiedDate)));
        }
        answer.append("\" referralPolicy=\"").append(this.referralPolicy);
        answer.append("\" active=\"").append(this.active);
        answer.append("\" >");
        for (String ruleName : this.getRuleNames()) {
            try {
                Rule rule = this.getRule(ruleName);
                answer.append(rule.toXML());
            }
            catch (Exception e) {
                DEBUG.error("Error in policy.toXML():" + e.getMessage());
            }
        }
        if (!this.referralPolicy) {
            if (!this.users.getSubjectNames().isEmpty()) {
                answer.append(this.users.toXML());
            }
            if (!this.conditions.getConditionNames().isEmpty()) {
                answer.append(this.conditions.toXML());
            }
            if (!this.respProviders.getResponseProviderNames().isEmpty()) {
                answer.append(this.respProviders.toXML());
            }
        } else if (!this.referrals.getReferralNames().isEmpty()) {
            answer.append(this.referrals.toXML());
        }
        answer.append("\n").append("</Policy>");
        return answer.toString();
    }

    public String toString() {
        return this.toXML();
    }

    static void checkForCharacter(String name, char c) throws InvalidNameException {
        if (name.indexOf(c) != -1) {
            Object[] objs = new Character[]{new Character(c)};
            throw new InvalidNameException("amPolicy", "invalid_char_in_name", objs, name, 1);
        }
    }

    public PolicyDecision getPolicyDecision(SSOToken token, String resourceTypeName, String resourceName, Set actionNames, Map envParameters) throws SSOException, NameNotFoundException, PolicyException {
        Map actionDecisionMap;
        PolicyDecision policyDecision = new PolicyDecision();
        ServiceTypeManager stm = ServiceTypeManager.getServiceTypeManager();
        ServiceType resourceType = stm.getServiceType(resourceTypeName);
        this.evaluationOrder = token != null ? this.getEvaluationOrder(token) : 5;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Policy " + this.getName() + " is Using Policy evaluation order :" + this.evaluationOrder);
        }
        if (this.isReferralPolicy() && !this.referrals.isEmpty()) {
            PolicyDecision referralDecision = this.referrals.getPolicyDecision(token, resourceTypeName, resourceName, actionNames, envParameters);
            if (referralDecision != null) {
                PolicyEvaluator.mergePolicyDecisions(resourceType, referralDecision, policyDecision);
            }
            if (DEBUG.messageEnabled()) {
                String tokenPrincipal = token != null ? token.getPrincipal().getName() : "";
                DEBUG.message(new StringBuffer("at Policy.getPolicyDecision()").append(" after processing referrals only:").append(" principal, resource name, action names,").append(" policyName, referralResults = ").append(tokenPrincipal).append(",  ").append(resourceName).append(",  ").append(actionNames).append(",  ").append(this.getName()).append(",  ").append(referralDecision).toString());
            }
        } else if (this.evaluationOrder == 1) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:SUBJECTS_CONDITIONS_RULES");
            }
            this.getPolicyDecisionSCR(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        } else if (this.evaluationOrder == 2) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:CONDITIONS_SUBJECTS_RULES");
            }
            this.getPolicyDecisionCSR(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        } else if (this.evaluationOrder == 3) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:RULES_SUBJECTS_CONDITIONS");
            }
            this.getPolicyDecisionRSC(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        } else if (this.evaluationOrder == 4) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:RULES_CONDITIONS_SUBJECTS");
            }
            this.getPolicyDecisionRCS(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        } else if (this.evaluationOrder == 5) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:SUBJECTS_RULES_CONDITIONS");
            }
            this.getPolicyDecisionSRC(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        } else if (this.evaluationOrder == 6) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using policy evaluation order:CONDITIONS_RULES_SUBJECTS");
            }
            this.getPolicyDecisionCRS(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        } else {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Using default policy evaluation order:RULES_CONDITIONS_SUBJECTS");
            }
            this.getPolicyDecisionRCS(token, resourceType, resourceName, actionNames, envParameters, policyDecision);
        }
        if (DEBUG.messageEnabled()) {
            String tokenPrincipal = token != null ? token.getPrincipal().getName() : "";
            DEBUG.message(new StringBuffer("at Policy.getPolicyDecision()").append(" principal, resource name, action names,").append(" policyName, policyDecision = ").append(tokenPrincipal).append(",  ").append(resourceName).append(",  ").append(actionNames).append(",  ").append(this.getName()).append(",  ").append(policyDecision).toString());
        }
        if ((actionDecisionMap = policyDecision.getActionDecisions()) != null && !actionDecisionMap.isEmpty()) {
            Collection actionDecisions = null;
            actionDecisions = actionDecisionMap.values();
            if (actionDecisions != null && !actionDecisions.isEmpty()) {
                Iterator it = actionDecisions.iterator();
                while (it.hasNext()) {
                    Set actionValues = ((ActionDecision)it.next()).getValues();
                    if (actionValues == null || actionValues.isEmpty()) continue;
                    Map responseAttributes = this.respProviders.getResponseProviderDecision(token, envParameters);
                    policyDecision.setResponseAttributes(responseAttributes);
                    break;
                }
            }
        }
        return policyDecision;
    }

    private Map getMatchedRuleResults(ServiceType resourceType, String resourceName, Set actionNames) throws NameNotFoundException {
        String resourceTypeName = resourceType.getName();
        HashMap answer = null;
        StringBuffer cacheKeyBuffer = new StringBuffer(100);
        String cacheKey = cacheKeyBuffer.append(resourceTypeName).append(resourceName).append(actionNames).toString();
        answer = (HashMap)this.matchRulesResultsCache.get(cacheKey);
        if (answer == null) {
            answer = new HashMap();
            for (Rule rule : this.rules.values()) {
                Map actionResults = rule.getActionValues(resourceTypeName, resourceName, actionNames);
                PolicyUtils.appendMapToMap(actionResults, answer);
            }
            for (String action : answer.keySet()) {
                Set actionValues = (Set)answer.get(action);
                if (actionValues.size() != 2) continue;
                ActionSchema actionSchema = null;
                AttributeSchema.Syntax actionSyntax = null;
                try {
                    actionSchema = resourceType.getActionSchema(action);
                    actionSyntax = actionSchema.getSyntax();
                }
                catch (InvalidNameException e) {
                    PolicyManager.debug.error("can not find action schmea for action = " + action, (Throwable)e);
                }
                if (!AttributeSchema.Syntax.BOOLEAN.equals(actionSyntax)) continue;
                String trueValue = actionSchema.getTrueValue();
                actionValues.remove(trueValue);
            }
            this.matchRulesResultsCache.put(cacheKey, answer);
        }
        return Policy.cloneRuleResults(answer);
    }

    Set getResourceNames(SSOToken token, String serviceTypeName, String resourceName, boolean followReferrals) throws PolicyException, SSOException {
        HashSet<String> resourceNames = new HashSet<String>();
        ServiceType st = ServiceTypeManager.getServiceTypeManager().getServiceType(serviceTypeName);
        for (Rule rule : this.rules.values()) {
            if (!rule.getServiceType().getName().equals(serviceTypeName)) continue;
            String ruleResource = rule.getResourceName();
            ResourceMatch resourceMatch = st.compare(resourceName, ruleResource, true);
            if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH) || resourceMatch.equals(ResourceMatch.EXACT_MATCH) || resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) {
                resourceNames.add(ruleResource);
            }
            if (!DEBUG.messageEnabled()) continue;
            StringBuffer sb = new StringBuffer(200);
            sb.append("at Policy.getResourceNames : ");
            sb.append(" for policyName, serviceType, resourceName, ");
            sb.append(" ruleResource, resourceMatch :");
            sb.append(this.getName()).append(",").append(serviceTypeName);
            sb.append(",").append(resourceName).append(",");
            sb.append(ruleResource).append(",").append(resourceMatch);
            DEBUG.message(sb.toString());
        }
        if (!resourceNames.isEmpty() && followReferrals) {
            Set rResourceNames = this.referrals.getResourceNames(token, serviceTypeName, resourceName);
            resourceNames.addAll(rResourceNames);
        }
        if (DEBUG.messageEnabled()) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("at Policy.getResourceNames : ");
            sb.append(" for policyName, serviceType, resourceName, ");
            sb.append(" followReferral, resourceNames :");
            sb.append(this.getName()).append(",").append(serviceTypeName);
            sb.append(",").append(resourceName).append(",");
            sb.append(followReferrals).append(",").append(resourceNames);
            DEBUG.message(sb.toString());
        }
        return resourceNames;
    }

    Set getResourceNames(String serviceTypeName) throws SSOException, NameNotFoundException {
        HashSet<String> resourceNames = new HashSet<String>();
        for (Rule rule : this.rules.values()) {
            if (!rule.getServiceType().getName().equals(serviceTypeName)) continue;
            String ruleResource = rule.getResourceName();
            resourceNames.add(ruleResource);
        }
        return resourceNames;
    }

    Set getReferredToOrganizations() throws PolicyException {
        HashSet<String> referredToOrgs = new HashSet<String>();
        for (String referralName : this.referrals.getReferralNames()) {
            Set values;
            Referral referral = this.referrals.getReferral(referralName);
            if (!(referral instanceof OrgReferral) || (values = referral.getValues()) == null || values.size() == 0) continue;
            String orgName = (String)values.iterator().next();
            referredToOrgs.add(orgName.toLowerCase());
        }
        return referredToOrgs;
    }

    void setSubjectsResultTtl(long ttl) {
        this.users.setResultTtl(ttl);
    }

    private void validateName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            DEBUG.message("Invalid policy name:" + name);
            throw new InvalidNameException("amPolicy", "null_name", null, "", 1);
        }
        if (name.indexOf(47) != -1) {
            DEBUG.message("Invalid policy name:" + name);
            DEBUG.message("Index Of /:" + name.indexOf(47));
            throw new InvalidNameException("amPolicy", "illegal_character_/_in_name", null, "", 1);
        }
    }

    private PolicyDecision getPolicyDecisionSCR(SSOToken token, ServiceType resourceType, String resourceName, Set actionNames, Map envParameters, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean resourceMatched = false;
        ConditionDecision conditionDecision = null;
        boolean allowedByConditions = false;
        boolean allowedBySubjects = false;
        Map advicesFromConditions = null;
        long conditionsTtl = Long.MIN_VALUE;
        long timeToLive = Long.MIN_VALUE;
        Map actionResults = null;
        if (token != null) {
            allowedBySubjects = this.users.isMember(token);
            timeToLive = this.users.getResultTtl(token);
        } else {
            allowedBySubjects = true;
            timeToLive = Long.MAX_VALUE;
        }
        if (allowedBySubjects) {
            conditionDecision = this.conditions.getConditionDecision(token, envParameters);
            allowedByConditions = conditionDecision.isAllowed();
            advicesFromConditions = conditionDecision.getAdvices();
            conditionsTtl = conditionDecision.getTimeToLive();
            if (conditionsTtl < timeToLive) {
                timeToLive = conditionsTtl;
            }
            if (allowedByConditions) {
                actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
                boolean bl = resourceMatched = !actionResults.isEmpty();
                if (resourceMatched) {
                    for (String resultActionName : actionResults.keySet()) {
                        Set resultActionValues = (Set)actionResults.get(resultActionName);
                        ActionDecision actionDecision = new ActionDecision(resultActionName, resultActionValues, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    policyDecision.setTimeToLive(Long.MAX_VALUE);
                }
            } else if (!advicesFromConditions.isEmpty()) {
                actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
                for (String resultActionName : actionResults.keySet()) {
                    ActionDecision actionDecision = new ActionDecision(resultActionName, Collections.EMPTY_SET, advicesFromConditions, timeToLive);
                    policyDecision.addActionDecision(actionDecision, resourceType);
                }
            } else {
                policyDecision.setTimeToLive(timeToLive);
            }
        } else {
            policyDecision.setTimeToLive(timeToLive);
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionSRC(SSOToken token, ServiceType resourceType, String resourceName, Set actionNames, Map envParameters, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean resourceMatched = false;
        ConditionDecision conditionDecision = null;
        boolean allowedByConditions = false;
        boolean allowedBySubjects = false;
        Map advicesFromConditions = null;
        long conditionsTtl = Long.MIN_VALUE;
        long timeToLive = Long.MIN_VALUE;
        Map actionResults = null;
        if (token != null) {
            allowedBySubjects = this.users.isMember(token);
            timeToLive = this.users.getResultTtl(token);
        } else {
            allowedBySubjects = true;
            timeToLive = Long.MAX_VALUE;
        }
        if (allowedBySubjects) {
            actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
            boolean bl = resourceMatched = !actionResults.isEmpty();
            if (resourceMatched) {
                conditionDecision = this.conditions.getConditionDecision(token, envParameters);
                allowedByConditions = conditionDecision.isAllowed();
                advicesFromConditions = conditionDecision.getAdvices();
                conditionsTtl = conditionDecision.getTimeToLive();
                if (conditionsTtl < timeToLive) {
                    timeToLive = conditionsTtl;
                }
                if (allowedByConditions) {
                    for (String resultActionName : actionResults.keySet()) {
                        Set resultActionValues = (Set)actionResults.get(resultActionName);
                        ActionDecision actionDecision = new ActionDecision(resultActionName, resultActionValues, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else if (!advicesFromConditions.isEmpty()) {
                    for (String resultActionName : actionResults.keySet()) {
                        ActionDecision actionDecision = new ActionDecision(resultActionName, Collections.EMPTY_SET, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    policyDecision.setTimeToLive(timeToLive);
                }
            } else {
                policyDecision.setTimeToLive(Long.MAX_VALUE);
            }
        } else {
            policyDecision.setTimeToLive(timeToLive);
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionCSR(SSOToken token, ServiceType resourceType, String resourceName, Set actionNames, Map envParameters, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean resourceMatched = false;
        ConditionDecision conditionDecision = null;
        boolean allowedByConditions = false;
        boolean allowedBySubjects = false;
        Map advicesFromConditions = null;
        long timeToLive = Long.MIN_VALUE;
        long subjectsTtl = Long.MIN_VALUE;
        Map actionResults = null;
        conditionDecision = this.conditions.getConditionDecision(token, envParameters);
        allowedByConditions = conditionDecision.isAllowed();
        advicesFromConditions = conditionDecision.getAdvices();
        timeToLive = conditionDecision.getTimeToLive();
        if (allowedByConditions) {
            allowedBySubjects = this.users.isMember(token);
            subjectsTtl = this.users.getResultTtl(token);
            if (subjectsTtl < timeToLive) {
                timeToLive = subjectsTtl;
            }
            if (allowedBySubjects) {
                actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
                boolean bl = resourceMatched = !actionResults.isEmpty();
                if (resourceMatched) {
                    for (String resultActionName : actionResults.keySet()) {
                        Set resultActionValues = (Set)actionResults.get(resultActionName);
                        ActionDecision actionDecision = new ActionDecision(resultActionName, resultActionValues, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    policyDecision.setTimeToLive(Long.MAX_VALUE);
                }
            } else {
                policyDecision.setTimeToLive(timeToLive);
            }
        } else {
            boolean reportAdvices = false;
            if (!advicesFromConditions.isEmpty()) {
                reportAdvices = this.users.isMember(token);
                subjectsTtl = this.users.getResultTtl(token);
                if (subjectsTtl < timeToLive) {
                    timeToLive = subjectsTtl;
                }
            }
            if (reportAdvices) {
                actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
                for (String resultActionName : actionResults.keySet()) {
                    ActionDecision actionDecision = new ActionDecision(resultActionName, Collections.EMPTY_SET, advicesFromConditions, timeToLive);
                    policyDecision.addActionDecision(actionDecision, resourceType);
                }
            } else {
                policyDecision.setTimeToLive(timeToLive);
            }
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionCRS(SSOToken token, ServiceType resourceType, String resourceName, Set actionNames, Map envParameters, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean resourceMatched = false;
        ConditionDecision conditionDecision = null;
        boolean allowedByConditions = false;
        boolean allowedBySubjects = false;
        Map advicesFromConditions = null;
        long subjectsTtl = Long.MIN_VALUE;
        long timeToLive = Long.MIN_VALUE;
        Map actionResults = null;
        conditionDecision = this.conditions.getConditionDecision(token, envParameters);
        allowedByConditions = conditionDecision.isAllowed();
        advicesFromConditions = conditionDecision.getAdvices();
        timeToLive = conditionDecision.getTimeToLive();
        actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
        if (allowedByConditions) {
            boolean bl = resourceMatched = !actionResults.isEmpty();
            if (resourceMatched) {
                allowedBySubjects = this.users.isMember(token);
                subjectsTtl = this.users.getResultTtl(token);
                if (subjectsTtl < timeToLive) {
                    timeToLive = subjectsTtl;
                }
                if (allowedBySubjects) {
                    for (String resultActionName : actionResults.keySet()) {
                        Set resultActionValues = (Set)actionResults.get(resultActionName);
                        ActionDecision actionDecision = new ActionDecision(resultActionName, resultActionValues, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    policyDecision.setTimeToLive(timeToLive);
                }
            } else {
                policyDecision.setTimeToLive(Long.MAX_VALUE);
            }
        } else {
            boolean reportAdvices = false;
            if (!advicesFromConditions.isEmpty()) {
                reportAdvices = this.users.isMember(token);
                subjectsTtl = this.users.getResultTtl(token);
                if (subjectsTtl < timeToLive) {
                    timeToLive = subjectsTtl;
                }
            }
            if (reportAdvices) {
                actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
                for (String resultActionName : actionResults.keySet()) {
                    ActionDecision actionDecision = new ActionDecision(resultActionName, Collections.EMPTY_SET, advicesFromConditions, timeToLive);
                    policyDecision.addActionDecision(actionDecision, resourceType);
                }
            } else {
                policyDecision.setTimeToLive(timeToLive);
            }
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionRSC(SSOToken token, ServiceType resourceType, String resourceName, Set actionNames, Map envParameters, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean resourceMatched = false;
        ConditionDecision conditionDecision = null;
        boolean allowedByConditions = false;
        boolean allowedBySubjects = false;
        Map advicesFromConditions = null;
        long conditionsTtl = Long.MIN_VALUE;
        long timeToLive = Long.MIN_VALUE;
        Map actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
        boolean bl = resourceMatched = !actionResults.isEmpty();
        if (resourceMatched) {
            allowedBySubjects = this.users.isMember(token);
            timeToLive = this.users.getResultTtl(token);
            if (allowedBySubjects) {
                conditionDecision = this.conditions.getConditionDecision(token, envParameters);
                allowedByConditions = conditionDecision.isAllowed();
                advicesFromConditions = conditionDecision.getAdvices();
                conditionsTtl = conditionDecision.getTimeToLive();
                if (conditionsTtl < timeToLive) {
                    timeToLive = conditionsTtl;
                }
                if (allowedByConditions) {
                    for (String resultActionName : actionResults.keySet()) {
                        Set resultActionValues = (Set)actionResults.get(resultActionName);
                        ActionDecision actionDecision = new ActionDecision(resultActionName, resultActionValues, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    Iterator resultActionNames = actionResults.keySet().iterator();
                    if (!advicesFromConditions.isEmpty()) {
                        while (resultActionNames.hasNext()) {
                            String resultActionName = (String)resultActionNames.next();
                            ActionDecision actionDecision = new ActionDecision(resultActionName, Collections.EMPTY_SET, advicesFromConditions, timeToLive);
                            policyDecision.addActionDecision(actionDecision, resourceType);
                        }
                    } else {
                        policyDecision.setTimeToLive(timeToLive);
                    }
                }
            } else {
                policyDecision.setTimeToLive(timeToLive);
            }
        } else {
            policyDecision.setTimeToLive(Long.MAX_VALUE);
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecisionRCS(SSOToken token, ServiceType resourceType, String resourceName, Set actionNames, Map envParameters, PolicyDecision policyDecision) throws SSOException, NameNotFoundException, PolicyException {
        boolean resourceMatched = false;
        ConditionDecision conditionDecision = null;
        boolean allowedByConditions = false;
        boolean allowedBySubjects = false;
        Map advicesFromConditions = null;
        long conditionsTtl = Long.MIN_VALUE;
        long subjectsTtl = Long.MIN_VALUE;
        long timeToLive = Long.MIN_VALUE;
        Map actionResults = this.getMatchedRuleResults(resourceType, resourceName, actionNames);
        boolean bl = resourceMatched = !actionResults.isEmpty();
        if (resourceMatched) {
            conditionDecision = this.conditions.getConditionDecision(token, envParameters);
            allowedByConditions = conditionDecision.isAllowed();
            advicesFromConditions = conditionDecision.getAdvices();
            timeToLive = conditionsTtl = conditionDecision.getTimeToLive();
            if (allowedByConditions) {
                allowedBySubjects = this.users.isMember(token);
                subjectsTtl = this.users.getResultTtl(token);
                if (subjectsTtl < timeToLive) {
                    timeToLive = subjectsTtl;
                }
                if (allowedBySubjects) {
                    for (String resultActionName : actionResults.keySet()) {
                        Set resultActionValues = (Set)actionResults.get(resultActionName);
                        ActionDecision actionDecision = new ActionDecision(resultActionName, resultActionValues, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    policyDecision.setTimeToLive(timeToLive);
                }
            } else {
                boolean reportAdvices = false;
                if (!advicesFromConditions.isEmpty()) {
                    reportAdvices = this.users.isMember(token);
                    subjectsTtl = this.users.getResultTtl(token);
                    if (subjectsTtl < timeToLive) {
                        timeToLive = subjectsTtl;
                    }
                }
                if (reportAdvices) {
                    for (String resultActionName : actionResults.keySet()) {
                        ActionDecision actionDecision = new ActionDecision(resultActionName, Collections.EMPTY_SET, advicesFromConditions, timeToLive);
                        policyDecision.addActionDecision(actionDecision, resourceType);
                    }
                } else {
                    policyDecision.setTimeToLive(timeToLive);
                }
            }
        } else {
            policyDecision.setTimeToLive(Long.MAX_VALUE);
        }
        return policyDecision;
    }

    private int getEvaluationOrder(SSOToken token) throws SSOException {
        int mpsWeight;
        int evaluationOrder = 4;
        int n = mpsWeight = this.users.isSubjectResultCached(token) ? 0 : this.psWeight;
        if (mpsWeight <= this.pcWeight && this.pcWeight <= this.prWeight) {
            evaluationOrder = 1;
        } else if (this.pcWeight <= mpsWeight && mpsWeight <= this.prWeight) {
            evaluationOrder = 2;
        } else if (this.prWeight <= this.pcWeight && this.pcWeight <= mpsWeight) {
            evaluationOrder = 4;
        } else if (this.prWeight <= mpsWeight && mpsWeight <= this.pcWeight) {
            evaluationOrder = 3;
        } else if (mpsWeight <= this.prWeight && this.prWeight <= this.pcWeight) {
            evaluationOrder = 5;
        } else if (this.pcWeight <= this.prWeight && this.prWeight <= mpsWeight) {
            evaluationOrder = 6;
        }
        return evaluationOrder;
    }

    private static void initializeStaticEvaluationWeights() {
        EVALUATION_WEIGHTS = SystemProperties.get(EVALUATION_WEIGHTS_KEY, DEFAULT_EVALUATION_WEIGHTS);
        StringTokenizer st = new StringTokenizer(EVALUATION_WEIGHTS, ":");
        int tokenCount = st.countTokens();
        if (tokenCount != 3) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid evaulationWeights defined,  defaulting to " + DEFAULT_EVALUATION_WEIGHTS);
            }
            EVALUATION_WEIGHTS = DEFAULT_EVALUATION_WEIGHTS;
        } else {
            String weight = st.nextToken();
            try {
                subjectWeight = Integer.parseInt(weight);
            }
            catch (NumberFormatException nfe) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid subjectWeight defined, defaulting to 0");
                }
                subjectWeight = 0;
            }
            weight = st.nextToken();
            try {
                ruleWeight = Integer.parseInt(weight);
            }
            catch (NumberFormatException nfe) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid ruleWeight defined, defaulting to 0");
                }
                ruleWeight = 0;
            }
            weight = st.nextToken();
            try {
                conditionWeight = Integer.parseInt(weight);
            }
            catch (NumberFormatException nfe) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Policy.initializeStaticEvaluationWeights: invalid conditionWeight defined, defaulting to 0");
                }
                conditionWeight = 0;
            }
        }
    }

    void initializeEvaluationWeights() {
        this.psWeight = this.users.size() * subjectWeight;
        this.prWeight = this.rules.size() * ruleWeight;
        this.pcWeight = this.conditions.size() * conditionWeight;
    }

    boolean isApplicableToUser(SSOToken token) throws PolicyException, SSOException {
        return this.users.isMember(token);
    }

    static Map cloneRuleResults(Map ruleResults) {
        HashMap clonedResults = new HashMap();
        if (ruleResults != null && !ruleResults.isEmpty()) {
            for (String key : ruleResults.keySet()) {
                Set values = (Set)ruleResults.get(key);
                HashSet clonedValues = new HashSet();
                clonedValues.addAll(values);
                clonedResults.put(key, clonedValues);
            }
        }
        return clonedResults;
    }

    String getSubjectRealm() {
        return this.subjectRealm;
    }

    void clearSubjectResultCache(String tokenIdString) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Policy.clearSubjectResultCache(tokenIdString):  clearing cached subject evaluation result for  tokenId XXXXX");
        }
        this.users.clearSubjectResultCache(tokenIdString);
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    static {
        Policy.initializeStaticEvaluationWeights();
    }
}

