/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.UI.LoginLogoutMapping;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.internal.server.SMSAuthModule;
import com.sun.identity.common.ConfigMonitoring;
import com.sun.identity.common.DebugPropertiesObserver;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ConfigurationObserver;
import com.sun.identity.common.configuration.ServerConfigXML;
import com.sun.identity.common.configuration.ServerConfigXMLObserver;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.servicetag.registration.StartRegister;
import com.sun.identity.setup.AMSetupDSConfig;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.setup.BootstrapData;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.ConfiguratorPlugin;
import com.sun.identity.setup.ConfigureData;
import com.sun.identity.setup.EmbeddedOpenDS;
import com.sun.identity.setup.HttpServletRequestWrapper;
import com.sun.identity.setup.HttpServletResponseWrapper;
import com.sun.identity.setup.IHttpServletRequest;
import com.sun.identity.setup.IHttpServletResponse;
import com.sun.identity.setup.InstallLog;
import com.sun.identity.setup.LDIFTemplates;
import com.sun.identity.setup.RegisterServices;
import com.sun.identity.setup.ServiceXMLTemplates;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.setup.UserIdRepo;
import com.sun.identity.shared.StringUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSPropertiesObserver;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AMSetupServlet
extends HttpServlet {
    private static ServletContext servletCtx = null;
    private static boolean isConfiguredFlag = false;
    private static final String SMS_STR = "sms";
    private static SSOToken adminToken = null;
    private static final String LEGACY_PROPERTIES = "legacy";
    static final String BOOTSTRAP_EXTRA = "bootstrap";
    static final String BOOTSTRAP_FILE_LOC = "bootstrap.file";
    static final String OPENDS_DIR = "/opends";
    private static String errorMessage = null;
    private static java.util.Locale configLocale;
    private static Set passwordParams;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.setProperty("file.separator", "/");
        if (servletCtx == null) {
            servletCtx = config.getServletContext();
        }
        AMSetupServlet.checkConfigProperties();
        LoginLogoutMapping.setProductInitialized(isConfiguredFlag);
        if (isConfiguredFlag && !ServerConfiguration.isLegacy()) {
            ServerConfigXMLObserver.getInstance().update(true);
            if (!AMSetupServlet.syncServerInfoWithRelication()) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.init: embedded replication syncfailed.");
            }
        }
    }

    public static boolean isConfigured() {
        return isConfiguredFlag;
    }

    static boolean isConfigured(String baseDir) {
        String bootstrapFile = baseDir + "/bootstrap";
        File file = new File(bootstrapFile);
        if (file.exists()) {
            try {
                isConfiguredFlag = Bootstrap.load(new BootstrapData(baseDir), false);
                LoginLogoutMapping.setProductInitialized(isConfiguredFlag);
                return isConfiguredFlag;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static void checkConfigProperties() {
        String overrideAMC = SystemProperties.get("com.sun.identity.overrideAMC");
        boolean bl = isConfiguredFlag = overrideAMC == null || overrideAMC.equalsIgnoreCase("false");
        if (!isConfiguredFlag && servletCtx != null) {
            String baseDir = AMSetupServlet.getBaseDir();
            try {
                String bootstrapFile = AMSetupServlet.getBootStrapFile();
                if (bootstrapFile != null) {
                    isConfiguredFlag = Bootstrap.load(new BootstrapData(baseDir), false);
                } else if (baseDir != null) {
                    isConfiguredFlag = AMSetupServlet.loadAMConfigProperties(baseDir + "/" + "AMConfig.properties");
                }
            }
            catch (ConfiguratorException e) {
            }
            catch (Exception e) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.checkConfigProperties", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadAMConfigProperties(String fileLocation) throws IOException {
        boolean loaded = false;
        File test = new File(fileLocation);
        if (test.exists()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(fileLocation);
                if (fin != null) {
                    Properties props = new Properties();
                    props.load(fin);
                    SystemProperties.initializeProperties(props);
                    loaded = true;
                }
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return loaded;
    }

    public static boolean checkInitState(ServletContext servletctx) {
        return isConfiguredFlag;
    }

    static String configure(ServletContext servletct, Map data) {
        servletCtx = servletct;
        HttpServletRequestWrapper req = new HttpServletRequestWrapper(data);
        HttpServletResponseWrapper res = new HttpServletResponseWrapper(null);
        boolean result = AMSetupServlet.processRequest(req, res);
        return result ? (String)req.getParameter("BASE_DIR") : null;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, ConfiguratorException {
        boolean result;
        String userStoreType;
        HttpServletRequestWrapper req = new HttpServletRequestWrapper(request);
        HttpServletResponseWrapper res = new HttpServletResponseWrapper(response);
        String loadBalancerHost = request.getParameter("LB_SITE_NAME");
        String primaryURL = request.getParameter("LB_PRIMARY_URL");
        if (loadBalancerHost != null) {
            HashMap<String, String> siteConfig = new HashMap<String, String>(5);
            siteConfig.put("wizardLoadBalancerSiteName", loadBalancerHost);
            siteConfig.put("wizardLoadBalancerURL", primaryURL);
            req.addParameter("SITE_CONFIGURATION_MAP", siteConfig);
        }
        if ((userStoreType = request.getParameter("USERSTORE_TYPE")) != null) {
            String tmp;
            HashMap<String, String> store = new HashMap<String, String>(12);
            String domainName = tmp = request.getParameter("USERSTORE_DOMAINNAME");
            store.put("userStoreDomainName", tmp);
            tmp = request.getParameter("USERSTORE_HOST");
            if (tmp == null || tmp.length() == 0) {
                String[] hostAndPort = new String[]{""};
                try {
                    if (domainName != null && domainName.length() > 0) {
                        hostAndPort = this.getLdapHostAndPort(domainName);
                    }
                }
                catch (NamingException nex) {
                    Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet:Naming Exceptionget host and port from domain name" + nex);
                }
                catch (IOException ioex) {
                    Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet:IO Exception. get host and port from domain name" + ioex);
                }
                String host = hostAndPort[0];
                String port = hostAndPort[1];
                if (host != null) {
                    store.put("userStoreHostName", host);
                    store.put("userStorePort", port);
                }
            } else {
                store.put("userStoreHostName", tmp);
                tmp = request.getParameter("USERSTORE_PORT");
                store.put("userStorePort", tmp);
            }
            tmp = request.getParameter("USERSTORE_SSL");
            store.put("userStoreSSL", tmp);
            tmp = request.getParameter("USERSTORE_SUFFIX");
            if (tmp == null || tmp.length() == 0) {
                if (domainName != null && domainName.length() > 0) {
                    String umRootSuffix = AMSetupServlet.dnsDomainToDN(domainName);
                    store.put("userStoreRootSuffix", umRootSuffix);
                }
            } else {
                store.put("userStoreRootSuffix", tmp);
            }
            tmp = request.getParameter("USERSTORE_MGRDN");
            store.put("userStoreLoginID", tmp);
            tmp = request.getParameter("USERSTORE_PASSWD");
            store.put("userStoreLoginPassword", tmp);
            store.put("userStoreType", userStoreType);
            req.addParameter("UserStore", store);
        }
        if (!(result = AMSetupServlet.processRequest(req, res))) {
            response.getWriter().write("Configuration failed - check installation logs!");
        } else {
            response.getWriter().write("Configuration complete!");
        }
    }

    public static boolean processRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpServletRequestWrapper req = new HttpServletRequestWrapper(request);
        HttpServletResponseWrapper res = new HttpServletResponseWrapper(response);
        return AMSetupServlet.processRequest(req, res);
    }

    public static boolean processRequest(IHttpServletRequest request, IHttpServletResponse response) {
        AMSetupServlet.setLocale(request);
        InstallLog.getInstance().open();
        ServicesDefaultValues.setServiceConfigValues(request);
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        String uri = (String)map.get("SERVER_URI");
        SystemProperties.initializeProperties("com.iplanet.services.debug.directory", basedir + uri + "/debug");
        Map siteMap = (Map)map.remove("SITE_CONFIGURATION_MAP");
        Map userRepo = (Map)map.remove("UserStore");
        try {
            isConfiguredFlag = AMSetupServlet.configure(request, map, userRepo);
            if (isConfiguredFlag) {
                FQDNUtils.getInstance().init();
                AMSetupServlet.postInitialize(AMSetupServlet.getAdminSSOToken());
            }
            LoginLogoutMapping.setProductInitialized(isConfiguredFlag);
            if (isConfiguredFlag) {
                boolean legacy = ServerConfiguration.isLegacy();
                String fileBootstrap = AMSetupServlet.getBootstrapLocator();
                if (fileBootstrap != null) {
                    AMSetupServlet.writeToFileEx(fileBootstrap, basedir);
                }
                if (!legacy) {
                    ServerConfigXMLObserver.getInstance().update(true);
                    HashMap mapBootstrap = new HashMap(2);
                    HashSet<String> set = new HashSet<String>(2);
                    set.add(fileBootstrap);
                    mapBootstrap.put(BOOTSTRAP_FILE_LOC, set);
                    if (fileBootstrap == null) {
                        set.add(AMSetupServlet.getPresetConfigDir());
                    } else {
                        set.add(fileBootstrap);
                    }
                    String serverInstanceName = SystemProperties.getServerInstanceName();
                    SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    ServerConfiguration.setServerInstance(adminToken, serverInstanceName, mapBootstrap);
                    if (siteMap != null && !siteMap.isEmpty()) {
                        Set sites;
                        String site = (String)siteMap.get("wizardLoadBalancerSiteName");
                        String primaryURL = (String)siteMap.get("wizardLoadBalancerURL");
                        if (primaryURL != null && primaryURL.length() > 0 && !(sites = SiteConfiguration.getSites(adminToken)).contains(site)) {
                            SiteConfiguration.createSite(adminToken, site, primaryURL, Collections.EMPTY_SET);
                        }
                        if (!ServerConfiguration.belongToSite(adminToken, serverInstanceName, site)) {
                            ServerConfiguration.addToSite(adminToken, serverInstanceName, site);
                        }
                    }
                    if (EmbeddedOpenDS.isMultiServer(map)) {
                        AMSetupServlet.updateReplPortInfo(map);
                    }
                }
            }
        }
        catch (Exception e) {
            InstallLog.getInstance().write("AMSetupServlet.processRequest: error", e);
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processRequest: error", (Throwable)e);
            Object[] params = new Object[]{e.getMessage(), basedir};
            throw new ConfiguratorException("configuration.failed", params, configLocale);
        }
        finally {
            InstallLog.getInstance().close();
        }
        if (WebtopNaming.configMonitoring() >= 0) {
            ConfigMonitoring cm = new ConfigMonitoring();
            cm.configureMonitoring();
        } else {
            Debug.getInstance((String)"amSetupServlet").error("WebtopNaming.configMonitoring returned error.");
        }
        return isConfiguredFlag;
    }

    private static void writeInputToFile(IHttpServletRequest request) throws IOException {
        StringBuffer buff = new StringBuffer();
        Map map = request.getParameterMap();
        for (String key : map.keySet()) {
            if (key.equals("actionLink")) continue;
            Object val = map.get(key);
            if (val instanceof String) {
                buff.append(key).append("=");
                if (passwordParams.contains(key)) {
                    buff.append("********");
                } else {
                    buff.append((String)val);
                }
                buff.append("\n");
                continue;
            }
            if (!(val instanceof Map)) continue;
            Map valMap = (Map)val;
            for (String k : valMap.keySet()) {
                buff.append(key).append(".").append(k).append("=");
                if (passwordParams.contains(k)) {
                    buff.append("********");
                } else {
                    buff.append((String)valMap.get(k));
                }
                buff.append("\n");
            }
        }
        String basedir = (String)map.get("BASE_DIR");
        AMSetupServlet.writeToFile(basedir + "/.configParam", buff.toString());
    }

    private static void checkBaseDir(String basedir, IHttpServletRequest req) throws IOException {
        Object[] params = new Object[]{basedir};
        SetupProgress.reportStart("emb.checkingbasedir", params);
        File baseDirectory = new File(basedir);
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
            AMSetupServlet.writeInputToFile(req);
        } else {
            File bootstrapFile = new File(basedir + "/" + BOOTSTRAP_EXTRA);
            File opendsDir = new File(basedir + OPENDS_DIR);
            if (bootstrapFile.exists() || opendsDir.exists()) {
                SetupProgress.reportEnd("emb.basedirfailed", null);
                throw new ConfiguratorException("Base directory specified :" + basedir + " cannot be used - has preexisting config data.");
            }
        }
        SetupProgress.reportEnd("emb.success", null);
    }

    private static boolean setupEmbeddedDS(Map map, String dataStore) throws ConfigurationException, Exception {
        boolean ditLoaded = false;
        EmbeddedOpenDS.setup(map, servletCtx);
        AMSetupDSConfig dsConfig = AMSetupDSConfig.getInstance();
        int sleepTime = 10;
        while (!dsConfig.isDServerUp() && sleepTime-- > 0) {
            Thread.sleep(1000L);
        }
        if (!dsConfig.isDServerUp()) {
            throw new ConfigurationException("OpenDS cannot be started.");
        }
        if (EmbeddedOpenDS.isMultiServer(map)) {
            String str1;
            int ndx2;
            int ndx1;
            List schemaFiles = AMSetupServlet.getSchemaFiles(dataStore);
            String basedir = (String)map.get("BASE_DIR");
            AMSetupServlet.writeSchemaFiles(basedir, schemaFiles, map, dataStore);
            String existingInstance = (String)map.get("existingserverid");
            if (existingInstance != null && (ndx1 = existingInstance.indexOf("://")) != -1 && ndx1 != existingInstance.length() - 1 && (ndx2 = (str1 = existingInstance.substring(ndx1 + 3)).indexOf(":")) != -1 && ndx2 != str1.length() - 1) {
                String finalStr = str1.substring(0, ndx2);
                map.put("DS_EMB_REPL_HOST2", finalStr);
            }
            EmbeddedOpenDS.setupReplication(map);
            ditLoaded = true;
        }
        return ditLoaded;
    }

    private static boolean setupSMDatastore(Map map) throws Exception {
        boolean isDITLoaded = ((String)map.get("DIT_LOADED")).equals("true");
        String dataStore = (String)map.get("DATA_STORE");
        if (dataStore.equals("embedded")) {
            isDITLoaded = AMSetupServlet.setupEmbeddedDS(map, dataStore);
        }
        if (!isDITLoaded) {
            List schemaFiles = AMSetupServlet.getSchemaFiles(dataStore);
            String basedir = (String)map.get("BASE_DIR");
            AMSetupServlet.writeSchemaFiles(basedir, schemaFiles, map, dataStore);
        }
        return isDITLoaded;
    }

    private static void configureServerInstance(SSOToken adminSSOToken, String serverInstanceName, String strAMConfigProperties, boolean isDITLoaded, String basedir, String strServerConfigXML, Map propAMConfig, Map map) throws SMSException, SSOException, IOException, ConfigurationException {
        SetupProgress.reportStart("configurator.progress.configure.server.instance", null);
        if (ServerConfiguration.isLegacy(adminSSOToken)) {
            Map mapProp = ServerConfiguration.getDefaultProperties();
            mapProp.putAll(propAMConfig);
            AMSetupServlet.appendLegacyProperties(mapProp);
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)mapProp);
            SystemProperties.initializeProperties(tmp, true, false);
            AMSetupServlet.writeToFile(basedir + "/" + "AMConfig.properties", AMSetupServlet.mapToString(mapProp));
            AMSetupServlet.writeToFile(basedir + "/serverconfig.xml", strServerConfigXML);
            String hostname = (String)map.get("SERVER_HOST");
            AMSetupServlet.updatePlatformServerList(serverInstanceName, hostname);
        } else {
            try {
                if (!isDITLoaded) {
                    ServerConfiguration.createDefaults(adminSSOToken);
                }
                if (!isDITLoaded || !ServerConfiguration.isServerInstanceExist(adminSSOToken, serverInstanceName)) {
                    ServerConfiguration.createServerInstance(adminSSOToken, serverInstanceName, ServerConfiguration.getPropertiesSet(strAMConfigProperties), strServerConfigXML);
                }
            }
            catch (UnknownPropertyNameException ex) {
                // empty catch block
            }
            ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMPlatformService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
            scm.addListener(ConfigurationObserver.getInstance());
        }
        SetupProgress.reportEnd("emb.done", null);
    }

    private static boolean configure(IHttpServletRequest request, Map map, Map userRepo) throws Exception {
        boolean configured = false;
        boolean existingConfiguration = false;
        try {
            ServiceConfig sc;
            String basedir = (String)map.get("BASE_DIR");
            AMSetupServlet.checkBaseDir(basedir, request);
            boolean isDITLoaded = AMSetupServlet.setupSMDatastore(map);
            String serverURL = (String)map.get("SERVER_URL");
            String deployuri = (String)map.get("SERVER_URI");
            AMSetupServlet.setupSecurIDDirs(basedir, deployuri);
            AMSetupServlet.setupSafeWordDirs(basedir, deployuri);
            SetupProgress.reportStart("configurator.progress.reinit.system", null);
            Map mapFileNameToConfig = AMSetupServlet.initializeConfigProperties();
            String strAMConfigProperties = (String)mapFileNameToConfig.get("AMConfig.properties");
            String strServerConfigXML = (String)mapFileNameToConfig.get("serverconfig.xml");
            Properties propAMConfig = ServerConfiguration.getProperties(strAMConfigProperties);
            propAMConfig.put("installTime", "true");
            String serverInstanceName = serverURL + deployuri;
            AMSetupServlet.reInitConfigProperties(serverInstanceName, propAMConfig, strServerConfigXML);
            SystemProperties.initializeProperties("installTime", "true");
            SetupProgress.reportEnd("emb.done", null);
            SSOToken adminSSOToken = AMSetupServlet.getAdminSSOToken();
            if (!isDITLoaded) {
                RegisterServices regService = new RegisterServices();
                boolean bUseExtUMDS = userRepo != null && !userRepo.isEmpty();
                regService.registers(adminSSOToken, bUseExtUMDS);
                AMSetupServlet.processDataRequests("/WEB-INF/template/sms");
            }
            SystemProperties.initializeProperties("installTime", "false");
            AMSetupServlet.configureServerInstance(adminSSOToken, serverInstanceName, strAMConfigProperties, isDITLoaded, basedir, strServerConfigXML, propAMConfig, map);
            String dataStore = (String)map.get("DATA_STORE");
            boolean embedded = dataStore.equals("embedded");
            if (embedded) {
                try {
                    String serverID = WebtopNaming.getAMServerID();
                    String entry = map.get("DIRECTORY_SERVER") + ":" + map.get("DIRECTORY_PORT") + "|" + serverID;
                    String orgName = (String)map.get("SM_CONFIG_ROOT_SUFFIX");
                    AMSetupServlet.updateEmbeddedIdRepo(orgName, "embedded", entry);
                }
                catch (Exception ex) {
                    Debug.getInstance((String)"amSetupServlet").error("EmbeddedDS : failed to setup serverid", (Throwable)ex);
                    throw ex;
                }
            }
            SystemProperties.setServerInstanceName(serverInstanceName);
            LDIFTemplates.copy(basedir, servletCtx);
            ServiceXMLTemplates.copy(basedir + "/template/xml", servletCtx);
            AMSetupServlet.createDotVersionFile(basedir);
            AMSetupServlet.handlePostPlugins(adminSSOToken);
            AMSetupServlet.postInitialize(adminSSOToken);
            if (!isDITLoaded && userRepo != null && !userRepo.isEmpty() && (sc = UserIdRepo.getOrgConfig(adminSSOToken)) != null) {
                CachedSMSEntry cEntry = CachedSMSEntry.getInstance(adminSSOToken, "ou=" + userRepo.get("userStoreHostName") + "," + sc.getDN());
                SMSEntry entry = cEntry.getClonedSMSEntry();
                if (entry.isNewEntry()) {
                    UserIdRepo.getInstance().configure(userRepo, basedir, servletCtx, adminSSOToken);
                } else {
                    existingConfiguration = true;
                }
            }
            AMSetupServlet.createPasswordFiles(basedir, deployuri);
            if (!isDITLoaded) {
                if (userRepo == null || userRepo.isEmpty()) {
                    AMSetupServlet.createDemoUser();
                }
                if (!existingConfiguration) {
                    AMSetupServlet.createIdentitiesForWSSecurity(serverURL, deployuri);
                }
            }
            String aceDataDir = basedir + "/" + deployuri + "/auth/ace/data";
            AMSetupServlet.copyAuthSecurIDFiles(aceDataDir);
            AMSetupServlet.startRegistrationProcess(basedir, deployuri);
            isConfiguredFlag = true;
            configured = true;
        }
        catch (Exception e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.configure: error", (Throwable)e);
            errorMessage = e.getMessage();
            throw e;
        }
        return configured;
    }

    public static String getErrorMessage() {
        return errorMessage != null ? errorMessage : "";
    }

    private static void appendLegacyProperties(Map prop) {
        ResourceBundle res = ResourceBundle.getBundle(LEGACY_PROPERTIES);
        Enumeration<String> i = res.getKeys();
        while (i.hasMoreElements()) {
            String key = i.nextElement();
            prop.put(key, res.getString(key));
        }
    }

    private static void postInitialize(SSOToken adminSSOToken) throws SSOException, SMSException {
        SMSEntry.initializeClass();
        AMAuthenticationManager.reInitializeAuthServices();
        AMIdentityRepository.clearCache();
        ServiceManager svcMgr = new ServiceManager(adminSSOToken);
        svcMgr.clearCache();
        LoginLogoutMapping lmp = new LoginLogoutMapping();
        lmp.initializeAuth(servletCtx);
        LoginLogoutMapping.setProductInitialized(true);
    }

    private static Map createBootstrapResource(boolean legacy) throws IOException {
        HashMap<String, String> initMap = new HashMap<String, String>();
        Map map = ServicesDefaultValues.getDefaultValues();
        String serverURL = (String)map.get("SERVER_URL");
        String basedir = (String)map.get("BASE_DIR");
        String deployuri = (String)map.get("SERVER_URI");
        String dataStore = (String)map.get("DATA_STORE");
        if (legacy) {
            initMap.put("ffbasedir", basedir);
        } else if (dataStore.equals("flatfile")) {
            initMap.put("protocol", "file://");
            initMap.put("ffbasedir", basedir + deployuri + "/" + SMS_STR);
            initMap.put("pwd", (String)map.get("ADMIN_PWD"));
            initMap.put("basedir", basedir);
        } else {
            String tmp = (String)map.get("DIRECTORY_SSL");
            boolean ssl = tmp != null && tmp.equals("SSL");
            initMap.put("protocol", ssl ? "ldaps://" : "ldap://");
            initMap.put("dshost", (String)map.get("DIRECTORY_SERVER"));
            initMap.put("dsport", (String)map.get("DIRECTORY_PORT"));
            initMap.put("dsbasedn", (String)map.get("ROOT_SUFFIX"));
            initMap.put("dsmgr", (String)map.get("DS_DIRMGRDN"));
            initMap.put("pwd", (String)map.get("ADMIN_PWD"));
            initMap.put("dspwd", (String)map.get("DS_DIRMGRPASSWD"));
        }
        initMap.put("serverinstance", serverURL + deployuri);
        return initMap;
    }

    private static void handlePostPlugins(SSOToken adminSSOToken) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (servletCtx == null) {
            return;
        }
        List plugins = AMSetupServlet.getConfigPluginClasses();
        for (ConfiguratorPlugin plugin : plugins) {
            plugin.doPostConfiguration(servletCtx, adminSSOToken);
        }
    }

    private static List getConfigPluginClasses() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        ArrayList<ConfiguratorPlugin> plugins = new ArrayList<ConfiguratorPlugin>();
        try {
            ResourceBundle rb = ResourceBundle.getBundle("configuratorPlugins");
            String strPlugins = rb.getString("configurator.plugins");
            if (strPlugins != null) {
                StringTokenizer st = new StringTokenizer(strPlugins);
                while (st.hasMoreTokens()) {
                    String className = st.nextToken();
                    Class<?> clazz = Class.forName(className);
                    plugins.add((ConfiguratorPlugin)clazz.newInstance());
                }
            }
        }
        catch (IllegalAccessException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getConfigPluginClasses: error", (Throwable)e);
            throw e;
        }
        catch (InstantiationException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getConfigPluginClasses: error", (Throwable)e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getConfigPluginClasses: error", (Throwable)e);
            throw e;
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return plugins;
    }

    private static void reInitConfigProperties(String serverName, Properties prop, String strServerConfigXML) throws FileNotFoundException, SMSException, IOException, SSOException, LDAPServiceException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        SystemProperties.initializeProperties(prop, true, false);
        Crypt.reinitialize();
        AMSetupServlet.initDSConfigMgr(strServerConfigXML);
        AdminUtils.initialize();
        SMSAuthModule.initialize();
        SystemProperties.initializeProperties(prop, true, true);
        DebugPropertiesObserver.getInstance().notifyChanges();
        SMSPropertiesObserver.getInstance().notifyChanges();
        List plugins = AMSetupServlet.getConfigPluginClasses();
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        for (ConfiguratorPlugin plugin : plugins) {
            plugin.reinitConfiguratioFile(basedir);
        }
    }

    public static String getPresetConfigDir() throws ConfiguratorException {
        String configDir = System.getProperty("com.sun.identity.configuration.directory");
        if (configDir == null || configDir.length() == 0) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(BOOTSTRAP_EXTRA);
                configDir = rb.getString("configuration.dir");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (configDir != null && configDir.length() > 0) {
            String realPath = AMSetupServlet.getNormalizedRealPath(servletCtx);
            if (realPath != null) {
                configDir = StringUtils.strReplaceAll((String)configDir, (String)"@REAL_PATH@", (String)realPath);
            } else {
                throw new ConfiguratorException("cannot get configuration path");
            }
        }
        return configDir;
    }

    static String getBootStrapFile() throws ConfiguratorException {
        File test;
        String bootstrap = null;
        String configDir = AMSetupServlet.getPresetConfigDir();
        if (configDir != null && configDir.length() > 0) {
            bootstrap = configDir + "/bootstrap";
        } else {
            String locator = AMSetupServlet.getBootstrapLocator();
            FileReader frdr = null;
            try {
                frdr = new FileReader(locator);
                BufferedReader brdr = new BufferedReader(frdr);
                bootstrap = brdr.readLine() + "/bootstrap";
            }
            catch (IOException e) {
                throw new ConfiguratorException(e.getMessage());
            }
            finally {
                if (frdr != null) {
                    try {
                        frdr.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (bootstrap != null && !(test = new File(bootstrap)).exists()) {
            bootstrap = null;
        }
        return bootstrap;
    }

    private static String getBootstrapLocator() throws ConfiguratorException {
        String configDir = AMSetupServlet.getPresetConfigDir();
        if (configDir != null && configDir.length() > 0) {
            return null;
        }
        if (servletCtx != null) {
            String path = AMSetupServlet.getNormalizedRealPath(servletCtx);
            if (path != null) {
                return System.getProperty("user.home") + "/" + ".openssocfg" + "/" + "AMConfig" + path;
            }
            throw new ConfiguratorException("Cannot read the bootstrap path");
        }
        return null;
    }

    private static String getBaseDir() throws ConfiguratorException {
        String configDir = AMSetupServlet.getPresetConfigDir();
        if (configDir != null && configDir.length() > 0) {
            return configDir;
        }
        if (servletCtx != null) {
            String path = AMSetupServlet.getNormalizedRealPath(servletCtx);
            if (path != null) {
                String bootstrap = System.getProperty("user.home") + "/" + ".openssocfg" + "/" + "AMConfig" + path;
                File test = new File(bootstrap);
                if (!test.exists()) {
                    return null;
                }
                FileReader frdr = null;
                try {
                    frdr = new FileReader(bootstrap);
                    BufferedReader brdr = new BufferedReader(frdr);
                    String string = brdr.readLine();
                    return string;
                }
                catch (IOException e) {
                    throw new ConfiguratorException(e.getMessage());
                }
                finally {
                    if (frdr != null) {
                        try {
                            frdr.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            throw new ConfiguratorException("Cannot read the bootstrap path");
        }
        throw new ConfiguratorException("Servlet Context is null");
    }

    public static String getNormalizedRealPath(ServletContext servletCtx) {
        String path = null;
        if (servletCtx != null && (path = AMSetupServlet.getAppResource(servletCtx)) != null) {
            String realPath = servletCtx.getRealPath("/");
            if (realPath != null && realPath.length() > 0) {
                realPath = realPath.replace('\\', '/');
                path = realPath.replaceAll("/", "_");
            } else {
                path = path.replaceAll("/", "_");
            }
            int idx = path.indexOf(":");
            if (idx != -1) {
                path = path.substring(idx + 1);
            }
        }
        return path;
    }

    private static String getAppResource(ServletContext servletCtx) {
        if (servletCtx != null) {
            try {
                URL turl = servletCtx.getResource("/");
                return turl.getPath();
            }
            catch (MalformedURLException mue) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getAppResource: Cannot access the resource", (Throwable)mue);
            }
        } else {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.getAppResource: Context is null");
        }
        return null;
    }

    private static void processDataRequests(String xmlBaseDir) throws SMSException, SSOException, IOException, PolicyException {
        SetupProgress.reportStart("configurator.progress.configure.system", null);
        SSOToken ssoToken = AMSetupServlet.getAdminSSOToken();
        try {
            Map map = ServicesDefaultValues.getDefaultValues();
            String hostname = (String)map.get("SERVER_HOST");
            ConfigureData configData = new ConfigureData(xmlBaseDir, servletCtx, hostname, ssoToken);
            configData.configure();
            SetupProgress.reportEnd("emb.done", null);
        }
        catch (SMSException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processDataRequests", (Throwable)e);
            throw e;
        }
        catch (SSOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processDataRequests", (Throwable)((Object)e));
            throw e;
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.processDataRequests", (Throwable)e);
            throw e;
        }
    }

    private static SSOToken getAdminSSOToken() {
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return adminToken;
    }

    private static Map initializeConfigProperties() throws SecurityException, IOException {
        HashMap<String, String> mapFileNameToContent = new HashMap<String, String>();
        List dataFiles = AMSetupServlet.getTagSwapConfigFiles();
        Map map = ServicesDefaultValues.getDefaultValues();
        String basedir = (String)map.get("BASE_DIR");
        String deployuri = (String)map.get("SERVER_URI");
        try {
            File fhm = new File(basedir + deployuri + "/" + SMS_STR);
            fhm.mkdirs();
        }
        catch (SecurityException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.initializeConfigProperties", (Throwable)e);
            throw e;
        }
        String version = (String)map.get("VERSION");
        boolean isEnterprise = version.contains("Enterprise");
        String libRegDir = basedir + "/" + deployuri + "/lib/registration";
        File reglibDir = new File(libRegDir);
        for (String file : dataFiles) {
            String absFile;
            StringBuffer sbuf = null;
            try {
                sbuf = AMSetupServlet.readFile(file);
            }
            catch (IOException ioex) {
                break;
            }
            int idx = file.lastIndexOf("/");
            String string = absFile = idx != -1 ? file.substring(idx + 1) : file;
            if (absFile.equalsIgnoreCase("AMConfig.properties")) {
                int idx1;
                String dbOption = (String)map.get("DATA_STORE");
                boolean embedded = dbOption.equals("embedded");
                boolean dbSunDS = false;
                boolean dbMsAD = false;
                if (embedded) {
                    dbSunDS = true;
                } else {
                    dbSunDS = dbOption.equals("dirServer");
                    dbMsAD = dbOption.equals("activeDir");
                }
                if ((dbSunDS || dbMsAD) && (idx1 = sbuf.indexOf("SMS_OBJECT_CLASS")) != -1) {
                    String dataStoreClass = embedded ? "EMBEDDED_DS_OBJECT_CLASS" : "DS_OBJECT_CLASS";
                    sbuf.replace(idx1, idx1 + "SMS_OBJECT_CLASS".length(), dataStoreClass);
                }
            }
            if (AMSetupServlet.determineOS().equals("linux")) {
                map.put("PAM_SERVICE_NAME", "password");
            }
            String swapped = ServicesDefaultValues.tagSwap(sbuf.toString(), file.endsWith("xml"));
            if (absFile.equalsIgnoreCase("AMConfig.properties") || absFile.equalsIgnoreCase("serverconfig.xml")) {
                mapFileNameToContent.put(absFile, swapped);
                continue;
            }
            if (absFile.equalsIgnoreCase("rsa_api.properties")) {
                AMSetupServlet.writeToFile(basedir + deployuri + "/auth/ace/data/" + absFile, swapped);
                continue;
            }
            if (absFile.startsWith("servicetag-registry")) {
                if ((!isEnterprise || !absFile.contains("-ent")) && (isEnterprise || !absFile.contains("-exp"))) continue;
                if (reglibDir.mkdirs()) {
                    AMSetupServlet.writeToFile(basedir + deployuri + "/lib/registration/servicetag-registry.xml", swapped);
                    continue;
                }
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.initializeConfigProperties: failed to write servicetag-registry.xml to " + reglibDir.getPath());
                SetupProgress.reportEnd("emb.failed", null);
                continue;
            }
            AMSetupServlet.writeToFile(basedir + "/" + absFile, swapped);
        }
        return mapFileNameToContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer readFile(String file) throws IOException {
        InputStreamReader fin = null;
        StringBuffer sbuf = new StringBuffer();
        InputStream is = null;
        try {
            int len;
            is = AMSetupServlet.getResourceAsStream(servletCtx, file);
            if (is == null) {
                throw new IOException(file + " not found");
            }
            fin = new InputStreamReader(is);
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception ex) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return sbuf;
    }

    private static void writeToFileEx(String fileName, String content) throws IOException {
        File btsFile = new File(fileName);
        if (!btsFile.getParentFile().exists()) {
            btsFile.getParentFile().mkdirs();
        }
        AMSetupServlet.writeToFile(fileName, content);
    }

    static void writeToFile(String fileName, String content) throws IOException {
        FileWriter fout = null;
        try {
            fout = new FileWriter(fileName);
            fout.write(content);
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.writeToFile", (Throwable)e);
            throw e;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static String getRandomString() {
        String randomStr = null;
        try {
            byte[] bytes = new byte[24];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(bytes);
            randomStr = Base64.encode((byte[])bytes).trim();
        }
        catch (Exception e) {
            randomStr = null;
            Debug.getInstance((String)"amSetupServlet").message("AMSetupServlet.getRandomString:Exception in generating encryption key.", (Throwable)e);
        }
        return randomStr != null ? randomStr : "KmhUnWR1MYWDYW4xuqdF5nbm+CXIyOVt";
    }

    public static int getUnusedPort(String hostname, int start, int incr) {
        int defaultPort = -1;
        for (int i = start; i < 65500 && defaultPort == -1; i += incr) {
            if (!AMSetupServlet.canUseAsPort(hostname, i)) continue;
            defaultPort = i;
        }
        return defaultPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canUseAsPort(String hostname, int port) {
        boolean canUseAsPort = false;
        ServerSocket serverSocket = null;
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
            serverSocket = new ServerSocket();
            serverSocket.bind(socketAddress);
            canUseAsPort = true;
            serverSocket.close();
            Socket s = null;
            s = new Socket();
            s.connect(socketAddress, 1000);
            canUseAsPort = false;
            if (s == null) return canUseAsPort;
            try {
                s.close();
                return canUseAsPort;
            }
            catch (Throwable t) {}
            return canUseAsPort;
            catch (Throwable t) {
                if (s == null) return canUseAsPort;
                try {
                    s.close();
                    return canUseAsPort;
                }
                catch (Throwable t2) {}
                return canUseAsPort;
                catch (Throwable throwable) {
                    if (s == null) throw throwable;
                    try {
                        s.close();
                        throw throwable;
                    }
                    catch (Throwable t3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException ex) {
            canUseAsPort = false;
            return canUseAsPort;
        }
        catch (NullPointerException ne) {
            canUseAsPort = false;
            return canUseAsPort;
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static Map getRemoteServerInfo(String server, String userid, String pwd) throws ConfigurationException {
        HttpURLConnection conn = null;
        try {
            String line;
            String data = "IDToken1=" + URLEncoder.encode(userid, "UTF-8") + "&IDToken2=" + URLEncoder.encode(pwd, "UTF-8");
            URL url = new URL(server + "/getServerInfo.jsp");
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Map info = null;
            while ((line = rd.readLine()) != null) {
                if (line.length() == 0) continue;
                info = BootstrapData.queryStringToMap(line);
            }
            wr.close();
            rd.close();
            Map map = info;
            return map;
        }
        catch (SSLHandshakeException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, java.util.Locale.getDefault());
        }
        catch (IllegalArgumentException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, java.util.Locale.getDefault());
        }
        catch (MalformedURLException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, java.util.Locale.getDefault());
        }
        catch (UnknownHostException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, java.util.Locale.getDefault());
        }
        catch (FileNotFoundException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("701", null, java.util.Locale.getDefault());
        }
        catch (ConnectException e) {
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw new ConfiguratorException("702", null, java.util.Locale.getDefault());
        }
        catch (IOException e) {
            ConfiguratorException cex = null;
            int status = 0;
            if (conn != null) {
                try {
                    status = conn.getResponseCode();
                }
                catch (Exception ig) {
                    // empty catch block
                }
            }
            cex = status == 401 || status == 400 || status == 405 || status == 408 ? new ConfiguratorException("" + status, null, java.util.Locale.getDefault()) : new ConfiguratorException(e.getMessage());
            Debug.getInstance((String)"amSetupServlet").warning("AMSetupServlet.getRemoteServerInfo()", (Throwable)e);
            throw cex;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static List getSchemaFiles(String dataStore) throws MissingResourceException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ResourceBundle rb = ResourceBundle.getBundle("schemaNames");
        boolean embedded = dataStore.equals("embedded");
        String strFiles = embedded ? rb.getString("opendsSmsSchema") : rb.getString("dsSmsSchema");
        StringTokenizer st = new StringTokenizer(strFiles);
        while (st.hasMoreTokens()) {
            fileNames.add(st.nextToken());
        }
        return fileNames;
    }

    private static List getTagSwapConfigFiles() throws MissingResourceException {
        ArrayList<String> fileNames = new ArrayList<String>();
        ResourceBundle rb = ResourceBundle.getBundle("configuratorTagSwap");
        String strFiles = rb.getString("tagswap.files");
        StringTokenizer st = new StringTokenizer(strFiles);
        while (st.hasMoreTokens()) {
            fileNames.add(st.nextToken());
        }
        return fileNames;
    }

    private static boolean isIPAddress(String hostname) {
        boolean isIPAddr;
        StringTokenizer st = new StringTokenizer(hostname, ".");
        boolean bl = isIPAddr = st.countTokens() == 4;
        if (isIPAddr) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int node = Integer.parseInt(token);
                    isIPAddr = node >= 0 && node < 256;
                }
                catch (NumberFormatException e) {
                    isIPAddr = false;
                }
            }
        }
        return isIPAddr;
    }

    private static void writeSchemaFiles(String basedir, List schemaFiles, Map map, String dataStore) throws Exception {
        SetupProgress.reportStart("configurator.progress.tagswap.schemafiles", null);
        HashSet<String> absSchemaFiles = new HashSet<String>();
        for (String file : schemaFiles) {
            String content = AMSetupServlet.readFile(file).toString();
            OutputStreamWriter fout = null;
            try {
                int idx = file.lastIndexOf("/");
                String absFile = basedir + "/" + (idx != -1 ? file.substring(idx + 1) : file);
                fout = new FileWriter(absFile);
                absSchemaFiles.add(absFile);
                fout.write(ServicesDefaultValues.tagSwap(content));
            }
            catch (IOException ioex) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.writeSchemaFiles: Exception in writing schema files:", (Throwable)ioex);
                throw ioex;
            }
            finally {
                if (fout == null) continue;
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
        SetupProgress.reportEnd("emb.success", null);
        AMSetupDSConfig dsConfig = AMSetupDSConfig.getInstance();
        dsConfig.loadSchemaFiles(schemaFiles);
        if (dataStore.equals("embedded")) {
            EmbeddedOpenDS.rebuildIndex(map);
        }
        Iterator iter = absSchemaFiles.iterator();
        while (iter.hasNext()) {
            File file = new File((String)iter.next());
            file.delete();
        }
    }

    private static void updateSTSwsdl(String basedir, String deployuri) throws IOException {
        URL url = servletCtx.getResource("/WEB-INF/lib/opensso.jar");
        String webAppLocation = url.toString().substring(5);
        int index = webAppLocation.indexOf("WEB-INF");
        webAppLocation = webAppLocation.substring(0, index - 1);
        String contentWSDL = AMSetupServlet.readFile("/WEB-INF/wsdl/famsts.wsdl").toString();
        contentWSDL = StringUtils.strReplaceAll((String)contentWSDL, (String)"@KEYSTORE_LOCATION@", (String)(basedir + deployuri));
        BufferedWriter outWSDL = new BufferedWriter(new FileWriter(webAppLocation + "/WEB-INF/wsdl/famsts.wsdl"));
        outWSDL.write(contentWSDL);
        outWSDL.close();
    }

    private static void createPasswordFiles(String basedir, String deployuri) throws IOException {
        String pwd = Crypt.encrypt((String)"changeit");
        String location = basedir + deployuri;
        AMSetupServlet.writeContent(location + "/.keypass", pwd);
        AMSetupServlet.writeContent(location + "/.storepass", pwd);
        AMSetupServlet.copyCtxFile("/WEB-INF/template/keystore", "keystore.jks", location);
    }

    private static void writeContent(String fName, String content) throws IOException {
        OutputStreamWriter fout = null;
        try {
            fout = new FileWriter(new File(fName));
            fout.write(content);
        }
        catch (IOException ioex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.writeContent: Exception in creating password files:", (Throwable)ioex);
            throw ioex;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static void updateEmbeddedIdRepo(String orgName, String configName, String entry) throws SMSException, SSOException {
        ServiceConfig subConfig;
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
        ServiceConfig sc = scm.getOrganizationConfig(orgName, null);
        if (sc != null && (subConfig = sc.getSubConfig(configName)) != null) {
            Map configMap = subConfig.getAttributes();
            Set vals = (Set)configMap.get("sun-idrepo-ldapv3-config-ldap-server");
            vals.add(entry);
            HashMap<String, Set> mp = new HashMap<String, Set>(2);
            mp.put("sun-idrepo-ldapv3-config-ldap-server", vals);
            subConfig.setAttributes(mp);
        }
    }

    private static void updatePlatformServerList(String serverURL, String hostName) throws SMSException, SSOException {
        SSOToken token = AMSetupServlet.getAdminSSOToken();
        ServiceSchemaManager ssm = new ServiceSchemaManager("iPlanetAMPlatformService", token);
        ServiceSchema ss = ssm.getGlobalSchema();
        AttributeSchema as = ss.getAttributeSchema("iplanet-am-platform-server-list");
        HashSet<String> values = as.getDefaultValues();
        if (!AMSetupServlet.isInPlatformList(values, serverURL)) {
            String instanceName = AMSetupServlet.getNextAvailableServerId(values);
            values.add(serverURL + "|" + instanceName);
            as.setDefaultValues(values);
            OrganizationConfigManager ocm = new OrganizationConfigManager(token, "/");
            Map attrs = ocm.getAttributes("sunIdentityRepositoryService");
            Set origValues = (Set)attrs.get("sunOrganizationAliases");
            if (!origValues.contains(hostName)) {
                values = new HashSet<String>();
                values.add(hostName);
                ocm.addAttributeValues("sunIdentityRepositoryService", "sunOrganizationAliases", values);
            }
        }
    }

    private static String getNextAvailableServerId(Set values) {
        boolean instanceNumber = true;
        int maxNumber = 1;
        for (String item : values) {
            int index1 = item.indexOf(124);
            if (index1 == -1) continue;
            int index2 = item.indexOf(124, index1 + 1);
            item = index2 == -1 ? item.substring(index1 + 1) : item.substring(index1 + 1, index2);
            try {
                int n = Integer.parseInt(item);
                if (n <= maxNumber) continue;
                maxNumber = n;
            }
            catch (NumberFormatException nfe) {}
        }
        String instanceName = Integer.toString(maxNumber + 1);
        if (instanceName.length() == 1) {
            instanceName = "0" + instanceName;
        }
        return instanceName;
    }

    private static boolean isInPlatformList(Set values, String hostname) {
        boolean found = false;
        Iterator items = values.iterator();
        while (items.hasNext() && !found) {
            String item = (String)items.next();
            int idx = item.indexOf(124);
            if (idx == -1) continue;
            String svr = item.substring(0, idx);
            found = svr.equals(hostname);
        }
        return found;
    }

    private static boolean isAgentServiceLoad(SSOToken token) {
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", token);
            return ssm != null;
        }
        catch (SSOException ex) {
            return false;
        }
        catch (SMSException ex) {
            return false;
        }
    }

    private static void createDemoUser() throws IdRepoException, SSOException {
        SetupProgress.reportStart("configurator.progress.create.demo.user", null);
        HashMap attributes = new HashMap();
        HashSet<String> setSN = new HashSet<String>(2);
        setSN.add("demo");
        attributes.put("sn", setSN);
        HashSet<String> setCN = new HashSet<String>(2);
        setCN.add("demo");
        attributes.put("cn", setCN);
        HashSet<String> setPwd = new HashSet<String>(2);
        setPwd.add("changeit");
        attributes.put("userpassword", setPwd);
        HashSet<String> setStatus = new HashSet<String>(2);
        setStatus.add("Active");
        attributes.put("inetuserstatus", setStatus);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(AMSetupServlet.getAdminSSOToken(), "/");
            amir.createIdentity(IdType.USER, "demo", attributes);
        }
        catch (IdRepoException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.createDemoUser", (Throwable)e);
            throw e;
        }
        catch (SSOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.createDemoUser", (Throwable)((Object)e));
            throw e;
        }
        SetupProgress.reportEnd("emb.done", null);
    }

    private static void createIdentitiesForWSSecurity(String serverURL, String deployuri) throws IdRepoException, SSOException {
        SSOToken token = AMSetupServlet.getAdminSSOToken();
        if (!AMSetupServlet.isAgentServiceLoad(token)) {
            return;
        }
        SetupProgress.reportStart("configurator.progress.create.wss.agents", null);
        AMIdentityRepository idrepo = new AMIdentityRepository(token, "/");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("sunIdentityServerDeviceStatus", "Active");
        config.put("SecurityMech", "urn:sun:wss:security:null:UserNameToken");
        config.put("UserCredential", "UserName:test|UserPassword:test");
        config.put("useDefaultStore", "true");
        config.put("privateKeyAlias", "test");
        config.put("publicKeyAlias", "test");
        config.put("isRequestSign", "true");
        config.put("keepSecurityHeaders", "true");
        config.put("WSPEndpoint", "default");
        config.put("EncryptionAlgorithm", "AES");
        config.put("EncryptionStrength", "256");
        config.put("SigningRefType", "DirectReference");
        config.put("AgentType", "WSCAgent");
        AMSetupServlet.createAgent(token, idrepo, "wsc", "wsc", "WSC", "", config);
        config.remove("AgentType");
        config.put("AgentType", "WSPAgent");
        config.put("DetectMessageReplay", "true");
        config.put("DetectUserTokenReplay", "true");
        config.remove("SecurityMech");
        config.put("SecurityMech", "urn:sun:wss:security:null:UserNameToken,urn:sun:wss:security:null:SAML2Token-HK,urn:sun:wss:security:null:SAML2Token-SV,urn:sun:wss:security:null:X509Token");
        AMSetupServlet.createAgent(token, idrepo, "wsp", "wsp", "WSP", "", config);
        config.remove("keepSecurityHeaders");
        config.remove("AgentType");
        config.put("AgentType", "STSAgent");
        config.remove("SecurityMech");
        config.remove("keepSecurityHeaders");
        config.remove("DetectMessageReplay");
        config.remove("DetectUserTokenReplay");
        config.remove("WSPEndpoint");
        config.put("SecurityMech", "urn:sun:wss:security:null:X509Token");
        config.put("STSEndpoint", serverURL + deployuri + "/sts");
        config.put("STSMexEndpoint", serverURL + deployuri + "/sts/mex");
        config.put("WSTrustVersion", "1.3");
        AMSetupServlet.createAgent(token, idrepo, "SecurityTokenService", "SecurityTokenService", "STS", "", config);
        HashMap<String, String> configAgentAuth = new HashMap<String, String>();
        configAgentAuth.put("AgentType", "SharedAgent");
        configAgentAuth.put("sunIdentityServerDeviceStatus", "Active");
        configAgentAuth.put("AgentsAllowedToRead", "wsc,wsp,SecurityTokenService");
        AMSetupServlet.createAgent(token, idrepo, "agentAuth", "changeit", "Agent_Authenticator", "", configAgentAuth);
        SetupProgress.reportEnd("emb.done", null);
    }

    private static void createUser(AMIdentityRepository idrepo, String uid, String gn, String sn) throws IdRepoException, SSOException {
        HashMap attributes = new HashMap();
        HashSet<String> values = new HashSet<String>();
        values.add(uid);
        attributes.put("uid", values);
        values = new HashSet();
        values.add(gn);
        attributes.put("givenname", values);
        values = new HashSet();
        values.add(sn);
        attributes.put("sn", values);
        values = new HashSet();
        values.add(gn + " " + sn);
        attributes.put("cn", values);
        values = new HashSet();
        values.add(uid);
        attributes.put("userPassword", values);
        AMIdentity id = idrepo.createIdentity(IdType.USER, uid, attributes);
        id.assignService("sunIdentityServerDiscoveryService", Collections.EMPTY_MAP);
    }

    private static void createAgent(SSOToken adminToken, AMIdentityRepository idrepo, String name, String password, String type, String desc, Map config) throws IdRepoException, SSOException {
        AMIdentity amid = new AMIdentity(adminToken, name, IdType.AGENTONLY, "/", null);
        if (!amid.isExists()) {
            HashMap attributes = new HashMap();
            HashSet<String> values = new HashSet<String>();
            values.add(password);
            attributes.put("userpassword", values);
            for (String key : config.keySet()) {
                String value = (String)config.get(key);
                values = new HashSet();
                if (value.indexOf(",") != -1) {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    while (st.hasMoreTokens()) {
                        values.add(st.nextToken());
                    }
                } else {
                    values.add(value);
                }
                attributes.put(key, values);
            }
            idrepo.createIdentity(IdType.AGENTONLY, name, attributes);
        }
    }

    private static void startRegistrationProcess(String basedir, String deployuri) {
        SetupProgress.reportStart("configurator.progress.setup.registration", null);
        String libRegDir = basedir + "/" + deployuri + "/lib/registration";
        File reglibDir = new File(libRegDir);
        if (reglibDir.exists()) {
            if (AMSetupServlet.copyRegFiles(libRegDir)) {
                StartRegister sr = new StartRegister();
                sr.servicetagTransfer();
                SetupProgress.reportEnd("emb.done", null);
            } else {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.startRegistrationProcess: failed to copy registration files to " + reglibDir.getPath());
                SetupProgress.reportEnd("emb.failed", null);
            }
        } else {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.startRegistrationProcess:failed to create registration lib directory");
            SetupProgress.reportEnd("emb.failed", null);
        }
    }

    private static boolean copyRegFiles(String destDir) {
        String[] jarFiles = new String[]{"scn_stprs_util.jar", "commons-codec-1.3.jar", "opensso-register.jar"};
        try {
            for (int i = 0; i < jarFiles.length; ++i) {
                AMSetupServlet.copyCtxFile("/WEB-INF/lib", jarFiles[i], destDir);
            }
        }
        catch (IOException ioex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.copyRegFiles:", (Throwable)ioex);
            return false;
        }
        return true;
    }

    private static void setupSecurIDDirs(String basedir, String deployuri) {
        String aceDataDir = basedir + "/" + deployuri + "/auth/ace/data";
        File dataAceDir = new File(aceDataDir);
        if (!dataAceDir.mkdirs()) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.setupSecurIDDirs: failed to create SecurID data directory");
        }
    }

    private static void copyAuthSecurIDFiles(String destDir) {
        String[] propFiles = new String[]{"log4j.properties"};
        try {
            for (int i = 0; i < propFiles.length; ++i) {
                AMSetupServlet.copyCtxFile("/WEB-INF/classes", propFiles[i], destDir);
            }
        }
        catch (IOException ioex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.copyAuthSecurIDFiles:", (Throwable)ioex);
        }
    }

    private static void setupSafeWordDirs(String basedir, String deployuri) {
        String safewordDir = basedir + "/" + deployuri + "/auth/safeword/serverVerification";
        File safewordFDir = new File(safewordDir);
        if (!safewordFDir.mkdirs()) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.setupSafeWordDirs: failed to create SafeWord verification directory");
        }
    }

    private static boolean copyCtxFile(String srcDir, String file, String destDir) throws IOException {
        FileOutputStream fos;
        InputStream in = AMSetupServlet.getResourceAsStream(servletCtx, srcDir + "/" + file);
        if (in != null) {
            int len;
            fos = new FileOutputStream(destDir + "/" + file);
            byte[] b = new byte[2000];
            while ((len = in.read(b)) > 0) {
                fos.write(b, 0, len);
            }
        } else {
            return false;
        }
        fos.close();
        in.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDSConfigMgr(String str) throws LDAPServiceException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(str.getBytes());
            DSConfigMgr.initInstance(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String mapToString(Map map) {
        StringBuffer buff = new StringBuffer();
        for (String key : map.keySet()) {
            buff.append(key).append("=").append((String)map.get(key)).append("\n");
        }
        return buff.toString();
    }

    private static String determineOS() {
        String OS_ARCH = System.getProperty("os.arch");
        String OS_NAME = System.getProperty("os.name");
        if (OS_ARCH.toLowerCase().indexOf("86") >= 0 || OS_ARCH.toLowerCase().indexOf("amd") >= 0) {
            if (OS_NAME.toLowerCase().indexOf("windows") >= 0) {
                return "windows";
            }
            if (OS_NAME.toLowerCase().indexOf("sunos") >= 0) {
                return "x86solaris";
            }
            return "linux";
        }
        return "solaris";
    }

    private static void setLocale(IHttpServletRequest request) {
        String acceptLangHeader;
        Map map = request.getParameterMap();
        String superLocale = (String)map.get("locale");
        configLocale = superLocale != null && superLocale.length() > 0 ? Locale.getLocaleObjFromAcceptLangHeader((String)superLocale) : ((acceptLangHeader = request.getHeader("Accept-Language")) != null && acceptLangHeader.length() > 0 ? Locale.getLocaleObjFromAcceptLangHeader((String)acceptLangHeader) : java.util.Locale.getDefault());
        SetupProgress.setLocale(configLocale);
    }

    private static void createDotVersionFile(String basedir) throws IOException {
        String version = SystemProperties.get("com.iplanet.am.version");
        AMSetupServlet.writeToFile(basedir + "/.version", version);
    }

    private static boolean syncServerInfoWithRelication() {
        String baseDir = SystemProperties.get("com.iplanet.services.configpath");
        boolean isEmbeddedDS = new File(baseDir + OPENDS_DIR).exists();
        if (!isEmbeddedDS) {
            return true;
        }
        try {
            if (AMSetupServlet.getAdminSSOToken() == null) {
                Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.syncServerInfoWithRelication: Could not sync servers with embedded replication:no admin token");
                return false;
            }
            String myName = WebtopNaming.getLocalServer();
            Properties props = ServerConfiguration.getServerInstance(adminToken, myName);
            String syncFlag = props.getProperty("com.sun.embedded.sync.servers");
            if ("off".equals(syncFlag)) {
                return true;
            }
            String myReplPort = props.getProperty("com.sun.embedded.replicationport");
            Object myDSPort = null;
            Set serverSet = ServerConfiguration.getServers(adminToken);
            if (serverSet == null || serverSet.size() < 2) {
                return true;
            }
            Iterator iter = serverSet.iterator();
            HashSet<String> currServerSet = new HashSet<String>();
            HashSet<String> currServerDSSet = new HashSet<String>();
            while (iter.hasNext()) {
                String sname = (String)iter.next();
                Properties p = ServerConfiguration.getServerInstance(adminToken, sname);
                String hname = p.getProperty("com.iplanet.am.server.host");
                String rPort = p.getProperty("com.sun.embedded.replicationport");
                currServerSet.add(hname + ":" + rPort);
                ServerConfigXML.ServerGroup sg = AMSetupServlet.getSMSServerGroup(sname);
                currServerDSSet.add(hname + ":" + AMSetupServlet.getSMSPort(sg));
            }
            ServerConfigXML.ServerGroup sGroup = AMSetupServlet.getSMSServerGroup(myName);
            boolean stats = EmbeddedOpenDS.syncReplicatedServers(currServerSet, AMSetupServlet.getSMSPort(sGroup), AMSetupServlet.getSMSPassword(sGroup));
            boolean statd = EmbeddedOpenDS.syncReplicatedDomains(currServerSet, AMSetupServlet.getSMSPort(sGroup), AMSetupServlet.getSMSPassword(sGroup));
            boolean statl = EmbeddedOpenDS.syncReplicatedServerList(currServerDSSet, AMSetupServlet.getSMSPort(sGroup), AMSetupServlet.getSMSPassword(sGroup));
            return stats || statd || statl;
        }
        catch (Exception ex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.syncServerInfoWithRelication: Could not sync servers with embedded replication:", (Throwable)ex);
            return false;
        }
    }

    private static ServerConfigXML.ServerGroup getSMSServerGroup(String sname) throws Exception {
        String xml = ServerConfiguration.getServerConfigXML(adminToken, sname);
        ServerConfigXML scc = new ServerConfigXML(xml);
        return scc.getSMSServerGroup();
    }

    private static String getSMSPassword(ServerConfigXML.ServerGroup ssg) throws Exception {
        ServerConfigXML.DirUserObject sduo = (ServerConfigXML.DirUserObject)ssg.dsUsers.get(0);
        String epass = sduo.password;
        String pass = (String)AccessController.doPrivileged(new DecodeAction(epass));
        return pass;
    }

    private static String getSMSPort(ServerConfigXML.ServerGroup ssg) throws Exception {
        ServerConfigXML.ServerObject sobj = (ServerConfigXML.ServerObject)ssg.hosts.get(0);
        return sobj.port;
    }

    private static void updateReplPortInfo(Map map) {
        try {
            String instanceName = WebtopNaming.getLocalServer();
            HashMap<String, String> newValues = new HashMap<String, String>();
            newValues.put("com.sun.embedded.replicationport", (String)map.get("DS_EMB_REPL_REPLPORT1"));
            ServerConfiguration.setServerInstance(AMSetupServlet.getAdminSSOToken(), instanceName, newValues);
            instanceName = (String)map.get("existingserverid");
            newValues.put("com.sun.embedded.replicationport", (String)map.get("DS_EMB_REPL_REPLPORT2"));
            ServerConfiguration.setServerInstance(AMSetupServlet.getAdminSSOToken(), instanceName, newValues);
        }
        catch (Exception ex) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupServlet.updateReplPortInfo: could not add replication port info to SM", (Throwable)ex);
        }
    }

    static InputStream getResourceAsStream(ServletContext servletContext, String file) {
        if (servletContext == null) {
            file = file.substring(1);
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        }
        return servletContext.getResourceAsStream(file);
    }

    static String dnsDomainToDN(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }

    private String[] getLdapHostAndPort(String domainName) throws NamingException, IOException {
        if (!domainName.endsWith(".")) {
            domainName = domainName + '.';
        }
        InitialDirContext ictx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        ictx = new InitialDirContext(env);
        Attributes attributes = ictx.getAttributes(domainName, new String[]{"A"});
        Attribute attrib = attributes.get("A");
        if (attrib == null) {
            throw new NamingException();
        }
        String serverHostName = null;
        String serverPortStr = null;
        String ldapServer = "_ldap._tcp." + domainName;
        Attributes attributes2 = ictx.getAttributes(ldapServer, new String[]{"SRV"});
        Attribute attr = attributes2.get("SRV");
        if (attr == null) {
            throw new NamingException();
        }
        String[] srv = attr.get().toString().split(" ");
        String hostNam = srv[3];
        serverHostName = hostNam.substring(0, hostNam.length() - 1);
        serverPortStr = srv[2];
        int serverPort = Integer.parseInt(serverPortStr);
        new Socket(serverHostName, serverPort).close();
        String[] hostAndPort = new String[]{serverHostName, serverPortStr};
        return hostAndPort;
    }

    static {
        passwordParams = new HashSet();
        passwordParams.add("DS_DIRMGRPASSWD");
        passwordParams.add("ADMIN_PWD");
        passwordParams.add("ADMIN_CONFIRM_PWD");
        passwordParams.add("AMLDAPUSERPASSWD");
        passwordParams.add("AMLDAPUSERPASSWD_CONFIRM");
        passwordParams.add("userStoreLoginPassword");
        passwordParams.add("AM_ENC_KEY");
    }
}

