/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.configuration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SSOServerRealmFedInfo;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenIssuerEndpointElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.UriNamedClaimTypesOfferedElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ConfigFedMonitoring {
    Debug debug;
    SSOToken ssoToken;
    private ArrayList realmList;
    public static final String IDENTITY_PROVIDER = "IDP";
    public static final String SERVICE_PROVIDER = "SP";
    public static final String POLICY_DECISION_POINT_DESCRIPTOR = "PDP";
    public static final String POLICY_ENFORCEMENT_POINT_DESCRIPTOR = "PEP";
    public static final String SAML_ATTRAUTHORITY = "AttrAuthority";
    public static final String SAML_AUTHNAUTHORITY = "AuthnAuthority";
    public static final String SAML_ATTRQUERY = "AttrQuery";
    public static final String AFFILIATE = "Affiliate";

    public void configureFedMonitoring() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = new Date();
        String startDate = sdf.format(date1);
        this.debug = Debug.getInstance((String)"amMonitoring");
        String classMethod = "ConfigFedMonitoring.configureMonitoring: ";
        if (!Agent.isRunning()) {
            if (this.debug.warningEnabled()) {
                this.debug.warning(classMethod + "monitoring is disabled");
            }
            return;
        }
        try {
            this.ssoToken = this.getSSOToken();
        }
        catch (SSOException ssoe) {
            this.debug.error(classMethod + "Could not get proper SSOToken", (Throwable)ssoe);
            return;
        }
        this.getSAML1TPs();
        this.getAllRealms("/");
        date1 = new Date();
        if (this.debug.messageEnabled()) {
            this.debug.message(classMethod + "\n" + "    Start time " + startDate + "\n" + "    End time = " + sdf.format(date1));
        }
    }

    private SSOToken getSSOToken() throws SSOException {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private void getSAML1TPs() {
        String classMethod = "ConfigFedMonitoring.getSAML1TPs: ";
        try {
            HashMap<String, AttributeSchema> attributeSchemas = new HashMap<String, AttributeSchema>();
            ServiceSchemaManager svcSchMgr = new ServiceSchemaManager("iPlanetAMSAMLService", this.ssoToken);
            Set schemaTypes = svcSchMgr.getSchemaTypes();
            for (SchemaType type : schemaTypes) {
                ServiceSchema schema = svcSchMgr.getSchema(type);
                if (schema == null) continue;
                String curSchemaType = type.getType();
                Set asch = schema.getAttributeSchemas();
                for (AttributeSchema as : asch) {
                    String i18n = as.getI18NKey();
                    if (i18n == null || i18n.trim().length() <= 0) continue;
                    attributeSchemas.put(as.getName(), as);
                }
            }
            StringBuffer cotsb = new StringBuffer(classMethod + "SAML1.x Trusted Partners:\n");
            AttributeSchema as = (AttributeSchema)attributeSchemas.get("iplanet-am-saml-partner-urls");
            Set orgValues = as.getDefaultValues();
            int ovsize = orgValues.size();
            if (this.debug.messageEnabled()) {
                cotsb.append("  has ").append(ovsize).append(" entries:\n");
            }
            ArrayList<String> s1List = new ArrayList<String>(ovsize);
            if (ovsize > 0) {
                for (String prtn : orgValues) {
                    StringTokenizer st = new StringTokenizer(prtn, "|");
                    int numtoks = st.countTokens();
                    if (this.debug.messageEnabled()) {
                        cotsb.append("  #tokens = ").append(numtoks).append("\n");
                    }
                    String xx = null;
                    while (st.hasMoreTokens()) {
                        prtn = st.nextToken();
                        StringTokenizer st2 = new StringTokenizer(prtn, "=");
                        if (st2.countTokens() != 2) continue;
                        String st3 = st2.nextToken();
                        xx = st2.nextToken();
                        if (!st3.equalsIgnoreCase("PARTNERNAME")) continue;
                        if (this.debug.messageEnabled()) {
                            cotsb.append("  **got PARTNERNAME**\n");
                        }
                        s1List.add(xx);
                    }
                    if (!this.debug.messageEnabled()) continue;
                    cotsb.append("    ").append(xx).append("\n");
                }
            }
            if (this.debug.messageEnabled()) {
                this.debug.message(cotsb.toString());
            }
            Agent.saml1TPConfig(s1List);
        }
        catch (SSOException e) {
            this.debug.error(classMethod + "sso ex getting saml1.x: " + e.getMessage());
        }
        catch (SMSException e) {
            this.debug.error(classMethod + "sms ex getting saml1.x: " + e.getMessage());
        }
    }

    private List getRealmsList(String startRealm) {
        String classMethod = "ConfigFedMonitoring.getRealmsList: ";
        try {
            int rlmCnt = 1;
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.ssoToken, startRealm);
            Set orgs = orgMgr.getSubOrganizationNames("*", true);
            this.realmList = new ArrayList(rlmCnt += orgs.size());
            this.realmList.add(startRealm);
            Iterator it = orgs.iterator();
            while (it.hasNext()) {
                String ss = "/" + (String)it.next();
                this.realmList.add(ss);
            }
            return this.realmList;
        }
        catch (SMSException e) {
            this.debug.error(classMethod + "SMSException getting OrgConfigMgr: " + e.getMessage());
            return new ArrayList();
        }
    }

    private void getAllRealms(String startRealm) {
        String classMethod = "ConfigFedMonitoring.getAllRealms: ";
        boolean skipSAML2Entities = true;
        StringBuffer sb = new StringBuffer(classMethod);
        sb.append("orgnames starting from ").append(startRealm).append(":\n");
        sb.append("  ").append(startRealm).append("\n");
        List rList = this.getRealmsList(startRealm);
        try {
            CircleOfTrustManager cotmgr = new CircleOfTrustManager();
            SAML2MetaManager saml2Mgr = new SAML2MetaManager();
            IDFFMetaManager idffmgr = new IDFFMetaManager((Object)this.ssoToken);
            for (String thisRealm : rList) {
                Set cots = this.getCOTs(thisRealm, cotmgr);
                Map s2Ents = null;
                if (!skipSAML2Entities) {
                    s2Ents = this.getSAML2Entities(thisRealm, saml2Mgr);
                }
                Map wsEnts = this.getWSFedEntities(thisRealm);
                Map idffentMap = this.getIDFFEntities(thisRealm, idffmgr);
                Map membMap = this.getCOTMembers(thisRealm, cots, cotmgr);
                SSOServerRealmFedInfo srfi = new SSOServerRealmFedInfo.SSOServerRealmFedInfoBuilder(thisRealm).cots(cots).samlv2Entities(s2Ents).wsEntities(wsEnts).idffEntities(idffentMap).membEntities(membMap).build();
                Agent.federationConfig((SSOServerRealmFedInfo)srfi);
            }
        }
        catch (SAML2MetaException e) {
            this.debug.error(classMethod + "SAML2 ex: " + e.getMessage());
        }
        catch (COTException e) {
            this.debug.error(classMethod + "COT ex: " + e.getMessage());
        }
        catch (IDFFMetaException e) {
            this.debug.error(classMethod + "IDFF ex: " + e.getMessage());
        }
    }

    public List getWSFedRoles(String entity, String realm) {
        ArrayList<String> roles = new ArrayList<String>(4);
        boolean isSP = true;
        int cnt = 0;
        try {
            FederationElement fedElem;
            if (WSFederationMetaManager.getIDPSSOConfig((String)realm, (String)entity) != null) {
                roles.add(IDENTITY_PROVIDER);
            }
            if (WSFederationMetaManager.getSPSSOConfig((String)realm, (String)entity) != null) {
                roles.add(SERVICE_PROVIDER);
            }
            if (roles.isEmpty() && (fedElem = WSFederationMetaManager.getEntityDescriptor((String)realm, (String)entity)) != null) {
                for (Object o : fedElem.getAny()) {
                    if (o instanceof UriNamedClaimTypesOfferedElement) {
                        roles.add(IDENTITY_PROVIDER);
                        isSP = false;
                        continue;
                    }
                    if (!(o instanceof TokenIssuerEndpointElement)) continue;
                    ++cnt;
                }
                if (isSP || cnt > 1) {
                    roles.add(SERVICE_PROVIDER);
                }
            }
        }
        catch (WSFederationMetaException e) {
            this.debug.warning("ConfigFedMonitoring.getWSFedRoles", (Throwable)e);
        }
        return roles != null ? roles : Collections.EMPTY_LIST;
    }

    private List getSAMLv2Roles(String entity, String realm) {
        ArrayList<String> roles;
        block11: {
            roles = new ArrayList<String>();
            try {
                SAML2MetaManager samlManager = new SAML2MetaManager();
                EntityDescriptorElement d = samlManager.getEntityDescriptor(realm, entity);
                if (d != null) {
                    if (SAML2MetaUtils.getSPSSODescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(SERVICE_PROVIDER);
                    }
                    if (SAML2MetaUtils.getIDPSSODescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(IDENTITY_PROVIDER);
                    }
                    if (SAML2MetaUtils.getPolicyDecisionPointDescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(POLICY_DECISION_POINT_DESCRIPTOR);
                    }
                    if (SAML2MetaUtils.getPolicyEnforcementPointDescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(POLICY_ENFORCEMENT_POINT_DESCRIPTOR);
                    }
                    if (SAML2MetaUtils.getAttributeAuthorityDescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(SAML_ATTRAUTHORITY);
                    }
                    if (SAML2MetaUtils.getAuthnAuthorityDescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(SAML_AUTHNAUTHORITY);
                    }
                    if (SAML2MetaUtils.getAttributeQueryDescriptor((EntityDescriptorElement)d) != null) {
                        roles.add(SAML_ATTRQUERY);
                    }
                    if (samlManager.getAffiliationDescriptor(realm, entity) != null) {
                        roles.add(AFFILIATE);
                    }
                }
            }
            catch (SAML2MetaException s) {
                if (!this.debug.warningEnabled()) break block11;
                this.debug.warning("ConfigFedMonitoring.getSAMLv2Roles() - Couldn't get SAMLMetaManager");
            }
        }
        return roles != null ? roles : Collections.EMPTY_LIST;
    }

    private List getIDFFRoles(String entity, String realm) {
        ArrayList<String> roles;
        block5: {
            roles = new ArrayList<String>(6);
            try {
                IDFFMetaManager idffManager = new IDFFMetaManager((Object)this.ssoToken);
                if (idffManager.getIDPDescriptor(realm, entity) != null) {
                    roles.add(IDENTITY_PROVIDER);
                }
                if (idffManager.getSPDescriptor(realm, entity) != null) {
                    roles.add(SERVICE_PROVIDER);
                }
                if (idffManager.getAffiliationDescriptor(realm, entity) != null) {
                    roles.add(AFFILIATE);
                }
            }
            catch (IDFFMetaException s) {
                if (!this.debug.warningEnabled()) break block5;
                this.debug.warning("ConfigFedMonitoring.getIDFFRoles() - Couldn't get SAMLMetaManager");
            }
        }
        return roles;
    }

    private String listToString(List roleNames) {
        StringBuffer sb = new StringBuffer();
        for (String role : roleNames) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(this.getLocalizedString(role));
        }
        return sb.toString();
    }

    private String getLocalizedString(String key) {
        return key;
    }

    private Set getCOTs(String realm, CircleOfTrustManager cotmgr) {
        String classMethod = "ConfigFedMonitoring.getCOTs: ";
        Set cotSet = null;
        try {
            cotSet = cotmgr.getAllCirclesOfTrust(realm);
        }
        catch (COTException e) {
            this.debug.error(classMethod + "COTMgr error: " + e.getMessage());
        }
        return cotSet;
    }

    private Map getCOTMembers(String realm, Set cotNames, CircleOfTrustManager cotmgr) {
        String classMethod = "ConfigFedMonitoring.getCOTMembers: ";
        StringBuffer sb = new StringBuffer(classMethod);
        HashMap cotMap = new HashMap();
        for (String cotName : cotNames) {
            if (this.debug.messageEnabled()) {
                sb.append(" cotName = ").append(cotName).append("\n");
            }
            HashMap<String, Set> memMap = new HashMap<String, Set>();
            try {
                Iterator it;
                Set cotSAML = cotmgr.listCircleOfTrustMember(realm, cotName, "saml2");
                Set cotIDFF = cotmgr.listCircleOfTrustMember(realm, cotName, "idff");
                Set cotWSFed = cotmgr.listCircleOfTrustMember(realm, cotName, "wsfed");
                memMap.put("SAML", cotSAML);
                memMap.put("IDFF", cotIDFF);
                memMap.put("WSFed", cotWSFed);
                cotMap.put(cotName, memMap);
                if (!this.debug.messageEnabled()) continue;
                sb.append("    SAMLv2 members: ");
                if (cotSAML != null && cotSAML.size() > 0) {
                    it = cotSAML.iterator();
                    while (it.hasNext()) {
                        sb.append("      ").append((String)it.next()).append("\n");
                    }
                } else {
                    sb.append("none\n");
                }
                sb.append("    IDFF members: ");
                if (cotIDFF != null && cotIDFF.size() > 0) {
                    it = cotIDFF.iterator();
                    while (it.hasNext()) {
                        sb.append("      ").append((String)it.next()).append("\n");
                    }
                } else {
                    sb.append("none\n");
                }
                sb.append("    WSFed members: ");
                if (cotWSFed != null && cotWSFed.size() > 0) {
                    it = cotWSFed.iterator();
                    while (it.hasNext()) {
                        sb.append("      ").append((String)it.next()).append("\n");
                    }
                    continue;
                }
                sb.append("none\n");
            }
            catch (COTException cx) {
                this.debug.error(classMethod + "COTException: " + cx.getMessage());
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.error(sb.toString());
        }
        return cotMap;
    }

    private Map getSAML2Entities(String realm, SAML2MetaManager saml2Mgr) {
        String classMethod = "ConfigFedMonitoring.getSAML2Entities:";
        Set s2Ents = null;
        HashMap s2entMap = new HashMap();
        try {
            s2Ents = saml2Mgr.getAllEntities(realm);
            List hosted = saml2Mgr.getAllHostedEntities(realm);
            Iterator it = s2Ents.iterator();
            while (it.hasNext()) {
                HashMap<String, String> wse = new HashMap<String, String>();
                String entId = (String)it.next();
                if (hosted != null && hosted.contains(entId)) {
                    wse.put("location", "hosted");
                } else {
                    wse.put("location", "remote");
                }
                wse.put("roles", this.listToString(this.getSAMLv2Roles(entId, realm)));
                s2entMap.put(entId, wse);
            }
        }
        catch (SAML2MetaException e) {
            this.debug.error(classMethod + "getting SAML2 entity providers for realm " + realm + ": " + e.getMessage());
        }
        return s2entMap;
    }

    private Map getWSFedEntities(String realm) {
        String classMethod = "ConfigFedMonitoring.getWSFedEntities:";
        Set wsEnts = null;
        HashMap wsentMap = new HashMap();
        try {
            wsEnts = WSFederationMetaManager.getAllEntities((String)realm);
            List hosted = WSFederationMetaManager.getAllHostedEntities((String)realm);
            Iterator it = wsEnts.iterator();
            while (it.hasNext()) {
                HashMap<String, String> wse = new HashMap<String, String>();
                String entId = (String)it.next();
                if (hosted != null && hosted.contains(entId)) {
                    wse.put("location", "hosted");
                } else {
                    wse.put("location", "remote");
                }
                wse.put("roles", this.listToString(this.getWSFedRoles(entId, realm)));
                wsentMap.put(entId, wse);
            }
        }
        catch (WSFederationMetaException e) {
            this.debug.error(classMethod + "getting WSFed entities for realm " + realm + ": " + e.getMessage());
        }
        return wsentMap;
    }

    private Map getIDFFEntities(String realm, IDFFMetaManager idffMgr) {
        String classMethod = "ConfigFedMonitoring.getIDFFEntities:";
        Set idffEnts = null;
        HashMap idffentMap = new HashMap();
        try {
            idffEnts = idffMgr.getAllEntities(realm);
            List hosted = idffMgr.getAllHostedEntities(realm);
            Iterator it = idffEnts.iterator();
            while (it.hasNext()) {
                HashMap<String, String> wse = new HashMap<String, String>();
                String entId = (String)it.next();
                if (hosted != null && hosted.contains(entId)) {
                    wse.put("location", "hosted");
                } else {
                    wse.put("location", "remote");
                }
                wse.put("roles", this.listToString(this.getIDFFRoles(entId, realm)));
                idffentMap.put(entId, wse);
            }
        }
        catch (IDFFMetaException e) {
            this.debug.error(classMethod + "getting IDFF entity providers for realm " + realm + ": " + e.getMessage());
        }
        return idffentMap;
    }
}

