/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.workflow.CreateIDFFMetaDataTemplate;
import com.sun.identity.workflow.CreateSAML2HostedProviderTemplate;
import com.sun.identity.workflow.CreateWSFedMetaDataTemplate;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class CreateMetaDataTemplate
extends AuthenticatedCommand {
    private String entityID;
    private String metadata;
    private String extendedData;
    private String idpAlias;
    private String spAlias;
    private String attraAlias;
    private String attrqAlias;
    private String authnaAlias;
    private String pdpAlias;
    private String pepAlias;
    private String idpSCertAlias;
    private String idpECertAlias;
    private String attraSCertAlias;
    private String attraECertAlias;
    private String authnaSCertAlias;
    private String authnaECertAlias;
    private String pdpSCertAlias;
    private String pdpECertAlias;
    private String spSCertAlias;
    private String spECertAlias;
    private String attrqSCertAlias;
    private String attrqECertAlias;
    private String affiAlias;
    private String affiOwnerID;
    private List affiMembers;
    private String affiSCertAlias;
    private String affiECertAlias;
    private String pepSCertAlias;
    private String pepECertAlias;
    private String protocol;
    private String host;
    private String port;
    private String deploymentURI;
    private boolean isWebBased;

    public void handleRequest(RequestContext rc) throws CLIException {
        block5: {
            super.handleRequest(rc);
            this.ldapLogin();
            this.superAdminUserValidation();
            this.getOptions(rc);
            this.validateOptions();
            this.normalizeOptions();
            String spec = FederationManager.getIDFFSubCommandSpecification(rc);
            String[] params = new String[]{this.entityID, this.metadata, this.extendedData, this.idpAlias, this.spAlias, this.attraAlias, this.attrqAlias, this.authnaAlias, this.pdpAlias, this.pepAlias, this.affiAlias, spec};
            this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_METADATA_TEMPL", params);
            try {
                if (spec.equals("saml2")) {
                    this.handleSAML2Request(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_METADATA_TEMPL", params);
                    break block5;
                }
                if (spec.equals("idff")) {
                    this.handleIDFFRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_METADATA_TEMPL", params);
                    break block5;
                }
                if (spec.equals("wsfed")) {
                    this.handleWSFedRequest(rc);
                    this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_METADATA_TEMPL", params);
                    break block5;
                }
                throw new CLIException(this.getResourceString("unsupported-specification"), 127);
            }
            catch (CLIException e) {
                String[] args = new String[]{this.entityID, spec, e.getMessage()};
                this.writeLog(1, Level.INFO, "FAILED_CREATE_METADATA_TEMPL", args);
                throw e;
            }
        }
    }

    private void handleSAML2Request(RequestContext rc) throws CLIException {
        if (!this.isWebBased || this.extendedData != null) {
            this.buildConfigTemplate();
        }
        if (!this.isWebBased || this.metadata != null) {
            this.buildDescriptorTemplate();
        }
    }

    private void handleIDFFRequest(RequestContext rc) throws CLIException {
        if (!this.isWebBased || this.extendedData != null) {
            this.buildIDFFConfigTemplate();
        }
        if (!this.isWebBased || this.metadata != null) {
            this.buildIDFFDescriptorTemplate();
        }
    }

    private void handleWSFedRequest(RequestContext rc) throws CLIException {
        if (!this.isWebBased || this.extendedData != null) {
            this.buildWSFedConfigTemplate();
        }
        if (!this.isWebBased || this.metadata != null) {
            this.buildWSFedDescriptorTemplate();
        }
    }

    private void getOptions(RequestContext rc) {
        block5: {
            this.entityID = this.getStringOptionValue("entityid");
            this.idpAlias = this.getStringOptionValue("identityprovider");
            this.spAlias = this.getStringOptionValue("serviceprovider");
            this.attraAlias = this.getStringOptionValue("attrauthority");
            this.attrqAlias = this.getStringOptionValue("attrqueryprovider");
            this.authnaAlias = this.getStringOptionValue("authnauthority");
            this.pdpAlias = this.getStringOptionValue("xacmlpdp");
            this.pepAlias = this.getStringOptionValue("xacmlpep");
            this.affiAlias = this.getStringOptionValue("affiliation");
            this.affiOwnerID = this.getStringOptionValue("affiownerid");
            this.affiMembers = rc.getOption("affimembers");
            this.metadata = this.getStringOptionValue("meta-data-file");
            this.extendedData = this.getStringOptionValue("extended-data-file");
            this.idpSCertAlias = this.getStringOptionValue("idpscertalias");
            this.idpECertAlias = this.getStringOptionValue("idpecertalias");
            this.spSCertAlias = this.getStringOptionValue("spscertalias");
            this.spECertAlias = this.getStringOptionValue("specertalias");
            this.attraSCertAlias = this.getStringOptionValue("attrascertalias");
            this.attraECertAlias = this.getStringOptionValue("attraecertalias");
            this.attrqSCertAlias = this.getStringOptionValue("attrqscertalias");
            this.attrqECertAlias = this.getStringOptionValue("attrqecertalias");
            this.authnaSCertAlias = this.getStringOptionValue("authnascertalias");
            this.authnaECertAlias = this.getStringOptionValue("authnaecertalias");
            this.affiSCertAlias = this.getStringOptionValue("affiscertalias");
            this.affiECertAlias = this.getStringOptionValue("affiecertalias");
            this.pdpSCertAlias = this.getStringOptionValue("xacmlpdpscertalias");
            this.pdpECertAlias = this.getStringOptionValue("xacmlpdpecertalias");
            this.pepSCertAlias = this.getStringOptionValue("xacmlpepscertalias");
            this.pepECertAlias = this.getStringOptionValue("xacmlpepecertalias");
            String webURL = this.getCommandManager().getWebEnabledURL();
            boolean bl = this.isWebBased = webURL != null && webURL.trim().length() > 0;
            if (this.isWebBased) {
                try {
                    URL url = new URL(webURL);
                    this.protocol = url.getProtocol();
                    this.host = url.getHost();
                    int iPort = url.getPort();
                    this.port = iPort == -1 ? "" + url.getDefaultPort() : "" + iPort;
                    String uri = url.getPath();
                    int slash = uri.indexOf("/", 1);
                    if (slash == -1) {
                        this.deploymentURI = uri;
                        break block5;
                    }
                    this.deploymentURI = uri.substring(0, slash);
                }
                catch (MalformedURLException ex) {
                    this.protocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
                    this.host = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
                    this.port = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
                    this.deploymentURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
                }
            } else {
                this.protocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
                this.host = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
                this.port = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
                this.deploymentURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
            }
        }
    }

    private void normalizeOptions() {
        if (this.idpAlias != null && !this.idpAlias.startsWith("/")) {
            this.idpAlias = "/" + this.idpAlias;
        }
        if (this.spAlias != null && !this.spAlias.startsWith("/")) {
            this.spAlias = "/" + this.spAlias;
        }
        if (this.attraAlias != null && !this.attraAlias.startsWith("/")) {
            this.attraAlias = "/" + this.attraAlias;
        }
        if (this.attrqAlias != null && !this.attrqAlias.startsWith("/")) {
            this.attrqAlias = "/" + this.attrqAlias;
        }
        if (this.authnaAlias != null && !this.authnaAlias.startsWith("/")) {
            this.authnaAlias = "/" + this.authnaAlias;
        }
        if (this.pdpAlias != null && !this.pdpAlias.startsWith("/")) {
            this.pdpAlias = "/" + this.pdpAlias;
        }
        if (this.pepAlias != null && !this.pepAlias.startsWith("/")) {
            this.pepAlias = "/" + this.pepAlias;
        }
        if (this.entityID == null) {
            this.entityID = this.host;
        }
        if (this.idpSCertAlias == null) {
            this.idpSCertAlias = "";
        }
        if (this.idpECertAlias == null) {
            this.idpECertAlias = "";
        }
        if (this.spSCertAlias == null) {
            this.spSCertAlias = "";
        }
        if (this.spECertAlias == null) {
            this.spECertAlias = "";
        }
        if (this.attraSCertAlias == null) {
            this.attraSCertAlias = "";
        }
        if (this.attraECertAlias == null) {
            this.attraECertAlias = "";
        }
        if (this.attrqSCertAlias == null) {
            this.attrqSCertAlias = "";
        }
        if (this.attrqECertAlias == null) {
            this.attrqECertAlias = "";
        }
        if (this.authnaSCertAlias == null) {
            this.authnaSCertAlias = "";
        }
        if (this.authnaECertAlias == null) {
            this.authnaECertAlias = "";
        }
        if (this.affiSCertAlias == null) {
            this.affiSCertAlias = "";
        }
        if (this.affiECertAlias == null) {
            this.affiECertAlias = "";
        }
        if (this.pdpSCertAlias == null) {
            this.pdpSCertAlias = "";
        }
        if (this.pdpECertAlias == null) {
            this.pdpECertAlias = "";
        }
        if (this.pepSCertAlias == null) {
            this.pepSCertAlias = "";
        }
        if (this.pepECertAlias == null) {
            this.pepECertAlias = "";
        }
    }

    private void validateOptions() throws CLIException {
        if (this.idpAlias == null && this.spAlias == null && this.pdpAlias == null && this.pepAlias == null && this.attraAlias == null && this.attrqAlias == null && this.authnaAlias == null && this.affiAlias == null) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-role-null"), 127);
        }
        if (this.affiAlias != null && (this.idpAlias != null || this.spAlias != null || this.pdpAlias != null || this.pepAlias != null || this.attraAlias != null || this.attrqAlias != null || this.authnaAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-affi-conflict"), 127);
        }
        if (this.affiAlias != null && (this.affiMembers == null || this.affiMembers.isEmpty())) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-affi-members-empty"), 127);
        }
        if (this.affiAlias != null && this.affiOwnerID == null) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-affi-ownerid-empty"), 127);
        }
        if (this.affiAlias == null && (this.affiSCertAlias != null || this.affiECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-affi-null-with-cert-alias"), 127);
        }
        if (this.idpAlias == null && (this.idpSCertAlias != null || this.idpECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-idp-null-with-cert-alias"), 127);
        }
        if (this.spAlias == null && (this.spSCertAlias != null || this.spECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-sp-null-with-cert-alias"), 127);
        }
        if (this.attraAlias == null && (this.attraSCertAlias != null || this.attraECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-attra-null-with-cert-alias"), 127);
        }
        if (this.attrqAlias == null && (this.attrqSCertAlias != null || this.attrqECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-attrq-null-with-cert-alias"), 127);
        }
        if (this.authnaAlias == null && (this.authnaSCertAlias != null || this.authnaECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-authna-null-with-cert-alias"), 127);
        }
        if (this.pdpAlias == null && (this.pdpSCertAlias != null || this.pdpECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-pdp-null-with-cert-alias"), 127);
        }
        if (this.pepAlias == null && (this.pepSCertAlias != null || this.pepECertAlias != null)) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-pep-null-with-cert-alias"), 127);
        }
        if (this.protocol == null) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-protocol-not-found"), 127);
        }
        if (this.host == null) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-host-not-found"), 127);
        }
        if (this.port == null) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-port-not-found"), 127);
        }
        if (this.deploymentURI == null) {
            throw new CLIException(this.getResourceString("create-meta-template-exception-deploymentURI-not-found"), 127);
        }
    }

    private void buildDescriptorTemplate() throws CLIException {
        Writer pw = null;
        try {
            boolean writeToFile = !this.isWebBased && this.metadata != null && this.metadata.length() > 0;
            pw = writeToFile ? new PrintWriter(new FileWriter(this.metadata)) : new StringWriter();
            String xml = CreateSAML2HostedProviderTemplate.buildMetaDataTemplate(this.entityID, this.getWorkflowParamMap(), this.protocol + "://" + this.host + ":" + this.port + this.deploymentURI);
            pw.write(xml);
            if (writeToFile) {
                Object[] objs = new Object[]{this.metadata};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-meta-template-created-descriptor-template"), objs));
            }
        }
        catch (SAML2MetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            Object[] objs = new Object[]{this.metadata};
            throw new CLIException(MessageFormat.format(this.getResourceString("cannot-write-to-file"), objs), 127);
        }
        finally {
            if (pw != null && pw instanceof PrintWriter) {
                ((PrintWriter)pw).close();
            } else {
                this.getOutputWriter().printlnMessage(((StringWriter)pw).toString());
            }
        }
    }

    private static String buildMetaAliasInURI(String alias) {
        return "/metaAlias" + alias;
    }

    private void buildConfigTemplate() throws CLIException {
        Writer pw = null;
        try {
            boolean writeToFile = !this.isWebBased && this.extendedData != null && this.extendedData.length() > 0;
            pw = writeToFile ? new PrintWriter(new FileWriter(this.extendedData)) : new StringWriter();
            String xml = CreateSAML2HostedProviderTemplate.createExtendedDataTemplate(this.entityID, this.getWorkflowParamMap(), this.protocol + "://" + this.host + ":" + this.port + this.deploymentURI);
            pw.write(xml);
            if (writeToFile) {
                Object[] objs = new Object[]{this.extendedData};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-meta-template-created-configuration-template"), objs));
            }
        }
        catch (IOException ex) {
            Object[] objs = new Object[]{this.extendedData};
            throw new CLIException(MessageFormat.format(this.getResourceString("cannot-write-to-file"), objs), 127);
        }
        finally {
            if (pw != null && pw instanceof PrintWriter) {
                ((PrintWriter)pw).close();
            } else {
                this.getOutputWriter().printlnMessage(((StringWriter)pw).toString());
            }
        }
    }

    private void buildIDFFConfigTemplate() throws CLIException {
        Writer pw = null;
        try {
            boolean writeToFile = !this.isWebBased && this.extendedData != null && this.extendedData.length() > 0;
            pw = writeToFile ? new PrintWriter(new FileWriter(this.extendedData)) : new StringWriter();
            String xml = CreateIDFFMetaDataTemplate.createExtendedMetaTemplate(this.entityID, this.getWorkflowParamMap());
            pw.write(xml);
            if (writeToFile) {
                Object[] objs = new Object[]{this.extendedData};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-meta-template-created-configuration-template"), objs));
            }
        }
        catch (IOException ex) {
            Object[] objs = new Object[]{this.extendedData};
            throw new CLIException(MessageFormat.format(this.getResourceString("cannot-write-to-file"), objs), 127);
        }
        finally {
            if (pw != null && pw instanceof PrintWriter) {
                ((PrintWriter)pw).close();
            } else {
                this.getOutputWriter().printlnMessage(((StringWriter)pw).toString());
            }
        }
    }

    private void buildIDFFDescriptorTemplate() throws CLIException {
        Writer pw = null;
        try {
            boolean writeToFile = !this.isWebBased && this.metadata != null && this.metadata.length() > 0;
            pw = writeToFile ? new PrintWriter(new FileWriter(this.metadata)) : new StringWriter();
            String xml = CreateIDFFMetaDataTemplate.createStandardMetaTemplate(this.entityID, this.getWorkflowParamMap(), this.protocol + "://" + this.host + ":" + this.port + this.deploymentURI);
            pw.write(xml);
            if (writeToFile) {
                Object[] objs = new Object[]{this.metadata};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-meta-template-created-descriptor-template"), objs));
            }
        }
        catch (IDFFMetaException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        catch (IOException e) {
            Object[] objs = new Object[]{this.metadata};
            throw new CLIException(MessageFormat.format(this.getResourceString("cannot-write-to-file"), objs), 127);
        }
        finally {
            if (pw != null && pw instanceof PrintWriter) {
                ((PrintWriter)pw).close();
            } else {
                this.getOutputWriter().printlnMessage(((StringWriter)pw).toString());
            }
        }
    }

    private void buildWSFedDescriptorTemplate() throws CLIException {
        Writer pw = null;
        try {
            boolean writeToFile = !this.isWebBased && this.metadata != null && this.metadata.length() > 0;
            pw = writeToFile ? new PrintWriter(new FileWriter(this.metadata)) : new StringWriter();
            String xml = CreateWSFedMetaDataTemplate.createStandardMetaTemplate(this.entityID, this.getWorkflowParamMap(), this.protocol + "://" + this.host + ":" + this.port + this.deploymentURI);
            pw.write(xml);
            if (writeToFile) {
                Object[] objs = new Object[]{this.metadata};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-meta-template-created-descriptor-template"), objs));
            }
        }
        catch (IOException e) {
            Object[] objs = new Object[]{this.metadata};
            throw new CLIException(MessageFormat.format(this.getResourceString("cannot-write-to-file"), objs), 127);
        }
        catch (JAXBException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        catch (CertificateEncodingException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (pw != null && pw instanceof PrintWriter) {
                ((PrintWriter)pw).close();
            } else {
                this.getOutputWriter().printlnMessage(((StringWriter)pw).toString());
            }
        }
    }

    private void buildWSFedConfigTemplate() throws CLIException {
        Writer pw = null;
        try {
            boolean writeToFile = !this.isWebBased && this.extendedData != null && this.extendedData.length() > 0;
            pw = writeToFile ? new PrintWriter(new FileWriter(this.extendedData)) : new StringWriter();
            String xml = CreateWSFedMetaDataTemplate.createExtendedMetaTemplate(this.entityID, this.getWorkflowParamMap());
            pw.write(xml);
            if (writeToFile) {
                Object[] objs = new Object[]{this.extendedData};
                this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("create-meta-template-created-configuration-template"), objs));
            }
        }
        catch (IOException ex) {
            Object[] objs = new Object[]{this.extendedData};
            throw new CLIException(MessageFormat.format(this.getResourceString("cannot-write-to-file"), objs), 127);
        }
        catch (JAXBException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (pw != null && pw instanceof PrintWriter) {
                ((PrintWriter)pw).close();
            } else {
                this.getOutputWriter().printlnMessage(((StringWriter)pw).toString());
            }
        }
    }

    private Map getWorkflowParamMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("idp", this.idpAlias);
        map.put("sp", this.spAlias);
        map.put("attra", this.attraAlias);
        map.put("attrq", this.attrqAlias);
        map.put("authna", this.authnaAlias);
        map.put("affiliation", this.affiAlias);
        map.put("affiOwnerID", this.affiOwnerID);
        map.put("affimembers", this.affiMembers);
        map.put("pdp", this.pdpAlias);
        map.put("pep", this.pepAlias);
        map.put("idpecert", this.idpECertAlias);
        map.put("idpscert", this.idpSCertAlias);
        map.put("specert", this.spECertAlias);
        map.put("spscert", this.spSCertAlias);
        map.put("attraecert", this.attraECertAlias);
        map.put("attrascert", this.attraSCertAlias);
        map.put("attrqecert", this.attrqECertAlias);
        map.put("attrqscert", this.attrqSCertAlias);
        map.put("authnaecert", this.authnaECertAlias);
        map.put("authnascert", this.authnaSCertAlias);
        map.put("affiecert", this.affiECertAlias);
        map.put("affiscert", this.affiSCertAlias);
        map.put("pdpecert", this.pdpECertAlias);
        map.put("pdpscert", this.pdpSCertAlias);
        map.put("pepecert", this.pepECertAlias);
        map.put("pepscert", this.pepSCertAlias);
        return map;
    }
}

