/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider.plugins;

import com.iplanet.sso.SSOToken;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.PasswordCredential;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AM71AgentProvider
extends ProviderConfig {
    private static final String AGENT_CONFIG_ATTR = "sunIdentityServerDeviceKeyValue";
    private static final String NAME = "Name";
    private static final String TYPE = "Type";
    private static final String SEC_MECH = "SecurityMech";
    private static final String WSP_ENDPOINT = "WSPEndpoint";
    private static final String KS_FILE = "KeyStoreFile";
    private static final String KS_PASSWD = "KeyStorePassword";
    private static final String KEY_PASSWD = "KeyPassword";
    private static final String RESPONSE_SIGN = "isResponseSign";
    private static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    private static final String REQUEST_SIGN = "isRequestSign";
    private static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    private static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    private static final String KEY_ALIAS = "keyAlias";
    private static final String TRUST_AUTHORITY = "TrustAuthority";
    private static final String PROPERTY = "Property:";
    private static final String USER_NAME = "UserName";
    private static final String USER_PASSWORD = "UserPassword";
    private static final String USER_CREDENTIAL = "UserCredential";
    private static final String SERVICE_TYPE = "ServiceType";
    private static final String USE_DEFAULT_KEYSTORE = "useDefaultStore";
    private static final String FORCE_AUTHENTICATION = "forceUserAuthn";
    private static final String KEEP_SECURITY_HEADERS = "keepSecurityHeaders";
    private static final String AUTHENTICATION_CHAIN = "authenticationChain";
    private AMIdentityRepository idRepo;
    private static Set agentConfigAttribute;
    private static Debug debug;
    private SSOToken token;
    private boolean profilePresent;

    public void init(String providerName, String providerType, SSOToken token, boolean isEndpoint) throws ProviderException {
        this.providerName = providerName;
        this.providerType = providerType;
        this.token = token;
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(token, "/");
            }
            if (agentConfigAttribute == null) {
                agentConfigAttribute = new HashSet();
                agentConfigAttribute.add(AGENT_CONFIG_ATTR);
            }
            IdSearchControl control = new IdSearchControl();
            control.setReturnAttributes(agentConfigAttribute);
            IdSearchResults results = this.idRepo.searchIdentities(IdType.AGENT, providerName + providerType, control);
            Set agents = results.getSearchResults();
            if (!agents.isEmpty()) {
                Set attributeValues;
                Map attrs = results.getResultAttributes();
                AMIdentity provider = (AMIdentity)agents.iterator().next();
                this.profilePresent = true;
                Map attributes = (Map)attrs.get(provider);
                if (debug.messageEnabled()) {
                    debug.message("Attributes: " + attributes);
                }
                if ((attributeValues = (Set)attributes.get(AGENT_CONFIG_ATTR.toLowerCase())) != null) {
                    this.parseAgentKeyValues(attributeValues);
                }
            }
        }
        catch (Exception e) {
            debug.error("AgentProvider.init: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private void parseAgentKeyValues(Set keyValues) throws ProviderException {
        if (keyValues == null || keyValues.isEmpty()) {
            return;
        }
        for (String entry : keyValues) {
            int index = entry.indexOf("=");
            if (index == -1) continue;
            this.setConfig(entry.substring(0, index), entry.substring(index + 1, entry.length()));
        }
    }

    private void setConfig(String attr, String value) {
        debug.message("Attribute name: " + attr + "Value: " + value);
        this.encryptionAlgorithm = "AES";
        this.encryptionStrength = 128;
        if (attr.equals(NAME)) {
            this.providerName = value;
        } else if (attr.equals(TYPE)) {
            this.providerType = value;
        } else if (attr.equals(SEC_MECH)) {
            if (this.secMech == null) {
                this.secMech = new ArrayList();
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                this.secMech.add(st.nextToken());
            }
        } else if (attr.equals(WSP_ENDPOINT)) {
            this.wspEndpoint = value;
        } else if (attr.equals(KS_FILE)) {
            this.ksFile = value;
        } else if (attr.equals(KS_PASSWD)) {
            this.ksPasswd = value;
        } else if (attr.equals(KEY_PASSWD)) {
            this.keyPasswd = value;
        } else if (attr.equals(RESPONSE_SIGN)) {
            this.isResponseSigned = Boolean.valueOf(value);
        } else if (attr.equals(RESPONSE_ENCRYPT)) {
            this.isResponseEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_SIGN)) {
            this.isRequestSigned = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_ENCRYPT)) {
            this.isRequestEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_HEADER_ENCRYPT)) {
            this.isRequestHeaderEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(KEY_ALIAS)) {
            this.privateKeyAlias = value;
        } else if (attr.equals(SERVICE_TYPE)) {
            this.serviceType = value;
        } else if (attr.equals(USE_DEFAULT_KEYSTORE)) {
            this.isDefaultKeyStore = Boolean.valueOf(value);
        } else if (attr.equals(TRUST_AUTHORITY)) {
            try {
                TrustAuthorityConfig ta;
                if (this.trustAuthorities == null) {
                    this.trustAuthorities = new ArrayList();
                }
                if ((ta = TrustAuthorityConfig.getConfig(value, "DiscoveryAgent")) != null) {
                    this.trustAuthorities.add(ta);
                }
            }
            catch (ProviderException pe) {
                ProviderUtils.debug.error("AM71AgentProvider.setAttribute:error", (Throwable)pe);
            }
        } else if (attr.startsWith(PROPERTY)) {
            this.properties.put(attr.substring(PROPERTY.length()), value);
        } else if (attr.equals(USER_CREDENTIAL)) {
            StringTokenizer st1;
            int index = value.indexOf("|");
            if (index == -1) {
                return;
            }
            String usertmp = value.substring(0, index);
            String passwordtmp = value.substring(index + 1, value.length());
            String user = null;
            String password = null;
            StringTokenizer st = new StringTokenizer(usertmp, ":");
            if (USER_NAME.equals(st.nextToken()) && st.hasMoreTokens()) {
                user = st.nextToken();
            }
            if (USER_PASSWORD.equals((st1 = new StringTokenizer(passwordtmp, ":")).nextToken()) && st1.hasMoreTokens()) {
                password = st1.nextToken();
            }
            if (user != null && password != null) {
                PasswordCredential credential = new PasswordCredential(user, password);
                if (this.usercredentials == null) {
                    this.usercredentials = new ArrayList();
                }
                this.usercredentials.add(credential);
            }
        } else if (attr.equals(FORCE_AUTHENTICATION)) {
            this.forceAuthn = Boolean.valueOf(value);
        } else if (attr.equals(KEEP_SECURITY_HEADERS)) {
            this.preserveSecHeaders = Boolean.valueOf(value);
        } else if (attr.equals(AUTHENTICATION_CHAIN)) {
            this.authenticationChain = value;
        } else if (ProviderUtils.debug.messageEnabled()) {
            ProviderUtils.debug.message("AM71AgentProvider.setConfig: Invalid Attribute configured." + attr);
        }
        this.publicKeyAlias = this.privateKeyAlias;
        if (this.publicKeyAlias == null) {
            this.publicKeyAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.encryptionkey");
            if (this.publicKeyAlias == null) {
                this.publicKeyAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Encryption Stength: " + this.encryptionStrength);
            debug.message("Encryption Algorithm: " + this.encryptionAlgorithm);
            debug.message("public key alias: " + this.publicKeyAlias);
        }
    }

    public void store() throws ProviderException {
        HashSet<String> set = new HashSet<String>();
        if (this.providerType != null) {
            set.add(this.getKeyValue(TYPE, this.providerType));
        }
        if (this.wspEndpoint != null) {
            set.add(this.getKeyValue(WSP_ENDPOINT, this.wspEndpoint));
        }
        if (this.ksFile != null) {
            set.add(this.getKeyValue(KS_FILE, this.ksFile));
        }
        if (this.ksPasswd != null) {
            set.add(this.getKeyValue(KS_PASSWD, this.ksPasswd));
        }
        if (this.keyPasswd != null) {
            set.add(this.getKeyValue(KEY_PASSWD, this.keyPasswd));
        }
        if (this.serviceType != null) {
            set.add(this.getKeyValue(SERVICE_TYPE, this.serviceType));
        }
        if (this.secMech != null) {
            Iterator iter = this.secMech.iterator();
            StringBuffer sb = new StringBuffer(100);
            while (iter.hasNext()) {
                sb.append((String)iter.next()).append(",");
            }
            sb = sb.deleteCharAt(sb.length() - 1);
            set.add(this.getKeyValue(SEC_MECH, sb.toString()));
        }
        set.add(this.getKeyValue(RESPONSE_SIGN, Boolean.toString(this.isResponseSigned)));
        set.add(this.getKeyValue(RESPONSE_ENCRYPT, Boolean.toString(this.isResponseEncrypted)));
        set.add(this.getKeyValue(REQUEST_SIGN, Boolean.toString(this.isRequestSigned)));
        set.add(this.getKeyValue(REQUEST_ENCRYPT, Boolean.toString(this.isRequestEncrypted)));
        set.add(this.getKeyValue(REQUEST_HEADER_ENCRYPT, Boolean.toString(this.isRequestHeaderEncrypted)));
        set.add(this.getKeyValue(USE_DEFAULT_KEYSTORE, Boolean.toString(this.isDefaultKeyStore)));
        set.add(this.getKeyValue(FORCE_AUTHENTICATION, Boolean.toString(this.forceAuthn)));
        set.add(this.getKeyValue(KEEP_SECURITY_HEADERS, Boolean.toString(this.preserveSecHeaders)));
        if (this.authenticationChain != null) {
            set.add(this.getKeyValue(AUTHENTICATION_CHAIN, this.authenticationChain));
        }
        if (this.privateKeyAlias != null) {
            set.add(this.getKeyValue(KEY_ALIAS, this.privateKeyAlias));
        }
        Enumeration<?> props = this.properties.propertyNames();
        while (props.hasMoreElements()) {
            String propertyName = (String)props.nextElement();
            String propertyValue = this.properties.getProperty(propertyName);
            set.add(this.getKeyValue(PROPERTY + propertyName, propertyValue));
        }
        if (this.usercredentials != null) {
            for (PasswordCredential cred : this.usercredentials) {
                String user = cred.getUserName();
                String password = cred.getPassword();
                if (user == null || password == null) continue;
                StringBuffer sb = new StringBuffer(100);
                sb.append(USER_NAME).append(":").append(user).append("|").append(USER_PASSWORD).append(":").append(password);
                set.add(this.getKeyValue(USER_CREDENTIAL, sb.toString()));
            }
        }
        if (this.trustAuthorities != null && !this.trustAuthorities.isEmpty()) {
            for (TrustAuthorityConfig taConfig : this.trustAuthorities) {
                set.add(this.getKeyValue(TRUST_AUTHORITY, taConfig.getName()));
            }
        }
        try {
            HashMap<String, HashSet<String>> attributes = new HashMap<String, HashSet<String>>();
            attributes.put(AGENT_CONFIG_ATTR, set);
            if (this.profilePresent) {
                AMIdentity id = new AMIdentity(this.token, this.providerName + this.providerType, IdType.AGENT, "/", null);
                debug.message("Attributes to be stored: " + attributes);
                id.setAttributes(attributes);
                id.store();
            } else {
                if (this.idRepo == null) {
                    this.idRepo = new AMIdentityRepository(this.token, "/");
                }
                this.idRepo.createIdentity(IdType.AGENT, this.providerName + this.providerType, attributes);
            }
        }
        catch (Exception e) {
            debug.error("AgentProvider.store: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    public void delete() throws ProviderException {
        if (!this.profilePresent) {
            return;
        }
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(this.token, "/");
            }
            AMIdentity id = new AMIdentity(this.token, this.providerName + this.providerType, IdType.AGENT, "/", null);
            HashSet<AMIdentity> identities = new HashSet<AMIdentity>();
            identities.add(id);
            this.idRepo.deleteIdentities(identities);
        }
        catch (Exception e) {
            debug.error("AM71AgentProvider.delete: Unable to get idRepo", (Throwable)e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private String getKeyValue(String key, String value) {
        return key + "=" + value;
    }

    public boolean isExists() {
        return this.profilePresent;
    }

    static {
        debug = ProviderUtils.debug;
    }
}

