/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ThreadPoolException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadPool {
    private int poolSize;
    private String poolName;
    private List<Runnable> taskList;
    private WorkerThread[] threads;
    private Lock lock = new ReentrantLock();
    private Condition hasTasks = this.lock.newCondition();

    public ThreadPool(String name, int poolSize) {
        this.poolSize = poolSize;
        this.poolName = name;
        this.taskList = new LinkedList<Runnable>();
        this.threads = new WorkerThread[poolSize];
        this.createThreads();
    }

    private synchronized void createThreads() {
        for (int i = 0; i < this.poolSize; ++i) {
            WorkerThread t = new WorkerThread(this.poolName, this);
            t.setDaemon(true);
            t.start();
            this.threads[i] = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(Runnable task) throws ThreadPoolException {
        try {
            this.lock.lock();
            this.taskList.add(task);
            this.hasTasks.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class WorkerThread
    extends Thread {
        private ThreadPool pool;

        public WorkerThread(String name, ThreadPool pool) {
            this.setName(name);
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Runnable task = null;
                try {
                    this.pool.lock.lock();
                    if (!this.pool.taskList.isEmpty()) {
                        task = (Runnable)ThreadPool.this.taskList.remove(0);
                    } else {
                        this.pool.hasTasks.await();
                    }
                }
                catch (InterruptedException ex) {
                    PrivilegeManager.debug.error("WorkerThread.run", (Throwable)ex);
                }
                finally {
                    this.pool.lock.unlock();
                }
                if (task == null) continue;
                task.run();
            }
        }
    }
}

