/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;

public class OpenSSOConfigurator {
    private static final String OPENSSO_CONFIGURATOR_PROPERTIES = "OpenSSOConfigurator";
    private static final String SERVER_URL = "SERVER_URL";
    static final String DEPLOYMENT_URI = "DEPLOYMENT_URI";
    private static final String ADMIN_PWD = "ADMIN_PWD";
    private static final String ADMIN_CONFIRM_PWD = "ADMIN_CONFIRM_PWD";
    private static final String USERSTORE_TYPE = "USERSTORE_TYPE";
    private static final String AMLDAPUSERPASSWD = "AMLDAPUSERPASSWD";
    private static final String AMLDAPUSERPASSWD_CONFIRM = "AMLDAPUSERPASSWD_CONFIRM";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ResourceBundle rb = ResourceBundle.getBundle(OPENSSO_CONFIGURATOR_PROPERTIES);
        if (args.length != 2 || !args[0].equals("--file") && !args[0].equals("-f")) {
            System.out.println(rb.getString("usage"));
            System.exit(-1);
        }
        String configFile = args[1];
        Properties config = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile);
            config.load(fis);
        }
        catch (IOException ex) {
            System.out.println(rb.getString("errorConfig"));
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {}
            }
        }
        String serverURL = null;
        String deploymentURI = null;
        String userStoreType = null;
        StringBuffer postBodySB = new StringBuffer();
        Enumeration<Object> e = config.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)config.get(key);
            if (val == null || (val = val.trim()).length() <= 0) continue;
            if (key.equals(DEPLOYMENT_URI)) {
                deploymentURI = val;
            } else {
                if (key.equals(SERVER_URL)) {
                    serverURL = val;
                }
                if (postBodySB.length() > 0) {
                    postBodySB.append("&");
                }
                String encodedVal = null;
                try {
                    encodedVal = URLEncoder.encode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ueex) {
                    encodedVal = val;
                }
                postBodySB.append(key).append("=").append(encodedVal);
                if (key.equals(ADMIN_PWD)) {
                    postBodySB.append("&").append(ADMIN_CONFIRM_PWD).append("=").append(encodedVal);
                } else if (key.equals(AMLDAPUSERPASSWD)) {
                    postBodySB.append("&").append(AMLDAPUSERPASSWD_CONFIRM).append("=").append(encodedVal);
                }
            }
            if (!key.equals(USERSTORE_TYPE)) continue;
            userStoreType = val;
        }
        if (serverURL == null) {
            System.out.println(rb.getString("errorServerURL"));
            System.exit(-1);
        }
        if (deploymentURI == null) {
            System.out.println(rb.getString("errorDeploymentURI"));
            System.exit(-1);
        }
        if (!deploymentURI.startsWith("/")) {
            deploymentURI = "/" + deploymentURI;
        }
        if (serverURL.endsWith("/")) {
            serverURL = serverURL.substring(0, serverURL.length() - 1);
        }
        String openssoURL = serverURL + deploymentURI;
        ReadProgress rp = new ReadProgress(openssoURL);
        Thread t = new Thread(rp);
        t.start();
        FilterOutputStream os = null;
        BufferedReader br = null;
        try {
            URL url = new URL(openssoURL + "/config/configurator");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Length", Integer.toString(postBodySB.length()));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.connect();
            os = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)os).writeBytes(postBodySB.toString());
            ((DataOutputStream)os).flush();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String str = null;
                while ((str = br.readLine()) != null) {
                    System.out.println(str);
                }
            } else {
                System.out.println(rb.getString("configFailed"));
                if (userStoreType != null && userStoreType.equals("LDAPv3ForADDC")) {
                    System.out.println(rb.getString("cannot.connect.to.UM.datastore"));
                }
            }
            conn.disconnect();
        }
        catch (ProtocolException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        System.exit(0);
    }

    static class ReadProgress
    implements Runnable {
        String openssoURL = null;

        public ReadProgress(String openssoURL) {
            this.openssoURL = openssoURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int retry = 0;
            while (retry <= 1) {
                ++retry;
                BufferedReader br = null;
                try {
                    URL url = new URL(this.openssoURL + "/setup/setSetupProgress?mode=text");
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setInstanceFollowRedirects(false);
                    conn.connect();
                    int responseCode = conn.getResponseCode();
                    if (responseCode == 200) {
                        br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            System.out.println(line);
                        }
                    } else {
                        if (responseCode == 302) continue;
                        System.out.println(conn.getResponseMessage());
                    }
                    conn.disconnect();
                    break;
                }
                catch (ProtocolException ex) {
                    ex.printStackTrace();
                    break;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    break;
                }
                finally {
                    if (br == null) continue;
                    try {
                        br.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }
}

