/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroupImpl;
import com.iplanet.am.sdk.AMDynamicGroupImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroupImpl;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.SearchControl;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AMGroupImpl
extends AMObjectImpl
implements AMGroup {
    public AMGroupImpl(SSOToken ssoToken, String DN2, int profileType) {
        super(ssoToken, DN2, profileType);
    }

    public long getNumberOfUsers() throws AMException, SSOException {
        return this.getUserDNs().size();
    }

    public Set getUserDNs() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Set members = this.dsServices.getMembers(this.token, this.entryDN, this.profileType);
        HashSet<String> users = new HashSet<String>();
        for (String curr : members) {
            try {
                if (this.dsServices.getObjectType(this.token, curr) != 1) continue;
                users.add(curr);
            }
            catch (AMException ame) {
                if (!debug.messageEnabled()) continue;
                debug.message("AMGroupImpl.getUserDNs: Unable to identify  the type of object: " + curr);
            }
        }
        return users;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set searchUsers(String wildcard) throws AMException, SSOException {
        if (wildcard == null) throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        if (wildcard.length() == 0) {
            throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        }
        Set usersSet = this.getUserDNs();
        if (wildcard.length() == 1) {
            if (!wildcard.equals("*")) throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
            return usersSet;
        }
        Set<String> resultSet = new HashSet();
        if (wildcard.startsWith("*")) {
            String pattern = wildcard.substring(1);
            if (pattern.indexOf(42) != -1) {
                throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
            }
            Iterator iter = usersSet.iterator();
            while (iter.hasNext()) {
                DN userDN = new DN((String)iter.next());
                RDN userRDN = (RDN)userDN.getRDNs().firstElement();
                String userName = userRDN.getValues()[0];
                if (!userName.endsWith(pattern)) continue;
                resultSet.add(userDN.toString());
            }
            return resultSet;
        }
        if (!wildcard.endsWith("*")) throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        String pattern = wildcard.substring(0, wildcard.length() - 1);
        if (pattern.indexOf(42) != -1) {
            throw new AMException(AMSDKBundle.getString("122", this.locale), "122");
        }
        Iterator iter = usersSet.iterator();
        while (iter.hasNext()) {
            DN userDN = new DN((String)iter.next());
            RDN userRDN = (RDN)userDN.getRDNs().firstElement();
            String userName = userRDN.getValues()[0];
            if (!userName.startsWith(pattern)) continue;
            resultSet.add(userDN.toString());
        }
        return resultSet;
    }

    public AMSearchResults searchUsers(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String gfilter;
        String base;
        int scope;
        if (this.profileType == 11 || this.profileType == 12) {
            String[] array = this.dsServices.getGroupFilterAndScope(this.token, this.entryDN, this.profileType);
            scope = Integer.parseInt(array[0]);
            base = array[1];
            gfilter = array[2];
        } else {
            scope = 2;
            base = this.getOrganizationDN();
            gfilter = "(iplanet-am-static-group-dn=" + this.entryDN + ")";
        }
        String userFilter = "(&" + gfilter + "(" + AMNamingAttrManager.getNamingAttr(1) + "=" + wildcard + ")" + this.getSearchFilter(1) + ")";
        String filter = null;
        if (avPairs == null) {
            filter = userFilter;
        } else if (avPairs.size() == 0) {
            filter = userFilter;
        } else {
            StringBuffer filterSB = new StringBuffer();
            filterSB.append("(&").append(userFilter).append("(|");
            for (String attributeName : avPairs.keySet()) {
                for (String attributeValue : (Set)avPairs.get(attributeName)) {
                    filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
                }
            }
            filterSB.append("))");
            filter = filterSB.toString();
        }
        searchControl.setSearchScope(scope);
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, base, filter, sc, returnAttrs);
    }

    public AMSearchResults searchUsers(AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        String gfilter;
        String base;
        int scope;
        if (this.profileType == 11 || this.profileType == 12) {
            String[] array = this.dsServices.getGroupFilterAndScope(this.token, this.entryDN, this.profileType);
            scope = Integer.parseInt(array[0]);
            base = array[1];
            gfilter = array[2];
        } else {
            scope = 2;
            base = this.getOrganizationDN();
            gfilter = "(iplanet-am-static-group-dn=" + this.entryDN + ")";
        }
        String filter = "(&" + gfilter + this.getSearchFilter(1) + avfilter + ")";
        if (debug.messageEnabled()) {
            debug.message("AMGroupImpl.searchUsers: " + filter);
        }
        searchControl.setSearchScope(scope);
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, base, filter, sc, returnAttrs);
    }

    public Set createStaticGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMStaticGroupImpl> groups = new HashSet<AMStaticGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMStaticGroupImpl groupImpl = new AMStaticGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createStaticGroups(Map groupsMap) throws AMException, SSOException {
        Iterator iter = groupsMap.keySet().iterator();
        HashSet<AMStaticGroupImpl> groups = new HashSet<AMStaticGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)groupsMap.get(groupName);
            AMStaticGroupImpl groupImpl = new AMStaticGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createDynamicGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMDynamicGroupImpl> groups = new HashSet<AMDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMDynamicGroupImpl groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createDynamicGroups(Map groupsMap) throws AMException, SSOException {
        Iterator iter = groupsMap.keySet().iterator();
        HashSet<AMDynamicGroupImpl> groups = new HashSet<AMDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)groupsMap.get(groupName);
            AMDynamicGroupImpl groupImpl = new AMDynamicGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createAssignableDynamicGroups(Set groupNames) throws AMException, SSOException {
        Iterator iter = groupNames.iterator();
        HashSet<AMAssignableDynamicGroupImpl> groups = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + (String)iter.next() + "," + this.entryDN;
            AMAssignableDynamicGroupImpl groupImpl = new AMAssignableDynamicGroupImpl(this.token, groupDN);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set createAssignableDynamicGroups(Map groupsMap) throws AMException, SSOException {
        Iterator iter = groupsMap.keySet().iterator();
        HashSet<AMAssignableDynamicGroupImpl> groups = new HashSet<AMAssignableDynamicGroupImpl>();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            String groupDN = AMNamingAttrManager.getNamingAttr(9) + "=" + groupName + "," + this.entryDN;
            Map attributes = (Map)groupsMap.get(groupName);
            AMAssignableDynamicGroupImpl groupImpl = new AMAssignableDynamicGroupImpl(this.token, groupDN);
            groupImpl.setAttributes(attributes);
            groupImpl.create();
            groups.add(groupImpl);
        }
        return groups;
    }

    public Set getGroupDNs(int level) throws AMException, SSOException {
        return this.searchGroups("*", level);
    }

    public long getNumberOfGroups(int level) throws AMException, SSOException {
        return this.searchGroups("*", level).size();
    }

    public void deleteStaticGroups(Set groupDNs) throws AMException, SSOException {
        for (String groupDN : groupDNs) {
            AMStaticGroupImpl group = new AMStaticGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public void deleteDynamicGroups(Set groupDNs) throws AMException, SSOException {
        for (String groupDN : groupDNs) {
            AMDynamicGroupImpl group = new AMDynamicGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public void deleteAssignableDynamicGroups(Set groupDNs) throws AMException, SSOException {
        for (String groupDN : groupDNs) {
            AMAssignableDynamicGroupImpl group = new AMAssignableDynamicGroupImpl(this.token, groupDN);
            group.delete();
        }
    }

    public Set searchGroups(String wildcard, int level) throws AMException, SSOException {
        return this.searchGroups(wildcard, null, level);
    }

    public Set searchGroups(String wildcard, Map avPairs, int level) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, level);
    }

    public AMSearchResults searchGroups(String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String filter = "(|" + this.getSearchFilter(9) + this.getSearchFilter(11) + this.getSearchFilter(12) + ")";
        return this.searchObjects(AMNamingAttrManager.getNamingAttr(9), filter, wildcard, avPairs, searchControl);
    }

    public void addNestedGroups(Set groups) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        AMHashMap attrMap = new AMHashMap();
        attrMap.put("uniquemember", groups);
        try {
            this.dsServices.setAttributes(this.token, this.entryDN, this.profileType, attrMap, null, true);
        }
        catch (AMException am) {
            if (am.getErrorCode().equals("452")) {
                debug.error("AMGroupImpl.addNestedGroups: Unable to add groups: -> ", (Throwable)am);
                throw new AMException(AMSDKBundle.getString("771", this.locale), "771");
            }
            throw am;
        }
    }

    public Set getNestedGroupDNs() throws AMException, SSOException {
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add("uniquemember");
        Map attrMap = this.dsServices.getAttributes(this.token, this.entryDN, attrNames, this.profileType);
        Set members = (Set)attrMap.get("uniquemember");
        HashSet<String> groups = new HashSet<String>();
        for (String curr : members) {
            try {
                if (this.dsServices.getObjectType(this.token, curr) == 1) continue;
                groups.add(curr);
            }
            catch (AMException ame) {
                debug.error("AMGroupImpl.getNestedGroupDNs: Unable to identity the type of object: " + curr);
            }
        }
        return groups;
    }

    public void removeNestedGroups(Set groups) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add("uniquemember");
        Map attrMap = this.dsServices.getAttributes(this.token, this.entryDN, attrNames, false, false, this.profileType);
        Set attrVals = (Set)attrMap.get("uniquemember");
        attrVals.removeAll(groups);
        if (debug.messageEnabled()) {
            debug.message("AMGroupImpl.removeNestedGroups: Setting nested groups to: " + attrVals.toString());
        }
        attrMap.put("uniquemember", attrVals);
        try {
            this.dsServices.setAttributes(this.token, this.entryDN, this.profileType, attrMap, null, false);
        }
        catch (AMException am) {
            if (am.getErrorCode().equals("452")) {
                debug.error("AMGroupImpl.removeNestedGroups: Unable to remove groups: -> ", (Throwable)am);
                throw new AMException(AMSDKBundle.getString("772", this.locale), "772");
            }
            throw am;
        }
    }

    public Set getUserAndGroupDNs() throws AMException, SSOException {
        Set users = this.getUserDNs();
        Set groups = this.getNestedGroupDNs();
        groups.addAll(users);
        return groups;
    }
}

