/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.CDMBundle;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientTypesManager;
import java.util.Iterator;
import java.util.Map;

public class ClientsManager {
    protected static ClientTypesManager clientTypesManager = AMClientDetector.getClientTypesManagerInstance();

    public static Client getInstance(String clientType) throws ClientException {
        Client client;
        if (clientType == null) {
            throw new ClientException(CDMBundle.getString("null_clientType"));
        }
        Client client2 = client = clientTypesManager != null ? clientTypesManager.getClientInstance(clientType) : null;
        if (client == null) {
            throw new ClientException(CDMBundle.getString("unknown_clientType") + ", " + clientType);
        }
        return client;
    }

    public static Client getDefaultInstance() {
        String def = clientTypesManager != null ? clientTypesManager.getDefaultClientType() : "genericHTML";
        Client client = clientTypesManager != null ? clientTypesManager.getClientInstance(def) : null;
        return client;
    }

    public static Iterator getAllInstances() {
        Map allInstances;
        Map map = allInstances = clientTypesManager != null ? clientTypesManager.getAllClientInstances() : null;
        if (allInstances != null) {
            return allInstances.values().iterator();
        }
        return null;
    }
}

