/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.ldap.event.EventServicePolling;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.services.ldap.event.Request;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPControl;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPInterruptedException;
import com.sun.identity.shared.ldap.LDAPMessage;
import com.sun.identity.shared.ldap.LDAPResponse;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchListener;
import com.sun.identity.shared.ldap.LDAPSearchResult;
import com.sun.identity.shared.ldap.LDAPSearchResultReference;
import com.sun.identity.shared.ldap.controls.LDAPEntryChangeControl;
import com.sun.identity.shared.ldap.controls.LDAPPersistSearchControl;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class EventService
implements Runnable {
    protected static DSConfigMgr cm = null;
    protected Map _requestList = null;
    static Thread _monitorThread = null;
    static LDAPSearchListener _msgQueue;
    protected static EventService _instance;
    private static final boolean CHANGES_ONLY = true;
    private static final boolean RETURN_CONTROLS = true;
    private static final boolean IS_CRITICAL = true;
    private static I18n i18n;
    protected static Debug debugger;
    protected static final String EVENT_CONNECTION_NUM_RETRIES = "com.iplanet.am.event.connection.num.retries";
    protected static final String EVENT_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.event.connection.delay.between.retries";
    protected static final String EVENT_CONNECTION_ERROR_CODES = "com.iplanet.am.event.connection.ldap.error.codes.retries";
    protected static final String EVENT_IDLE_TIMEOUT_INTERVAL = "com.sun.am.event.connection.idle.timeout";
    protected static final String EVENT_LISTENER_DISABLE_LIST = "com.sun.am.event.connection.disable.list";
    private static boolean _allDisabled;
    private static int _numRetries;
    private static int _retryInterval;
    private static int _retryMaxInterval;
    private static int _retryCount;
    private static long _lastResetTime;
    protected static HashSet _retryErrorCodes;
    protected static int _idleTimeOut;
    protected static long _idleTimeOutMills;
    private static final String[] ALL_LISTENERS;
    protected static String[] listeners;
    protected static Hashtable _ideListenersMap;
    protected static volatile boolean _isThreadStarted;
    protected static volatile boolean _shutdownCalled;

    private static HashSet getPropertyRetryErrorCodes(String key) {
        HashSet<String> codes = new HashSet<String>();
        String retryErrorStr = SystemProperties.get(key);
        if (retryErrorStr != null && retryErrorStr.trim().length() > 0) {
            StringTokenizer stz = new StringTokenizer(retryErrorStr, ",");
            while (stz.hasMoreTokens()) {
                codes.add(stz.nextToken().trim());
            }
        }
        return codes;
    }

    private static int getPropertyIntValue(String key, int defaultValue) {
        int value;
        block4: {
            value = defaultValue;
            String valueStr = SystemProperties.get(key);
            if (valueStr != null && valueStr.trim().length() > 0) {
                try {
                    value = Integer.parseInt(valueStr);
                }
                catch (NumberFormatException e) {
                    value = defaultValue;
                    if (!debugger.warningEnabled()) break block4;
                    debugger.warning("EventService.getPropertyIntValue(): Invalid value for property: com.iplanet.am.event.connection.num.retries Defaulting to value: " + defaultValue);
                }
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getPropertyIntValue(): " + key + " = " + value);
        }
        return value;
    }

    private static void getListenerList() {
        String list = SystemProperties.get(EVENT_LISTENER_DISABLE_LIST, "");
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getListenerList(): com.sun.am.event.connection.disable.list: " + list);
        }
        boolean enableDataStoreNotification = Boolean.parseBoolean(SystemProperties.get("com.sun.identity.sm.enableDataStoreNotification"));
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getListenerList(): com.sun.identity.sm.enableDataStoreNotification: " + enableDataStoreNotification);
        }
        boolean configTime = Boolean.parseBoolean(SystemProperties.get("installTime"));
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getListenerList(): installTime: " + configTime);
        }
        String[] tmpListeners = new String[ALL_LISTENERS.length];
        for (int i = 0; i < ALL_LISTENERS.length; ++i) {
            tmpListeners[i] = ALL_LISTENERS[i];
        }
        boolean disableACI = false;
        boolean disableUM = false;
        boolean disableSM = false;
        if (list.length() != 0) {
            StringTokenizer st = new StringTokenizer(list, ",");
            String listener = "";
            while (st.hasMoreTokens()) {
                listener = st.nextToken().trim();
                if (listener.equalsIgnoreCase("aci")) {
                    disableACI = true;
                    continue;
                }
                if (listener.equalsIgnoreCase("um")) {
                    disableUM = true;
                    continue;
                }
                if (listener.equalsIgnoreCase("sm")) {
                    disableSM = true;
                    continue;
                }
                debugger.error("EventService.getListenerList() - Invalid listener name: " + listener);
            }
        }
        if (!disableUM || !disableACI) {
            boolean disableAMSDK = true;
            if (!configTime) {
                try {
                    ServiceSchemaManager scm = new ServiceSchemaManager(EventService.getSSOToken(), "sunIdentityRepositoryService", "1.0");
                    ServiceSchema idRepoSubSchema = scm.getOrganizationSchema();
                    Set idRepoPlugins = idRepoSubSchema.getSubSchemaNames();
                    if (idRepoPlugins.contains("amSDK")) {
                        disableAMSDK = false;
                    }
                }
                catch (SMSException ex) {
                    if (debugger.warningEnabled()) {
                        debugger.warning("EventService.getListenerList() - Unable to obtain idrepo service", (Throwable)ex);
                    }
                }
                catch (SSOException ex) {
                    // empty catch block
                }
            }
            if (disableAMSDK) {
                disableUM = true;
                disableACI = true;
                if (debugger.messageEnabled()) {
                    debugger.message("EventService.getListenerList(): AMSDK is not configured or config time. Disabling UM and ACI event listeners");
                }
            }
        }
        if (configTime || ServiceManager.isRealmEnabled()) {
            boolean bl = disableSM = !enableDataStoreNotification;
            if (debugger.messageEnabled()) {
                debugger.message("EventService.getListenerList(): In realm mode or config time, SMS listener is set to datastore notification flag: " + enableDataStoreNotification);
            }
        }
        if (disableACI) {
            tmpListeners[0] = null;
        }
        if (disableUM) {
            tmpListeners[1] = null;
        }
        if (disableSM) {
            tmpListeners[2] = null;
        }
        listeners = tmpListeners;
        if (disableACI && disableUM && disableSM) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.getListenerList() - all listeners are disabled, EventService won't start");
            }
            _allDisabled = true;
        } else {
            _allDisabled = false;
        }
    }

    protected EventService() throws EventException {
        EventService.getConfigManager();
        this._requestList = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EventService getEventService() throws EventException, LDAPException {
        if (_shutdownCalled) {
            return null;
        }
        if (_instance == null) {
            _idleTimeOut = EventService.getPropertyIntValue(EVENT_IDLE_TIMEOUT_INTERVAL, _idleTimeOut);
            _idleTimeOutMills = _idleTimeOut * 60000;
            ShutdownManager shutdownMan = ShutdownManager.getInstance();
            if (shutdownMan.acquireValidLock()) {
                try {
                    _instance = _idleTimeOut == 0 ? new EventService() : new EventServicePolling();
                    shutdownMan.addShutdownListener(new ShutdownListener(){

                        public void shutdown() {
                            if (_instance != null) {
                                _instance.finalize();
                            }
                        }
                    });
                }
                finally {
                    shutdownMan.releaseLockAndNotify();
                }
            }
        }
        return _instance;
    }

    protected static String getName() {
        return "EventService";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = this;
        synchronized (object) {
            _shutdownCalled = true;
            if (_monitorThread != null && _monitorThread.isAlive()) {
                _monitorThread.interrupt();
                _isThreadStarted = false;
            }
        }
        object = this._requestList;
        synchronized (object) {
            Collection requestObjs = this._requestList.values();
            for (Request request : requestObjs) {
                this.removeListener(request);
            }
            this._requestList.clear();
        }
    }

    protected synchronized String addListener(SSOToken token, IDSEventListener listener, String base, int scope, String filter, int operations) throws LDAPException, EventException {
        if (_shutdownCalled) {
            throw new EventException(i18n.getString("dscfg-connectFail"));
        }
        LDAPConnection lc = null;
        try {
            lc = listener.getClass().getName().equals("com.sun.identity.sm.ldap.LDAPEventManager") && cm.getServerGroup("sms") != null ? cm.getNewConnection("sms", LDAPUser.Type.AUTH_ADMIN) : cm.getNewAdminConnection();
        }
        catch (LDAPServiceException le) {
            throw new EventException(i18n.getString("dscfg-connectFail"), le);
        }
        LDAPSearchConstraints cons = lc.getSearchConstraints();
        LDAPPersistSearchControl psearchCtrl = new LDAPPersistSearchControl(operations, true, true, true);
        cons.setServerControls((LDAPControl)psearchCtrl);
        cons.setBatchSize(1);
        String[] attrs = new String[]{"objectclass"};
        LDAPSearchListener searchListener = null;
        try {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.addListener() - Submiting Persistent Search on: " + base + " for listener: " + listener);
            }
            searchListener = lc.search(base, scope, filter, attrs, false, null, cons);
        }
        catch (LDAPException le) {
            if (lc != null && lc.isConnected()) {
                try {
                    lc.disconnect();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            debugger.error("EventService.addListener() - Failed to set Persistent Search" + le.getMessage());
            throw le;
        }
        int[] outstandingRequests = searchListener.getMessageIDs();
        int id = outstandingRequests[outstandingRequests.length - 1];
        String reqID = Integer.toString(id);
        long startTime = System.currentTimeMillis();
        Request request = new Request(id, reqID, token, base, scope, filter, attrs, operations, listener, lc, startTime);
        this._requestList.put(reqID, request);
        if (_msgQueue == null) {
            _msgQueue = searchListener;
        } else {
            _msgQueue.merge(searchListener);
        }
        if (!_isThreadStarted) {
            EventService.startMonitorThread();
        } else if (this._requestList.size() == 1) {
            this.notify();
        }
        if (debugger.messageEnabled()) {
            outstandingRequests = _msgQueue.getMessageIDs();
            debugger.message("EventService.addListener(): merged Listener:  requestID: " + reqID + " & Request: " + request + " on to message Queue. No. of current outstanding " + "requests = " + outstandingRequests.length);
        }
        return reqID;
    }

    public IDSEventListener getIDSListeners(String className) {
        return (IDSEventListener)_ideListenersMap.get(className);
    }

    public static boolean isThreadStarted() {
        return _isThreadStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.run(): Event Thread is running! No Idle timeout Set: " + _idleTimeOut + " minutes.");
            }
            boolean successState = true;
            LDAPMessage message = null;
            while (successState) {
                try {
                    if (debugger.messageEnabled()) {
                        debugger.message("EventService.run(): Waiting for response");
                    }
                    message = _msgQueue.getResponse();
                    EventService eventService = this;
                    synchronized (eventService) {
                        if (message == null && this._requestList.isEmpty()) {
                            this.wait();
                            continue;
                        }
                    }
                    successState = this.processResponse(message);
                }
                catch (LDAPInterruptedException ex) {
                    if (_shutdownCalled) {
                        break;
                    }
                    if (!debugger.warningEnabled()) continue;
                    debugger.warning("EventService.run() LDAPInterruptedException received:", (Throwable)ex);
                }
                catch (LDAPException ex) {
                    if (_shutdownCalled) {
                        break;
                    }
                    int resultCode = ex.getLDAPResultCode();
                    if (debugger.warningEnabled()) {
                        debugger.warning("EventService.run() LDAPException received:", (Throwable)ex);
                    }
                    if ((_retryErrorCodes = EventService.getPropertyRetryErrorCodes(EVENT_CONNECTION_ERROR_CODES)).contains("" + resultCode)) {
                        this.resetErrorSearches(true);
                        continue;
                    }
                    this.processNetworkError((Exception)((Object)ex));
                }
            }
        }
        catch (InterruptedException ex) {
            if (!_shutdownCalled && debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Interrupted exception caught.", (Throwable)ex);
            }
        }
        catch (RuntimeException ex) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Runtime exception caught.", (Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Unknown exception caught.", (Throwable)ex);
            }
        }
        catch (Throwable t) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Unknown exception caught. Sleeping for a while.. ", t);
            }
            throw new Error(t);
        }
        finally {
            EventService ex = this;
            synchronized (ex) {
                if (!_shutdownCalled) {
                    _monitorThread = null;
                    EventService.startMonitorThread();
                }
            }
        }
    }

    private static synchronized void startMonitorThread() {
        if (!(_monitorThread != null && _monitorThread.isAlive() || _shutdownCalled)) {
            _monitorThread = new Thread((Runnable)_instance, EventService.getName());
            _monitorThread.setDaemon(true);
            _monitorThread.start();
            _isThreadStarted = true;
        }
    }

    protected boolean retryManager(boolean clearCaches) {
        int i;
        long now = System.currentTimeMillis();
        if (now - _lastResetTime > 43200000L) {
            _retryCount = 1;
            _lastResetTime = now;
        }
        if ((i = _retryCount * _retryInterval) > _retryMaxInterval) {
            i = _retryMaxInterval;
        } else {
            _retryCount *= 2;
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.retryManager() - wait " + i / 1000 + " seconds before calling resetAllSearches");
        }
        this.sleepRetryInterval(i);
        return this.resetAllSearches(clearCaches);
    }

    protected boolean processResponse(LDAPMessage message) {
        if (message == null && !this._requestList.isEmpty()) {
            debugger.error("EventService.processResponse() - Received a NULL Response, call retryManager");
            return this.retryManager(false);
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processResponse() - received DS message  => " + message.toString());
        }
        boolean successState = true;
        Request request = this.getRequestEntry(message.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponse() - Received ldap message with unknown id = " + message.getMessageID());
            }
        } else if (message.getMessageType() == 26) {
            this.processSearchResultMessage((LDAPSearchResult)message, request);
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (message.getMessageType() == 29) {
            LDAPResponse rsp = (LDAPResponse)message;
            successState = this.processResponseMessage(rsp, request);
        } else if (message.getMessageType() == 27) {
            this.processSearchResultRef((LDAPSearchResultReference)message, request);
        }
        return successState;
    }

    protected void removeListener(Request request) {
        block5: {
            LDAPConnection connection = request.getLDAPConnection();
            if (connection != null) {
                if (debugger.messageEnabled()) {
                    debugger.message("EventService.removeListener(): Removing listener requestID: " + request.getRequestID() + " Listener: " + request.getListener());
                }
                try {
                    if (connection != null && connection.isConnected()) {
                        connection.abandon(request.getId());
                        connection.disconnect();
                    }
                }
                catch (LDAPException le) {
                    if (!debugger.warningEnabled()) break block5;
                    debugger.warning("EventService.removeListener(): LDAPException, when trying to remove listener", (Throwable)le);
                }
            }
        }
    }

    protected void resetErrorSearches(boolean clearCaches) {
        Hashtable tmpReqList = new Hashtable();
        tmpReqList.putAll(this._requestList);
        int[] ids = _msgQueue.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            String reqID = Integer.toString(ids[i]);
            tmpReqList.remove(reqID);
        }
        Collection reqList = tmpReqList.values();
        for (Request req : reqList) {
            this._requestList.remove(req.getRequestID());
        }
        _numRetries = EventService.getPropertyIntValue(EVENT_CONNECTION_NUM_RETRIES, _numRetries);
        _retryInterval = EventService.getPropertyIntValue(EVENT_CONNECTION_RETRY_INTERVAL, _retryInterval);
        RetryTask task = new RetryTask(tmpReqList, _numRetries);
        task.clearCache(clearCaches);
        SystemTimer.getTimer().schedule((TaskRunnable)task, new Date((System.currentTimeMillis() + (long)_retryInterval) / 1000L * 1000L));
    }

    public synchronized boolean resetAllSearches(boolean clearCaches) {
        boolean doItAgain;
        Iterator<Object> iter;
        if (_shutdownCalled) {
            return false;
        }
        Hashtable tmpReqList = new Hashtable();
        tmpReqList.putAll(this._requestList);
        this._requestList.clear();
        Collection reqList = tmpReqList.values();
        if (clearCaches && !reqList.isEmpty()) {
            for (Request req : reqList) {
                IDSEventListener el = req.getListener();
                el.allEntriesChanged();
            }
        }
        EventService.getListenerList();
        if (_allDisabled) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.resetAllSearches(): All psearches have been disabled");
            }
            if (!reqList.isEmpty()) {
                for (Request req : reqList) {
                    this.removeListener(req);
                    if (!debugger.messageEnabled()) continue;
                    debugger.message("EventService.resetAllSearches(): Psearch disabled: " + req.getListener().getClass().getName());
                }
            }
            return true;
        }
        HashSet tmpListenerList = new HashSet();
        HashSet<String> newListenerList = new HashSet<String>();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] == null) continue;
            boolean present = false;
            iter = reqList.iterator();
            while (iter.hasNext()) {
                Request request = (Request)iter.next();
                IDSEventListener el = request.getListener();
                String listenerClass = el.getClass().getName();
                if (!listenerClass.equals(listeners[i])) continue;
                present = true;
                iter.remove();
                tmpListenerList.add(request);
            }
            if (present) continue;
            if (debugger.messageEnabled()) {
                debugger.message("EventService.resetAllSearches(): Psearch being added: " + listeners[i]);
            }
            newListenerList.add(listeners[i]);
        }
        if (!reqList.isEmpty()) {
            for (Request req : reqList) {
                this.removeListener(req);
                if (!debugger.messageEnabled()) continue;
                debugger.message("EventService.resetAllSearches(): Psearch disabled due to configuration changes: " + req.getListener().getClass().getName());
            }
        }
        reqList = tmpListenerList;
        _numRetries = EventService.getPropertyIntValue(EVENT_CONNECTION_NUM_RETRIES, _numRetries);
        int retry = 1;
        boolean bl = doItAgain = _numRetries == -1 || _numRetries != 0 && retry <= _numRetries;
        while (doItAgain) {
            if (debugger.messageEnabled()) {
                String str = _numRetries == -1 ? "indefinitely" : Integer.toString(retry);
                debugger.message("EventService.resetAllSearches(): retrying = " + str);
            }
            iter = reqList.iterator();
            while (iter.hasNext()) {
                try {
                    Request request = (Request)iter.next();
                    this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations());
                    this.removeListener(request);
                    iter.remove();
                }
                catch (LDAPServiceException lDAPServiceException) {
                    if (retry != _numRetries) continue;
                    this.processNetworkError(lDAPServiceException);
                }
                catch (LDAPException lDAPException) {
                    if (retry != _numRetries) continue;
                    this.processNetworkError((Exception)((Object)lDAPException));
                }
            }
            iter = newListenerList.iterator();
            while (iter.hasNext()) {
                String string = (String)iter.next();
                try {
                    Class<?> thisClass = Class.forName(string);
                    IDSEventListener listener = (IDSEventListener)thisClass.newInstance();
                    _ideListenersMap.put(string, listener);
                    _instance.addListener(EventService.getSSOToken(), listener, listener.getBase(), listener.getScope(), listener.getFilter(), listener.getOperations());
                    if (debugger.messageEnabled()) {
                        debugger.message("EventService.resetAllSearches() - successfully initialized: " + string);
                    }
                    iter.remove();
                }
                catch (Exception e) {
                    debugger.error("EventService.resetAllSearches() Unable to start listener " + string, (Throwable)e);
                }
            }
            if (reqList.isEmpty() && newListenerList.isEmpty()) {
                return true;
            }
            if (_numRetries != -1) {
                boolean bl2 = doItAgain = ++retry <= _numRetries;
                if (!doItAgain) {
                    for (Request request : reqList) {
                        this.removeListener(request);
                        debugger.error("EventService.resetAllSearches(): unable to restart: " + request.getListener().getClass().getName());
                    }
                    for (String string : newListenerList) {
                        debugger.error("EventService.resetAllSearches(): unable add listener: " + string);
                    }
                }
            }
            if (!doItAgain) continue;
            this.sleepRetryInterval();
        }
        return false;
    }

    protected void sleepRetryInterval() {
        _retryInterval = EventService.getPropertyIntValue(EVENT_CONNECTION_RETRY_INTERVAL, _retryInterval);
        try {
            Thread.sleep(_retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void sleepRetryInterval(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static void getConfigManager() throws EventException {
        try {
            cm = DSConfigMgr.getDSConfigMgr();
        }
        catch (LDAPServiceException lse) {
            debugger.error("EventService.getConfigManager() - Failed to get handle to Configuration Manager", (Throwable)lse);
            throw new EventException(i18n.getString("dscfg-nocfgmgr"), lse);
        }
    }

    private void dispatchException(Exception e, Request request) {
        IDSEventListener el = request.getListener();
        debugger.error("EventService.dispatchException() - dispatching exception to the listener: " + request.getRequestID() + " Listener: " + request.getListener(), (Throwable)e);
        el.eventError(e.toString());
    }

    private void dispatchEvent(DSEvent dirEvent, Request request) {
        IDSEventListener el = request.getListener();
        el.entryChanged(dirEvent);
    }

    protected void processNetworkError(Exception ex) {
        Hashtable tmpRequestList = new Hashtable();
        tmpRequestList.putAll(this._requestList);
        int[] ids = _msgQueue.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            tmpRequestList.remove(Integer.toString(ids[i]));
        }
        Collection reqList = tmpRequestList.values();
        for (Request request : reqList) {
            this.dispatchException(ex, request);
        }
    }

    protected boolean processResponseMessage(LDAPResponse rsp, Request request) {
        _retryErrorCodes = EventService.getPropertyRetryErrorCodes(EVENT_CONNECTION_ERROR_CODES);
        int resultCode = rsp.getResultCode();
        if (_retryErrorCodes.contains("" + resultCode)) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponseMessage() - received LDAP Response for requestID: " + request.getRequestID() + " Listener: " + request.getListener() + "Need restarting");
            }
            this.resetErrorSearches(false);
        } else if (resultCode != 0 || resultCode != 10) {
            if (resultCode == 51) {
                debugger.error("EventService.processResponseMessage() - received error BUSY, call retryManager");
                return this.retryManager(false);
            }
            LDAPException ex = new LDAPException("Error result", rsp.getResultCode(), rsp.getErrorMessage(), rsp.getMatchedDN());
            this.dispatchException((Exception)((Object)ex), request);
        }
        return true;
    }

    protected void processSearchResultMessage(LDAPSearchResult res, Request req) {
        LDAPControl[] ctrls;
        LDAPEntry modEntry = res.getEntry();
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processSearchResultMessage() - Changed " + modEntry.getDN());
        }
        if ((ctrls = res.getControls()) == null) {
            Exception ex = new Exception("EventService - Cannot create NamingEvent, no change control info");
            this.dispatchException(ex, req);
        } else {
            for (int i = 0; i < ctrls.length; ++i) {
                LDAPEntryChangeControl changeCtrl = null;
                if (ctrls[i].getType() != 2) continue;
                changeCtrl = (LDAPEntryChangeControl)ctrls[i];
                if (debugger.messageEnabled()) {
                    debugger.message("EventService.processSearchResultMessage() changeCtrl = " + changeCtrl.toString());
                }
                if (changeCtrl.getChangeType() == -1) {
                    Exception ex = new Exception("EventService - Cannot create NamingEvent, no change control info");
                    this.dispatchException(ex, req);
                }
                try {
                    DSEvent event = this.createDSEvent(modEntry, changeCtrl, req);
                    this.dispatchEvent(event, req);
                    continue;
                }
                catch (Exception ex) {
                    this.dispatchException(ex, req);
                }
            }
        }
    }

    protected void processSearchResultRef(LDAPSearchResultReference ref, Request req) {
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processSearchResultRef() - Ignoring..");
        }
    }

    protected static SSOToken getSSOToken() throws SSOException {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    protected Request getRequestEntry(int id) {
        return (Request)this._requestList.get(Integer.toString(id));
    }

    private DSEvent createDSEvent(LDAPEntry entry, LDAPEntryChangeControl changeCtrl, Request req) throws Exception {
        DSEvent dsEvent = new DSEvent();
        if (debugger.messageEnabled()) {
            debugger.message("EventService.createDSEvent() - Notifying event to: " + req.getListener());
        }
        String dn = entry.getDN();
        dsEvent.setID(dn);
        int changeType = changeCtrl.getChangeType();
        dsEvent.setEventType(changeType);
        dsEvent.setSearchID(req.getRequestID());
        String className = entry.getAttribute("objectclass").toString();
        dsEvent.setClassName(className);
        return dsEvent;
    }

    static /* synthetic */ int access$000() {
        return _retryInterval;
    }

    static /* synthetic */ int access$100(String x0, int x1) {
        return EventService.getPropertyIntValue(x0, x1);
    }

    static {
        _instance = null;
        i18n = I18n.getInstance("amSDK");
        debugger = Debug.getInstance((String)"amEventService");
        _allDisabled = false;
        _numRetries = 3;
        _retryInterval = 3000;
        _retryMaxInterval = 720000;
        _retryCount = 1;
        _lastResetTime = 0L;
        _idleTimeOut = 0;
        ALL_LISTENERS = new String[]{"com.iplanet.am.sdk.ldap.ACIEventListener", "com.iplanet.am.sdk.ldap.EntryEventListener", "com.sun.identity.sm.ldap.LDAPEventManager"};
        _ideListenersMap = new Hashtable();
        _isThreadStarted = false;
        _shutdownCalled = false;
    }

    class RetryTask
    extends GeneralTaskRunnable {
        private long runPeriod = EventService.access$100("com.iplanet.am.event.connection.delay.between.retries", EventService.access$000());
        private Map requests;
        private int numOfRetries;
        private int retry;
        private boolean clearCaches;

        public RetryTask(Map requests, int numOfRetries) {
            this.requests = requests;
            this.numOfRetries = numOfRetries;
            this.retry = 1;
        }

        public void clearCache(boolean cc) {
            this.clearCaches = cc;
        }

        public void run() {
            Iterator iter = this.requests.values().iterator();
            while (iter.hasNext()) {
                Request req = (Request)iter.next();
                try {
                    if (!EventService.this._requestList.containsValue(req)) {
                        EventService.this.addListener(req.getRequester(), req.getListener(), req.getBaseDn(), req.getScope(), req.getFilter(), req.getOperations());
                    }
                    EventService.this.removeListener(req);
                    if (this.clearCaches) {
                        req.getListener().allEntriesChanged();
                    }
                    iter.remove();
                }
                catch (Exception e) {
                    if (this.retry != this.numOfRetries) continue;
                    EventService.this.dispatchException(e, req);
                }
            }
            if (this.requests.isEmpty()) {
                this.runPeriod = -1L;
            } else if (this.numOfRetries != -1 && ++this.retry > this.numOfRetries) {
                this.runPeriod = -1L;
            }
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }
    }
}

