/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.cos;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SchemaManager;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.iplanet.ums.cos.ICOSDefinition;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.util.DN;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;

public class COSManager {
    private static final String[] DEF_ATTRIBUTE_NAMES = new String[]{"objectclass", "cn", "cosTemplateDn", "cosSpecifier", "cosAttribute", "cosIndirectSpecifier"};
    private PersistentObject _parentObject;
    private SchemaManager _schemaManager;
    private static I18n i18n = I18n.getInstance("amSDK");

    protected COSManager(SSOToken token, Guid guid) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        this._parentObject = UMSObject.getObject(token, guid);
        try {
            this._schemaManager = SchemaManager.getSchemaManager(token.getPrincipal());
        }
        catch (SSOException se) {
            throw new UMSException("Bad Authentication Token " + se.getMessage());
        }
    }

    protected COSManager(Principal principal, Guid guid) throws UMSException {
        this._parentObject = UMSObject.getObject(principal, guid);
        this._schemaManager = SchemaManager.getSchemaManager(principal);
    }

    public static COSManager getCOSManager(SSOToken token, Guid guid) throws UMSException {
        return new COSManager(token, guid);
    }

    public static COSManager getCOSManager(Principal principal, Guid guid) throws UMSException {
        return new COSManager(principal, guid);
    }

    public void addDefinition(ICOSDefinition cosDef) throws UMSException {
        if (!(cosDef instanceof DirectCOSDefinition)) {
            String msg = i18n.getString("cos-invalid_cosdefinition");
            throw new UMSException(msg);
        }
        String[] cosAttributes = cosDef.getCOSAttributes();
        AbstractCollection aList = (AbstractCollection)((Object)Arrays.asList(ICOSDefinition.qualifiers));
        for (int i = 0; i < cosAttributes.length; ++i) {
            String cosAttribute = null;
            String qualifier = null;
            StringTokenizer st = new StringTokenizer(cosAttributes[i]);
            if (st.hasMoreTokens()) {
                cosAttribute = st.nextToken();
            }
            if (cosAttribute == null) {
                String msg = i18n.getString("cos-cos_invalid_cos_attribute_qualifier");
                throw new UMSException(msg);
            }
            if (st.hasMoreTokens()) {
                qualifier = st.nextToken();
            }
            if (qualifier == null) {
                qualifier = ICOSDefinition.qualifiers[0];
                cosDef.removeCOSAttribute(cosAttribute);
                cosDef.addCOSAttribute(cosAttribute, 0);
            }
            if (aList.contains(qualifier)) continue;
            String msg = i18n.getString("cos-cos_invalid_cos_attribute_qualifier");
            throw new UMSException(msg);
        }
        PersistentObject po = (PersistentObject)((Object)cosDef);
        this._parentObject.addChild(po);
    }

    public void removeDefinition(String name) throws UMSException {
        Guid guid = new Guid("cn=" + name + "," + this._parentObject.getGuid().getDn());
        this._parentObject.removeChild(guid);
    }

    public void updateDefinition(ICOSDefinition cosDef) throws UMSException {
        PersistentObject pObject = (PersistentObject)((Object)cosDef);
        if (pObject.getGuid() == null) {
            String msg = i18n.getString("cos-replace_definition_not_persistent");
            throw new UMSException(msg);
        }
        pObject.save();
    }

    public ICOSDefinition getDefinition(String name) throws UMSException, COSNotFoundException {
        ICOSDefinition cosDef = null;
        SearchResults sr = this._parentObject.getChildren("(&(objectclass=ldapsubentry)(objectclass=cossuperdefinition)(cn=" + name + ")", DEF_ATTRIBUTE_NAMES, null);
        while (sr.hasMoreElements() && !(cosDef = (ICOSDefinition)((Object)sr.next())).getName().equals(name)) {
            cosDef = null;
        }
        if (cosDef == null) {
            String msg = i18n.getString("cos-cos_definition_not_found");
            throw new COSNotFoundException(msg);
        }
        sr.abandon();
        return cosDef;
    }

    public Collection getDefinitions() throws UMSException {
        ArrayList<PersistentObject> cosDefinitions = new ArrayList<PersistentObject>();
        SearchResults sr = this._parentObject.search("&(objectclass=ldapsubentry)(objectclass=cossuperdefinition)", DEF_ATTRIBUTE_NAMES, null);
        while (sr.hasMoreElements()) {
            cosDefinitions.add(sr.next());
        }
        return cosDefinitions;
    }

    public void assignCOSDef(PersistentObject pObject, ICOSDefinition cosDef, COSTemplate cosTemplate) throws UMSException {
        if (pObject == null || cosDef == null) {
            String msg = i18n.getString("cos-cos_def_or_target_object_null");
            throw new UMSException(msg);
        }
        if (pObject.getGuid() == null) {
            String msg = i18n.getString("cos-cos_target_object_not_persistent");
            throw new UMSException(msg);
        }
        if (!(cosDef instanceof DirectCOSDefinition)) {
            String msg = i18n.getString("cos-invalid_cosdefinition");
            throw new UMSException(msg);
        }
        if (cosDef instanceof DirectCOSDefinition) {
            this.assignDirectCOSDef(pObject, (DirectCOSDefinition)cosDef, cosTemplate, this._schemaManager);
        }
    }

    public void removeCOSAssignment(PersistentObject pObject, ICOSDefinition cosDef, COSTemplate cosTemplate) throws UMSException {
        if (pObject == null || cosDef == null) {
            String msg = i18n.getString("cos-cos_def_or_target_object_null");
            throw new UMSException(msg);
        }
        if (pObject.getGuid() == null) {
            String msg = i18n.getString("cos-cos_target_object_not_persistent");
            throw new UMSException(msg);
        }
        if (!(cosDef instanceof DirectCOSDefinition)) {
            String msg = i18n.getString("cos-invalid_cosdefinition");
            throw new UMSException(msg);
        }
        if (cosDef instanceof DirectCOSDefinition) {
            this.removeDirectCOSAssignment(pObject, (DirectCOSDefinition)cosDef, cosTemplate, this._schemaManager);
        }
    }

    private void removeDirectCOSAssignment(PersistentObject pObject, DirectCOSDefinition cosDef, COSTemplate cosTemplate, SchemaManager sMgr) throws UMSException {
        block6: {
            AttrSet attrSet = new AttrSet();
            try {
                ArrayList aList;
                String cosSpecObjectClass;
                if (pObject.getAttribute(cosDef.getCOSSpecifier()) != null) {
                    attrSet.add(new Attr(cosDef.getCOSSpecifier(), cosTemplate.getName()));
                }
                if (this.objectClassExists(cosSpecObjectClass = (String)(aList = (ArrayList)sMgr.getObjectClasses(cosDef.getCOSSpecifier())).get(0), pObject)) {
                    attrSet.add(new Attr("objectclass", cosSpecObjectClass));
                }
                String[] cosAttributes = cosDef.getCOSAttributes();
                String cosAttribute = null;
                for (int i = 0; i < cosAttributes.length; ++i) {
                    StringTokenizer st = new StringTokenizer(cosAttributes[i]);
                    cosAttribute = st.nextToken();
                    aList = (ArrayList)sMgr.getObjectClasses(cosAttribute);
                    String cosAttributeObjectClass = (String)aList.get(0);
                    if (!this.objectClassExists(cosAttributeObjectClass, pObject)) continue;
                    attrSet.add(new Attr("objectclass", cosAttributeObjectClass));
                }
                if (attrSet.size() > 0) {
                    ModSet modSet = new ModSet(attrSet, 1);
                    pObject.modify(modSet);
                    pObject.save();
                }
            }
            catch (UMSException e) {
                LDAPException le = (LDAPException)e.getRootCause();
                if (le.getLDAPResultCode() == 65) break block6;
                throw e;
            }
        }
    }

    private void assignDirectCOSDef(PersistentObject pObject, DirectCOSDefinition cosDef, COSTemplate cosTemplate, SchemaManager sMgr) throws UMSException {
        DN cosParentDN;
        if (cosDef.getGuid() == null) {
            String msg = i18n.getString("cos-cos_definition_not_persistent");
            throw new UMSException(msg);
        }
        DN targetDN = new DN(pObject.getGuid().getDn());
        if (!targetDN.isDescendantOf(cosParentDN = new DN(cosDef.getParentGuid().getDn()))) {
            String msg = i18n.getString("cos-cos_target_object_different_tree");
            throw new UMSException(msg);
        }
        if (cosDef.getCOSSpecifier().equalsIgnoreCase("nsrole")) {
            return;
        }
        AttrSet attrSet = new AttrSet();
        ArrayList aList = (ArrayList)sMgr.getObjectClasses(cosDef.getCOSSpecifier());
        String cosSpecObjectClass = (String)aList.get(0);
        if (!this.objectClassExists(cosSpecObjectClass, pObject)) {
            attrSet.add(new Attr("objectclass", cosSpecObjectClass));
        }
        String[] cosAttributes = cosDef.getCOSAttributes();
        String qualifier = null;
        Arrays.asList(ICOSDefinition.qualifiers);
        Attr attr = cosTemplate.getAttribute("objectclass");
        String[] cosTempObjClasses = attr.getStringValues();
        for (int i = 0; i < cosAttributes.length; ++i) {
            StringTokenizer st = new StringTokenizer(cosAttributes[i]);
            st.nextToken();
            qualifier = st.nextToken();
            if (qualifier.equals(ICOSDefinition.qualifiers[2])) continue;
            for (int j = 0; j < cosTempObjClasses.length; ++j) {
                if (cosTempObjClasses[j].equalsIgnoreCase("top") || cosTempObjClasses[j].equalsIgnoreCase("costemplate") || this.objectClassExists(cosTempObjClasses[j], pObject) || attrSet.contains("objectclass", cosTempObjClasses[j])) continue;
                attrSet.add(new Attr("objectclass", cosTempObjClasses[j]));
            }
        }
        if (pObject.getAttribute(cosDef.getCOSSpecifier()) == null) {
            attrSet.add(new Attr(cosDef.getCOSSpecifier(), cosTemplate.getName()));
        }
        if (attrSet.size() > 0) {
            ModSet modSet = new ModSet(attrSet);
            pObject.modify(modSet);
            pObject.save();
        }
    }

    private boolean objectClassExists(String objectClass, PersistentObject pObject) {
        Attr attr = pObject.getAttribute("objectclass");
        String[] vals = attr.getStringValues();
        for (int i = 0; i < vals.length; ++i) {
            if (!objectClass.equalsIgnoreCase(vals[i])) continue;
            return true;
        }
        return false;
    }
}

