/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSEntry;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfiguredModuleInstances
extends ChoiceValues {
    public Map getChoiceValues() {
        return this.getChoiceValues(Collections.EMPTY_MAP);
    }

    public Map getChoiceValues(Map envParams) {
        String orgDN = null;
        if (envParams != null) {
            orgDN = (String)envParams.get("organization_name");
        }
        if (orgDN == null || orgDN.length() == 0) {
            orgDN = SMSEntry.getRootSuffix();
        }
        HashMap answer = new HashMap();
        try {
            this.getInstanceNames(orgDN, "LDAP", answer);
            this.getInstanceNames(orgDN, "DataStore", answer);
            this.getInstanceNames(orgDN, "AD", answer);
            this.getInstanceNames(orgDN, "Anonymous", answer);
            this.getInstanceNames(orgDN, "JDBC", answer);
            this.getInstanceNames(orgDN, "Unix", answer);
        }
        catch (Exception e) {
            // empty catch block
        }
        return answer;
    }

    private void getInstanceNames(String orgDN, String moduleType, Map answer) {
        Set instanceNames = null;
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMAuthenticationManager amAM = new AMAuthenticationManager(adminToken, orgDN);
            instanceNames = amAM.getModuleInstanceNames(moduleType);
            if (instanceNames != null && !instanceNames.isEmpty()) {
                for (String config : instanceNames) {
                    answer.put(config, config);
                }
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
    }
}

