/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

public class DeleteAgents
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        ArrayList agentNames = rc.getOption("agentnames");
        String file = this.getStringOptionValue("file");
        if (agentNames == null) {
            agentNames = new ArrayList();
        }
        if (file != null) {
            agentNames.addAll(AttributeValues.parseValues(file));
        }
        if (agentNames.isEmpty()) {
            throw new CLIException(this.getResourceString("missing-agent-names"), 127);
        }
        String displayableNames = this.tokenize(agentNames);
        String[] params = new String[]{realm, displayableNames};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_AGENTS", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            HashSet<AMIdentity> setDelete = new HashSet<AMIdentity>();
            for (String name : agentNames) {
                AMIdentity amid = new AMIdentity(adminSSOToken, name, IdType.AGENTONLY, realm, null);
                setDelete.add(amid);
            }
            amir.deleteIdentities(setDelete);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnMessage(this.getResourceString("delete-agent-succeeded"));
            Iterator i = agentNames.iterator();
            while (i.hasNext()) {
                outputWriter.printlnMessage("    " + (String)i.next());
            }
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_AGENTS", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, displayableNames, e.getMessage()};
            this.debugError("DeleteAgents.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AGENTS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, displayableNames, e.getMessage()};
            this.debugError("DeleteAgents.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_AGENTS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

