/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ShowSiteMembers
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String siteName = this.getStringOptionValue("sitename");
        String[] params = new String[]{siteName};
        this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_SITE_MEMBERS", params);
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            Set members = SiteConfiguration.listServers(adminSSOToken, siteName);
            if (members != null && !members.isEmpty()) {
                Iterator i = members.iterator();
                while (i.hasNext()) {
                    outputWriter.printlnMessage((String)i.next());
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("show-site-members-no-members"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SHOW_SITE_MEMBERS", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("ShowSiteMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_SITE_MEMBERS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("ShowSiteMembers.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SHOW_SITE_MEMBERS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("ShowSiteMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_SITE_MEMBERS", args);
            throw new CLIException(e, 127);
        }
    }
}

