/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.console.base.model.AMAdminConstants;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import com.sun.identity.sm.SMSEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class AMSystemConfig
implements AMAdminConstants {
    public static String serverDeploymentURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
    public static String consoleDeploymentURI = SystemProperties.get("com.iplanet.am.console.deploymentDescriptor");
    public static String serverProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
    public static String serverHost = SystemProperties.get("com.iplanet.am.server.host");
    public static String serverPort = SystemProperties.get("com.iplanet.am.server.port");
    public static String serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
    public static boolean isConsoleRemote = Boolean.valueOf(SystemProperties.get("com.iplanet.am.console.remote"));
    public static String defaultOrg = SMSEntry.getRootSuffix();
    public static String version = "";
    public static boolean iPlanetCompliantDIT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(HttpURLConnection connection) {
        InputStream in_buf = null;
        String result = null;
        try {
            in_buf = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in_buf, "UTF-8"));
            result = reader.readLine();
        }
        catch (IOException e) {
            AMModelBase.debug.error("AMSystemConfig.getContent", (Throwable)e);
        }
        finally {
            if (in_buf != null) {
                try {
                    in_buf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result == null ? "" : result;
    }

    public static String normalizeString(String tmp) {
        if (tmp != null) {
            String[] dns = LDAPDN.explodeDN((String)tmp, (boolean)false);
            if (dns != null && dns.length > 0) {
                int len = dns.length - 1;
                DN root = new DN(dns[len]);
                for (int i = len - 1; i >= 0; --i) {
                    root.addRDN(new RDN(dns[i]));
                }
                tmp = root.toString();
            }
        } else {
            tmp = "";
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (!isConsoleRemote) {
            version = SystemProperties.get("com.iplanet.am.version");
        } else {
            HttpURLConnection connection = null;
            try {
                URL url = new URL(serverProtocol + "://" + serverHost + ":" + serverPort + serverDeploymentURI + "/SMSServlet?method=version");
                connection = HttpURLConnectionManager.getConnection((URL)url);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    version = AMSystemConfig.getContent(connection);
                }
            }
            catch (MalformedURLException e) {
                AMModelBase.debug.error("AMSystemConfig.<init>, get version from server", (Throwable)e);
            }
            catch (IOException e) {
                AMModelBase.debug.error("AMSystemConfig.<init>, get version from server", (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        String s = SystemProperties.get("com.iplanet.am.compliance");
        if (s != null && s.equalsIgnoreCase("true")) {
            iPlanetCompliantDIT = true;
        }
    }
}

