/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import sun.misc.BASE64Encoder;

public class PolicyCache
implements SSOTokenListener {
    private static PolicyCache instance = new PolicyCache();
    private Map mapTokenIDs = new HashMap(100);
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static Random random = new Random();

    private PolicyCache() {
    }

    public static PolicyCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cachePolicy(SSOToken token, CachedPolicy policy) {
        String randomStr = "";
        if (policy != null) {
            try {
                String key = ((Object)token.getTokenID()).toString();
                Map map = this.mapTokenIDs;
                synchronized (map) {
                    HashMap<String, CachedPolicy> map2 = (HashMap<String, CachedPolicy>)this.mapTokenIDs.get(key);
                    if (map2 == null) {
                        map2 = new HashMap<String, CachedPolicy>(10);
                        token.addSSOTokenListener(this);
                    }
                    randomStr = PolicyCache.getRandomString();
                    map2.put(randomStr, policy);
                    this.mapTokenIDs.put(key, map2);
                }
            }
            catch (SSOException ssoe) {
                AMModelBase.debug.warning("PolicyCache.cachePolicy", (Throwable)((Object)ssoe));
                randomStr = "";
            }
        }
        return randomStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicy(SSOToken token, String cachedID, CachedPolicy policy) {
        if (policy != null) {
            try {
                String key = ((Object)token.getTokenID()).toString();
                Map map = this.mapTokenIDs;
                synchronized (map) {
                    HashMap<String, CachedPolicy> map2 = (HashMap<String, CachedPolicy>)this.mapTokenIDs.get(key);
                    if (map2 == null) {
                        map2 = new HashMap<String, CachedPolicy>(10);
                        token.addSSOTokenListener(this);
                    }
                    map2.put(cachedID, policy);
                    this.mapTokenIDs.put(key, map2);
                }
            }
            catch (SSOException ssoe) {
                AMModelBase.debug.warning("PolicyCache.replacePolicy", (Throwable)((Object)ssoe));
            }
        }
    }

    public CachedPolicy getPolicy(SSOToken token, String cacheID) throws AMConsoleException {
        CachedPolicy policy = null;
        String key = ((Object)token.getTokenID()).toString();
        Map map = (Map)this.mapTokenIDs.get(key);
        if (map != null) {
            policy = (CachedPolicy)map.get(cacheID);
        }
        if (policy == null) {
            throw new AMConsoleException("Cannot locate cached policy " + cacheID);
        }
        return policy;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int type = evt.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    SSOToken token = evt.getToken();
                    this.clearAllPolicies(token.getTokenID());
                }
            }
        }
        catch (SSOException ssoe) {
            AMModelBase.debug.warning("PolicyCache.ssoTokenChanged", (Throwable)((Object)ssoe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllPolicies(SSOTokenID tokenID) {
        boolean removed = false;
        String key = ((Object)tokenID).toString();
        Map map = this.mapTokenIDs;
        synchronized (map) {
            removed = this.mapTokenIDs.remove(key) != null;
        }
        if (removed && AMModelBase.debug.messageEnabled()) {
            AMModelBase.debug.warning("PolicyCache.clearAllPolicies," + key);
        }
    }

    private static String getRandomString() {
        StringBuffer sb = new StringBuffer(30);
        byte[] keyRandom = new byte[5];
        random.nextBytes(keyRandom);
        sb.append(System.currentTimeMillis());
        sb.append(encoder.encode(keyRandom));
        return sb.toString();
    }
}

