/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.URLResourceName;
import com.sun.identity.entitlement.interfaces.ISaveIndex;
import com.sun.identity.entitlement.interfaces.ISearchIndex;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.entitlement.util.ResourceNameIndexGenerator;
import com.sun.identity.entitlement.util.ResourceNameSplitter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationType {
    private String name;
    private Map<String, Boolean> actions;
    private ResourceName resourceCompInstance;
    private ISaveIndex saveIndexInstance;
    private ISearchIndex searchIndexInstance;

    public ApplicationType(String name, Map<String, Boolean> actions, Class searchIndex, Class saveIndex, Class resourceComp) throws InstantiationException, IllegalAccessException {
        this.name = name;
        this.actions = actions;
        this.setSearchIndex(searchIndex);
        this.setSaveIndex(saveIndex);
        Class resourceCompClass = resourceComp == null ? URLResourceName.class : resourceComp;
        this.resourceCompInstance = (ResourceName)resourceCompClass.newInstance();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Boolean> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, Boolean> actions) {
        this.actions = actions;
    }

    public void setSaveIndex(Class saveIndex) throws InstantiationException, IllegalAccessException {
        Class saveIndexClass = saveIndex == null ? ResourceNameIndexGenerator.class : saveIndex;
        this.saveIndexInstance = (ISaveIndex)saveIndexClass.newInstance();
    }

    public void setSearchIndex(Class searchIndex) throws InstantiationException, IllegalAccessException {
        Class searchIndexClass = searchIndex == null ? ResourceNameSplitter.class : searchIndex;
        this.searchIndexInstance = (ISearchIndex)searchIndexClass.newInstance();
    }

    public ResourceSearchIndexes getResourceSearchIndex(String resource) {
        return this.searchIndexInstance.getIndexes(resource);
    }

    public ResourceSaveIndexes getResourceSaveIndex(String resource) {
        return this.saveIndexInstance.getIndexes(resource);
    }

    public ResourceName getResourceComparator() {
        return this.resourceCompInstance;
    }

    public ISaveIndex getSaveIndex() {
        return this.saveIndexInstance;
    }

    public ISearchIndex getSearchIndex() {
        return this.searchIndexInstance;
    }
}

