/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.SubjectAttributesCollector;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSOSubjectAttributesCollector
implements SubjectAttributesCollector {
    static ServiceConfigManager idRepoServiceConfigManager;
    private static final String GROUP_MEMBERSHIP_SEARCH_INDEX_ENABLED_ATTR = "groupMembershipSearchIndexEnabled";
    private static final String LDAPv3Config_USER_ATTR = "sun-idrepo-ldapv3-config-user-attributes";
    private String realm;
    private boolean groupMembershipSearchIndexEnabled = false;

    @Override
    public void init(String realm, Map<String, Set<String>> configMap) {
        Set<String> values;
        this.realm = realm;
        if (configMap != null && (values = configMap.get(GROUP_MEMBERSHIP_SEARCH_INDEX_ENABLED_ATTR)) != null && !values.isEmpty()) {
            this.groupMembershipSearchIndexEnabled = Boolean.valueOf(values.iterator().next());
        }
    }

    @Override
    public Map<String, Set<String>> getAttributes(Subject subject, Set<String> attrNames) throws EntitlementException {
        String uuid = SubjectUtils.getPrincipalId(subject);
        try {
            Set<String> membershipAttrNames;
            HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentity amid = new AMIdentity(adminToken, uuid);
            HashSet<String> set = new HashSet<String>(2);
            set.add(OpenSSOSubjectAttributesCollector.getIDWithoutOrgName(amid));
            results.put("identity:", set);
            Set<String> primitiveAttrNames = this.getAttributeNames(attrNames, "attribute:");
            if (!primitiveAttrNames.isEmpty()) {
                Map primitiveAttrValues = amid.getAttributes(primitiveAttrNames);
                for (String name : primitiveAttrValues.keySet()) {
                    Set values = (Set)primitiveAttrValues.get(name);
                    if (values == null) continue;
                    results.put("attribute:" + name, values);
                }
            }
            if (!(membershipAttrNames = this.getAttributeNames(attrNames, "membership:")).isEmpty()) {
                for (String m : membershipAttrNames) {
                    Set memberships;
                    IdType type = IdUtils.getType(m);
                    if (type == null || (memberships = amid.getMemberships(type)) == null) continue;
                    HashSet<String> setMemberships = new HashSet<String>();
                    for (AMIdentity a : memberships) {
                        setMemberships.add(a.getUniversalId());
                    }
                    results.put("membership:" + m, setMemberships);
                }
            }
            Set<Object> publicCreds = subject.getPublicCredentials();
            publicCreds.add(results);
            return results;
        }
        catch (SSOException e) {
            Object[] params = new Object[]{uuid};
            throw new EntitlementException(600, params, (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            Object[] params = new Object[]{uuid};
            throw new EntitlementException(600, params, e);
        }
    }

    private Set<String> getAttributeNames(Set<String> attrNames, String ns) {
        HashSet<String> results = new HashSet<String>();
        int len = ns.length();
        for (String s : attrNames) {
            if (!s.startsWith(ns)) continue;
            results.add(s.substring(len));
        }
        return results;
    }

    @Override
    public boolean hasAttribute(Subject subject, String attrName, String attrValue) throws EntitlementException {
        String uuid = SubjectUtils.getPrincipalId(subject);
        try {
            AMIdentity parent;
            IdType type;
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentity amid = new AMIdentity(adminToken, uuid);
            if (attrName.startsWith("attribute:")) {
                Set values = amid.getAttribute(attrName.substring("attribute:".length()));
                return values != null ? values.contains(attrValue) : false;
            }
            if (attrName.startsWith("membership:") && (type = IdUtils.getType(attrName.substring("membership:".length()))) != null && (parent = new AMIdentity(adminToken, attrValue)).getType().equals(type)) {
                Set members = parent.getMembers(IdType.USER);
                return members.contains(amid.getUniversalId());
            }
            return false;
        }
        catch (IdRepoException e) {
            Object[] params = new Object[]{uuid};
            throw new EntitlementException(601, params, e);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{uuid};
            throw new EntitlementException(601, params, (Throwable)((Object)e));
        }
    }

    @Override
    public Set<String> getAvailableSubjectAttributeNames() throws EntitlementException {
        try {
            ServiceConfig sc = idRepoServiceConfigManager.getOrganizationConfig(this.realm, null);
            if (sc == null) {
                return null;
            }
            Set subConfigNames = sc.getSubConfigNames();
            if (subConfigNames == null || subConfigNames.isEmpty()) {
                return null;
            }
            AbstractCollection result = null;
            for (String idRepoName : subConfigNames) {
                ServiceConfig reposc = sc.getSubConfig(idRepoName);
                Map attrMap = reposc.getAttributesForRead();
                Set userAttrs = (Set)attrMap.get(LDAPv3Config_USER_ATTR);
                if (userAttrs == null || userAttrs.isEmpty()) continue;
                if (result == null) {
                    result = new CaseInsensitiveHashSet();
                }
                result.addAll(userAttrs);
            }
            return result;
        }
        catch (SMSException e) {
            throw new EntitlementException(602, (Throwable)e);
        }
        catch (SSOException e) {
            throw new EntitlementException(602, (Throwable)((Object)e));
        }
    }

    @Override
    public boolean isGroupMembershipSearchIndexEnabled() {
        return this.groupMembershipSearchIndexEnabled;
    }

    @Override
    public Map<String, Set<String>> getUserAttributes(Subject subject, Set<String> attrNames) throws EntitlementException {
        String uuid = SubjectUtils.getPrincipalId(subject);
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentity amid = new AMIdentity(adminToken, uuid);
            return amid.getAttributes(attrNames);
        }
        catch (IdRepoException e) {
            Object[] params = new Object[]{uuid};
            throw new EntitlementException(601, params, e);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{uuid};
            throw new EntitlementException(601, params, (Throwable)((Object)e));
        }
    }

    protected static String getIDWithoutOrgName(AMIdentity amidentity) {
        return "id=" + LDAPDN.escapeValue((String)amidentity.getName()) + ",ou=" + amidentity.getType().getName();
    }

    static {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            idRepoServiceConfigManager = new ServiceConfigManager(adminToken, "sunIdentityRepositoryService", "1.0");
        }
        catch (SSOException ssoex) {
            PrivilegeManager.debug.error("OpenSSOSubjectAttributesCollector.static:", (Throwable)((Object)ssoex));
        }
        catch (SMSException smsex) {
            PrivilegeManager.debug.error("OpenSSOSubjectAttributesCollector.static:", (Throwable)smsex);
        }
    }
}

