/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.common;

import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;

public class IdCacheStats
implements StatsListener {
    private String nameOfCache;
    int cacheSize = 0;
    long totalGetRequests = 0L;
    long totalGetCacheHits = 0L;
    long totalIntervalHits = 0L;
    long intervalCount = 0L;
    long totalSearchRequests = 0L;
    long totalSearchHits = 0L;
    private Stats stats = null;

    public IdCacheStats(String name) {
        this.nameOfCache = name;
        this.stats = Stats.getInstance((String)name);
    }

    public void updateGetHitCount(int sizeOfCache) {
        if (this.stats.isEnabled()) {
            ++this.totalGetCacheHits;
            ++this.totalIntervalHits;
            this.cacheSize = sizeOfCache;
        }
    }

    public void incrementGetRequestCount(int sizeOfCache) {
        if (this.stats.isEnabled()) {
            ++this.totalGetRequests;
            ++this.intervalCount;
            this.cacheSize = sizeOfCache;
        }
    }

    public void updateSearchHitCount(int sizeOfCache) {
        if (this.stats.isEnabled()) {
            ++this.totalSearchHits;
            ++this.totalIntervalHits;
            this.cacheSize = sizeOfCache;
        }
    }

    public void incrementSearchRequestCount(int sizeOfCache) {
        if (this.stats.isEnabled()) {
            ++this.totalSearchRequests;
            ++this.intervalCount;
            this.cacheSize = sizeOfCache;
        }
    }

    public void printStats() {
        this.stats.record("Idm  Cache Statistics: " + this.nameOfCache + "\n--------------------" + "\nNumber of Get and Search requests during this interval: " + (double)this.intervalCount + "\nNumber of Hits during this interval: " + this.totalIntervalHits + "\nHit ratio for this interval: " + (double)this.totalIntervalHits / (double)this.intervalCount + "\nTotal number of Get requests since server start: " + this.totalGetRequests + "\nTotal number of Get Hits since server start: " + this.totalGetCacheHits + "\nOverall Hit ratio: " + (double)this.totalGetCacheHits / (double)this.totalGetRequests + "\nTotal number of Search requests since server start: " + this.totalSearchRequests + "\nTotal number of FQDN Search hits since server start: " + this.totalSearchHits + "\nOverall Hit ratio: " + (double)this.totalSearchHits / (double)this.totalSearchRequests + "\nTotal Cache Size: " + this.cacheSize + "\n");
        this.intervalCount = 0L;
        this.totalIntervalHits = 0L;
    }
}

