/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.jaxrpc;

import com.sun.identity.shared.jaxrpc.JAXRPCHelper;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.Stub;

public class JAXRPCUtil
extends JAXRPCHelper {
    private static HashMap remoteStubs = new HashMap();

    public static Object getRemoteStub(String serviceName) throws RemoteException {
        Object answer = null;
        if (serverFailed || (answer = remoteStubs.get(serviceName)) == null) {
            answer = JAXRPCUtil.getValidStub(serviceName);
            serverFailed = false;
        }
        return answer;
    }

    public static void serverFailed(String serviceName) {
        if (serviceName.startsWith(validRemoteURL)) {
            serverFailed = true;
        } else {
            remoteStubs.remove(serviceName);
        }
    }

    protected static synchronized Object getValidStub(String serviceName) throws RemoteException {
        Object stub = JAXRPCUtil.getServiceEndPoint(JAXRPCUtil.getValidURL((String)serviceName));
        remoteStubs.put(serviceName, stub);
        return stub;
    }

    protected static Object getServiceEndPoint(String iurl) {
        Stub s;
        block11: {
            if (debug.messageEnabled()) {
                debug.message("JAXRPCUtil Endpoint URL: " + iurl);
            }
            s = null;
            try {
                Class<?> imsClass = Class.forName("com.sun.identity.jaxrpc.IdentityManagementServices_Impl");
                Object imsImpl = imsClass.newInstance();
                Method method = null;
                if (iurl.endsWith("SMSObjectIF")) {
                    method = imsClass.getMethod("getSMSObjectIFPort", null);
                }
                s = (Stub)method.invoke(imsImpl, (Object[])null);
            }
            catch (ClassNotFoundException cnfe) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCUtil: unable to find class IdentityManagementServices_Impl", (Throwable)cnfe);
                }
            }
            catch (InstantiationException ne) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCUtil: unable to instantiate class IdentityManagementServices_Impl", (Throwable)ne);
                }
            }
            catch (IllegalAccessException iae) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCUtil: Illegal access to class IdentityManagementServices_Impl", (Throwable)iae);
                }
            }
            catch (Throwable t) {
                if (!debug.warningEnabled()) break block11;
                debug.warning("JAXRPCUtil:getServiceEndPoint exception", t);
            }
        }
        if (s != null) {
            s._setProperty("javax.xml.rpc.service.endpoint.address", (Object)iurl);
        }
        return s;
    }
}

