/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResultsCacheUtil {
    static Debug debug = Debug.getInstance((String)"amRemotePolicy");
    private static final String BEGIN_XML_DATA_BLOCK = "<![CDATA[";
    private static final String END_XML_DATA_BLOCK = "]]>";
    private static final String NODE_POLICY_SERVICE = "PolicyService";
    private static final String NODE_POLICY_NOTIFICATION = "PolicyNotification";

    public static void processNotification(String xml) throws PolicyEvaluationException {
        PolicyNotification pn;
        if (debug.messageEnabled()) {
            debug.message("ResultsCacheUtil.processNotification():recieved notification xml=" + xml);
        }
        if ((pn = ResultsCacheUtil.extractPolicyNotification(xml)) != null) {
            ResourceResultCache.processPolicyNotification(pn);
        } else {
            debug.error("ResultsCacheUtil.processPolicyNotification():PolicyNotification is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PolicyNotification extractPolicyNotification(String xml) throws PolicyEvaluationException {
        PolicyNotification policyNotification = null;
        try {
            String notificationDataBlock = ResultsCacheUtil.getNotificationDataBlock(xml);
            if (notificationDataBlock != null) {
                Document doc = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(notificationDataBlock.getBytes()));
                Node rootNode = XMLUtils.getRootNode((Document)doc, (String)NODE_POLICY_SERVICE);
                if (rootNode != null) {
                    Node notificationNode = XMLUtils.getChildNode((Node)rootNode, (String)NODE_POLICY_NOTIFICATION);
                    if (notificationNode != null) {
                        return PolicyNotification.parseXML(notificationNode);
                    }
                    debug.error("ResultsCacheUtil.extractPolicyNotification():cannot find notification node");
                    throw new PolicyEvaluationException("amPolicy", "invalid_root_element", null, null);
                }
                debug.error("ResultsCacheUtil.extractPolicyNotification():");
                return policyNotification;
            } else {
                debug.error("ResultsCacheUtil:extractPolicyNotification():notification data block is null");
            }
            return policyNotification;
        }
        catch (Exception xe) {
            debug.error("ResultsCacheUtil.extractPolicyNotification():", (Throwable)xe);
            throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, xe);
        }
    }

    private static String getNotificationDataBlock(String xml) {
        int idx = xml.indexOf(BEGIN_XML_DATA_BLOCK);
        if (idx != -1 && (idx = (xml = xml.substring(idx + BEGIN_XML_DATA_BLOCK.length())).indexOf(END_XML_DATA_BLOCK)) != -1) {
            return xml.substring(0, idx);
        }
        return null;
    }
}

