/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.configuration;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.AttributeStruct;
import com.sun.identity.common.PropertiesFinder;
import com.sun.identity.configuration.FedLibSystemProperties;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class FedSystemProperties
extends FedLibSystemProperties {
    private static Map attributeMap = new HashMap();

    private static void initAttributeMapping() {
        if (systemConfigProps != null) {
            systemConfigProps.clear();
        }
        ResourceBundle rb = ResourceBundle.getBundle("serverAttributeMap");
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String propertyName = e.nextElement();
            attributeMap.put(propertyName, new AttributeStruct(rb.getString(propertyName)));
        }
    }

    public String get(String key) {
        AttributeStruct ast;
        String value = null;
        if (this.isServerMode() && (ast = (AttributeStruct)attributeMap.get(key)) != null) {
            value = PropertiesFinder.getProperty((String)key, (AttributeStruct)ast);
        }
        return value != null ? value : this.getPropertyValue(key);
    }

    private boolean isServerMode() {
        return Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.serverMode"));
    }

    private String getPropertyValue(String key) {
        String value = super.get(key);
        if (value != null && value.trim().length() > 0) {
            return value;
        }
        if (key.equals("com.sun.identity.common.serverMode")) {
            return SystemProperties.get((String)"com.iplanet.am.serverMode");
        }
        return SystemProperties.get((String)key);
    }

    public Collection getServerList() throws Exception {
        return WebtopNaming.getPlatformServerList((boolean)false);
    }

    public URL getServiceURL(String serviceName, String protocol, String hostname, int port, String uri) throws Exception {
        return WebtopNaming.getServiceURL((String)serviceName, (String)protocol, (String)hostname, (String)("" + port), (String)uri);
    }

    static {
        FedSystemProperties.initAttributeMapping();
    }
}

