/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.ldap.ObjectClassManager;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class CommonUtils {
    private static final String LOCALE_PROPERTY = "Locale";
    private static final String AM_SDK_DEBUG_FILE_PROPS = "com.iplanet.am.sdk.ldap.debugFileName";
    private static final String AM_SDK_DEBUG_FILE = "amProfile_ldap";
    private static SSOToken internalToken = null;
    protected static Debug debug;
    protected static Map supportedTypes;
    protected static Map supportedNames;
    protected static Map creationtemplateMap;
    protected static Map statusAttributeMap;
    protected static Map searchtemplateMap;
    private static final String LOCALE_INTEGRATION_PROPERTY = "locale.integration";
    protected static boolean integrateLocale;

    CommonUtils() {
    }

    protected static SSOToken getInternalToken() {
        if (internalToken == null) {
            internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return internalToken;
    }

    protected static Debug getDebugInstance() {
        return debug;
    }

    protected static String getUserLocale(SSOToken token) {
        try {
            String locale = token.getProperty(LOCALE_PROPERTY);
            if (debug.messageEnabled()) {
                debug.message("CommonUtils.getUserLocale(): locale = " + locale);
            }
            return locale;
        }
        catch (SSOException ssoe) {
            debug.error("CommonUtils.getUserLocale(): missing locale, setting to null");
            return null;
        }
    }

    protected static AttrSet combineAttrSets(AttrSet attrSet1, AttrSet attrSet2) {
        Attr attr;
        int i;
        int count;
        AttrSet retAttrSet = new AttrSet();
        if (attrSet1 != null) {
            count = attrSet1.size();
            for (i = 0; i < count; ++i) {
                attr = attrSet1.elementAt(i);
                retAttrSet.add(attr);
            }
        }
        if (attrSet2 != null) {
            count = attrSet2.size();
            for (i = 0; i < count; ++i) {
                attr = attrSet2.elementAt(i);
                retAttrSet.add(attr);
            }
        }
        return retAttrSet;
    }

    protected static Map mergeMaps(Map mapA, Map mapB) {
        if (mapA == null && mapB == null) {
            return null;
        }
        if (mapA == null || mapA.isEmpty()) {
            return mapB;
        }
        if (mapB == null || mapB.isEmpty()) {
            return mapA;
        }
        Map bigMap = mapA.size() > mapB.size() ? mapA : mapB;
        Map smallMap = mapA.size() <= mapB.size() ? mapA : mapB;
        for (String attrName : smallMap.keySet()) {
            Set values = (Set)bigMap.get(attrName);
            if (values != null) {
                values.addAll((Set)smallMap.get(attrName));
                continue;
            }
            bigMap.put(attrName, (Set)smallMap.get(attrName));
        }
        return bigMap;
    }

    protected static String mapSetToString(Map map) {
        StringBuffer sb = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            for (String name : map.keySet()) {
                Set values = (Set)map.get(name);
                sb.append("\n\tName: ").append(name);
                sb.append(" Values: ").append(values.toString());
            }
        } else {
            sb.append("<empty>");
        }
        return sb.toString();
    }

    protected static String mapByteToString(Map map) {
        StringBuffer sb = new StringBuffer();
        if (map != null && !map.isEmpty()) {
            for (String name : map.keySet()) {
                byte[][] values = (byte[][])map.get(name);
                sb.append("\n\tName: ").append(name);
                sb.append(" Values: ").append(values);
            }
        } else {
            sb.append("<empty>");
        }
        return sb.toString();
    }

    protected static Set getSetCopy(Set values) {
        HashSet<String> copyValues = Collections.EMPTY_SET;
        if (!values.isEmpty()) {
            copyValues = new HashSet<String>(values.size());
            for (String value : values) {
                copyValues.add(value);
            }
        }
        return copyValues;
    }

    protected static Set stringArrayToSet(String[] strs) {
        int count = strs.length;
        HashSet<String> set = count > 0 ? new HashSet<String>(count) : new HashSet();
        for (int i = 0; i < count; ++i) {
            set.add(strs[i]);
        }
        return set;
    }

    protected static Map attrSetToMap(AttrSet attrSet) {
        return CommonUtils.attrSetToMap(attrSet, false);
    }

    protected static Map attrSetToMap(AttrSet attrSet, boolean fetchByteValues) {
        AMHashMap attributesMap = new AMHashMap(fetchByteValues);
        if (attrSet == null) {
            return attributesMap;
        }
        int attrSetSize = attrSet.size();
        if (!fetchByteValues) {
            for (int i = 0; i < attrSetSize; ++i) {
                Attr attr = attrSet.elementAt(i);
                String[] values = attr.getStringValues();
                attributesMap.put(attr.getName(), CommonUtils.stringArrayToSet(values));
            }
        } else {
            for (int i = 0; i < attrSetSize; ++i) {
                Attr attr = attrSet.elementAt(i);
                attributesMap.put(attr.getName(), attr.getByteValues());
            }
        }
        return attributesMap;
    }

    protected static AttrSet mapToAttrSet(Map map) {
        return CommonUtils.mapToAttrSet(map, false);
    }

    protected static AttrSet mapToAttrSet(Map map, boolean byteValues) {
        AttrSet attrSet = new AttrSet();
        if (map == null) {
            return attrSet;
        }
        if (!byteValues) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String attrName = itr.next().toString();
                Set set = (Set)map.get(attrName);
                String[] attrValues = set == null ? null : set.toArray(new String[set.size()]);
                if (attrValues == null) continue;
                attrSet.replace(new Attr(attrName, attrValues));
            }
        } else {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String attrName = itr.next().toString();
                byte[][] attrValues = (byte[][])map.get(attrName);
                if (attrValues == null) continue;
                attrSet.replace(new Attr(attrName, attrValues));
            }
        }
        return attrSet;
    }

    protected static Guid[] toGuidArray(Set set) {
        Object[] obj = set.toArray();
        Guid[] ss = new Guid[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            ss[i] = new Guid((String)obj[i]);
        }
        return ss;
    }

    protected static Guid[] getGuidArray(Set set) {
        return set.toArray(new Guid[set.size()]);
    }

    protected static String formatToRFC(String dn) {
        return new DN(dn).toRFCString().toLowerCase();
    }

    protected static String getPrincipalDN(SSOToken token) throws SSOException {
        String principalName = token.getPrincipal().getName();
        return CommonUtils.formatToRFC(principalName);
    }

    protected static Set combineOCs(Set one, Set two) {
        if (one == null || one.isEmpty()) {
            return two;
        }
        if (two == null || two.isEmpty()) {
            return one;
        }
        HashSet<String> resultSet = new HashSet<String>();
        for (String value1 : one) {
            resultSet.add(value1.toLowerCase());
        }
        for (String value2 : two) {
            resultSet.add(value2.toLowerCase());
        }
        return resultSet;
    }

    protected static boolean isObjectClassPresent(Set objectClasses, String objectClass) {
        if (objectClasses != null && !objectClasses.isEmpty()) {
            for (String serviceOC : objectClasses) {
                if (!serviceOC.equalsIgnoreCase(objectClass)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set updateAndGetRemovableOCs(Set origSet, Set removeOCs) {
        HashSet<String> returnOCs = removeOCs;
        if (removeOCs != null && !removeOCs.isEmpty()) {
            returnOCs = new HashSet<String>();
            block0: for (String origOC : origSet) {
                for (String removeOC : removeOCs) {
                    if (!origOC.equalsIgnoreCase(removeOC)) continue;
                    returnOCs.add(origOC);
                    continue block0;
                }
            }
            origSet.removeAll(returnOCs);
        }
        return returnOCs;
    }

    protected static Map removeEmptyValues(Map attrMap) {
        HashMap finalMap = new HashMap();
        for (String tStr : attrMap.keySet()) {
            Set s = (Set)attrMap.get(tStr);
            if (s.isEmpty()) continue;
            finalMap.put(tStr, attrMap.get(tStr));
        }
        return finalMap;
    }

    protected static boolean populateManagedObjects() {
        try {
            ServiceConfigManager scm = new ServiceConfigManager("DAI", CommonUtils.getInternalToken());
            ServiceConfig gc = scm.getGlobalConfig(null);
            Set managedObjects = gc.getSubConfigNames("*", "ManagedObjects");
            if (managedObjects == null || managedObjects.isEmpty()) {
                debug.message("CommonUtils.populateManagedObject managedObjects=null");
                return false;
            }
            for (String mo : managedObjects) {
                ServiceConfig sc = gc.getSubConfig(mo = mo.toLowerCase());
                if (sc == null) continue;
                Map attrs = sc.getAttributes();
                Set ocSet = (Set)attrs.get("objectclass");
                Set ctSet = (Set)attrs.get("creationtemplatename");
                Set stSet = (Set)attrs.get("searchtemplatename");
                Set typeSet = (Set)attrs.get("type");
                Set stAttr = (Set)attrs.get("statusattribute");
                String oc = CommonUtils.getObjectClass(ocSet, mo);
                String ct = CommonUtils.getCreationTemplateName(ctSet, mo);
                String st = CommonUtils.getSearchTemplateName(stSet, mo);
                String stAttrName = CommonUtils.getStatusAttributeName(stAttr);
                String typeS = (String)typeSet.iterator().next();
                supportedTypes.put(mo, typeS);
                supportedNames.put(typeS, mo);
                if (oc != null) {
                    ObjectClassManager.objectClassMap.put(typeS, oc);
                    ObjectClassManager.objectTypeMap.put(oc, typeS);
                }
                if (st != null) {
                    searchtemplateMap.put(typeS, st);
                }
                if (ct != null) {
                    creationtemplateMap.put(typeS, ct);
                }
                if (stAttrName == null) continue;
                statusAttributeMap.put(typeS, stAttrName);
            }
            if (debug.messageEnabled()) {
                debug.message("CreationTemplate MAP = " + creationtemplateMap.toString());
                debug.message("SearchTemplate Map = " + searchtemplateMap.toString());
                debug.message("ObjectClass-Type Map = " + ObjectClassManager.objectClassMap.toString());
                debug.message("Type-ObjectClass MAP = " + ObjectClassManager.objectTypeMap.toString());
                debug.message("Supported names-type = " + supportedTypes.toString());
                debug.message("Status Attributes= " + statusAttributeMap.toString());
            }
        }
        catch (SMSException se) {
            return false;
        }
        catch (SSOException ssoe) {
            return false;
        }
        return true;
    }

    protected static void populateManagedObjectsWithDefaults() {
    }

    private static String getObjectClass(Set ocSet, String objectName) {
        if (ocSet == null || ocSet.isEmpty()) {
            return null;
        }
        return ((String)ocSet.iterator().next()).toLowerCase();
    }

    private static String getCreationTemplateName(Set ocSet, String objectName) {
        if (ocSet == null || ocSet.isEmpty()) {
            return null;
        }
        return (String)ocSet.iterator().next();
    }

    private static String getSearchTemplateName(Set ocSet, String objectName) {
        if (ocSet == null || ocSet.isEmpty()) {
            return null;
        }
        return (String)ocSet.iterator().next();
    }

    private static String getStatusAttributeName(Set stSet) {
        if (stSet == null || stSet.isEmpty()) {
            return null;
        }
        return (String)stSet.iterator().next();
    }

    static {
        supportedTypes = new HashMap();
        supportedNames = new HashMap();
        creationtemplateMap = new HashMap();
        statusAttributeMap = new HashMap();
        searchtemplateMap = new HashMap();
        integrateLocale = true;
        debug = Debug.getInstance((String)SystemProperties.get(AM_SDK_DEBUG_FILE_PROPS, AM_SDK_DEBUG_FILE));
        String cCaller = SystemProperties.get(LOCALE_INTEGRATION_PROPERTY);
        if (cCaller == null || cCaller.equalsIgnoreCase("true")) {
            integrateLocale = true;
            if (debug.messageEnabled()) {
                debug.message("AM SDK: Locale integration enabled");
            }
        } else {
            integrateLocale = false;
        }
        CommonUtils.populateManagedObjects();
    }
}

