/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.UI;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.identity.authentication.UI.AuthViewBeanBase;
import com.sun.identity.authentication.UI.LoginViewBean;
import com.sun.identity.authentication.client.AuthClientUtils;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthExceptionViewBean
extends AuthViewBeanBase {
    static AuthD ad = AuthD.getAuth();
    public static final String PAGE_NAME = "AuthException";
    static Debug exDebug = Debug.getInstance((String)"amAuthExceptionViewBean");
    HttpServletRequest request;
    HttpServletResponse response;
    AuthContextLocal ac = null;
    public String ResultVal = "";
    private static String LOGINURL = "";
    public ResourceBundle rb = null;
    public static final String URL_LOGIN = "urlLogin";
    public static final String TXT_EXCEPTION = "StaticTextException";
    public static final String TXT_GOTO_LOGIN_AFTER_FAIL = "txtGotoLoginAfterFail";
    public static final String HTML_TITLE_AUTH_EXCEPTION = "htmlTitle_AuthException";

    public AuthExceptionViewBean() {
        super(PAGE_NAME);
        exDebug.message("AuthExceptionViewBean() constructor called");
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(URL_LOGIN, StaticTextField.class);
        this.registerChild(TXT_EXCEPTION, StaticTextField.class);
        this.registerChild(TXT_GOTO_LOGIN_AFTER_FAIL, StaticTextField.class);
    }

    public void forwardTo(RequestContext requestContext) {
        exDebug.message("In forwardTo()");
        if (requestContext != null) {
            this.request = requestContext.getRequest();
            this.response = requestContext.getResponse();
        }
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Expires", "0");
        if (ad == null) {
            super.forwardTo(requestContext);
            return;
        }
        try {
            this.ac = AuthUtils.getAuthContext(this.request, this.response, AuthUtils.getSessionIDFromRequest(this.request), false, false);
        }
        catch (Exception e) {
            if (e instanceof L10NMessage) {
                java.util.Locale locale = Locale.getLocale((String)AuthUtils.getLocale(this.ac));
                this.ResultVal = ((L10NMessage)e).getL10NMessage(locale);
            }
            this.ResultVal = e.getMessage();
        }
        if (this.ac == null || AuthUtils.sessionTimedOut(this.ac)) {
            try {
                if (exDebug.messageEnabled()) {
                    exDebug.message("Goto Login URL : " + LOGINURL);
                }
                this.response.sendRedirect(LOGINURL);
            }
            catch (Exception exception) {}
        } else {
            super.forwardTo(requestContext);
        }
    }

    public String getDisplayURL() {
        exDebug.message("In getDisplayURL()");
        if (ad == null) {
            return new StringBuffer().append(File.separator).append("config").append(File.separator).append("auth").append(File.separator).append("default").append(File.separator).append("Exception.jsp").toString();
        }
        java.util.Locale locale = Locale.getLocale((String)AuthUtils.getLocale(this.ac));
        String client = AuthUtils.getClientType(this.request);
        this.rb = rbCache.getResBundle("amAuthUI", locale);
        if (this.rb == null) {
            return AuthUtils.getFileName(this.ac, "Exception.jsp");
        }
        return AuthUtils.getFileName(this.ac, "authException.jsp");
    }

    protected View createChild(String name) {
        if (exDebug.messageEnabled()) {
            exDebug.message("In createChild() : child name = " + name);
        }
        if (name.equals(TXT_EXCEPTION)) {
            return new StaticTextField((ContainerView)this, name, (Object)this.ResultVal);
        }
        if (name.equals(TXT_GOTO_LOGIN_AFTER_FAIL)) {
            return new StaticTextField((ContainerView)this, name, (Object)"");
        }
        if (name.equals(URL_LOGIN)) {
            String loginURL = AuthUtils.encodeURL(LOGINURL, this.ac, this.response);
            return new StaticTextField((ContainerView)this, name, (Object)loginURL);
        }
        if (name.equals(HTML_TITLE_AUTH_EXCEPTION)) {
            String exceptionTitle = this.rb.getString(HTML_TITLE_AUTH_EXCEPTION);
            return new StaticTextField((ContainerView)this, name, (Object)exceptionTitle);
        }
        return super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        if (ad != null) {
            try {
                String cookieDomain2 = null;
                Set cookieDomainSet = AuthClientUtils.getCookieDomainsForReq(this.request);
                this.setPageEncoding(this.request, this.response);
                if (cookieDomainSet.isEmpty()) {
                    Cookie cookie = AuthUtils.getLogoutCookie(this.ac, null);
                    this.response.addCookie(cookie);
                    if (AuthUtils.getPersistentCookieMode(this.ac)) {
                        cookie = AuthUtils.clearPersistentCookie(null, this.ac);
                        if (exDebug.messageEnabled()) {
                            exDebug.message("Clearing persistent cookie: null cookie domain");
                            exDebug.message("Persistent cookie: " + cookie);
                        }
                        this.response.addCookie(cookie);
                    }
                } else {
                    for (String cookieDomain2 : cookieDomainSet) {
                        Cookie cookie = AuthUtils.getLogoutCookie(this.ac, cookieDomain2);
                        this.response.addCookie(cookie);
                        if (!AuthUtils.getPersistentCookieMode(this.ac)) continue;
                        cookie = AuthUtils.clearPersistentCookie(cookieDomain2, this.ac);
                        if (exDebug.messageEnabled()) {
                            exDebug.message("Clearing persistent cookie: " + cookieDomain2);
                            exDebug.message("Persistent cookie: " + cookie);
                        }
                        this.response.addCookie(cookie);
                    }
                }
                AuthUtils.clearlbCookie(this.request, this.response);
                this.ResultVal = this.rb.getString("uncaught_exception");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (exDebug.messageEnabled()) {
                    exDebug.message("error in getting Exception : " + e.getMessage());
                }
                this.ResultVal = this.rb.getString("uncaught_exception") + " : " + e.getMessage();
            }
        }
    }

    public void handleHrefExceptionRequest(RequestInvocationEvent event) throws ServletException, IOException {
        ViewBean targetView = this.getViewBean(LoginViewBean.class);
        targetView.forwardTo(this.getRequestContext());
    }

    public boolean beginHrefExceptionDisplay(ChildDisplayEvent event) {
        return true;
    }

    public boolean beginContentHrefExceptionDisplay(ChildDisplayEvent event) {
        this.setDisplayFieldValue(TXT_GOTO_LOGIN_AFTER_FAIL, this.rb.getString("gotoLoginAfterFail"));
        return true;
    }

    public boolean beginStaticTextExceptionDisplay(ChildDisplayEvent event) {
        return true;
    }

    public String getTileIndex() {
        return "";
    }

    public boolean beginContentStaticTextExceptionDisplay(ChildDisplayEvent event) {
        return true;
    }

    static {
        LOGINURL = serviceUri + "/UI/Login";
    }
}

