/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.sun.identity.authentication.internal.AuthContext;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class AuthLoginThread
extends Thread
implements CallbackHandler {
    private AuthContext loginContext;

    protected AuthLoginThread(AuthContext ctx) {
        AuthContext.authDebug.message("AuthLoginThread::Constructor");
        this.loginContext = ctx;
    }

    public void run() {
        AuthContext.authDebug.message("AuthLoginThread::run()");
        try {
            this.loginContext.loginContext.login();
            this.loginContext.setLoginStatus(3);
            AuthContext.authDebug.message("AuthLoginThread::run() successful login");
        }
        catch (LoginException le) {
            this.loginContext.setLoginStatus(4);
            this.loginContext.loginException = le;
            AuthContext.authDebug.message("AuthLoginThread::run() exception during login; " + le);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Callback[] callback) throws IOException, UnsupportedCallbackException {
        AuthContext.authDebug.message("AuthLoginThread::handle()");
        this.loginContext.submittedInformation = null;
        AuthLoginThread authLoginThread = this;
        synchronized (authLoginThread) {
            this.loginContext.informationRequired = callback;
            this.notify();
        }
        AuthContext.authDebug.message("AuthLoginThread::handle() sent notify to wake up sleeping threads");
        while (this.loginContext.submittedInformation == null) {
            try {
                AuthContext.authDebug.message("AuthLoginThread::handle() waiting for Callbacks to be submitted");
                authLoginThread = this;
                synchronized (authLoginThread) {
                    if (this.loginContext.submittedInformation == null) {
                        this.wait();
                    }
                }
                AuthContext.authDebug.message("AuthLoginThread::handle() woke up from waiting for Callbacks to be submitted");
            }
            catch (InterruptedException interruptedException) {}
        }
        this.loginContext.loginContext.updateSharedState(this.loginContext.submittedInformation);
        callback = this.loginContext.submittedInformation;
    }
}

