/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal.server;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.ums.Guid;
import com.iplanet.ums.TemplateManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import com.sun.identity.authentication.internal.util.AuthI18n;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.LDAPSocketFactory;
import com.sun.identity.shared.ldap.factory.JSSESocketFactory;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.ServiceManager;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class LocalLdapAuthModule
implements LoginModule {
    private static final String UIDATTR = "uid";
    private static final String TEMPLATE_NAME = "BasicUser";
    private static Debug debug = Debug.getInstance((String)"amAuthInternalLDAPModule");
    private boolean readServerConfiguration = false;
    private String baseDN = null;
    private LDAPConnection conn = null;
    private CallbackHandler cbHandler;
    private AuthSubject subject;
    private Map sharedState;
    private Map options;
    private String userDN;

    public void initialize(AuthSubject subject, CallbackHandler handle, Map sharedState, Map options) {
        this.subject = subject;
        this.cbHandler = handle;
        this.sharedState = sharedState;
        this.options = options;
    }

    public boolean login() throws LoginException {
        String uid = (String)this.sharedState.get("javax.security.auth.login.name");
        String strPasswd = (String)this.sharedState.get("javax.security.auth.login.password");
        if (debug.messageEnabled()) {
            debug.message("LocalLdapAuthModule::login() From shared state: Username: " + uid + " Password: " + (strPasswd == null ? "<not present>" : "<present>"));
        }
        if (uid == null || strPasswd == null) {
            Callback[] cbs = new Callback[]{new NameCallback("User name: "), new PasswordCallback("Password: ", false)};
            try {
                if (debug.messageEnabled()) {
                    debug.message("LocalLdapAuthModule::login() Sending Name & Password Callback");
                }
                this.cbHandler.handle(cbs);
            }
            catch (UnsupportedCallbackException e) {
                throw new LoginException(e.getMessage());
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            uid = ((NameCallback)cbs[0]).getName();
            char[] passwd = ((PasswordCallback)cbs[1]).getPassword();
            if (passwd != null) {
                strPasswd = new String(passwd);
            }
        }
        boolean authentication = false;
        this.userDN = this.getDN(uid);
        if (strPasswd != null && strPasswd.length() != 0 && this.authenticate(this.userDN, strPasswd)) {
            authentication = true;
        }
        return authentication;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        Set principals = this.subject.getPrincipals();
        principals.add(new AuthPrincipal(this.userDN));
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean authenticate(String dn, String passwd) throws LoginException {
        localConn = null;
        orgUrl = (String)this.options.get("ORGANIZATION");
        if (orgUrl == null || orgUrl.equals("ldap://") || orgUrl.equals("ldaps://") || !orgUrl.startsWith("ldap://") && !orgUrl.startsWith("ldaps://")) {
            try {
                dscm = DSConfigMgr.getDSConfigMgr();
                si = dscm.getServerInstance("default", LDAPUser.Type.AUTH_BASIC);
                hostName = dscm.getHostName("default");
                if (si.getConnectionType() == Server.Type.CONN_SSL) {
                    try {
                        localConn = new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null));
                    }
                    catch (Exception e) {
                        LocalLdapAuthModule.debug.error("getConnection.JSSESocketFactory", (Throwable)e);
                        throw new LDAPServiceException(AuthI18n.authI18n.getString("dscfg-jssSockFactoryFail"));
                    }
                } else {
                    localConn = new LDAPConnection();
                }
                if (dn == null || passwd == null) {
                    throw new LoginException(AuthI18n.authI18n.getString("dscfg-connectFail"));
                }
                localConn.connect(3, hostName, 389, dn, passwd);
            }
            catch (LDAPServiceException ex) {
                LocalLdapAuthModule.debug.error("Authenticate failed: " + ex);
                throw new LoginException(ex.getMessage());
            }
            catch (LDAPException ex) {
                LocalLdapAuthModule.debug.error("Authenticate failed: " + (Object)ex);
                throw new LoginException(ex.getMessage());
            }
        }
        try {
            if (LocalLdapAuthModule.debug.messageEnabled()) {
                LocalLdapAuthModule.debug.message("authenticate(): orgUrl= " + orgUrl);
            }
            useSSL = false;
            if (orgUrl.startsWith("ldaps://")) {
                start = "ldaps://".length();
                useSSL = true;
            } else {
                start = "ldap://".length();
            }
            end = orgUrl.indexOf(58, start);
            if (end == -1 && (end = orgUrl.indexOf(47, start)) == -1) {
                end = orgUrl.length();
            }
            hostName = orgUrl.substring(start, end);
            portNumber = "389";
            start = end + 1;
            if (start < orgUrl.length()) {
                end = orgUrl.indexOf(47, start);
                if (end == -1) {
                    end = orgUrl.length();
                }
                portNumber = orgUrl.substring(start, end);
            }
            if (useSSL) {
                try {
                    localConn = new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null));
                    if (!LocalLdapAuthModule.debug.messageEnabled()) ** GOTO lbl56
                    LocalLdapAuthModule.debug.message("authenticate(): LDAPConnection created with new JSSESocetFactory");
                }
                catch (Exception e) {
                    LocalLdapAuthModule.debug.error("authentication().JSSESocketFactory()", (Throwable)e);
                    throw new LoginException(e.getMessage());
                }
            } else {
                localConn = new LDAPConnection();
            }
lbl56:
            // 3 sources

            if (LocalLdapAuthModule.debug.messageEnabled()) {
                LocalLdapAuthModule.debug.message("before connect(), hostName=" + hostName + ",port=" + portNumber);
            }
            localConn.connect(hostName, Integer.parseInt(portNumber));
        }
        catch (Exception e) {
            LocalLdapAuthModule.debug.error("authentication", (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        try {
            localConn.authenticate(3, dn, passwd);
        }
        catch (LDAPException ex) {
            throw new LoginException(ex.getMessage());
        }
        finally {
            try {
                localConn.disconnect();
            }
            catch (LDAPException e) {}
        }
        return true;
    }

    private String getDN(String uid) throws LoginException {
        String retVal = "";
        if (uid == null) {
            throw new LoginException(AuthI18n.authI18n.getString("com.iplanet.auth.invalid-username"));
        }
        if (DN.isDN((String)uid)) {
            return uid;
        }
        String namingAttribute = UIDATTR;
        try {
            String orgName = (String)this.options.get("ORGANIZATION");
            if (orgName != null && !DN.isDN((String)orgName)) {
                orgName = this.baseDN;
            }
            if (ServiceManager.isAMSDKConfigured()) {
                namingAttribute = TemplateManager.getTemplateManager().getCreationTemplate(TEMPLATE_NAME, orgName == null ? null : new Guid(orgName)).getNamingAttribute();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer filter = new StringBuffer();
        filter.append('(').append(namingAttribute).append('=').append(uid).append(')');
        String[] attrs = new String[]{"noAttr"};
        LDAPSearchResults results = null;
        try {
            if (!this.readServerConfiguration) {
                this.readServerConfig();
            }
            if (this.conn == null) {
                debug.warning("LocalLdapAuthModule.getDN(): lda connection is null");
                throw new LoginException("INVALID_USER_NAME");
            }
            results = this.conn.search(this.baseDN, 2, filter.toString(), attrs, false);
        }
        catch (LDAPException ex) {
            throw new LoginException(ex.getMessage());
        }
        finally {
            try {
                this.conn.disconnect();
                this.conn = null;
            }
            catch (Exception e) {
                this.conn = null;
            }
        }
        LDAPEntry entry = null;
        try {
            if (results.hasMoreElements()) {
                entry = results.next();
                retVal = entry.getDN();
            }
        }
        catch (LDAPException ex) {
            throw new LoginException(ex.getMessage());
        }
        if (retVal == "") {
            throw new LoginException("INVALID_USER_NAME");
        }
        return retVal;
    }

    private void readServerConfig() throws LoginException {
        if (this.readServerConfiguration) {
            return;
        }
        try {
            DSConfigMgr cfgMgr = DSConfigMgr.getDSConfigMgr();
            this.conn = cfgMgr.getNewBasicConnection();
            ServerInstance si = cfgMgr.getServerInstance("default", LDAPUser.Type.AUTH_BASIC);
            this.baseDN = si.getBaseDN();
            this.readServerConfiguration = true;
        }
        catch (LDAPServiceException ex) {
            throw new LoginException(ex.getMessage());
        }
    }
}

