/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.jdbc;

import com.sun.identity.authentication.modules.jdbc.JDBCPasswordSyntaxTransform;
import com.sun.identity.authentication.modules.jdbc.JDBCPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.sql.DataSource;

public class JDBC
extends AMLoginModule {
    private String userTokenId;
    private String userName;
    private String password;
    private String resultPassword;
    private char[] passwordCharArray;
    private Principal userPrincipal = null;
    private String errorMsg = null;
    private static final String amAuthJDBC = "amAuthJDBC";
    private static Debug debug = Debug.getInstance((String)"amAuthJDBC");
    private ResourceBundle bundle = null;
    private Map options;
    private static String CONNECTIONTYPE = "sunAMAuthJDBCConnectionType";
    private static String JNDINAME = "sunAMAuthJDBCJndiName";
    private static String DRIVER = "sunAMAuthJDBCDriver";
    private static String URL = "sunAMAuthJDBCUrl";
    private static String DBUSER = "sunAMAuthJDBCDbuser";
    private static String DBPASSWORD = "sunAMAuthJDBCDbpassword";
    private static String PASSWORDCOLUMN = "sunAMAuthJDBCPasswordColumn";
    private static String STATEMENT = "sunAMAuthJDBCStatement";
    private static String TRANSFORM = "sunAMAuthJDBCPasswordSyntaxTransformPlugin";
    private static String AUTHLEVEL = "sunAMAuthJDBCAuthLevel";
    private static String DEFAULT_TRANSFORM = "com.sun.identity.authentication.modules.jdbc.ClearTextTransform";
    private String driver;
    private String connectionType;
    private String jndiName;
    private String url;
    private String dbuser;
    private String dbpassword;
    private String passwordColumn;
    private String statement;
    private String transform;
    private Map sharedState;
    private boolean getCredentialsFromSharedState = false;
    private static final int MAX_NAME_LENGTH = 80;
    private boolean useJNDI = false;

    public JDBC() {
        debug.message("JDBC()");
    }

    public void init(Subject subject, Map sharedState, Map options) {
        debug.message("in initialize...");
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthJDBC, locale);
        if (debug.messageEnabled()) {
            debug.message("amAuthJDBC Authentication resource bundle locale=" + locale);
        }
        this.options = options;
        this.sharedState = sharedState;
        if (options != null) {
            try {
                this.connectionType = CollectionHelper.getMapAttr((Map)options, (String)CONNECTIONTYPE);
                if (this.connectionType == null) {
                    debug.message("No CONNECTIONTYPE for configuring");
                    this.errorMsg = "noCONNECTIONTYPE";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for CONNECTIONTYPE: " + this.connectionType);
                }
                if (this.connectionType.equals("JNDI")) {
                    this.useJNDI = true;
                }
                if (this.useJNDI) {
                    debug.message("Using JNDI Retrieved Connection pool");
                    this.jndiName = CollectionHelper.getMapAttr((Map)options, (String)JNDINAME);
                    if (this.jndiName == null) {
                        debug.message("No JNDINAME for configuring");
                        this.errorMsg = "noJNDINAME";
                        return;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Found config for JNDINAME: " + this.jndiName);
                    }
                } else {
                    debug.message("Using non pooled JDBC");
                    this.driver = CollectionHelper.getMapAttr((Map)options, (String)DRIVER);
                    if (this.driver == null) {
                        debug.message("No DRIVER for configuring");
                        this.errorMsg = "noDRIVER";
                        return;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Found config for DRIVER: " + this.driver);
                    }
                }
                this.url = CollectionHelper.getMapAttr((Map)options, (String)URL);
                if (this.url == null) {
                    debug.message("No URL for configuring");
                    this.errorMsg = "noURL";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for URL: " + this.url);
                }
                this.dbuser = CollectionHelper.getMapAttr((Map)options, (String)DBUSER);
                if (this.dbuser == null) {
                    debug.message("No DBUSER for configuring");
                    this.errorMsg = "noDBUSER";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for DBUSER: " + this.dbuser);
                }
                this.dbpassword = CollectionHelper.getMapAttr((Map)options, (String)DBPASSWORD, (String)"");
                if (this.dbpassword == null) {
                    debug.message("No DBPASSWORD for configuring");
                    this.errorMsg = "noDBPASSWORD";
                    return;
                }
                this.passwordColumn = CollectionHelper.getMapAttr((Map)options, (String)PASSWORDCOLUMN);
                if (this.passwordColumn == null) {
                    debug.message("No PASSWORDCOLUMN for configuring");
                    this.errorMsg = "noPASSWORDCOLUMN";
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("Found config for PASSWORDCOLUMN: " + this.passwordColumn);
                }
                this.statement = CollectionHelper.getMapAttr((Map)options, (String)STATEMENT);
                if (this.statement == null) {
                    debug.message("No STATEMENT for configuring");
                    this.errorMsg = "noSTATEMENT";
                }
                this.transform = CollectionHelper.getMapAttr((Map)options, (String)TRANSFORM);
                if (this.transform == null) {
                    if (debug.messageEnabled()) {
                        debug.message("No TRANSFORM for configuring.Using clear text");
                    }
                    this.transform = DEFAULT_TRANSFORM;
                } else if (debug.messageEnabled()) {
                    debug.message("Plugin for TRANSFORM: " + this.transform);
                }
                String authLevel = CollectionHelper.getMapAttr((Map)options, (String)AUTHLEVEL);
                if (authLevel != null) {
                    try {
                        this.setAuthLevel(Integer.parseInt(authLevel));
                    }
                    catch (Exception e) {
                        debug.error("Unable to set auth level " + authLevel, (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                debug.error("JDBC Init Exception", (Throwable)ex);
            }
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthJDBC, this.errorMsg, null);
        }
        if (debug.messageEnabled()) {
            debug.message("State: " + state);
        }
        if (state != 1) {
            throw new AuthLoginException(amAuthJDBC, "invalidState", null);
        }
        if (callbacks != null && callbacks.length == 0) {
            this.userName = (String)this.sharedState.get(this.getUserKey());
            this.password = (String)this.sharedState.get(this.getPwdKey());
            if (this.userName == null || this.password == null) {
                return 1;
            }
            this.getCredentialsFromSharedState = true;
        } else {
            this.userName = ((NameCallback)callbacks[0]).getName();
            if (debug.messageEnabled()) {
                debug.message("Authenticating this user: " + this.userName);
            }
            this.passwordCharArray = ((PasswordCallback)callbacks[1]).getPassword();
            this.password = new String(this.passwordCharArray);
            if (this.userName == null || this.userName.length() == 0) {
                throw new AuthLoginException(amAuthJDBC, "noUserName", null);
            }
        }
        this.storeUsernamePasswd(this.userName, this.password);
        if (this.userName.length() > 80) {
            throw new AuthLoginException(amAuthJDBC, "userNameTooLong", null);
        }
        Connection database = null;
        try {
            ResultSet results;
            if (this.useJNDI) {
                InitialContext initctx = new InitialContext();
                DataSource ds = (DataSource)initctx.lookup(this.jndiName);
                if (debug.messageEnabled()) {
                    debug.message("Datasource Acquired: " + ds.toString());
                }
                database = ds.getConnection();
                debug.message("Using JNDI Retrieved Connection pool");
            } else {
                Class.forName(this.driver);
                database = DriverManager.getConnection(this.url, this.dbuser, this.dbpassword);
            }
            if (debug.messageEnabled()) {
                debug.message("Connection Acquired: " + database.toString());
            }
            if (debug.messageEnabled()) {
                debug.message("PreparedStatement to build: " + this.statement);
            }
            PreparedStatement thisStatement = database.prepareStatement(this.statement);
            thisStatement.setString(1, this.userName);
            if (debug.messageEnabled()) {
                debug.message("Statement to execute: " + thisStatement);
            }
            if ((results = thisStatement.executeQuery()) == null) {
                debug.message("returned null from executeQuery()");
                throw new AuthLoginException(amAuthJDBC, "nullResult", null);
            }
            int index = 0;
            while (results.next()) {
                if (++index > 1) {
                    if (debug.messageEnabled()) {
                        debug.message("Too many results.UID should be a primary key");
                    }
                    throw new AuthLoginException(amAuthJDBC, "multiEntry", null);
                }
                this.resultPassword = results.getString(this.passwordColumn).trim();
            }
            if (index == 0) {
                if (debug.messageEnabled()) {
                    debug.message("No results from your SQL query.UID should be valid");
                }
                throw new AuthLoginException(amAuthJDBC, "nullResult", null);
            }
        }
        catch (Throwable e) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                int n = 1;
                return n;
            }
            if (debug.messageEnabled()) {
                debug.message("JDBC Exception:", e);
            }
            throw new AuthLoginException(e);
        }
        finally {
            block44: {
                if (database != null) {
                    try {
                        database.close();
                    }
                    catch (Exception dbe) {
                        debug.error("Error in closing database connection: " + dbe.getMessage());
                        if (!debug.messageEnabled()) break block44;
                        debug.message("Fail to close database:", (Throwable)dbe);
                    }
                }
            }
        }
        if (!this.transform.equals(DEFAULT_TRANSFORM)) {
            try {
                JDBCPasswordSyntaxTransform syntaxTransform = (JDBCPasswordSyntaxTransform)Class.forName(this.transform).newInstance();
                if (debug.messageEnabled()) {
                    debug.message("Got my Transform Object" + syntaxTransform.toString());
                }
                this.password = syntaxTransform.transform(this.password);
                if (debug.messageEnabled()) {
                    debug.message("Password transformed by: " + this.transform);
                }
            }
            catch (Throwable e) {
                if (debug.messageEnabled()) {
                    debug.message("Syntax Transform Exception:" + e.toString());
                }
                throw new AuthLoginException(e);
            }
        }
        if (this.password != null && this.password.equals(this.resultPassword)) {
            this.userTokenId = this.userName;
            return -1;
        }
        debug.message("password not match. Auth failed.");
        this.setFailureID(this.userName);
        throw new InvalidPasswordException(amAuthJDBC, "loginFailed", null, this.userName, null);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new JDBCPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUserdVars() {
        this.userName = null;
        this.password = null;
        this.resultPassword = null;
        this.passwordCharArray = null;
        this.errorMsg = null;
        this.bundle = null;
        this.options = null;
        this.driver = null;
        this.connectionType = null;
        this.jndiName = null;
        this.url = null;
        this.dbuser = null;
        this.dbpassword = null;
        this.passwordColumn = null;
        this.statement = null;
        this.transform = null;
        this.sharedState = null;
    }
}

