/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RealmRemoveServiceAttributes
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        try {
            Map origValues;
            String[] params = new String[]{realm, serviceName};
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            Set assignedServices = ocm.getAssignedServices(true);
            AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity ai = repo.getRealmIdentity();
            Set servicesFromIdRepo = ai.getAssignedServices();
            boolean modified = false;
            if (assignedServices.contains(serviceName)) {
                this.writeLog(0, Level.INFO, "ATTEMPT_REALM_REMOVE_SERVICE_ATTR_VALUES", params);
                origValues = ocm.getServiceAttributes(serviceName);
                if (AttributeValues.mergeAttributeValues(origValues, attributeValues, false)) {
                    ocm.modifyService(serviceName, origValues);
                }
                this.writeLog(0, Level.INFO, "SUCCEED_REALM_REMOVE_SERVICE_ATTR_VALUES", params);
                modified = true;
            }
            if (servicesFromIdRepo.contains(serviceName)) {
                this.writeLog(0, Level.INFO, "ATTEMPT_REALM_REMOVE_SERVICE_ATTR_VALUES", params);
                origValues = ai.getServiceAttributes(serviceName);
                if (AttributeValues.mergeAttributeValues(origValues, attributeValues, false)) {
                    ai.modifyService(serviceName, origValues);
                }
                this.writeLog(0, Level.INFO, "SUCCEED_REALM_REMOVE_SERVICE_ATTR_VALUES", params);
                modified = true;
            }
            if (modified) {
                outputWriter.printlnMessage(this.getResourceString("realm-remove-service-attributes-succeed"));
                outputWriter.printlnMessage("");
                outputWriter.printlnMessage(FormatUtils.printAttributeValues("{0}={1}", attributeValues));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("realm-remove-service-attributes-not-assigned"), params));
            }
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmRemoveServiceAttributes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REALM_REMOVE_SERVICE_ATTR_VALUES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmRemoveServiceAttributes.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REALM_REMOVE_SERVICE_ATTR_VALUES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmRemoveServiceAttributes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REALM_REMOVE_SERVICE_ATTR_VALUES", args);
            throw new CLIException(e, 127);
        }
    }
}

