/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.wsfederation.common.WSFederationConstants;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.plugins.DefaultLibrarySPAccountMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DefaultADFSPartnerAccountMapper
extends DefaultLibrarySPAccountMapper {
    public DefaultADFSPartnerAccountMapper() {
        debug.message("DefaultADFSPartnerAccountMapper.constructor: ");
    }

    protected Map getSearchParameters(NameIdentifier nameID, String realm, String hostEntityID, String remoteEntityID) throws WSFederationException {
        String classMethod = "DefaultADFSPartnerAccountMapper.getSearchParameters: ";
        IDPSSOConfigElement idpConfig = null;
        try {
            idpConfig = WSFederationMetaManager.getIDPSSOConfig((String)realm, (String)remoteEntityID);
        }
        catch (WSFederationMetaException wsfme) {
            throw new WSFederationException((Throwable)wsfme);
        }
        String nameIdAttribute = WSFederationMetaUtils.getAttribute((BaseConfigType)idpConfig, (String)"nameIdAttribute");
        if (nameIdAttribute == null || nameIdAttribute.length() == 0) {
            nameIdAttribute = "uid";
        }
        String domainAttribute = WSFederationMetaUtils.getAttribute((BaseConfigType)idpConfig, (String)"domainAttribute");
        String strNameIncludesDomain = WSFederationMetaUtils.getAttribute((BaseConfigType)idpConfig, (String)"nameIncludesDomain");
        boolean nameIncludesDomain = Boolean.valueOf(strNameIncludesDomain);
        String nameValue = nameID.getName();
        if (nameValue == null || nameValue.length() == 0) {
            throw new WSFederationException("libWSFederation", "nullNameID", null);
        }
        HashMap keyMap = new HashMap();
        String name = null;
        if (nameID.getFormat().equals(WSFederationConstants.NAMED_CLAIM_TYPES[0]) && !nameIncludesDomain) {
            int atSign = nameValue.indexOf(64);
            if (atSign == -1) {
                Object[] args = new String[]{nameValue};
                throw new WSFederationException("libWSFederation", "missingAtInUpn", args);
            }
            name = nameValue.substring(0, atSign);
            String upnDomain = nameValue.substring(atSign + 1);
            if (domainAttribute != null && domainAttribute.length() > 0) {
                HashSet<String> set = new HashSet<String>();
                set.add(upnDomain);
                keyMap.put(domainAttribute, set);
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "domain is " + upnDomain);
            }
        } else {
            name = nameValue;
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "name is " + name);
        }
        HashSet<String> set = new HashSet<String>();
        set.add(name);
        keyMap.put(nameIdAttribute, set);
        return keyMap;
    }

    protected boolean isDynamicalOrIgnoredProfile(String realm) {
        try {
            OrganizationConfigManager orgConfigMgr = AuthD.getAuth().getOrgConfigManager(realm);
            ServiceConfig svcConfig = orgConfigMgr.getServiceConfig("iPlanetAMAuthService");
            Map attrs = svcConfig.getAttributes();
            String tmp = CollectionHelper.getMapAttr((Map)attrs, (String)"iplanet-am-auth-dynamic-profile-creation");
            if (debug.messageEnabled()) {
                debug.message("dynamicalCreationEnabled, attr=" + tmp);
            }
            return tmp != null && (tmp.equalsIgnoreCase("createAlias") || tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("ignore"));
        }
        catch (Exception e) {
            debug.error("dynamicalCreationEnabled, unable to get attribute", (Throwable)e);
            return false;
        }
    }
}

