/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.logging.LogUtil;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.BinarySecurityToken;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.UserNameToken;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecureSOAPMessage {
    private SOAPMessage soapMessage = null;
    private SecurityToken securityToken = null;
    private SecurityMechanism securityMechanism = null;
    private boolean create = false;
    private Element wsseHeader = null;
    private X509Certificate messageCertificate = null;
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private String server_proto = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.protocol");
    private String server_host = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host");
    private String server_port = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.port");
    private List signingIds = new ArrayList();
    private String messageID = null;
    private long msgTimestamp = 0L;

    public SecureSOAPMessage(SOAPMessage soapMessage, boolean create) throws SecurityException {
        this.soapMessage = soapMessage;
        this.create = create;
        if (debug.messageEnabled()) {
            debug.message("SecureSOAPMessage.Input SOAP message : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        if (!create) {
            this.parseSOAPMessage(soapMessage);
        } else {
            soapMessage.getSOAPPart().normalize();
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.Input SOAP message After normalization: " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
            }
            this.addNameSpaces();
            this.addSecurityHeader();
        }
    }

    public Element getSecurityHeaderElement() {
        return this.wsseHeader;
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public void setSOAPMessage(SOAPMessage inSoapMessage) {
        this.soapMessage = inSoapMessage;
    }

    private void parseSOAPMessage(SOAPMessage soapMessage) throws SecurityException {
        try {
            NodeList headerChildNodes;
            SOAPHeader header = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (header == null && debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.parseSOAPMessage: No SOAP header found.");
            }
            if (((headerChildNodes = header.getChildNodes()) == null || headerChildNodes.getLength() == 0) && debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.parseSOAPMessage: No security header found.");
            }
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                Node currentNode = headerChildNodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String nodeName = currentNode.getLocalName();
                String nodeNS = currentNode.getNamespaceURI();
                if ("Security".equals(nodeName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nodeNS)) {
                    this.wsseHeader = (Element)currentNode;
                }
                if (!"MessageID".equals(nodeName) || !"http://www.w3.org/2005/08/addressing".equals(nodeNS)) continue;
                this.messageID = XMLUtils.getElementValue((Element)((Element)currentNode));
            }
        }
        catch (SOAPException se) {
            debug.error("SecureSOAPMessage.parseSOAPMessage: SOAPException in parsing the headers.", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "ERROR_PARSING_SOAP_HEADERS", data, null);
            throw new SecurityException(se.getMessage());
        }
    }

    public void parseSecurityHeader(Node node) throws SecurityException {
        this.securityMechanism = SecurityMechanism.WSS_NULL_ANONYMOUS;
        if (node != null) {
            NodeList securityHeaders = node.getChildNodes();
            for (int i = 0; i < securityHeaders.getLength(); ++i) {
                Node currentNode = securityHeaders.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String localName = currentNode.getLocalName();
                String nameSpace = currentNode.getNamespaceURI();
                if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: Assertion token found in the security header.");
                    }
                    try {
                        this.securityToken = new AssertionToken((Element)currentNode);
                        AssertionToken assertionToken = (AssertionToken)this.securityToken;
                        this.securityMechanism = assertionToken.isSenderVouches() ? SecurityMechanism.WSS_NULL_SAML_SV : SecurityMechanism.WSS_NULL_SAML_HK;
                        this.messageCertificate = WSSUtils.getCertificate(assertionToken);
                        continue;
                    }
                    catch (SAMLException se) {
                        debug.error("SecureSOAPMessage.parseSecurityHeader: unable to parse the token", (Throwable)se);
                        throw new SecurityException(se.getMessage());
                    }
                }
                if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: SAML2 token found in the security header.");
                    }
                    try {
                        this.securityToken = new SAML2Token((Element)currentNode);
                        SAML2Token saml2Token = (SAML2Token)this.securityToken;
                        this.securityMechanism = saml2Token.isSenderVouches() ? SecurityMechanism.WSS_NULL_SAML2_SV : SecurityMechanism.WSS_NULL_SAML2_HK;
                        this.messageCertificate = SAML2TokenUtils.getCertificate(saml2Token);
                        continue;
                    }
                    catch (SAML2Exception se) {
                        debug.error("SecureSOAPMessage.parseSecurityHeader: unable to parse the token", (Throwable)se);
                        throw new SecurityException(se.getMessage());
                    }
                }
                if ("BinarySecurityToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: binary token found in the security header.");
                    }
                    this.securityToken = new BinarySecurityToken((Element)currentNode);
                    if (this.securityToken.getTokenType().equals("urn:sun:wss:kerberostoken")) {
                        this.securityMechanism = SecurityMechanism.WSS_NULL_KERBEROS_TOKEN;
                        continue;
                    }
                    this.securityMechanism = SecurityMechanism.WSS_NULL_X509_TOKEN;
                    this.messageCertificate = WSSUtils.getCertificate(this.securityToken);
                    continue;
                }
                if ("UsernameToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                    if (debug.messageEnabled()) {
                        debug.message("SecureSOAPMessage.parseSecurityHeader:: username token found in the security header.");
                    }
                    this.securityToken = new UserNameToken((Element)currentNode);
                    UserNameToken usernameToken = (UserNameToken)this.securityToken;
                    String passwordType = usernameToken.getPasswordType();
                    if (passwordType == null) continue;
                    if (passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                        this.securityMechanism = SecurityMechanism.WSS_NULL_USERNAME_TOKEN;
                        continue;
                    }
                    if (!passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText")) continue;
                    this.securityMechanism = SecurityMechanism.WSS_NULL_USERNAME_TOKEN_PLAIN;
                    continue;
                }
                if ("Signature".equals(localName) && "http://www.w3.org/2000/09/xmldsig#".equals(nameSpace)) {
                    if (this.securityToken != null) continue;
                    this.messageCertificate = WSSUtils.getMessageCertificate((Element)node);
                    if (this.messageCertificate == null) continue;
                    this.securityMechanism = SecurityMechanism.WSS_NULL_X509_TOKEN;
                    continue;
                }
                if ("Timestamp".equals(localName) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                    if (this.validateTimestamp((Element)currentNode)) continue;
                    throw new SecurityException(bundle.getString("invalidTimestamp"));
                }
                if (!debug.messageEnabled()) continue;
                debug.message("SecureSOAPMessage.parseSecurityHeader: ignore header element, " + localName);
            }
        }
    }

    public SecurityMechanism getSecurityMechanism() {
        return this.securityMechanism;
    }

    public void setSecurityMechanism(SecurityMechanism securityMechanism) {
        this.securityMechanism = securityMechanism;
    }

    public void setSecurityToken(SecurityToken token) throws SecurityException {
        if (this.wsseHeader == null) {
            debug.error("SecureSOAPMessage.setSecurityToken:: WSSE security Header is not found in the Secure SOAP Message.");
            throw new SecurityException(bundle.getString("securityHeaderNotFound"));
        }
        this.securityToken = token;
        String tokenType = this.securityToken.getTokenType();
        if ("urn:sun:wss:usernametoken".equals(tokenType)) {
            UserNameToken userNameToken = (UserNameToken)this.securityToken;
            this.signingIds.add(userNameToken.getSigningId());
        } else if ("urn:sun:wss:x509token".equals(tokenType)) {
            BinarySecurityToken binaryToken = (BinarySecurityToken)this.securityToken;
            this.signingIds.add(binaryToken.getSigningId());
        }
        Element tokenE = token.toDocumentElement();
        Node tokenNode = this.soapMessage.getSOAPPart().importNode((Node)tokenE, true);
        WSSUtils.prependChildElement(this.wsseHeader, (Element)tokenNode, true, (Document)this.soapMessage.getSOAPPart());
        try {
            this.soapMessage.saveChanges();
        }
        catch (SOAPException se) {
            throw new SecurityException(se.getMessage());
        }
    }

    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    private void addNameSpaces() throws SecurityException {
        try {
            SOAPEnvelope envelope = this.soapMessage.getSOAPPart().getEnvelope();
            envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPBody body = this.soapMessage.getSOAPPart().getEnvelope().getBody();
            body.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            body.setAttribute("wsu:Id", SAMLUtils.generateID());
        }
        catch (SOAPException se) {
            debug.error("SecureSOAPMessage.addNameSpaces:: Could not add Name spaces. ", (Throwable)se);
            throw new SecurityException(bundle.getString("nameSpaceAdditionfailure"));
        }
    }

    private void addSecurityHeader() throws SecurityException {
        if (debug.messageEnabled()) {
            debug.message("SecureSOAPMessage.addSecurityHeader:: preparing the security header");
        }
        try {
            SOAPEnvelope envelope = this.soapMessage.getSOAPPart().getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                header = this.soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            SOAPPart soapPart = this.soapMessage.getSOAPPart();
            this.wsseHeader = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            this.wsseHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            this.wsseHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            this.wsseHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse11", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            String envPrefix = envelope.getPrefix();
            if (envPrefix != null) {
                this.wsseHeader.setAttribute(envPrefix + ":" + "mustUnderstand", "1");
            }
            Element timeStamp = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
            String tsId = SAMLUtils.generateID();
            if (this.signingIds != null) {
                this.signingIds.add(tsId);
            }
            timeStamp.setAttribute("wsu:Id", tsId);
            this.wsseHeader.appendChild(timeStamp);
            Element created = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
            Date createTime = new Date();
            Date expireTime = new Date();
            expireTime.setTime(createTime.getTime() + 300000L);
            created.appendChild(soapPart.createTextNode(DateUtils.toUTCDateFormat((Date)createTime)));
            timeStamp.appendChild(created);
            Element expires = this.soapMessage.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
            expires.appendChild(soapPart.createTextNode(DateUtils.toUTCDateFormat((Date)expireTime)));
            timeStamp.appendChild(expires);
            header.appendChild((Node)this.wsseHeader);
        }
        catch (SOAPException se) {
            debug.error("SecureSOAPMessage.addSecurityHeader:: SOAPException while adding the security header.", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "ERROR_ADDING_SECURITY_HEADER", data, null);
            throw new SecurityException(bundle.getString("addSecurityHeaderFailed"));
        }
    }

    public void sign(String certAlias, String refType) throws SecurityException {
        Document doc = this.toDocument();
        String tokenType = null;
        if (this.securityToken != null) {
            tokenType = this.securityToken.getTokenType();
        } else if (this.securityMechanism != null && this.securityMechanism.getURI().equals("urn:sun:wss:security:null:X509Token")) {
            tokenType = "urn:sun:wss:x509token";
        }
        if ("urn:sun:wss:samltoken".equals(tokenType) || "urn:sun:wss:saml2token".equals(tokenType)) {
            this.signWithAssertion(doc, certAlias);
        } else if ("urn:sun:wss:x509token".equals(tokenType)) {
            this.signWithBinaryToken(doc, certAlias, refType);
        } else if ("urn:sun:wss:usernametoken".equals(tokenType) || null == this.securityToken) {
            this.signWithUNToken(doc, certAlias);
        } else if ("urn:sun:wss:kerberostoken".equals(tokenType)) {
            this.signWithKerberosToken(doc);
        } else {
            debug.error("SecureSOAPMessage.sign:: Invalid token type for XML signing.");
        }
        if (debug.messageEnabled()) {
            debug.message("SecureSOAPMessage.sign:: After Signing : " + WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
        }
    }

    private void signWithAssertion(Document doc, String certAlias) throws SecurityException {
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        KeyProvider keyProvider = sigManager.getKeyProvider();
        X509Certificate cert = null;
        String uri = this.securityMechanism.getURI();
        if ("urn:sun:wss:security:null:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-HK".equals(uri)) {
            cert = WSSUtils.getCertificate(this.securityToken);
        } else if ("urn:sun:wss:security:null:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-HK".equals(uri)) {
            cert = SAML2TokenUtils.getCertificate(this.securityToken);
        } else if ("urn:sun:wss:security:null:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:null:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-SV".equals(uri)) {
            cert = keyProvider.getX509Certificate(certAlias);
        } else if ("urn:sun:wss:sts:security".equals(uri)) {
            if ("urn:sun:wss:samltoken".equals(this.securityToken.getTokenType())) {
                cert = WSSUtils.getCertificate(this.securityToken);
            } else if ("urn:sun:wss:saml2token".equals(this.securityToken.getTokenType())) {
                cert = SAML2TokenUtils.getCertificate(this.securityToken);
            }
            if (cert == null) {
                cert = keyProvider.getX509Certificate(certAlias);
            }
        } else {
            debug.error("SecureSOAPMessage.signWithSAMLAssertion:: Unknown security mechanism");
            throw new SecurityException(bundle.getString("unknownSecurityMechanism"));
        }
        Element sigElement = null;
        try {
            String assertionID = null;
            if (this.securityToken instanceof AssertionToken) {
                AssertionToken assertionToken = (AssertionToken)this.securityToken;
                assertionID = assertionToken.getAssertion().getAssertionID();
            } else if (this.securityToken instanceof SAML2Token) {
                SAML2Token saml2Token = (SAML2Token)this.securityToken;
                assertionID = saml2Token.getAssertion().getID();
            }
            sigElement = sigManager.signWithSAMLToken(doc, (Certificate)cert, assertionID, "", this.getSigningIds());
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithAssertion:: signing failed", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithAssertion:: signing failed", (Throwable)ex);
            String[] data = new String[]{ex.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithAssertion:: SOAP message save failed : ", (Throwable)ex);
        }
    }

    private void signWithBinaryToken(Document doc, String certAlias, String refType) throws SecurityException {
        X509Certificate cert = null;
        Element sigElement = null;
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        KeyProvider keyProvider = sigManager.getKeyProvider();
        try {
            cert = keyProvider.getX509Certificate(certAlias);
            sigElement = sigManager.signWithBinarySecurityToken(doc, (Certificate)cert, "", this.getSigningIds(), refType);
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: Signature Exception.", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: signing failed", (Throwable)ex);
            String[] data = new String[]{ex.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: SOAP message save failed : ", (Throwable)ex);
        }
    }

    private void signWithKerberosToken(Document doc) throws SecurityException {
        Element sigElement = null;
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        try {
            BinarySecurityToken bst = (BinarySecurityToken)this.securityToken;
            sigElement = sigManager.signWithKerberosToken(doc, bst.getSecretKey(), "http://www.w3.org/2000/09/xmldsig#hmac-sha1", this.getSigningIds());
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: Signature Exception.", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: signing failed", (Throwable)ex);
            String[] data = new String[]{ex.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithBinaryToken:: SOAP message save failed : ", (Throwable)ex);
        }
    }

    private void signWithUNToken(Document doc, String certAlias) throws SecurityException {
        X509Certificate cert = null;
        Element sigElement = null;
        XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
        KeyProvider keyProvider = sigManager.getKeyProvider();
        try {
            cert = keyProvider.getX509Certificate(certAlias);
            sigElement = sigManager.signWithUserNameToken(doc, (Certificate)cert, "", this.getSigningIds());
        }
        catch (XMLSignatureException se) {
            debug.error("SecureSOAPMessage.signWithUNToken:: Signature Exception.", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithUNToken:: signing failed", (Throwable)ex);
            String[] data = new String[]{ex.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_SIGN", data, null);
            throw new SecurityException(bundle.getString("unabletoSign"));
        }
        this.wsseHeader.appendChild(this.soapMessage.getSOAPPart().importNode((Node)sigElement, true));
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.signWithUNToken:: SOAP message save failed : ", (Throwable)ex);
        }
    }

    private List getSigningIds() throws Exception {
        if (this.signingIds == null) {
            this.signingIds = new ArrayList();
        }
        SOAPBody body = this.soapMessage.getSOAPPart().getEnvelope().getBody();
        String id = body.getAttribute("wsu:Id");
        this.signingIds.add(id);
        return this.signingIds;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public long getMessageTimestamp() {
        return this.msgTimestamp;
    }

    public boolean verifySignature(String alias) throws SecurityException {
        try {
            Document doc = this.toDocument();
            XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
            String certAlias = null;
            certAlias = this.messageCertificate != null ? sigManager.getKeyProvider().getCertificateAlias((Certificate)this.messageCertificate) : alias;
            return sigManager.verifyWSSSignature(doc, certAlias);
        }
        catch (SAMLException se) {
            debug.error("SecureSOAPMessage.verify:: Signature validation failed", (Throwable)se);
            String[] data = new String[]{se.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "SIGNATURE_VALIDATION_FAILED", data, null);
            throw new SecurityException(bundle.getString("signatureValidationFailed"));
        }
    }

    public boolean verifyKerberosTokenSignature(Key secretKey) throws SecurityException {
        try {
            Document doc = this.toDocument();
            XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
            return sigManager.verifyWSSSignature(doc, secretKey);
        }
        catch (SAMLException se) {
            debug.error("SecureSOAPMessage.verify:: Signature validation failed", (Throwable)se);
            throw new SecurityException(bundle.getString("signatureValidationFailed"));
        }
    }

    private Document toDocument() throws SecurityException {
        try {
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            this.soapMessage.writeTo((OutputStream)bop);
            ByteArrayInputStream bin = new ByteArrayInputStream(bop.toByteArray());
            return XMLUtils.toDOMDocument((InputStream)bin, (Debug)WSSUtils.debug);
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.toDocument: Could not Convert the SOAP Message to XML document.", (Throwable)ex);
            throw new SecurityException(ex.getMessage());
        }
    }

    public X509Certificate getMessageCertificate() {
        return this.messageCertificate;
    }

    public void encrypt(String certAlias, String encryptionAlgorithm, int encryptionKeyStrength, boolean encryptBody, boolean encryptHeader) throws SecurityException {
        Document doc = this.toDocument();
        String tokenType = null;
        tokenType = this.securityToken == null ? "urn:sun:wss:x509token" : this.securityToken.getTokenType();
        HashMap<Element, String> elmMap = new HashMap<Element, String>();
        Document encryptedDoc = null;
        String searchType = null;
        String searchNS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        try {
            if (encryptBody) {
                Element elmDoc = doc.getDocumentElement();
                String nameSpaceURI = elmDoc.getNamespaceURI();
                Element bodyElement = (Element)elmDoc.getElementsByTagNameNS(nameSpaceURI, "Body").item(0);
                String bodyId = bodyElement.getAttribute("wsu:Id");
                Node firstNodeInsideBody = bodyElement.getFirstChild();
                elmMap.put((Element)firstNodeInsideBody, bodyId);
            }
            if (encryptHeader) {
                String tokenId = null;
                if ("urn:sun:wss:x509token".equals(tokenType)) {
                    searchType = "BinarySecurityToken";
                } else if ("urn:sun:wss:usernametoken".equals(tokenType)) {
                    searchType = "UsernameToken";
                } else if ("urn:sun:wss:samltoken".equals(tokenType)) {
                    searchType = "Assertion";
                    AssertionToken assertionToken = (AssertionToken)this.securityToken;
                    tokenId = assertionToken.getAssertion().getAssertionID();
                    searchNS = "urn:oasis:names:tc:SAML:1.0:assertion";
                } else if ("urn:sun:wss:saml2token".equals(tokenType)) {
                    searchType = "Assertion";
                    SAML2Token saml2Token = (SAML2Token)this.securityToken;
                    tokenId = saml2Token.getAssertion().getID();
                    searchNS = "urn:oasis:names:tc:SAML:2.0:assertion";
                }
                Element secHeaderElement = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.encrypt:: Security Header : " + WSSUtils.print(secHeaderElement));
                }
                if (secHeaderElement != null) {
                    Element token = (Element)secHeaderElement.getElementsByTagNameNS(searchNS, searchType).item(0);
                    if (token != null && tokenId == null) {
                        tokenId = token.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    }
                    elmMap.put(token, tokenId);
                }
            }
            XMLEncryptionManager encManager = WSSUtils.getXMLEncryptionManager();
            encryptedDoc = encManager.encryptAndReplaceWSSElements(doc, elmMap, encryptionAlgorithm, encryptionKeyStrength, certAlias, 0, tokenType, this.server_proto + "://" + this.server_host + ":" + this.server_port);
        }
        catch (EncryptionException ee) {
            debug.error("SecureSOAPMessage.encrypt:: Encryption Exception : ", (Throwable)ee);
            String[] data = new String[]{ee.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_ENCRYPT", data, null);
            throw new SecurityException(bundle.getString("unabletoEncrypt"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.encrypt:: encryption failed : ", (Throwable)ex);
            String[] data = new String[]{ex.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_ENCRYPT", data, null);
            throw new SecurityException(bundle.getString("unabletoEncrypt"));
        }
        try {
            Element encryptedKeyElem = (Element)encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.encrypt:EncryptedKey DOC : " + WSSUtils.print(encryptedKeyElem));
            }
            Node encKeyNode = this.soapMessage.getSOAPPart().importNode((Node)encryptedKeyElem, true);
            this.wsseHeader.appendChild(encKeyNode);
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.encrypt:: wsseHeader: after Encrypt : " + WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
            }
            NodeList nodes = encryptedDoc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Element encryptedDataElem = (Element)nodes.item(i);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.encrypt:EncryptedData DOC (" + i + ") : " + WSSUtils.print(encryptedDataElem));
                }
                Node encDataNode = this.soapMessage.getSOAPPart().importNode((Node)encryptedDataElem, true);
                if ("Body".equals(encryptedDataElem.getParentNode().getLocalName())) {
                    Node firstNodeInsideBody = this.soapMessage.getSOAPPart().getEnvelope().getBody().getFirstChild();
                    this.soapMessage.getSOAPPart().getEnvelope().getBody().replaceChild(encDataNode, firstNodeInsideBody);
                    continue;
                }
                if (!encryptHeader) continue;
                Element token = (Element)this.wsseHeader.getElementsByTagNameNS(searchNS, searchType).item(0);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.encrypt:: wsseHeader: token element : " + WSSUtils.print(token));
                }
                if (token == null) continue;
                this.wsseHeader.removeChild(encKeyNode);
                this.wsseHeader.insertBefore(encKeyNode, token);
                this.wsseHeader.replaceChild(encDataNode, token);
            }
            this.soapMessage.saveChanges();
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.encrypt:*** SOAP PART ***");
                debug.message(WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
            }
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.encrypt:: encryption failed : ", (Throwable)ex);
            throw new SecurityException(bundle.getString("unabletoGetFinalSoapMessage"));
        }
    }

    public void decrypt(String keyAlias, boolean decryptBody, boolean decryptHeader) throws SecurityException {
        Document decryptedDoc = null;
        try {
            Document doc = this.toDocument();
            NodeList nodes = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            if (nodes == null || nodes.getLength() == 0) {
                debug.error("SecureSOAPMessage.decrypt:: Request is not encrypted.");
                throw new SecurityException(bundle.getString("decryptEncryptionFailed"));
            }
            XMLSignatureManager sigManager = XMLSignatureManager.getInstance();
            XMLEncryptionManager encManager = WSSUtils.getXMLEncryptionManager();
            String certAlias = null;
            certAlias = this.messageCertificate != null ? sigManager.getKeyProvider().getCertificateAlias((Certificate)this.messageCertificate) : keyAlias;
            decryptedDoc = encManager.decryptAndReplace(doc, certAlias);
        }
        catch (EncryptionException ee) {
            debug.error("SecureSOAPMessage.decrypt:: Decrypt encryption failed : ", (Throwable)ee);
            String[] data = new String[]{ee.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_DECRYPT", data, null);
            throw new SecurityException(bundle.getString("decryptEncryptionFailed"));
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.decrypt:: exception : ", (Throwable)ex);
            String[] data = new String[]{ex.getLocalizedMessage()};
            LogUtil.error(Level.INFO, "UNABLE_TO_DECRYPT", data, null);
            throw new SecurityException(bundle.getString("unabletoDecrypt"));
        }
        try {
            if (decryptBody) {
                Element elmDoc = decryptedDoc.getDocumentElement();
                String nameSpaceURI = elmDoc.getNamespaceURI();
                Element decryptedBodyElem = (Element)decryptedDoc.getElementsByTagNameNS(nameSpaceURI, "Body").item(0);
                SOAPBody bodyElement = this.soapMessage.getSOAPPart().getEnvelope().getBody();
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.decrypt::decrypted Body element : " + WSSUtils.print(decryptedBodyElem));
                    debug.message("SecureSOAPMessage.decrypt::SOAP Body element : " + WSSUtils.print((Node)bodyElement));
                }
                Node decDataNode = this.soapMessage.getSOAPPart().importNode((Node)decryptedBodyElem, true);
                Node firstNodeInsideBody = this.soapMessage.getSOAPPart().getEnvelope().getBody().getFirstChild();
                this.soapMessage.getSOAPPart().getEnvelope().getBody().replaceChild(decDataNode.getFirstChild(), firstNodeInsideBody);
            }
            if (decryptHeader) {
                Element decryptedSecHeaderElement = (Element)decryptedDoc.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security").item(0);
                Node decSecHeaderDataNode = this.soapMessage.getSOAPPart().importNode((Node)decryptedSecHeaderElement, true);
                Node tokenNode = this.getTokenNode(decSecHeaderDataNode);
                Element token = (Element)this.wsseHeader.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
                if (debug.messageEnabled()) {
                    debug.message("SecureSOAPMessage.decrypt: decrypted Security Header doc : " + WSSUtils.print(decryptedSecHeaderElement));
                    debug.message("SecureSOAPMessage.decrypt: SOAP HEADER DOC : " + WSSUtils.print(this.wsseHeader));
                    debug.message("SecureSOAPMessage.decrypt: tokenNode from decrypted Security header doc: " + WSSUtils.print(tokenNode));
                    debug.message("SecureSOAPMessage.decrypt: token from current SOAP wsseHeader : " + WSSUtils.print(token));
                }
                if (token != null) {
                    Element encKey = (Element)this.wsseHeader.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
                    this.wsseHeader.removeChild(encKey);
                    this.wsseHeader.appendChild(encKey);
                    this.wsseHeader.replaceChild(tokenNode, token);
                }
            }
            this.soapMessage.saveChanges();
            if (debug.messageEnabled()) {
                debug.message("SecureSOAPMessage.decrypt:*** SOAP PART ***");
                debug.message(WSSUtils.print((Node)this.soapMessage.getSOAPPart()));
            }
        }
        catch (Exception ex) {
            debug.error("SecureSOAPMessage.decrypt:: decryption failed : ", (Throwable)ex);
            throw new SecurityException(bundle.getString("unabletoGetFinalSoapMessage"));
        }
    }

    private Node getTokenNode(Node secHeaderNode) throws Exception {
        Node tokenNode = null;
        String searchType = null;
        NodeList securityHeaders = secHeaderNode.getChildNodes();
        for (int i = 0; i < securityHeaders.getLength(); ++i) {
            Node currentNode = securityHeaders.item(i);
            String localName = currentNode.getLocalName();
            String nameSpace = currentNode.getNamespaceURI();
            if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(nameSpace)) {
                searchType = "Assertion";
            } else if ("Assertion".equals(localName) && "urn:oasis:names:tc:SAML:2.0:assertion".equals(nameSpace)) {
                searchType = "Assertion";
            } else if ("BinarySecurityToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                searchType = "BinarySecurityToken";
            } else if ("UsernameToken".equals(localName) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(nameSpace)) {
                searchType = "UsernameToken";
            }
            if (searchType == null) continue;
            tokenNode = currentNode;
            break;
        }
        return tokenNode;
    }

    private boolean validateTimestamp(Element tsElement) {
        String created = null;
        String expires = null;
        NodeList nl = tsElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if ("Created".equals(childName)) {
                created = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (!"Expires".equals(childName)) continue;
            expires = XMLUtils.getElementValue((Element)((Element)child));
        }
        try {
            this.msgTimestamp = DateUtils.stringToDate(created).getTime();
            long createdTS = this.msgTimestamp - WSSUtils.getTimeSkew();
            long expiresTS = DateUtils.stringToDate(expires).getTime();
            long now = new Date().getTime();
            if (created == null) {
                if (expires == null) {
                    return false;
                }
                if (now < expiresTS) {
                    return true;
                }
            } else if (expires == null ? now >= createdTS : now >= createdTS && now < expiresTS) {
                return true;
            }
            return false;
        }
        catch (ParseException pe) {
            WSSUtils.debug.error("SecureSOAPMessage.validateTimestamp: parsing exception", (Throwable)pe);
            return false;
        }
    }
}

