/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RealmGetPolicy
extends AuthenticatedCommand {
    private static final String ARGUMENT_POLICY_NAMES = "policynames";

    public void handleRequest(RequestContext rc) throws CLIException {
        block23: {
            super.handleRequest(rc);
            this.ldapLogin();
            SSOToken adminSSOToken = this.getAdminSSOToken();
            String realm = this.getStringOptionValue("realm");
            List filters = rc.getOption(ARGUMENT_POLICY_NAMES);
            String outfile = this.getStringOptionValue("outfile");
            IOutput outputWriter = this.getOutputWriter();
            String currentPolicyName = null;
            try {
                PolicyManager pm = new PolicyManager(adminSSOToken, realm);
                HashSet policyNames = null;
                if (filters == null || filters.isEmpty()) {
                    policyNames = pm.getPolicyNames();
                } else {
                    policyNames = new HashSet();
                    Iterator i = filters.iterator();
                    while (i.hasNext()) {
                        policyNames.addAll(pm.getPolicyNames((String)i.next()));
                    }
                }
                if (policyNames != null && !policyNames.isEmpty()) {
                    FileOutputStream fout = null;
                    PrintWriter pwout = null;
                    if (outfile != null) {
                        try {
                            fout = new FileOutputStream(outfile, true);
                            pwout = new PrintWriter(fout, true);
                        }
                        catch (FileNotFoundException e) {
                            this.debugError("RealmGetPolicy.handleRequest", e);
                            try {
                                if (fout != null) {
                                    fout.close();
                                }
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw new CLIException(e, 24);
                        }
                        catch (SecurityException e) {
                            this.debugError("RealmGetPolicy.handleRequest", e);
                            try {
                                if (fout != null) {
                                    fout.close();
                                }
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw new CLIException(e, 24);
                        }
                    }
                    String[] params = new String[2];
                    params[0] = realm;
                    Iterator i = policyNames.iterator();
                    while (i.hasNext()) {
                        params[1] = currentPolicyName = (String)i.next();
                        this.writeLog(0, Level.INFO, "ATTEMPT_GET_POLICY_IN_REALM", params);
                        Policy policy = pm.getPolicy(currentPolicyName);
                        if (pwout != null) {
                            pwout.write("<!-- extracted from realm, " + realm + " -->\n");
                            pwout.write(policy.toXML());
                        } else {
                            outputWriter.printlnMessage("<!-- extracted from realm, " + realm + " -->");
                            outputWriter.printlnMessage(policy.toXML());
                        }
                        this.writeLog(0, Level.INFO, "SUCCEED_GET_POLICY_IN_REALM", params);
                    }
                    if (pwout != null) {
                        try {
                            pwout.close();
                            fout.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    String[] arg = new String[]{realm};
                    outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("get-policy-in-realm-succeed"), arg));
                    break block23;
                }
                String[] arg = new String[]{realm};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("get-policy-in-realm-no-policies"), arg));
            }
            catch (PolicyException e) {
                String[] args = new String[]{realm, currentPolicyName, e.getMessage()};
                this.debugError("RealmGetPolicy.handleRequest", e);
                this.writeLog(1, Level.INFO, "FAILED_GET_POLICY_IN_REALM", args);
                throw new CLIException(e, 127);
            }
            catch (SSOException e) {
                String[] args = new String[]{realm, currentPolicyName, e.getMessage()};
                this.debugError("RealmGetPolicy.handleRequest", (Throwable)((Object)e));
                this.writeLog(1, Level.INFO, "FAILED_GET_POLICY_IN_REALM", args);
                throw new CLIException((Throwable)((Object)e), 127);
            }
        }
    }
}

