/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.util.logging.Level;

public class ExportServer
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        String outputFile = this.getStringOptionValue("outfile");
        String[] params = new String[]{serverName};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_EXPORT_SERVER", params);
            if (ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                String config = ServerConfiguration.exportServerInstance(adminSSOToken, serverName);
                if (outputFile != null && outputFile.length() > 0) {
                    CLIUtil.writeToFile(outputFile, config);
                } else {
                    outputWriter.printlnMessage(config);
                }
                outputWriter.printlnMessage(this.getResourceString("export-server-succeeded"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("export-server-no-exists"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_EXPORT_SERVER", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_EXPORT_SERVER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_EXPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_EXPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
    }
}

