/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.policy.model.PolicyModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IPConditionHelper {
    private static final String ATTR_DNS_NAME = "DnsName";
    private static final String ATTR_START_IP = "StartIp";
    private static final String ATTR_END_IP = "EndIp";
    private static IPConditionHelper instance = new IPConditionHelper();

    private IPConditionHelper() {
    }

    public static IPConditionHelper getInstance() {
        return instance;
    }

    public String getConditionXML(boolean bCreate, boolean readonly) {
        String xml = null;
        xml = bCreate ? "com/sun/identity/console/propertyPMConditionIP.xml" : (readonly ? "com/sun/identity/console/propertyPMConditionIP_Readonly.xml" : "com/sun/identity/console/propertyPMConditionIP.xml");
        return AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xml));
    }

    public String getMissingValuesMessage() {
        return "policy.condition.missing.ip.dns.message";
    }

    public void setPropertiesValues(Map values, AMPropertySheetModel propertySheetModel, AMModel model) {
        if (values != null && !values.isEmpty()) {
            for (String propName : values.keySet()) {
                Set val = (Set)values.get(propName);
                if (val == null || val.isEmpty()) continue;
                if (propName.equals(ATTR_START_IP) || propName.equals(ATTR_END_IP)) {
                    this.setIPAddress(propName, (String)val.iterator().next(), propertySheetModel);
                    continue;
                }
                propertySheetModel.setValues(propName, val.toArray(), model);
            }
        }
    }

    public Map getConditionValues(PolicyModel model, AMPropertySheetModel propertySheetModel) {
        HashSet<String> set;
        HashMap map = new HashMap(6);
        String dnsName = (String)propertySheetModel.getValue(ATTR_DNS_NAME);
        if (dnsName.trim().length() > 0) {
            HashSet<String> set2 = new HashSet<String>(2);
            set2.add(dnsName);
            map.put(ATTR_DNS_NAME, set2);
        }
        String startIP = this.getIPAddress(ATTR_START_IP, propertySheetModel);
        String endIP = this.getIPAddress(ATTR_END_IP, propertySheetModel);
        if (!startIP.equals("0.0.0.0")) {
            set = new HashSet<String>(2);
            set.add(startIP);
            map.put(ATTR_START_IP, set);
        } else if (!endIP.equals("0.0.0.0")) {
            set = new HashSet(2);
            set.add(endIP);
            map.put(ATTR_START_IP, set);
        }
        if (!endIP.equals("0.0.0.0")) {
            set = new HashSet(2);
            set.add(endIP);
            map.put(ATTR_END_IP, set);
        } else if (!startIP.equals("0.0.0.0")) {
            set = new HashSet(2);
            set.add(startIP);
            map.put(ATTR_END_IP, set);
        }
        return map;
    }

    private String getIPAddress(String propName, AMPropertySheetModel propertySheetModel) {
        StringBuffer buff = new StringBuffer(20);
        for (int i = 1; i < 5; ++i) {
            if (i > 1) {
                buff.append(".");
            }
            String node = (String)propertySheetModel.getValue(propName + i);
            if ((node = node.trim()).length() == 0) {
                node = "0";
            }
            buff.append(node);
        }
        return buff.toString();
    }

    private void setIPAddress(String propName, String value, AMPropertySheetModel propertySheetModel) {
        StringTokenizer st = new StringTokenizer(value, ".");
        if (st.countTokens() == 4) {
            int i = 1;
            while (st.hasMoreTokens()) {
                propertySheetModel.setValue(propName + i, st.nextToken());
                ++i;
            }
        }
    }
}

