/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.authentication.internal.server.AuthSPrincipal;
import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.Evaluator;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/1/entitlement/decision")
public class DecisionResource {
    @Context
    private SecurityContext security;

    @GET
    @Produces(value={"text/plain"})
    public String decision(@QueryParam(value="realm") String realm, @QueryParam(value="subject") String subject, @QueryParam(value="action") String action, @QueryParam(value="resource") String resource, @QueryParam(value="application") String application) {
        Subject caller = this.toSubject("id=amAdmin,ou=user,dc=opensso,dc=java,dc=net");
        try {
            Evaluator evaluator = application == null ? new Evaluator(caller) : new Evaluator(caller, application);
            return this.permission(evaluator.hasEntitlement(realm, this.toSubject(subject), this.toEntitlement(resource, action), Collections.EMPTY_MAP));
        }
        catch (EntitlementException ee) {
            return this.permission(false);
        }
    }

    private Entitlement toEntitlement(String resource, String action) {
        HashSet<String> set = new HashSet<String>();
        set.add(action);
        return new Entitlement(resource, set);
    }

    private Subject toSubject(Principal principal) {
        if (principal == null) {
            return null;
        }
        HashSet<Principal> set = new HashSet<Principal>();
        set.add(principal);
        return new Subject(false, set, new HashSet(), new HashSet());
    }

    private Subject toSubject(String subject) {
        if (subject == null) {
            return null;
        }
        return this.toSubject(new AuthSPrincipal(subject));
    }

    private String permission(boolean b) {
        return b ? Permission.allow.toString() : Permission.deny.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permission {
        deny,
        allow;

    }
}

