/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.logging;

import com.sun.identity.plugin.log.LogException;
import com.sun.identity.plugin.log.LogManager;
import com.sun.identity.plugin.log.Logger;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.wss.security.WSSUtils;
import java.util.Map;
import java.util.logging.Level;

public class LogUtil {
    public static final String UNSUPPORTED_TOKEN_TYPE = "UNSUPPORTED_TOKEN_TYPE";
    public static final String CREATED_SAML11_ASSERTION = "CREATED_SAML11_ASSERTION";
    public static final String CREATED_SAML20_ASSERTION = "CREATED_SAML20_ASSERTION";
    public static final String ERROR_SIGNING_SAML_ASSERTION = "ERROR_SIGNING_SAML_ASSERTION";
    public static final String ERROR_CREATING_SAML11_ASSERTION = "ERROR_CREATING_SAML11_ASSERTION";
    public static final String ERROR_CREATING_SAML20_ASSERTION = "ERROR_CREATING_SAML20_ASSERTION";
    public static final String IDENTITY_SUBJECT_NAME = "IDENTITY_SUBJECT_NAME";
    public static final String ATTR_MAP_FOR_SP = "ATTR_MAP_FOR_SP";
    public static final String SUCCESS_RETRIEVING_TOKEN_FROM_STS = "SUCCESS_RETRIEVING_TOKEN_FROM_STS";
    public static final String ERROR_RETRIEVING_TOKEN_FROM_STS = "ERROR_RETRIEVING_TOKEN_FROM_STS";
    public static final String SUCCESS_VALIDATE_REQUEST = "SUCCESS_VALIDATE_REQUEST";
    public static final String REQUEST_TO_BE_VALIDATED = "REQUEST_TO_BE_VALIDATED";
    public static final String RESPONSE_TO_BE_SECURED = "RESPONSE_TO_BE_SECURED";
    public static final String SUCCESS_SECURE_RESPONSE = "SUCCESS_SECURE_RESPONSE";
    public static final String REQUEST_TO_BE_SECURED = "REQUEST_TO_BE_SECURED";
    public static final String SUCCESS_SECURE_REQUEST = "SUCCESS_SECURE_REQUEST";
    public static final String RESPONSE_TO_BE_VALIDATED = "RESPONSE_TO_BE_VALIDATED";
    public static final String SUCCESS_VALIDATE_RESPONSE = "SUCCESS_VALIDATE_RESPONSE";
    public static final String AUTHENTICATION_FAILED = "AUTHENTICATION_FAILED";
    public static final String ERROR_PARSING_SOAP_HEADERS = "ERROR_PARSING_SOAP_HEADERS";
    public static final String ERROR_ADDING_SECURITY_HEADER = "ERROR_ADDING_SECURITY_HEADER";
    public static final String SIGNATURE_VALIDATION_FAILED = "SIGNATURE_VALIDATION_FAILED";
    public static final String UNABLE_TO_SIGN = "UNABLE_TO_SIGN";
    public static final String UNABLE_TO_ENCRYPT = "UNABLE_TO_ENCRYPT";
    public static final String UNABLE_TO_DECRYPT = "UNABLE_TO_DECRYPT";
    public static final String DOMAIN = "Domain";
    public static final String LOGIN_ID = "LoginID";
    public static final String IP_ADDR = "IPAddr";
    public static final String MODULE_NAME = "ModuleName";
    private static boolean logStatus;
    private static final String WebServices_LOG = "WebServicesSecurity";
    private static Logger logger;

    public static void access(Level level, String msgid, String[] data) {
        LogUtil.access(level, msgid, data, null, null);
    }

    public static void access(Level level, String msgid, String[] data, Object session) {
        LogUtil.access(level, msgid, data, session, null);
    }

    public static void access(Level level, String msgid, String[] data, Object session, Map props) {
        if (LogUtil.isLogEnabled() && logger != null) {
            try {
                logger.access(level, msgid, data, session, props);
            }
            catch (LogException le) {
                WSSUtils.debug.error("LogUtil.access: Couldn't write log:", (Throwable)le);
            }
        }
    }

    public static void error(Level level, String msgid, String[] data) {
        LogUtil.error(level, msgid, data, null, null);
    }

    public static void error(Level level, String msgid, String[] data, Object session) {
        LogUtil.error(level, msgid, data, session, null);
    }

    public static void error(Level level, String msgid, String[] data, Object session, Map props) {
        if (LogUtil.isLogEnabled() && logger != null) {
            try {
                logger.error(level, msgid, data, session, props);
            }
            catch (LogException le) {
                WSSUtils.debug.error("LogUtil.error:Couldn't write log:", (Throwable)le);
            }
        }
    }

    public static boolean isLogEnabled() {
        if (logger == null) {
            return false;
        }
        return logStatus;
    }

    public static boolean isAccessLoggable(Level level) {
        if (logger == null) {
            return false;
        }
        return logger.isAccessLoggable(level);
    }

    public static boolean isErrorLoggable(Level level) {
        if (logger == null) {
            return false;
        }
        return logger.isErrorLoggable(level);
    }

    static {
        logger = null;
        String status = SystemPropertiesManager.get((String)"com.iplanet.am.logstatus");
        logStatus = status != null && status.equalsIgnoreCase("ACTIVE");
        try {
            logger = LogManager.getLogger((String)WebServices_LOG);
        }
        catch (LogException le) {
            WSSUtils.debug.error("LogUtil.static: Error getting logger:", (Throwable)le);
        }
    }
}

