/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.ReferralOpViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Set;

public class ReferralEditViewBean
extends ReferralOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/ReferralEdit.jsp";
    public static final String EDIT_REFERRAL_NAME = "editReferralName";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    public ReferralEditViewBean() {
        super("ReferralEdit", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        PolicyModel model = (PolicyModel)this.getModel();
        String i18nName = (String)this.propertySheetModel.getValue("tfReferralTypeName");
        String title = model.getLocalizedString("page.title.policy.referral.edit");
        String[] param = new String[]{i18nName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
    }

    protected String getPropertyXMLFileName(boolean readonly) {
        return readonly ? "com/sun/identity/console/propertyPMReferralEdit_Readonly.xml" : "com/sun/identity/console/propertyPMReferralEdit.xml";
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        try {
            this.handleButton1Request(this.getCachedPolicy());
        }
        catch (AMConsoleException e) {
            this.redirectToStartURL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleButton1Request(CachedPolicy cachedPolicy) throws ModelControlException {
        Referral deleted = null;
        String origName = (String)this.getPageSessionAttribute(EDIT_REFERRAL_NAME);
        Policy policy = cachedPolicy.getPolicy();
        try {
            Referral referral = this.createReferral();
            if (referral != null) {
                String name = (String)this.propertySheetModel.getValue("tfReferralName");
                if (origName.equals(name)) {
                    policy.replaceReferral(name, referral);
                } else {
                    deleted = policy.removeReferral(origName);
                    policy.addReferral(name, referral);
                }
                deleted = null;
                this.setInlineAlertMessage("info", "message.information", "policy.referral.updated");
                cachedPolicy.setPolicyModified(true);
            }
        }
        catch (NameAlreadyExistsException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        finally {
            if (deleted != null) {
                try {
                    policy.addReferral(origName, deleted);
                }
                catch (NameAlreadyExistsException e) {
                    debug.warning("ReferralEditViewBean.handleButton1Request", (Throwable)e);
                }
                catch (InvalidNameException e) {
                    debug.warning("ReferralEditViewBean.handleButton1Request", (Throwable)e);
                }
            }
        }
        this.forwardTo();
    }

    protected Set getDefaultValues() {
        Set values = null;
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            String referralName = (String)this.getPageSessionAttribute("referralName");
            Referral referral = policy.getReferral(referralName);
            values = referral.getValues();
        }
        catch (NameNotFoundException e) {
            debug.warning("ReferralEditViewBean.getDefaultValues", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("ReferralEditViewBean.getDefaultValues", (Throwable)e);
        }
        return values;
    }

    protected String getBreadCrumbDisplayName() {
        PolicyModel model = (PolicyModel)this.getModel();
        String origName = (String)this.getPageSessionAttribute(EDIT_REFERRAL_NAME);
        String[] arg = new String[]{origName};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.editReferral"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }
}

