/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.tools.bundles.SetupConstants;
import com.sun.identity.tools.bundles.SetupUtils;
import com.sun.identity.tools.bundles.VersionCheck;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class Main
implements SetupConstants {
    public static void main(String[] args) {
        ResourceBundle bundle = ResourceBundle.getBundle(System.getProperty("file.setup", "com.sun.identity.tools.bundles.amadmtoolssetup"));
        if (System.getProperty("help.print") != null && System.getProperty("help.print").equals("yes")) {
            SetupUtils.printUsage(bundle);
            System.exit(0);
        }
        if (System.getProperty("version.check") != null && System.getProperty("version.check").equals("yes")) {
            System.exit(VersionCheck.isValid());
        }
        boolean loadConfig = System.getProperty("load.config") != null && System.getProperty("load.config").equals("yes");
        String currentOS = SetupUtils.determineOS();
        Properties configProp = null;
        String debugPath = null;
        String logPath = null;
        if (loadConfig) {
            String configPath = System.getProperty("path.AMConfig");
            debugPath = System.getProperty("path.debug");
            logPath = System.getProperty("path.log");
            try {
                if (configPath == null || configPath.length() == 0) {
                    configPath = SetupUtils.getUserInput(bundle.getString(currentOS + ".question"));
                    if (!new File(configPath).isAbsolute()) {
                        System.out.println(bundle.getString("message.error.dir.absolute"));
                        System.exit(1);
                    }
                    if (debugPath == null || debugPath.length() == 0) {
                        debugPath = SetupUtils.getUserInput(bundle.getString(currentOS + ".debug.dir"));
                    }
                    if (!new File(debugPath).isAbsolute()) {
                        System.out.println(bundle.getString("message.error.dir.absolute"));
                        System.exit(1);
                    }
                    if (!Main.isWriteable(debugPath)) {
                        System.out.println(bundle.getString("message.error.debug.dir.not.writable"));
                        System.exit(1);
                    }
                    if (logPath == null || logPath.length() == 0) {
                        logPath = SetupUtils.getUserInput(bundle.getString(currentOS + ".log.dir"));
                    }
                    if (!new File(logPath).isAbsolute()) {
                        System.out.println(bundle.getString("message.error.dir.absolute"));
                        System.exit(1);
                    }
                    if (!Main.isWriteable(logPath)) {
                        System.out.println(bundle.getString("message.error.log.dir.not.writable"));
                        System.exit(1);
                    }
                } else {
                    String toolsHome = new File(".").getCanonicalPath();
                    toolsHome = toolsHome.replaceAll("\\\\", "/");
                    if (debugPath == null || debugPath.length() == 0) {
                        debugPath = toolsHome + "/debug";
                    }
                    if (logPath == null || logPath.length() == 0) {
                        logPath = toolsHome + "/log";
                    }
                }
                if ((configProp = Bootstrap.load(configPath, false)) == null) {
                    System.out.println(bundle.getString("message.error.dir"));
                    System.exit(1);
                }
                new File(debugPath).mkdirs();
                new File(logPath).mkdirs();
                if (!configPath.endsWith(FILE_SEPARATOR)) {
                    configPath = configPath + FILE_SEPARATOR;
                }
                configProp.setProperty("UserInput", configPath.substring(0, configPath.length() - 1));
                configProp.setProperty("LogDir", logPath);
                configProp.setProperty("DebugDir", debugPath);
                configProp.setProperty("CurrentPlatform", currentOS);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                System.exit(1);
            }
        } else {
            configProp = new Properties();
        }
        SetupUtils.evaluateBundleValues(bundle, configProp);
        try {
            SetupUtils.copyAndFilterScripts(bundle, configProp);
            if (loadConfig) {
                Object[] p = new Object[]{debugPath};
                System.out.println(MessageFormat.format(bundle.getString("message.info.debug.dir"), p));
                p[0] = logPath;
                System.out.println(MessageFormat.format(bundle.getString("message.info.log.dir"), p));
                System.out.println(bundle.getString("message.info.version.tools") + " " + bundle.getString("version.tools"));
                System.out.println(bundle.getString("message.info.version.am") + " " + SystemProperties.get("com.iplanet.am.version"));
            }
        }
        catch (IOException ex) {
            System.out.println(bundle.getString("message.error.copy"));
            System.exit(1);
        }
        System.exit(0);
    }

    private static boolean isWriteable(String file) {
        File f;
        boolean exist = false;
        boolean writable = false;
        while (file != null && !exist) {
            f = new File(file);
            exist = f.exists();
            if (exist) continue;
            file = f.getParent();
        }
        if (file != null) {
            f = new File(file);
            writable = f.canWrite();
        }
        return writable;
    }
}

