/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationSchema;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AMAuthenticationManager {
    private static String bundleName;
    private static Debug debug;
    private static Set authTypes;
    private static Map moduleServiceNames;
    private static Set globalModuleNames;
    private SSOToken token;
    private String realm;
    private ServiceConfig orgServiceConfig;
    private static Hashtable moduleInstanceTable;
    private static SSOToken adminToken;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AMAuthenticationManager(SSOToken token, String org) throws AMConfigurationException {
        try {
            SMSEntry.validateToken(token);
            this.token = token;
            this.realm = DNMapper.orgNameToDN(org);
            if (this.realm != null && this.realm.length() != 0) {
                this.realm = this.realm.toLowerCase();
            }
            this.orgServiceConfig = this.getOrgServiceConfig();
            if (this.orgServiceConfig == null) {
                throw new AMConfigurationException(bundleName, "badRealm", new Object[]{this.realm});
            }
            Class<AMAuthenticationManager> clazz = AMAuthenticationManager.class;
            synchronized (AMAuthenticationManager.class) {
                if (moduleInstanceTable.get(this.realm) != null) return;
                AMAuthenticationManager.buildModuleInstanceTable(token, this.realm);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        catch (SMSException e) {
            throw new AMConfigurationException(e);
        }
        catch (Exception ee) {
            String installTime = SystemProperties.get("com.sun.identity.security.amadmin");
            if (installTime == null || !installTime.equalsIgnoreCase("false")) return;
            debug.error("Token is invalid.", (Throwable)ee);
        }
    }

    public static synchronized void reInitializeAuthServices() {
        authTypes.clear();
        if (globalModuleNames != Collections.EMPTY_SET) {
            globalModuleNames.clear();
        }
        AMAuthenticationManager.initAuthenticationService(adminToken);
    }

    public static Set getAuthenticationTypes() {
        return authTypes;
    }

    public static Set getAuthenticationServiceNames() {
        Set<Object> names;
        Collection keys = moduleServiceNames.values();
        Set<Object> set = names = keys != null ? new HashSet(keys) : Collections.EMPTY_SET;
        if (debug.messageEnabled()) {
            debug.message("Authenticator serviceNames: " + names);
        }
        return names;
    }

    public static String getAuthenticationServiceName(String moduleName) {
        return (String)moduleServiceNames.get(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initAuthenticationService(SSOToken token) {
        block12: {
            try {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthService", token);
                ServiceSchema schema = scm.getGlobalSchema();
                Set authenticators = (Set)schema.getAttributeDefaults().get("iplanet-am-auth-authenticators");
                for (String module : authenticators) {
                    String serviceName;
                    int index = module.lastIndexOf(".");
                    if (index != -1) {
                        module = module.substring(index + 1);
                    }
                    if (!module.equals("Application")) {
                        authTypes.add(module);
                    }
                    if ((serviceName = (String)moduleServiceNames.get(module)) != null) continue;
                    serviceName = AuthUtils.getModuleServiceName(module);
                    try {
                        new ServiceSchemaManager(serviceName, token);
                        Map map = moduleServiceNames;
                        synchronized (map) {
                            HashMap<String, String> newMap = new HashMap<String, String>(moduleServiceNames);
                            newMap.put(module, serviceName);
                            moduleServiceNames = newMap;
                        }
                    }
                    catch (Exception e) {
                        if (globalModuleNames == Collections.EMPTY_SET) {
                            globalModuleNames = new HashSet();
                        }
                        globalModuleNames.add(module);
                        authTypes.remove(module);
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("Global module names: " + globalModuleNames);
                    debug.message("moduleServiceNames: " + moduleServiceNames);
                }
            }
            catch (Exception smse) {
                String installTime = SystemProperties.get("com.sun.identity.security.amadmin");
                if (installTime == null || !installTime.equalsIgnoreCase("false")) break block12;
                debug.error("Failed to get module types", (Throwable)smse);
            }
        }
    }

    private static void buildModuleInstanceTable(SSOToken token, String realm) {
        block4: {
            try {
                if (debug.messageEnabled()) {
                    debug.message("AMAuthenticationManager.buildModuleInstanceTable: realm = " + realm);
                }
                Collection authServiceNames = moduleServiceNames.values();
                for (String service : authServiceNames) {
                    AMAuthenticationManager.buildModuleInstanceForService(realm, service);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block4;
                debug.message("building module instance table error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void buildModuleInstanceForService(String realm, String serviceName) {
        block17: {
            if (debug.messageEnabled()) {
                debug.message("start moduleInstanceTable : " + moduleInstanceTable + " for realm : " + realm + " and service : " + serviceName);
            }
            try {
                String moduleName = AMAuthenticationManager.getModuleName(serviceName);
                if (debug.messageEnabled()) {
                    debug.message("Module name : " + moduleName);
                }
                if (moduleName == null || moduleName.length() == 0) break block17;
                ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminToken);
                ServiceConfig config = scm.getOrganizationConfig(realm, null);
                if (config == null && debug.messageEnabled()) {
                    debug.message("AMAuthenticationManager.buildModuleInstanceForService: Service=" + serviceName + " not configured in realm=" + realm);
                }
                realm = DNMapper.orgNameToDN(realm);
                Hashtable hashtable = moduleInstanceTable;
                synchronized (hashtable) {
                    HashMap moduleMap = (HashMap)moduleInstanceTable.remove(realm);
                    if (moduleMap != null) {
                        HashMap newMap = new HashMap(moduleMap);
                        newMap.remove(moduleName);
                        moduleMap = newMap;
                    }
                    HashSet<String> instanceSet = new HashSet<String>();
                    Map defaultAttrs = null;
                    if (config != null) {
                        defaultAttrs = config.getAttributesWithoutDefaults();
                    }
                    if (defaultAttrs != null && !defaultAttrs.isEmpty()) {
                        instanceSet.add(moduleName);
                    }
                    Set instances = null;
                    if (config != null) {
                        instances = config.getSubConfigNames();
                    }
                    if (instances != null) {
                        instanceSet.addAll(instances);
                    }
                    if (!instanceSet.isEmpty()) {
                        if (moduleMap == null) {
                            moduleMap = new HashMap();
                        }
                        moduleMap.put(moduleName, instanceSet);
                    }
                    if (moduleMap != null && !moduleMap.isEmpty()) {
                        moduleInstanceTable.put(realm, moduleMap);
                    }
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block17;
                debug.message("build module instance for service error: ", (Throwable)e);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("return moduleInstanceTable: " + moduleInstanceTable);
        }
    }

    private static String getModuleName(String serviceName) {
        for (String moduleName : moduleServiceNames.keySet()) {
            if (!moduleServiceNames.get(moduleName).equals(serviceName)) continue;
            return moduleName;
        }
        return null;
    }

    public AMAuthenticationSchema getAuthenticationSchema(String authType) throws AMConfigurationException {
        return AMAuthenticationManager.getAuthenticationSchema(authType, this.token);
    }

    private static AMAuthenticationSchema getAuthenticationSchema(String authType, SSOToken token) throws AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("getting auth schema for " + authType);
        }
        try {
            String serviceName = AMAuthenticationManager.getServiceName(authType);
            ServiceSchemaManager scm = new ServiceSchemaManager(serviceName, token);
            ServiceSchema orgSchema = scm.getOrganizationSchema();
            ServiceSchema subSchema = orgSchema.getSubSchema("serverconfig");
            ServiceSchema serviceSchema = subSchema != null ? subSchema : orgSchema;
            AMAuthenticationSchema amschema = new AMAuthenticationSchema(serviceSchema);
            return amschema;
        }
        catch (Exception e) {
            throw new AMConfigurationException(e);
        }
    }

    public AMAuthenticationInstance getAuthenticationInstance(String authName) {
        String type = this.getAuthInstanceType(authName);
        if (type == null) {
            return null;
        }
        return this.getAuthenticationInstance(authName, type);
    }

    private AMAuthenticationInstance getAuthenticationInstance(String authName, String type) {
        if (globalModuleNames.contains(authName)) {
            return new AMAuthenticationInstance(authName, type, null, null);
        }
        String serviceName = AMAuthenticationManager.getServiceName(type);
        Object instance = null;
        ServiceConfigManager scm = null;
        ServiceSchemaManager ssm = null;
        try {
            ssm = new ServiceSchemaManager(serviceName, this.token);
        }
        catch (SMSException e) {
            if (debug.messageEnabled()) {
                debug.message("Instance type does not exist: " + type);
            }
            return null;
        }
        catch (SSOException ee) {
            debug.error("SSO token is invalid", (Throwable)((Object)ee));
            return null;
        }
        Map globalAttrs = null;
        ServiceSchema schema = null;
        try {
            schema = ssm.getSchema(SchemaType.GLOBAL);
            if (schema != null) {
                globalAttrs = schema.getAttributeDefaults();
            }
        }
        catch (SMSException e) {
            // empty catch block
        }
        Map orgAttrs = null;
        ServiceConfig service = null;
        try {
            scm = new ServiceConfigManager(serviceName, this.token);
            service = scm.getOrganizationConfig(this.realm, null);
            if (service != null) {
                if (authName.equals(type)) {
                    orgAttrs = service.getAttributesWithoutDefaults();
                } else if ((service = service.getSubConfig(authName)) != null) {
                    orgAttrs = service.getAttributes();
                }
            }
        }
        catch (SSOException e) {
            if (debug.warningEnabled()) {
                debug.warning("Token doesn't have access to service: " + this.token + " :: " + serviceName);
            }
        }
        catch (SMSException e) {
            // empty catch block
        }
        if (debug.messageEnabled()) {
            debug.message("global attrs = " + globalAttrs);
            debug.message("org attrs = ");
            if (orgAttrs != null) {
                for (Map.Entry e : orgAttrs.entrySet()) {
                    if (((String)e.getKey()).endsWith("passwd") || ((String)e.getKey()).endsWith("Passwd") || ((String)e.getKey()).endsWith("password") || ((String)e.getKey()).endsWith("Password") || ((String)e.getKey()).endsWith("secret")) {
                        debug.message(e.getKey() + ": " + "<BLOCKED>");
                        continue;
                    }
                    debug.message(e.getKey() + ": " + e.getValue());
                }
            }
        }
        if (globalAttrs != null && !globalAttrs.isEmpty() || orgAttrs != null && !orgAttrs.isEmpty()) {
            return new AMAuthenticationInstance(authName, type, service, schema);
        }
        return null;
    }

    private String getAuthInstanceType(String authName) {
        String returnValue = null;
        if (globalModuleNames.contains(authName)) {
            returnValue = authName;
        } else {
            Map moduleMap = (Map)moduleInstanceTable.get(this.realm);
            if (moduleMap != null) {
                for (String type : moduleMap.keySet()) {
                    Set instanceNames = (Set)moduleMap.get(type);
                    if (!instanceNames.contains(authName)) continue;
                    returnValue = type;
                    break;
                }
            }
        }
        return returnValue;
    }

    public Set getModuleInstanceNames(String aModuleType) {
        HashSet instances = Collections.EMPTY_SET;
        Map moduleMap = (Map)moduleInstanceTable.get(this.realm);
        if (moduleMap != null || !globalModuleNames.isEmpty()) {
            instances = new HashSet();
            if (moduleMap != null) {
                for (String key : moduleMap.keySet()) {
                    if (!key.equals(aModuleType)) continue;
                    instances.addAll((Set)moduleMap.get(key));
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Registered module names: " + instances);
        }
        return instances;
    }

    private Set getRegisteredModuleNames() {
        HashSet instances = Collections.EMPTY_SET;
        Map moduleMap = (Map)moduleInstanceTable.get(this.realm);
        if (moduleMap != null || !globalModuleNames.isEmpty()) {
            instances = new HashSet();
            if (moduleMap != null) {
                for (String key : moduleMap.keySet()) {
                    instances.addAll((Set)moduleMap.get(key));
                }
            }
            if (!globalModuleNames.isEmpty()) {
                instances.addAll(globalModuleNames);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Registered module names: " + instances);
        }
        return instances;
    }

    public Set getAllowedModuleNames() {
        Set retVal = null;
        if (AuthUtils.getAuthRevisionNumber() >= 30) {
            retVal = this.getRegisteredModuleNames();
        } else {
            Map attrMap = this.orgServiceConfig.getAttributes();
            Set defaultModuleNames = (Set)attrMap.get("iplanet-am-auth-allowed-modules");
            HashSet returnSet = Collections.EMPTY_SET;
            if (defaultModuleNames != null && !globalModuleNames.isEmpty()) {
                returnSet = new HashSet();
                returnSet.addAll(globalModuleNames);
                returnSet.addAll(defaultModuleNames);
            }
            retVal = returnSet;
        }
        if (retVal != null) {
            retVal.remove("Application");
        }
        return retVal;
    }

    private boolean isInheritedAuthInstance(String name) {
        Map attrMap = this.orgServiceConfig.getAttributes();
        Set defaultModuleNames = (Set)attrMap.get("iplanet-am-auth-allowed-modules");
        return defaultModuleNames != null && defaultModuleNames.contains(name);
    }

    private ServiceConfig getOrgServiceConfig() {
        try {
            ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMAuthService", this.token);
            return scm.getOrganizationConfig(this.realm, null);
        }
        catch (Exception e) {
            String installTime = SystemProperties.get("com.sun.identity.security.amadmin");
            if (installTime != null && installTime.equalsIgnoreCase("false")) {
                debug.error("Service config for " + this.realm + " is null." + e.getMessage());
            }
            return null;
        }
    }

    public Set getAuthenticationInstances() {
        HashSet<AMAuthenticationInstance> instanceSet = Collections.EMPTY_SET;
        Map moduleMap = (Map)moduleInstanceTable.get(this.realm);
        if (moduleMap != null || !globalModuleNames.isEmpty()) {
            instanceSet = new HashSet<AMAuthenticationInstance>();
            if (!globalModuleNames.isEmpty()) {
                for (String name : globalModuleNames) {
                    AMAuthenticationInstance instance;
                    if (name.equals("Application") || (instance = this.getAuthenticationInstance(name, name)) == null) continue;
                    instanceSet.add(instance);
                }
            }
            if (moduleMap != null) {
                for (String type : moduleMap.keySet()) {
                    Set instanceNameSet = (Set)moduleMap.get(type);
                    for (String name : instanceNameSet) {
                        AMAuthenticationInstance instance = this.getAuthenticationInstance(name, type);
                        if (instance == null) continue;
                        instanceSet.add(instance);
                    }
                }
            }
        }
        return instanceSet;
    }

    public AMAuthenticationInstance createAuthenticationInstance(String name, String type, Map attributes) throws AMConfigurationException {
        if (name.indexOf(32) != -1) {
            throw new AMConfigurationException(bundleName, "invalidAuthenticationInstanceName", null);
        }
        Set moduleTypes = AMAuthenticationManager.getAuthenticationTypes();
        if (!moduleTypes.contains(type)) {
            throw new AMConfigurationException(bundleName, "wrongType", new Object[]{type});
        }
        AMAuthenticationInstance instance = this.getAuthenticationInstance(name);
        if (instance != null) {
            if (instance.getServiceConfig() != null) {
                throw new AMConfigurationException(bundleName, "authInstanceExist", new Object[]{name});
            }
            throw new AMConfigurationException(bundleName, "authInstanceIsGlobal", new Object[]{name});
        }
        String serviceName = AMAuthenticationManager.getServiceName(type);
        ServiceSchema schema = null;
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
            schema = ssm.getSchema(SchemaType.GLOBAL);
        }
        catch (SSOException e) {
            if (debug.warningEnabled()) {
                debug.warning("Token doesn't have access to service: " + this.token + " -> " + serviceName);
            }
        }
        catch (SMSException e) {
            // empty catch block
        }
        try {
            ServiceConfig orgConfig;
            OrganizationConfigManager ocm = new OrganizationConfigManager(this.token, this.realm);
            if (!ocm.getAssignedServices().contains(serviceName)) {
                ocm.assignService(serviceName, null);
            }
            if ((orgConfig = ocm.getServiceConfig(serviceName)) == null) {
                orgConfig = ocm.addServiceConfig(serviceName, null);
            }
            ServiceConfig subConfig = orgConfig;
            if (!name.equals(type)) {
                orgConfig.addSubConfig(name, "serverconfig", 0, attributes);
                subConfig = orgConfig.getSubConfig(name);
            } else {
                subConfig.setAttributes(attributes);
            }
            return new AMAuthenticationInstance(name, type, subConfig, schema);
        }
        catch (Exception e) {
            throw new AMConfigurationException(e);
        }
    }

    public void deleteAuthenticationInstance(String name) throws AMConfigurationException {
        AMAuthenticationInstance instance = this.getAuthenticationInstance(name);
        if (instance == null) {
            throw new AMConfigurationException(bundleName, "authInstanceNotExist", new Object[]{name});
        }
        if (this.isModuleInstanceInUse(name)) {
            throw new AMConfigurationException(bundleName, "authInstanceInUse", new Object[]{name});
        }
        String type = this.getAuthInstanceType(name);
        ServiceConfig serviceConfig = instance.getServiceConfig();
        if (serviceConfig == null) {
            throw new AMConfigurationException(bundleName, "authInstanceIsGloal", new Object[]{type});
        }
        try {
            if (name.equals(type)) {
                Map attrs = serviceConfig.getAttributesWithoutDefaults();
                if (attrs != null) {
                    serviceConfig.removeAttributes(attrs.keySet());
                }
            } else {
                String serviceName = serviceConfig.getServiceName();
                ServiceConfigManager scm = new ServiceConfigManager(serviceName, this.token);
                ServiceConfig orgConfig = scm.getOrganizationConfig(this.realm, null);
                orgConfig.removeSubConfig(name);
            }
            if (this.isInheritedAuthInstance(name)) {
                HashSet<String> moduleNames = new HashSet<String>();
                moduleNames.add(name);
                this.orgServiceConfig.removeAttributeValues("iplanet-am-auth-allowed-modules", moduleNames);
            }
        }
        catch (Exception e) {
            throw new AMConfigurationException(e);
        }
    }

    public boolean isEditable(AMAuthenticationInstance instance) {
        return true;
    }

    private static String getServiceName(String module) {
        return (String)moduleServiceNames.get(module);
    }

    private boolean isModuleInstanceInUse(String moduleInstance) {
        boolean returnValue;
        Set services;
        block6: {
            services = Collections.EMPTY_SET;
            returnValue = false;
            try {
                ServiceConfig namedConfig;
                ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMAuthConfiguration", this.token);
                ServiceConfig oConfig = scm.getOrganizationConfig(this.realm, null);
                if (oConfig != null && (namedConfig = oConfig.getSubConfig("Configurations")) != null) {
                    services = namedConfig.getSubConfigNames("*");
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block6;
                debug.message("Failed to get named sub configurations.");
            }
        }
        for (String service : services) {
            if (debug.messageEnabled()) {
                debug.message("Checking " + service + " ...");
            }
            if (!this.serviceContains(service, moduleInstance)) continue;
            if (debug.messageEnabled()) {
                debug.message(moduleInstance + " is used in " + service);
            }
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private boolean serviceContains(String serviceName, String moduleInstance) {
        Set xmlConfigValues;
        Map dataMap;
        boolean returnValue;
        block7: {
            returnValue = false;
            dataMap = null;
            if (serviceName != null) {
                try {
                    dataMap = AMAuthConfigUtils.getNamedConfig(serviceName, this.realm, this.token);
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) break block7;
                    debug.message("Failed to get named sub config attrs.");
                }
            }
        }
        if (dataMap != null && (xmlConfigValues = (Set)dataMap.get("iplanet-am-auth-configuration")) != null && !xmlConfigValues.isEmpty()) {
            Document doc;
            String xmlConfig = (String)xmlConfigValues.iterator().next();
            if (debug.messageEnabled()) {
                debug.message("service config for " + serviceName + "  = " + xmlConfig);
            }
            if (xmlConfig != null && xmlConfig.length() != 0 && (doc = XMLUtils.toDOMDocument((String)xmlConfig, (Debug)debug)) != null) {
                Element vPair = doc.getDocumentElement();
                Set values = XMLUtils.getAttributeValuePair((Node)vPair);
                for (String value : values) {
                    if (!value.startsWith(moduleInstance)) continue;
                    returnValue = true;
                    break;
                }
            }
        }
        return returnValue;
    }

    static {
        adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        authTypes = new HashSet();
        moduleServiceNames = new HashMap();
        bundleName = "amAuthConfig";
        debug = Debug.getInstance((String)bundleName);
        moduleInstanceTable = new Hashtable();
        globalModuleNames = Collections.EMPTY_SET;
        AMAuthenticationManager.initAuthenticationService(adminToken);
    }
}

