/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class GetSupportedIdTypes
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String[] params = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_SUPPORTED_IDTYPES", params);
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set supportedIdTypes = amir.getSupportedIdTypes();
            if (supportedIdTypes != null && !supportedIdTypes.isEmpty()) {
                String msg = this.getResourceString("supported-type-result");
                String[] arg = new String[]{""};
                Iterator i = supportedIdTypes.iterator();
                while (i.hasNext()) {
                    arg[0] = ((IdType)i.next()).getName();
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("no-supported-idtype"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_SUPPORTED_IDTYPES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("GetSupportedIdTypes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_SUPPORTED_IDTYPES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("GetSupportedIdTypes.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_SUPPORTED_IDTYPES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

