/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PolicyDataStore;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.ReferralPrivilege;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.entitlement.util.PrivilegeSearchFilter;
import com.sun.identity.policy.ResourceMatch;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferralPrivilegeManager {
    private String realm;
    private Subject adminSubject;

    public ReferralPrivilegeManager(String realm, Subject subject) {
        this.realm = realm;
        this.adminSubject = subject;
    }

    public void add(ReferralPrivilege referral) throws EntitlementException {
        String principalName;
        this.validateReferral(referral);
        Date date = new Date();
        referral.setCreationDate(date.getTime());
        referral.setLastModifiedDate(date.getTime());
        Set<Principal> principals = this.adminSubject.getPrincipals();
        String string = principalName = principals != null && !principals.isEmpty() ? principals.iterator().next().getName() : null;
        if (principalName != null) {
            referral.setCreatedBy(principalName);
            referral.setLastModifiedBy(principalName);
        }
        PolicyDataStore pdb = PolicyDataStore.getInstance();
        pdb.addReferral(this.adminSubject, this.realm, referral);
        this.addApplicationToSubRealm(referral);
    }

    private void validateReferral(ReferralPrivilege referral) throws EntitlementException {
        if (!this.realm.equals("/")) {
            Map<String, Set<String>> map = referral.getOriginalMapApplNameToResources();
            for (String appName : map.keySet()) {
                Application appl = ApplicationManager.getApplication(this.adminSubject, this.realm, appName);
                ResourceName comp = appl.getResourceComparator();
                Set<String> resources = appl.getResources();
                Set<String> refResources = map.get(appName);
                for (String r : resources) {
                    this.validateReferral(referral, comp, r, refResources);
                }
            }
        }
    }

    private void validateReferral(ReferralPrivilege referral, ResourceName comp, String res, Set<String> refResources) throws EntitlementException {
        if (!res.endsWith("*")) {
            res = res + "*";
        }
        for (String rr : refResources) {
            ResourceMatch match = comp.compare(rr, res, true);
            if (!match.equals(ResourceMatch.EXACT_MATCH) && !match.equals(ResourceMatch.WILDCARD_MATCH) && !match.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
            return;
        }
        Object[] param = new Object[]{referral.getName()};
        throw new EntitlementException(267, param);
    }

    public void addApplicationToSubRealm(ReferralPrivilege referral) throws EntitlementException {
        Map<String, Set<String>> map = referral.getMapApplNameToResources();
        for (String appName : map.keySet()) {
            Set<String> resources = map.get(appName);
            for (String r : referral.getRealms()) {
                ApplicationManager.referApplication(this.adminSubject, this.realm, r, appName, resources);
            }
        }
    }

    public ReferralPrivilege getReferral(String name) throws EntitlementException {
        PolicyDataStore pdb = PolicyDataStore.getInstance();
        return pdb.getReferral(this.adminSubject, this.realm, name);
    }

    public void delete(String name) throws EntitlementException {
        ReferralPrivilege referral = this.getReferral(name);
        if (referral != null) {
            this.removeApplicationFromSubRealm(referral);
            PolicyDataStore pdb = PolicyDataStore.getInstance();
            pdb.removeReferral(this.adminSubject, this.realm, name);
        }
    }

    private void removeApplicationFromSubRealm(ReferralPrivilege referral) throws EntitlementException {
        Map<String, Set<String>> map = referral.getMapApplNameToResources();
        for (String appName : map.keySet()) {
            Set<String> resources = map.get(appName);
            for (String r : referral.getRealms()) {
                ApplicationManager.dereferApplication(this.adminSubject, r, appName, resources);
            }
        }
    }

    public void modify(ReferralPrivilege referral) throws EntitlementException {
        ReferralPrivilege orig = this.getReferral(referral.getName());
        if (orig != null) {
            referral.setCreatedBy(orig.getCreatedBy());
            referral.setCreationDate(orig.getCreationDate());
        }
        Date date = new Date();
        referral.setLastModifiedDate(date.getTime());
        Set<Principal> principals = this.adminSubject.getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            referral.setLastModifiedBy(principals.iterator().next().getName());
        }
        PolicyDataStore pdb = PolicyDataStore.getInstance();
        pdb.removeReferral(this.adminSubject, this.realm, referral.getName());
        pdb.addReferral(this.adminSubject, this.realm, referral);
    }

    public Set<String> searchReferralPrivilegeNames(Set<PrivilegeSearchFilter> filter, int searchSizeLimit, int searchTimeLimit) throws EntitlementException {
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(this.adminSubject, this.realm);
        return pis.searchReferralPrivilegeNames(filter, true, searchSizeLimit, false, false);
    }

    public Set<String> searchReferralPrivilegeNames(Set<PrivilegeSearchFilter> filter) throws EntitlementException {
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(this.adminSubject, this.realm);
        return pis.searchReferralPrivilegeNames(filter, true, 0, false, false);
    }
}

